/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.CharMatchScore;
import com.wcohen.secondstring.MemoMatrix;
import com.wcohen.secondstring.StringWrapper;

public class NeedlemanWunsch
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double gapCost;

    public NeedlemanWunsch() {
        this(CharMatchScore.DIST_01, 1.0);
    }

    public NeedlemanWunsch(CharMatchScore charMatchScore, double d) {
        this.charMatchScore = charMatchScore;
        this.gapCost = d;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        MyMatrix myMatrix = new MyMatrix(stringWrapper, stringWrapper2);
        return myMatrix.get(stringWrapper.length(), stringWrapper2.length());
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        MyMatrix myMatrix = new MyMatrix(stringWrapper, stringWrapper2);
        double d = myMatrix.get(stringWrapper.length(), stringWrapper2.length());
        myMatrix.setPrintNegativeValues(true);
        return myMatrix.toString() + "\nScore = " + d;
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new NeedlemanWunsch(), stringArray);
    }

    private class MyMatrix
    extends MemoMatrix {
        public MyMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
            super(stringWrapper, stringWrapper2);
        }

        public double compute(int n, int n2) {
            if (n == 0) {
                return (double)(-n2) * NeedlemanWunsch.this.gapCost;
            }
            if (n2 == 0) {
                return (double)(-n) * NeedlemanWunsch.this.gapCost;
            }
            return MemoMatrix.max3(this.get(n - 1, n2 - 1) + NeedlemanWunsch.this.charMatchScore.matchScore(this.sAt(n), this.tAt(n2)), this.get(n - 1, n2) - NeedlemanWunsch.this.gapCost, this.get(n, n2 - 1) - NeedlemanWunsch.this.gapCost);
        }
    }
}

