/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.CharMatchScore;
import com.wcohen.secondstring.MemoMatrix;
import com.wcohen.secondstring.StringWrapper;

public class SmithWaterman
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double gapCost;

    public SmithWaterman() {
        this(CharMatchScore.DIST_21, 1.0);
    }

    public SmithWaterman(CharMatchScore charMatchScore, double d) {
        this.charMatchScore = charMatchScore;
        this.gapCost = d;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        MyMatrix myMatrix = new MyMatrix(stringWrapper, stringWrapper2);
        return this.score(stringWrapper, stringWrapper2, myMatrix);
    }

    private double score(StringWrapper stringWrapper, StringWrapper stringWrapper2, MyMatrix myMatrix) {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n <= stringWrapper.length()) {
            int n2 = 0;
            while (n2 <= stringWrapper2.length()) {
                d = Math.max(d, myMatrix.get(n, n2));
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        MyMatrix myMatrix = new MyMatrix(stringWrapper, stringWrapper2);
        double d = this.score(stringWrapper, stringWrapper2, myMatrix);
        return myMatrix.toString() + "\nScore = " + d;
    }

    public String toString() {
        return "[SmithWaterman]";
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new SmithWaterman(), stringArray);
    }

    private class MyMatrix
    extends MemoMatrix {
        public MyMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
            super(stringWrapper, stringWrapper2);
        }

        public double compute(int n, int n2) {
            if (n == 0) {
                return 0.0;
            }
            if (n2 == 0) {
                return 0.0;
            }
            return MemoMatrix.max4(0.0, this.get(n - 1, n2 - 1) + SmithWaterman.this.charMatchScore.matchScore(this.sAt(n), this.tAt(n2)), this.get(n - 1, n2) - SmithWaterman.this.gapCost, this.get(n, n2 - 1) - SmithWaterman.this.gapCost);
        }
    }
}

