/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStatisticalTokenDistance;
import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.JaroWinkler;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.expt.Blocker;
import com.wcohen.secondstring.expt.ClusterNGramBlocker;
import com.wcohen.secondstring.expt.MatchData;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SoftTokenFelligiSunter
extends AbstractStatisticalTokenDistance {
    private double mismatchFactor;
    private StringDistance tokenDistance;
    private double tokenMatchThreshold;
    private static final StringDistance DEFAULT_TOKEN_DISTANCE = new JaroWinkler();
    private boolean tokenDistancesComputed = false;
    private Map neighborMap;

    public SoftTokenFelligiSunter(Tokenizer tokenizer, StringDistance stringDistance, double d, double d2) {
        super(tokenizer);
        this.tokenDistance = stringDistance;
        this.tokenMatchThreshold = d;
        this.mismatchFactor = d2;
    }

    public SoftTokenFelligiSunter() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER, DEFAULT_TOKEN_DISTANCE, 0.9, 0.5);
    }

    public void setMismatchFactor(double d) {
        this.mismatchFactor = d;
    }

    public void setMismatchFactor(Double d) {
        this.mismatchFactor = d;
    }

    public void setTokenMatchThreshold(double d) {
        this.tokenMatchThreshold = d;
    }

    public void setTokenMatchThreshold(Double d) {
        this.tokenMatchThreshold = d;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        this.computeTokenDistances();
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            double d2;
            Token token = (Token)iterator.next();
            double d3 = this.getDocumentFrequency(token);
            if (bagOfTokens2.contains(token)) {
                double d4 = -Math.log(d3 / (double)this.collectionSize);
                d += d4;
                continue;
            }
            Token token2 = null;
            double d5 = this.tokenMatchThreshold;
            Iterator iterator2 = bagOfTokens2.tokenIterator();
            while (iterator2.hasNext()) {
                Token token3 = (Token)iterator2.next();
                double d6 = this.tokenDistance.score(token.getValue(), token3.getValue());
                if (!(d6 >= d5)) continue;
                token2 = token3;
                d5 = d6;
            }
            if (token2 != null) {
                d3 = this.neighborhoodDocumentFrequency(token, d5);
                d2 = -Math.log(d3 / (double)this.collectionSize);
                d += d2;
                continue;
            }
            d2 = -Math.log(d3 / (double)this.collectionSize);
            d -= d2 * this.mismatchFactor;
        }
        return d;
    }

    public StringWrapper prepare(String string) {
        return new BagOfTokens(string, this.tokenizer.tokenize(string));
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        StringBuffer stringBuffer = new StringBuffer("");
        PrintfFormat printfFormat = new PrintfFormat("%.3f");
        stringBuffer.append("Common tokens: ");
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!bagOfTokens2.contains(token)) continue;
            stringBuffer.append(" " + token.getValue() + ": ");
            stringBuffer.append(printfFormat.sprintf(bagOfTokens2.getWeight(token)));
        }
        stringBuffer.append("\nscore = " + this.score(stringWrapper, stringWrapper2));
        return stringBuffer.toString();
    }

    public String toString() {
        return "[SoftTokenFelligiSunter]";
    }

    private void computeTokenDistances() {
        Object object;
        if (this.tokenDistancesComputed) {
            return;
        }
        this.neighborMap = new HashMap();
        MatchData matchData = new MatchData();
        Iterator iterator = this.documentFrequency.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Token)iterator.next();
            matchData.addInstance("tokens", ((Token)object).getValue(), ((Token)object).getValue());
        }
        object = new ClusterNGramBlocker();
        ((Blocker)object).block(matchData);
        int n = 0;
        while (n < ((Blocker)object).size()) {
            String string;
            Blocker.Pair pair = ((Blocker)object).getPair(n);
            String string2 = pair.getA().getText().unwrap();
            double d = this.tokenDistance.score(string2, string = pair.getB().getText().unwrap());
            if (d >= this.tokenMatchThreshold) {
                this.addNeighbor(string2, string, d);
            }
            ++n;
        }
        this.tokenDistancesComputed = true;
    }

    private void addNeighbor(String string, String string2, double d) {
        TreeSet<TokenNeighbor> treeSet = (TreeSet<TokenNeighbor>)this.neighborMap.get(string);
        if (treeSet == null) {
            treeSet = new TreeSet<TokenNeighbor>();
            this.neighborMap.put(string, treeSet);
        }
        treeSet.add(new TokenNeighbor(string2, d));
    }

    private int neighborhoodDocumentFrequency(Token token, double d) {
        int n = this.getDocumentFrequency(token);
        String string = token.getValue();
        TreeSet treeSet = (TreeSet)this.neighborMap.get(string);
        if (treeSet == null) {
            return n;
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TokenNeighbor tokenNeighbor = (TokenNeighbor)iterator.next();
            if (tokenNeighbor.score < d) break;
            n += tokenNeighbor.freq;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new SoftTokenFelligiSunter(), stringArray);
    }

    private class TokenNeighbor
    implements Comparable {
        public String tokVal;
        public int freq;
        public double score;

        public TokenNeighbor(String string, double d) {
            this.tokVal = string;
            this.score = d;
            this.freq = SoftTokenFelligiSunter.this.getDocumentFrequency(SoftTokenFelligiSunter.this.tokenizer.intern(string));
        }

        public int compareTo(Object object) {
            TokenNeighbor tokenNeighbor = (TokenNeighbor)object;
            if (tokenNeighbor.score > this.score) {
                return 1;
            }
            if (tokenNeighbor.score < this.score) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return this.tokVal.hashCode();
        }
    }
}

