/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.DirichletJS;
import com.wcohen.secondstring.Jaccard;
import com.wcohen.secondstring.Jaro;
import com.wcohen.secondstring.JaroWinkler;
import com.wcohen.secondstring.JaroWinklerTFIDF;
import com.wcohen.secondstring.JelinekMercerJS;
import com.wcohen.secondstring.Level2Jaro;
import com.wcohen.secondstring.Level2MongeElkan;
import com.wcohen.secondstring.Levenstein;
import com.wcohen.secondstring.MongeElkan;
import com.wcohen.secondstring.SoftTokenFelligiSunter;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.TFIDF;
import com.wcohen.secondstring.TokenFelligiSunter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestPackage
extends TestSuite {
    private static final boolean DEBUG = false;

    public TestPackage(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new MyFixture("testLevenstein"));
        testSuite.addTest((Test)new MyFixture("testJaccard"));
        testSuite.addTest((Test)new MyFixture("testJaro"));
        testSuite.addTest((Test)new MyFixture("testJaroWinkler"));
        testSuite.addTest((Test)new MyFixture("testDirichletJS"));
        testSuite.addTest((Test)new MyFixture("testJelinekMercerJS"));
        testSuite.addTest((Test)new MyFixture("testJaroWinklerTFIDF"));
        testSuite.addTest((Test)new MyFixture("testSoftTokenFelligiSunter"));
        testSuite.addTest((Test)new MyFixture("testTFIDF"));
        testSuite.addTest((Test)new MyFixture("testTokenFelligiSunter"));
        return testSuite;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestPackage.suite());
    }

    public static class MyFixture
    extends TestCase {
        private String s = "william w. cohen";
        private String t = "w. liam chen";
        private static List corpus = new ArrayList();

        public MyFixture(String string) {
            super(string);
        }

        public void check(StringDistance stringDistance, double d, double d2) {
            stringDistance.accumulateStatistics(corpus.iterator());
            double d3 = stringDistance.score(this.s, this.t);
            Assert.assertEquals((double)d, (double)d3, (double)d2);
        }

        public void testJaccard() {
            this.check(new Jaccard(), 0.2, 0.0);
        }

        public void testJaro() {
            this.check(new Jaro(), 0.833, 0.01);
        }

        public void testJaroWinkler() {
            this.check(new JaroWinkler(), 0.85, 0.01);
        }

        public void testLevel2Jaro() {
            this.check(new Level2Jaro(), 0.902, 0.01);
        }

        public void testLevel2MongeElkan() {
            this.check(new Level2MongeElkan(), 0.9167, 0.001);
        }

        public void testLevenstein() {
            this.check(new Levenstein(), -6.0, 0.0);
        }

        public void testMongeElkan() {
            this.check(new MongeElkan(), 0.55, 0.01);
        }

        public void testDirichletJS() {
            this.check(new DirichletJS(), 0.2884, 0.01);
        }

        public void testJelinekMercerJS() {
            this.check(new JelinekMercerJS(), 0.2974, 0.01);
        }

        public void testJaroWinklerTFIDF() {
            this.check(new JaroWinklerTFIDF(), 0.886, 0.01);
        }

        public void testSoftTokenFelligiSunter() {
            this.check(new SoftTokenFelligiSunter(), 3.154, 0.01);
        }

        public void testTFIDF() {
            this.check(new TFIDF(), 0.2647, 0.01);
        }

        public void testTokenFelligiSunter() {
            this.check(new TokenFelligiSunter(), -0.6931, 0.01);
        }

        static {
            String[] stringArray = new String[]{"william", "w", "cohen", "liam", "chen", "liam", "o", "furniture", "george", "w", "bush", "wei", "chen"};
            int n = 0;
            while (n < stringArray.length) {
                corpus.add(new StringWrapper(stringArray[n]));
                ++n;
            }
        }
    }
}

