/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.expt;

import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class MatchData {
    private Map sourceLists;
    private ArrayList sourceNames;
    private String filename;

    public MatchData(String string) throws InputFormatException {
        this.filename = string;
        this.sourceNames = new ArrayList();
        this.sourceLists = new HashMap();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new InputFormatException(string, n, "no source");
                }
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new InputFormatException(string, n, "no id");
                }
                String string4 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new InputFormatException(string, n, "no text fields");
                }
                String string5 = stringTokenizer.nextToken();
                this.addInstance(string3, string4, string5);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new InputFormatException(string, 0, iOException.toString());
        }
    }

    public MatchData() {
        this.filename = "none";
        this.sourceNames = new ArrayList();
        this.sourceLists = new HashMap();
    }

    public void addInstance(String string, String string2, String string3) {
        Instance instance = new Instance(string, string2, string3);
        ArrayList<Instance> arrayList = (ArrayList<Instance>)this.sourceLists.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Instance>();
            this.sourceLists.put(string, arrayList);
            this.sourceNames.add(string);
        }
        arrayList.add(instance);
    }

    public int numSources() {
        return this.sourceNames.size();
    }

    public String getSource(int n) {
        return (String)this.sourceNames.get(n);
    }

    public int numInstances(String string) {
        return ((ArrayList)this.sourceLists.get(string)).size();
    }

    public Instance getInstance(String string, int n) {
        return (Instance)((ArrayList)this.sourceLists.get(string)).get(n);
    }

    public void prepare(StringDistance stringDistance) {
        stringDistance.accumulateStatistics(new MatchIterator());
        int n = 0;
        while (n < this.numSources()) {
            String string = this.getSource(n);
            int n2 = 0;
            while (n2 < this.numInstances(string)) {
                Instance instance = this.getInstance(string, n2);
                instance.prepare(stringDistance);
                ++n2;
            }
            ++n;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numSources()) {
            String string = this.getSource(n);
            int n2 = 0;
            while (n2 < this.numInstances(string)) {
                Instance instance = this.getInstance(string, n2);
                stringBuffer.append(instance.toString() + "\n");
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new MatchData(stringArray[0]).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class InputFormatException
    extends Exception {
        public InputFormatException(String string, int n, String string2) {
            super("line " + n + " of file " + string + ": " + string2);
        }
    }

    public class MatchIterator
    implements Iterator {
        private int sourceCursor = 0;
        private int instanceCursor = 0;
        private String src;

        public MatchIterator() {
            this.src = MatchData.this.getSource(this.sourceCursor);
        }

        public void remove() {
            throw new IllegalStateException("remove not implemented");
        }

        public String getSource() {
            return this.src;
        }

        public StringWrapper nextStringWrapper() {
            return (StringWrapper)this.next();
        }

        public boolean hasNext() {
            return this.sourceCursor < MatchData.this.numSources() && this.instanceCursor < MatchData.this.numInstances(this.src);
        }

        public Object next() {
            Instance instance = MatchData.this.getInstance(this.src, this.instanceCursor++);
            if (this.instanceCursor > MatchData.this.numInstances(this.src)) {
                ++this.sourceCursor;
                if (this.sourceCursor < MatchData.this.numSources()) {
                    this.src = MatchData.this.getSource(this.sourceCursor);
                }
            }
            return instance.getText();
        }
    }

    public static class Instance {
        private final String source;
        private final String id;
        private StringWrapper text;

        public Instance(String string, String string2, String string3) {
            this.source = string.trim();
            this.id = string2.trim();
            this.text = new StringWrapper(string3.trim());
        }

        public String getSource() {
            return this.source;
        }

        public String getId() {
            return this.id;
        }

        public StringWrapper getText() {
            return this.text;
        }

        public String toString() {
            return "[src: '" + this.source + "' id: '" + this.id + "' text: '" + this.text + "']";
        }

        public void prepare(StringDistance stringDistance) {
            this.text = stringDistance.prepare(this.text.unwrap());
        }
    }
}

