/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.expt;

import com.wcohen.secondstring.DistanceFactory;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.expt.Blocker;
import com.wcohen.secondstring.expt.MatchData;
import com.wcohen.secondstring.expt.NullBlocker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;

public class MatchExpt
implements Serializable {
    public static final String BLOCKER_PACKAGE = "com.wcohen.secondstring.expt.";
    public static final String DISTANCE_PACKAGE = "com.wcohen.secondstring.";
    private static final long serialVersionUID = 1L;
    private static int CURRENT_SERIALIZED_VERSION_NUMBER = 1;
    private transient Blocker.Pair[] pairs;
    private int numCorrectPairs;
    private double preparationTime;
    private double blockingTime;
    private double matchingTime;
    private double sortingTime;
    private static double[] elevenPoints = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public MatchExpt(MatchData matchData, StringDistance stringDistance, Blocker blocker) {
        this.setUpExperiment(matchData, stringDistance, blocker);
    }

    public MatchExpt(MatchData matchData, StringDistance stringDistance) {
        this(matchData, stringDistance, new NullBlocker());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.pairs.length);
        int n = 0;
        while (n < this.pairs.length) {
            if (this.correctPair(n)) {
                objectOutputStream.writeInt(n);
                objectOutputStream.writeObject(this.pairs[n]);
            }
            ++n;
        }
        objectOutputStream.writeInt(-1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.pairs = new Blocker.Pair[n];
        int n2 = objectInputStream.readInt();
        while (n2 >= 0) {
            this.pairs[n2] = (Blocker.Pair)objectInputStream.readObject();
            n2 = objectInputStream.readInt();
        }
    }

    private void setUpExperiment(MatchData matchData, StringDistance stringDistance, Blocker blocker) {
        System.out.println("setting up expt: " + stringDistance + " " + blocker + " file: " + matchData.getFilename());
        long l = System.currentTimeMillis();
        matchData.prepare(stringDistance);
        this.preparationTime = (double)(System.currentTimeMillis() - l) / 1000.0;
        l = System.currentTimeMillis();
        blocker.block(matchData);
        this.blockingTime = (double)(System.currentTimeMillis() - l) / 1000.0;
        this.numCorrectPairs = blocker.numCorrectPairs();
        this.pairs = new Blocker.Pair[blocker.size()];
        l = System.currentTimeMillis();
        System.out.println("Pairs: " + this.pairs.length + " Correct: " + blocker.numCorrectPairs());
        int n = 0;
        while (n < blocker.size()) {
            this.pairs[n] = blocker.getPair(n);
            this.pairs[n].setDistance(stringDistance.score(this.pairs[n].getA().getText(), this.pairs[n].getB().getText()));
            if (n > 0 && n % 100000 == 0) {
                System.out.println("First " + n + " distances in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec");
            }
            ++n;
        }
        this.matchingTime = (double)(System.currentTimeMillis() - l) / 1000.0;
        l = System.currentTimeMillis();
        Arrays.sort(this.pairs);
        this.sortingTime = (double)(System.currentTimeMillis() - l) / 1000.0;
        System.out.println("Matching time: " + this.matchingTime);
    }

    public Double time() {
        return new Double(this.preparationTime + this.blockingTime + this.matchingTime + this.sortingTime);
    }

    public Double pairsPerSecond() {
        return new Double((double)this.pairs.length / (this.preparationTime + this.blockingTime + this.matchingTime + this.sortingTime));
    }

    public Double averagePrecision() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.pairs.length) {
            if (this.correctPair(n)) {
                double d3 = (d += 1.0) / ((double)n + 1.0);
                d2 += d3;
            }
            ++n;
        }
        return new Double(d2 / (double)this.numCorrectPairs);
    }

    public Double maxF1() {
        double d = -1.7976931348623157E308;
        double d2 = 0.0;
        int n = 0;
        while (n < this.pairs.length) {
            if (this.correctPair(n)) {
                double d3 = (d2 += 1.0) / ((double)n + 1.0);
                double d4 = d2 / (double)this.numCorrectPairs;
                if (d3 > 0.0 && d4 > 0.0) {
                    double d5 = 2.0 * (d3 * d4) / (d3 + d4);
                    d = Math.max(d5, d);
                }
            }
            ++n;
        }
        return new Double(d);
    }

    public Double blockerRecall() {
        double d = 0.0;
        int n = 0;
        while (n < this.pairs.length) {
            if (this.correctPair(n)) {
                d += 1.0;
            }
            ++n;
        }
        return new Double(d / (double)this.numCorrectPairs);
    }

    public static double[] interpolated11PointRecallLevels() {
        return elevenPoints;
    }

    public double[] interpolated11PointPrecision() {
        double[] dArray = new double[11];
        int n = 0;
        int n2 = 0;
        while (n2 < this.pairs.length) {
            if (this.correctPair(n2)) {
                ++n;
            }
            double d = (double)n / (double)this.numCorrectPairs;
            double d2 = (double)n / ((double)n2 + 1.0);
            int n3 = 0;
            while (n3 < elevenPoints.length) {
                if (d >= elevenPoints[n3]) {
                    dArray[n3] = Math.max(dArray[n3], d2);
                }
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    public void graphPrecisionRecall(PrintStream printStream) throws IOException {
        double[] dArray = new double[this.pairs.length];
        double d = this.numCorrectPairs;
        double d2 = d / (double)this.pairs.length;
        int n = this.pairs.length - 1;
        while (n >= 0) {
            if (this.correctPair(n)) {
                dArray[n] = d2;
                d2 = Math.max(d2, (d -= 1.0) / (double)(n + 1));
            }
            --n;
        }
        d = 0.0;
        int n2 = 0;
        while (n2 < this.pairs.length) {
            if (this.correctPair(n2)) {
                double d3 = (d += 1.0) / (double)this.numCorrectPairs;
                printStream.println(d3 + "\t" + dArray[n2]);
            }
            ++n2;
        }
    }

    public void displayResults(boolean bl, PrintStream printStream) throws IOException {
        PrintfFormat printfFormat = new PrintfFormat("%s %3d %7.2f | %30s | %30s\n");
        int n = 0;
        while (n < this.pairs.length) {
            if (this.pairs[n] != null) {
                String string;
                String string2 = this.pairs[n].getA().getId().equals(this.pairs[n].getB().getId()) ? "+" : "-";
                String string3 = this.pairs[n].getA() == null ? "***" : this.pairs[n].getA().getText().unwrap();
                String string4 = string = this.pairs[n].getB() == null ? "***" : this.pairs[n].getB().getText().unwrap();
                if (bl || "+".equals(string2)) {
                    printStream.print(printfFormat.sprintf(new Object[]{string2, new Integer(n + 1), new Double(this.pairs[n].getDistance()), string3, string}));
                }
            }
            ++n;
        }
    }

    private boolean correctPair(int n) {
        return this.pairs[n] != null && this.pairs[n].isCorrect();
    }

    public static void main(String[] stringArray) {
        try {
            Blocker blocker = (Blocker)Class.forName(BLOCKER_PACKAGE + stringArray[0]).newInstance();
            StringDistance stringDistance = DistanceFactory.build(stringArray[1]);
            MatchData matchData = new MatchData(stringArray[2]);
            MatchExpt matchExpt = new MatchExpt(matchData, stringDistance, blocker);
            int n = 3;
            while (n < stringArray.length) {
                String string;
                if ((string = stringArray[n++]).equals("-display")) {
                    matchExpt.displayResults(true, System.out);
                    continue;
                }
                if (string.equals("-shortDisplay")) {
                    matchExpt.displayResults(false, System.out);
                    continue;
                }
                if (string.equals("-graph")) {
                    matchExpt.graphPrecisionRecall(System.out);
                    continue;
                }
                if (string.equals("-summarize")) {
                    System.out.println("maxF1:\t" + matchExpt.maxF1());
                    System.out.println("avgPrec:\t" + matchExpt.averagePrecision());
                    continue;
                }
                throw new RuntimeException("illegal command " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\nusage: <blocker> <distanceClass> <matchDataFile> [commands]\n");
        }
    }
}

