/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.expt;

import com.wcohen.secondstring.DistanceFactory;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.expt.Blocker;
import com.wcohen.secondstring.expt.MatchData;
import com.wcohen.secondstring.expt.MatchExpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MatchExptScript {
    public static final String BLOCKER_PACKAGE = "com.wcohen.secondstring.expt.";
    public static final String DISTANCE_PACKAGE = "com.wcohen.secondstring.";
    private List blockers = new ArrayList();
    private List datasets = new ArrayList();
    private List distances = new ArrayList();
    private List blockerNames = new ArrayList();
    private List datasetNames = new ArrayList();
    private List distanceNames = new ArrayList();
    private MatchExpt[][][] expt = null;
    private boolean echoCommands = true;
    private boolean computable = true;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$wcohen$secondstring$expt$MatchExpt;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$wcohen$secondstring$expt$MatchExptScript;

    public void clear(String string) {
        if (string.equals("blockers")) {
            this.blockers.clear();
        } else if (string.equals("datasets")) {
            this.datasets.clear();
        } else if (string.equals("distances")) {
            this.distances.clear();
        } else if (string.equals("all")) {
            this.clear("blockers");
            this.clear("datasets");
            this.clear("distances");
        } else {
            System.out.println("usage: clear blockers|datasets|distances|all");
        }
    }

    public void show(String string) {
        if (string.equals("blockers")) {
            MatchExptScript.showList("blockers", this.blockerNames);
        } else if (string.equals("datasets")) {
            MatchExptScript.showList("datasets", this.datasetNames);
        } else if (string.equals("distances")) {
            MatchExptScript.showList("distances", this.distanceNames);
        } else if (string.equals("all")) {
            this.show("blockers");
            this.show("datasets");
            this.show("distances");
        } else {
            System.out.println("usage: show blockers|datasets|distances|all");
        }
    }

    private static void showList(String string, List list) {
        System.out.println(list.size() + " " + string + ":");
        int n = 0;
        while (n < list.size()) {
            System.out.println(n + 1 + ". " + list.get(n).toString());
            ++n;
        }
    }

    public void echo(String string) {
        this.echoCommands = "on".equals(string);
    }

    public void dataset(String string) throws MatchData.InputFormatException {
        this.datasets.add(new MatchData(string));
        this.datasetNames.add(string);
        this.expt = null;
    }

    public void distance(String string) {
        this.distances.add(DistanceFactory.build(string));
        this.distanceNames.add(string);
        this.expt = null;
    }

    public void blocker(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.blockers.add(Class.forName(BLOCKER_PACKAGE + string).newInstance());
        this.blockerNames.add(string);
        this.expt = null;
    }

    public void blocker(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Blocker blocker = (Blocker)Class.forName(BLOCKER_PACKAGE + string).newInstance();
        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
        Method method = blocker.getClass().getMethod("set" + string2, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MatchExptScript.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        method.invoke((Object)blocker, Boolean.valueOf(string3));
        this.blockers.add(blocker);
        this.blockerNames.add(string);
        this.expt = null;
    }

    public void compute() {
        if (!this.computable) {
            throw new RuntimeException("can't re-'compute' experiment results after a 'restore'");
        }
        this.expt = new MatchExpt[this.blockers.size()][this.distances.size()][this.datasets.size()];
        int n = 0;
        while (n < this.blockers.size()) {
            Blocker blocker = (Blocker)this.blockers.get(n);
            int n2 = 0;
            while (n2 < this.distances.size()) {
                StringDistance stringDistance = (StringDistance)this.distances.get(n2);
                int n3 = 0;
                while (n3 < this.datasets.size()) {
                    MatchData matchData = (MatchData)this.datasets.get(n3);
                    this.expt[n][n2][n3] = new MatchExpt(matchData, stringDistance, blocker);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void table(String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        PrintfFormat printfFormat = new PrintfFormat("Dataset %2d:");
        PrintfFormat printfFormat2 = new PrintfFormat(" %9.5f  ");
        PrintfFormat printfFormat3 = new PrintfFormat(" %11s");
        if (this.expt == null) {
            this.compute();
        }
        int n = 0;
        while (n < this.blockerNames.size()) {
            int n2;
            Object object;
            System.out.println("\nblocker: " + this.blockerNames.get(n) + "\n");
            System.out.print("           ");
            int n3 = 0;
            while (n3 < this.distanceNames.size()) {
                object = (String)this.distanceNames.get(n3);
                if (((String)object).length() > 11) {
                    object = ((String)object).substring(0, 11);
                }
                System.out.print(printfFormat3.sprintf((String)object));
                ++n3;
            }
            System.out.println();
            object = new double[this.distanceNames.size()];
            int n4 = 0;
            while (n4 < this.datasetNames.size()) {
                System.out.print(printfFormat.sprintf(n4 + 1));
                n2 = 0;
                while (n2 < this.distanceNames.size()) {
                    Method method = (class$com$wcohen$secondstring$expt$MatchExpt == null ? MatchExptScript.class$("com.wcohen.secondstring.expt.MatchExpt") : class$com$wcohen$secondstring$expt$MatchExpt).getMethod(string, new Class[0]);
                    Double d = (Double)method.invoke((Object)this.expt[n][n2][n4], new Object[0]);
                    System.out.print(printfFormat2.sprintf(d));
                    Object object2 = object;
                    int n5 = n2++;
                    object2[n5] = object2[n5] + d;
                }
                System.out.print("\n");
                ++n4;
            }
            System.out.print("   Average:");
            n2 = 0;
            while (n2 < this.distanceNames.size()) {
                System.out.print(printfFormat2.sprintf((double)(object[n2] / (double)this.datasetNames.size())));
                ++n2;
            }
            System.out.print("\n\n");
            ++n;
        }
    }

    public void precisionRecall() {
        PrintfFormat printfFormat = new PrintfFormat("%9s %9s %9s");
        PrintfFormat printfFormat2 = new PrintfFormat(" %5.2f");
        PrintfFormat printfFormat3 = new PrintfFormat(" r%4.2f");
        System.out.print(printfFormat.sprintf(new Object[]{"block", "dist", "data"}));
        double[] dArray = MatchExpt.interpolated11PointRecallLevels();
        int n = 0;
        while (n < dArray.length) {
            System.out.print(printfFormat3.sprintf(dArray[n]));
            ++n;
        }
        System.out.println("   avgPrec\n");
        int n2 = 0;
        while (n2 < this.blockerNames.size()) {
            String string = (String)this.blockerNames.get(n2);
            if (string.length() > 7) {
                string = string.substring(0, 7);
            }
            int n3 = 0;
            while (n3 < this.distanceNames.size()) {
                String string2 = (String)this.distanceNames.get(n3);
                if (string2.length() > 7) {
                    string2 = string2.substring(0, 7);
                }
                double[] dArray2 = new double[12];
                int n4 = 0;
                while (n4 < this.datasetNames.size()) {
                    String string3 = (String)this.datasetNames.get(n4);
                    int n5 = (string3 = new File(string3).getName()).indexOf(46);
                    if (n5 >= 0) {
                        string3 = string3.substring(0, n5);
                    }
                    if (string3.length() > 9) {
                        string3 = string3.substring(0, 9);
                    }
                    System.out.print(printfFormat.sprintf(new Object[]{string, string2, string3}));
                    double[] dArray3 = this.expt[n2][n3][n4].interpolated11PointPrecision();
                    int n6 = 0;
                    while (n6 < dArray3.length) {
                        System.out.print(printfFormat2.sprintf(dArray3[n6]));
                        int n7 = n6;
                        dArray2[n7] = dArray2[n7] + dArray3[n6];
                        ++n6;
                    }
                    double d = this.expt[n2][n3][n4].averagePrecision();
                    System.out.print("   " + printfFormat2.sprintf(d));
                    dArray2[11] = dArray2[11] + d;
                    System.out.print("\n");
                    ++n4;
                }
                System.out.print(printfFormat.sprintf(new Object[]{string, string2, "avg"}));
                int n8 = 0;
                while (n8 < dArray2.length - 1) {
                    System.out.print(printfFormat2.sprintf(dArray2[n8] / (double)this.datasetNames.size()));
                    ++n8;
                }
                System.out.println("   " + printfFormat2.sprintf(dArray2[11] / (double)this.datasetNames.size()) + "\n");
                ++n3;
            }
            ++n2;
        }
    }

    public void save(String string) throws IOException, FileNotFoundException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
        objectOutputStream.writeObject(this.blockerNames);
        objectOutputStream.writeObject(this.datasetNames);
        objectOutputStream.writeObject(this.distanceNames);
        objectOutputStream.writeObject(this.expt);
        objectOutputStream.close();
    }

    public void restore(String string) throws IOException, FileNotFoundException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        this.blockerNames = (List)objectInputStream.readObject();
        this.datasetNames = (List)objectInputStream.readObject();
        this.distanceNames = (List)objectInputStream.readObject();
        this.expt = (MatchExpt[][][])objectInputStream.readObject();
        this.computable = false;
        objectInputStream.close();
    }

    public void runScript(String string) {
        int n = 0;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if (string2.startsWith("#")) continue;
                String string3 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                if (string3 == null) continue;
                if (this.echoCommands) {
                    System.out.println("exec: " + string2);
                }
                this.execCommand(string3, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + string + " line " + n + ": " + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    private void execCommand(String string, List list) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] classArray = new Class[list.size()];
        int n = 0;
        while (n < list.size()) {
            classArray[n] = class$java$lang$String == null ? MatchExptScript.class$("java.lang.String") : class$java$lang$String;
            ++n;
        }
        Method method = (class$com$wcohen$secondstring$expt$MatchExptScript == null ? (class$com$wcohen$secondstring$expt$MatchExptScript = MatchExptScript.class$("com.wcohen.secondstring.expt.MatchExptScript")) : class$com$wcohen$secondstring$expt$MatchExptScript).getMethod(string, classArray);
        method.invoke((Object)this, (Object[])list.toArray(new String[list.size()]));
    }

    public static void main(String[] stringArray) {
        try {
            MatchExptScript matchExptScript = new MatchExptScript();
            if (stringArray.length == 0) {
                System.out.println("usage: file1 file2 ...");
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    matchExptScript.runScript(stringArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

