;;==========================================================================;;
;; Silly geese demo, inspired by Richard A. Worthington.                    ;;
;; http://spatula-city.org/~im14u2c/intv/                                   ;;
;;==========================================================================;;

;* ======================================================================== *;
;*  TO BUILD IN BIN+CFG FORMAT:                                             *;
;*      as1600 -o geese.bin -l geese.lst geese.asm                          *;
;*                                                                          *;
;*  TO BUILD IN ROM FORMAT:                                                 *;
;*      as1600 -o geese.rom -l geese.lst geese.asm                          *;
;* ======================================================================== *;

;* ======================================================================== *;
;*  This demo (specifically, the contents of geese.asm) is hereby placed    *;
;*  into the public domain.  The library routines it includes are NOT       *;
;*  placed in the public domain, however.  You may distribute and/or        *;
;*  modify this demo as you see fit.  Enjoy!                                *;
;* ======================================================================== *;


        ROMW    16              ; Use standard 16-bit ROM width



;------------------------------------------------------------------------------
; Include system information
;------------------------------------------------------------------------------
        INCLUDE "../library/gimini.asm"

;------------------------------------------------------------------------------
; Allocate 8-bit variables in Scratch RAM
;------------------------------------------------------------------------------
SCRATCH     ORG     $100, $100, "-RWBN"
ISRVEC      RMB     2               ; Always at $100 / $101
WFLAG       RMB     1               ; ISR wait flag: ISR clears, fg task sets.
MFLAG       RMB     1               ; When 0, it's time to move all geese.
MDEC        RMB     1               ; Decrement control for geese movement.
DFLAG       RMB     1               ; direction to try to move the next goose.

_SCRATCH    EQU     $               ; end of scratch area




;------------------------------------------------------------------------------
; Allocate 16-bit variables in System RAM
;------------------------------------------------------------------------------
SYSTEM      ORG     $2F0, $2F0, "-RWBN"
STACK       RMB     32              ; Reserve 32 words for the stack

_SYSTEM     EQU     $               ; end of system area



;------------------------------------------------------------------------------
; EXEC-friendly ROM header.
;------------------------------------------------------------------------------
        ORG     $5000           ; Use default memory map
ROMHDR: BIDECLE ZERO            ; MOB picture base   (points to NULL list)
        BIDECLE ZERO            ; Process table      (points to NULL list)
        BIDECLE MAIN            ; Program start address
        BIDECLE ZERO            ; Bkgnd picture base (points to NULL list)
        BIDECLE ONES            ; GRAM pictures      (points to NULL list)
        BIDECLE TITLE           ; Cartridge title/date
        DECLE   $03C0           ; No ECS title, run code after title,
                                ; ... no clicks
ZERO:   DECLE   $0000           ; Screen border control
        DECLE   $0000           ; 0 = color stack, 1 = f/b mode
ONES:   DECLE   1, 1, 1, 1, 1   ; Initial color stack and border:  Blue
;------------------------------------------------------------------------------


;; ======================================================================== ;;
;;  TITLE  -- Display our modified title screen & copyright date.           ;;
;; ======================================================================== ;;
TITLE:  PROC
        BYTE    103, 'Geese', 0
        BEGIN

        ; Patch the title string to say '=JRMZ=' instead of Mattel.
        CALL    PRINT.FLS       ; Write string (ptr in R5)
        DECLE   C_WHT, $23D     ; White, Point to 'Mattel' in top-left
        STRING  '=JRMZ='        ; Guess who?  :-)
        STRING  ' Productions' 
        BYTE    0

        CALL    PRINT.FLS       ; Write string (ptr in R1)
        DECLE   C_WHT, $2D0     ; White, Point to 'Mattel' in lower-right
        STRING  '2002 =JRMZ='   ; Guess who?  :-)
        BYTE    0

        ; Done.
        RETURN                  ; Return to EXEC for title screen display
        ENDP


;; ======================================================================== ;;
;;  MAIN:  Here's our main program code.                                    ;;
;; ======================================================================== ;;
MAIN:   PROC
        DIS
        MVII    #STACK, R6

        CALL    CLRSCR          ; Clear the screen

        MVII    #ISR,   R0      ; Point to the ISR responsible for the ducks.
        MVO     R0,     ISRVEC
        SWAP    R0
        MVO     R0,     ISRVEC+1

        CLRR    R0
        MVO     R0,     MFLAG
        EIS

        CALL    WINT

        ;; Fill the screen with a pattern of geese.
        MVII    #$200,  R4
        MVII    #$800+7,R0      ; white geese for now.  Goose in card #0
        CLRR    R1          
        MVII    #1,     R3
        MVII    #240,   R2
@@init_loop:
        DECR    R1
        BPL     @@no_goose
        INCR    R3
        MOVR    R3,     R1
        XORI    #5,     R1
        ANDI    #7,     R3
        MVO@    R0,     R4
        DECR    R2
        BNEQ    @@init_loop
    B   @@init_done

@@no_goose:
    INCR    R4
        DECR    R2
        BNEQ    @@init_loop
@@init_done:

        ;; Main loop:  Whenever MFLAG expires, go through and pick 
        ;; directions for all the geese to move.  Once the directions are
        ;; picked, set MFLAG back to 8 so they all move.

@@gloop:
    MVII    #1, R0
    MVO R0, MDEC

        CALL    WINT
        MVI     MFLAG,  R0
        TSTR    R0
        BNEQ    @@gloop

        ;; first pass:  convert all the just-moved geese back to regular 
        ;; geese.  Moving geese occupy 2 cards.  The starting point has
        ;; an even card # and the ending point has an odd card #.
        MVII    #$200,  R4
        MVII    #240,   R2
        MVII    #$800+7,R1
        CLRR    R3
@@cloop:
        MVI@    R4,     R0      ; get a card from the screen
        TSTR    R0
        BEQ     @@no_goose_c    ; if zero, this ain't a goose.
    CMPR    R1, R0
    BEQ @@no_goose_c    ; this wasn't a moving goose

        DECR    R4              ; it's a moving goose, so back up for it.
        ANDI    #$8,    R0      ; look at lsb of card #
        BNEQ    @@put_goose_c   ; if set, put a stationary goose here.

        MVO@    R3,     R4      ; otherwise clear the card
        DECR    R2
        BNEQ    @@cloop
        B       @@cloop_done
@@put_goose_c
        MVO@    R1,     R4
@@no_goose_c:
        DECR    R2
        BNEQ    @@cloop
@@cloop_done:

    CLRR    R0
    MVO R0, MDEC
    MVII    #7, R0
    MVO R0, MFLAG
    CALL    WINT

        ;; second pass:  try to move the geese in 'random' directions.
        MVII    #$200,  R4
        MVI     DFLAG,  R1

@@mloop:
        MVI@    R4,     R0
        CMPI    #$807,  R0
        BNEQ    @@no_goose_m_


        DECR    R4
        MOVR    R4,     R3      ; copy pointer to goose

        ANDI    #$6,    R1      ; dispatch to code to try directions.
        ADDR    R1,     PC
        B       @@try_up
        B       @@try_down
        B       @@try_left
        B       @@try_right

@@try_up:
        MVII    #$800+2*8+7, R2 ; card for goose moving upward.

        SUBI    #20,    R3      ; and move it up a row
        CMPI    #$200,  R3      ; did it go off top of screen?
        BC      @@move_goose    ; no: it's ok
        ADDI    #240,   R3      ; yes: wrap around to bottom row.
        B       @@move_goose

@@try_down:
        MVII    #$800+6*8+7, R2 ; card for goose moving downward
        ADDI    #20,    R3      ; and move it up a row
        CMPI    #$2F0,  R3      ; did it go off bottom of screen?
        BNC     @@move_goose    ; no: it's ok
        SUBI    #240,   R3      ; yes: wrap around to top row.
        B       @@move_goose     

@@try_left:
        MVII    #$800+8*8+7, R2 ; card for goose moving leftward
        DECR    R3              ; and move it left a column
        CMPI    #$200,  R3      ; did it go off top of screen?
        BC      @@move_goose    ; no: it's ok
        ADDI    #240,   R3      ; yes: wrap around to right edge
        B       @@move_goose     

@@try_right:
        MVII    #$800+4*8+7, R2 ; card for goose moving downward
        INCR    R3              ; and move it right a column
        CMPI    #$2F0,  R3      ; did it go off bottom of screen?
        BNC     @@move_goose    ; no: it's ok
        SUBI    #240,   R3      ; yes: wrap around to left edge
;       B       @@move_goose     
        
@@move_goose:
        MVI@    R3,     R0      ; Check card at this location
        TSTR    R0
        BNEQ    @@no_goose_m    ; if it's non-empty, don't go here.

        MVO@    R2,     R4
        ADDI    #$8,    R2
        MVO@    R2,     R3

        ADDI    #2,     R1      ; we successfully moved in this direction.

        CMPI    #$2F0,  R4
        BNC     @@mloop
        B       @@mloop_done

@@no_goose_m
        INCR    R4
@@no_goose_m_
        CMPI    #$2F0,  R4
        BNC     @@mloop
        
@@mloop_done:
        MVO     R1,     DFLAG
        MVII    #8,     R0
        MVO     R0,     MFLAG
        B       @@gloop

        ENDP


;; ======================================================================== ;;
;;  WINT:  Spin, waiting for an interrupt.                                  ;;
;; ======================================================================== ;;
WINT    PROC
        CLRR    R0              ;
        MVO     R0,     WFLAG   ; Clear the 'waiting' flag
@@1     CMP     WFLAG,  R0      ; Wait for it to get set.
        BEQ     @@1             ;
        JR      R5              ; return
        ENDP


;; ======================================================================== ;;
;;  ISR                                                                     ;;
;; ======================================================================== ;;
ISR     PROC
        PSHR    R5

        MVO     R0,     $20     ; enable display
        MVII    #1,     R0      ;
        MVO     R0,     WFLAG   ;
        MVO     R0,     $28
        MVO     R0,     $2C

        ;; Find out if we're animating any motion.
        MVI     MFLAG,  R0
        SUB     MDEC,   R0
        BMI     @@no_move
        MVO     R0,     MFLAG

        ;; Copy over the 8 motion cards based on the frame number.
    ANDI    #$7,    R0
    SLL R0, 2
    SLL R0, 1
        ADDI    #MVGFX, R0
        MOVR    R0,     R4

        MVII    #$3810, R5
        MVII    #4,     R0

@@mv_loop:
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
@@copy1
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
        MVI@    R4,     R1
        MVO@    R1,     R5
        SWAP    R1
        MVO@    R1,     R5
    ADDI    #56,    R4
        DECR    R0
        BNEQ    @@mv_loop

        PULR    PC

@@no_move:
        ;; If we're not animating any motion, just copy over 1 card for
        ;; the stationary goose.
        MVII    #$3800, R5
        MVII    #MVGFX.up_0, R4
        MVII    #1,     R0
        B       @@copy1

        ENDP




;; ======================================================================== ;;
;;  LIBRARY INCLUDES                                                        ;;
;; ======================================================================== ;;
        INCLUDE "../library/print.asm"       ; PRINT.xxx routines
        INCLUDE "../library/fillmem.asm"     ; CLRSCR/FILLZERO/FILLMEM



;; ======================================================================== ;;
;;  Movement graphics.                                                      ;;
;; ======================================================================== ;;
MVGFX    PROC

@@up_7
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
@@up_6
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
@@up_5
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
@@up_4
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
@@up_3
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
@@up_2
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
@@up_1
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
@@up_0
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@right_7
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
@@right_6
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0100   ; .......#
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ....##..
            DECLE   $0E0C   ; ....###.
;           - - -           ; ....#...
            DECLE   $0808   ; ....#...
;           - - -           ; #####...
            DECLE   $F0F8   ; ####....
;           - - -           ; .#......
            DECLE   $6040   ; .##.....
@@right_5
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .......#
            DECLE   $0301   ; ......##
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ...##...
            DECLE   $1C18   ; ...###..
;           - - -           ; ...#....
            DECLE   $1010   ; ...#....
;           - - -           ; ####....
            DECLE   $E0F0   ; ###.....
;           - - -           ; #.......
            DECLE   $C080   ; ##......
@@right_4
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ......##
            DECLE   $0703   ; .....###
;           - - -           ; .......#
            DECLE   $0101   ; .......#
;           - - -           ; ..##....
            DECLE   $3830   ; ..###...
;           - - -           ; ..#.....
            DECLE   $2020   ; ..#.....
;           - - -           ; ###.....
            DECLE   $C0E0   ; ##......
;           - - -           ; ........
            DECLE   $8000   ; #.......
@@right_3
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....###
            DECLE   $0F07   ; ....####
;           - - -           ; ......#.
            DECLE   $0302   ; ......##
;           - - -           ; .##.....
            DECLE   $7060   ; .###....
;           - - -           ; .#......
            DECLE   $4040   ; .#......
;           - - -           ; ##......
            DECLE   $80C0   ; #.......
;           - - -           ; ........
            DECLE   $0000   ; ........
@@right_2
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ....####
            DECLE   $1F0F   ; ...#####
;           - - -           ; .....#..
            DECLE   $0604   ; .....##.
;           - - -           ; ##......
            DECLE   $E0C0   ; ###.....
;           - - -           ; #.......
            DECLE   $8080   ; #.......
;           - - -           ; #.......
            DECLE   $0080   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@right_1
;           - - -           ; .......#
            DECLE   $0101   ; .......#
;           - - -           ; .......#
            DECLE   $0101   ; .......#
;           - - -           ; ...#####
            DECLE   $3E1F   ; ..#####.
;           - - -           ; ....#...
            DECLE   $0C08   ; ....##..
;           - - -           ; #.......
            DECLE   $C080   ; ##......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@right_0
;           - - -           ; ......##
            DECLE   $0303   ; ......##
;           - - -           ; ......#.
            DECLE   $0202   ; ......#.
;           - - -           ; ..#####.
            DECLE   $7C3E   ; .#####..
;           - - -           ; ...#....
            DECLE   $1810   ; ...##...
;           - - -           ; ........
            DECLE   $8000   ; #.......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........

@@down_7
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
@@down_6
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
@@down_5
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@down_4
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@down_3
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@down_2
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@down_1
;           - - -           ; ........
            DECLE   $0600   ; .....##.
;           - - -           ; .....###
            DECLE   $0407   ; .....#..
;           - - -           ; .....#..
            DECLE   $7C04   ; .#####..
;           - - -           ; #####...
            DECLE   $20F8   ; ..#.....
;           - - -           ; ..##....
            DECLE   $0030   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@down_0
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
@@left_7
;           - - -           ; ........
            DECLE   $8000   ; #.......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ......##
            DECLE   $0303   ; ......##
;           - - -           ; ......#.
            DECLE   $0202   ; ......#.
;           - - -           ; ..#####.
            DECLE   $7C3E   ; .#####..
;           - - -           ; ...#....
            DECLE   $1810   ; ...##...
@@left_6
;           - - -           ; #.......
            DECLE   $C080   ; ##......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .......#
            DECLE   $0101   ; .......#
;           - - -           ; .......#
            DECLE   $0101   ; .......#
;           - - -           ; ...#####
            DECLE   $3E1F   ; ..#####.
;           - - -           ; ....#...
            DECLE   $0C08   ; ....##..
@@left_5
;           - - -           ; ##......
            DECLE   $E0C0   ; ###.....
;           - - -           ; #.......
            DECLE   $8080   ; #.......
;           - - -           ; #.......
            DECLE   $0080   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ....####
            DECLE   $1F0F   ; ...#####
;           - - -           ; .....#..
            DECLE   $0604   ; .....##.
@@left_4
;           - - -           ; .##.....
            DECLE   $7060   ; .###....
;           - - -           ; .#......
            DECLE   $4040   ; .#......
;           - - -           ; ##......
            DECLE   $80C0   ; #.......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .....###
            DECLE   $0F07   ; ....####
;           - - -           ; ......#.
            DECLE   $0302   ; ......##
@@left_3
;           - - -           ; ..##....
            DECLE   $3830   ; ..###...
;           - - -           ; ..#.....
            DECLE   $2020   ; ..#.....
;           - - -           ; ###.....
            DECLE   $C0E0   ; ##......
;           - - -           ; ........
            DECLE   $8000   ; #.......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ......##
            DECLE   $0703   ; .....###
;           - - -           ; .......#
            DECLE   $0101   ; .......#
@@left_2
;           - - -           ; ...##...
            DECLE   $1C18   ; ...###..
;           - - -           ; ...#....
            DECLE   $1010   ; ...#....
;           - - -           ; ####....
            DECLE   $E0F0   ; ###.....
;           - - -           ; #.......
            DECLE   $C080   ; ##......
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; .......#
            DECLE   $0301   ; ......##
;           - - -           ; ........
            DECLE   $0000   ; ........
@@left_1
;           - - -           ; ....##..
            DECLE   $0E0C   ; ....###.
;           - - -           ; ....#...
            DECLE   $0808   ; ....#...
;           - - -           ; #####...
            DECLE   $F0F8   ; ####....
;           - - -           ; .#......
            DECLE   $6040   ; .##.....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0100   ; .......#
;           - - -           ; ........
            DECLE   $0000   ; ........
@@left_0
;           - - -           ; .....##.
            DECLE   $0706   ; .....###
;           - - -           ; .....#..
            DECLE   $0404   ; .....#..
;           - - -           ; .#####..
            DECLE   $F87C   ; #####...
;           - - -           ; ..#.....
            DECLE   $3020   ; ..##....
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........
;           - - -           ; ........
            DECLE   $0000   ; ........

            ENDP
