package jzipdotorg;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;
import jzipdotorg.WorkHorse.*;

/**
 * Title: jzip.org
 * version 0.1.1
 * Description: GUI for jzip.org project
 * Copyright: Copyright (c) 2003 Grzegorz Kowal

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
 * author:Grzegorz Kowal - wolk!
 * contact: greg_kowal@hotmail.com
 */
 
 
public class GUI extends JFrame
{
  JPanel        contentPane;
  JMenuBar      jMenuBar1      = new JMenuBar();
  JMenu         jMenuFile      = new JMenu();
  JMenuItem     jMenuNew       = new JMenuItem();
  JMenuItem     jMenuOpen      = new JMenuItem();
  JMenuItem     jMenuAdd       = new JMenuItem();
  JMenuItem     jMenuExtract   = new JMenuItem();
  JMenuItem     jMenuDelete    = new JMenuItem();
  JMenuItem     jMenuFileExit  = new JMenuItem();
  JMenu         jMenuHelp      = new JMenu();
  JMenuItem     jMenuHelpAbout = new JMenuItem();
  JMenuItem     jMenuLicence   = new JMenuItem();
  JToolBar      jToolBar       = new JToolBar();
  JButton       jbNew          = new JButton();
  JButton       jbOpen         = new JButton();
  JScrollPane   jScrollPane1   = new JScrollPane();
  JButton       jbAdd          = new JButton();
  JButton       jbExtract      = new JButton();
  JButton       jbDelete       = new JButton();
  JTextField 	jTextField1    = new JTextField();
  WorkHorse     w              = new WorkHorse();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  String        title          = "<.:jzip.org - ";
  String        titleEnd       = ":.>";
  String        select         = "Select archive";
  String		work		   = "Working...";
  String		done		   = "Done!";
  ImageIcon     iNew           = new ImageIcon( GUI.class.getResource("/images/New.png"));
  ImageIcon     iOpen          = new ImageIcon( GUI.class.getResource("/images/Open.png"));
  ImageIcon     iAdd           = new ImageIcon( GUI.class.getResource("/images/Add.png"));
  ImageIcon     iExtract       = new ImageIcon( GUI.class.getResource("/images/Extract.png"));
  ImageIcon     iDelete        = new ImageIcon( GUI.class.getResource("/images/Delete.png"));
  ImageIcon     jzipIcon       = new ImageIcon( GUI.class.getResource("/images/jzip.org.png")); //GUI.class.getResource("images/jzip.org.png");
 //Vector		colNames	   = new Vector();
  String language;
  String country;
  Locale loc;
  ResourceBundle mess;
  String colNames[] = new String[4];
  JTable		jTable1;
  
 
  

  //Construct the frame
  public GUI() 
  {
  	language = "";
  	country  = "";
  	
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try 
    {
	      jbInit();
    }
    catch(Exception e) 
    {
	      e.printStackTrace();
    }
  }
  
    public GUI(String[] s) 
    {	    
	    if(s.length==1)
	    {
	    	language = "";
	    	country  = "";
	    	
		    
		    
		    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		    
		    try 
		    {
			      jbInit();
			      if(new File(s[0]).exists())
			      {
			      	jbExtract.setEnabled(true);  	
			      	
					jMenuExtract.setEnabled(true);
			      	
			      	setTitle(title + w.filename + titleEnd);
			      	
			      	w.openFile(new File(s[0]));			      		
			      	
			      	jTable1 = new JTable(w.getObject(), colNames);
    
    				jScrollPane1.getViewport().add(jTable1, null);

			      }
			      else
			      {
			      		JOptionPane o = new JOptionPane();
			      		o.showMessageDialog(this, mess.getString("nofile"));
			      }
		    }
		    catch(Exception e) 
		    {
		      	e.printStackTrace();
		    }
	    }
	    else if(s.length>=2)
	    {
	    	language = s[0];
	    	country  = s[1];
	    
		    //colNames.add("Names");
		    
		    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	    
		    try 
		    {
			      jbInit();
			      
			      if(s.length==3)
			      {
			      		if(new File(s[2]).exists())
			      		{
			      			jbExtract.setEnabled(true);  	
			      	
							jMenuExtract.setEnabled(true);
							
				      		w.openFile(new File(s[2]));
				      						      		
				      		setTitle(title + w.filename + titleEnd);
				      		
				      		jTable1 = new JTable(w.getObject(), colNames);
    
    						jScrollPane1.getViewport().add(jTable1, null);
				      	}
				      	else
				      	{
				      		JOptionPane o = new JOptionPane(mess.getString("nofile"),1);
				      		o.showMessageDialog(this, mess.getString("nofile"));
				      	}
			      }
		    }
		    catch(Exception e) 
		    {
		     	e.printStackTrace();
		    }
	    
	 	}
  }
  
  //Component initialization
  private void jbInit() throws Exception  
  {
  	loc  		= new Locale(language, country);
  	mess 		= ResourceBundle.getBundle("i18n/MessagesBundle", loc);

  	select 		= mess.getString("select");
  	work   		= mess.getString("work");
  	done   		= mess.getString("done");
  	colNames[0] = mess.getString("name");
  	colNames[1] = mess.getString("size");
  	colNames[2] = mess.getString("compres");
  	colNames[3] = mess.getString("time");

  	jTable1 	= new JTable(w.getObject(), colNames);
  	
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(gridBagLayout1);
    this.setSize(new Dimension(700, 351));
    this.setTitle(title + select + titleEnd);
    this.setIconImage(jzipIcon.getImage());

    jbNew.setVerticalAlignment(SwingConstants.BOTTOM);
    jbNew.setVerticalTextPosition(SwingConstants.BOTTOM);
    jbNew.setMaximumSize(new Dimension(47, 47));
    jbNew.setMinimumSize(new Dimension(47, 47));
    jbNew.setPreferredSize(new Dimension(47, 47));
    jbNew.setToolTipText(mess.getString("new"));
    jbNew.setHorizontalAlignment(SwingConstants.RIGHT);
    jbNew.setHorizontalTextPosition(SwingConstants.CENTER);
    jbNew.setIcon(iNew);
    jbNew.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jbNew_actionPerformed(e);
      }
    });

    jbOpen.setVerticalAlignment(SwingConstants.BOTTOM);
    jbOpen.setVerticalTextPosition(SwingConstants.BOTTOM);
    jbOpen.setMaximumSize(new Dimension(47, 47));
    jbOpen.setMinimumSize(new Dimension(47, 47));
    jbOpen.setPreferredSize(new Dimension(47, 47));
    jbOpen.setToolTipText(mess.getString("open"));
    jbOpen.setHorizontalTextPosition(SwingConstants.CENTER);
    jbOpen.setIcon(iOpen);
    jbOpen.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jbOpen_actionPerformed(e);
      }
    });

    jbAdd.setMaximumSize(new Dimension(47, 47));
    jbAdd.setMinimumSize(new Dimension(47, 47));
    jbAdd.setPreferredSize(new Dimension(47, 47));
    jbAdd.setToolTipText(mess.getString("add"));
    jbAdd.setHorizontalTextPosition(SwingConstants.CENTER);
    jbAdd.setIcon(iAdd);
    jbAdd.setVerticalTextPosition(SwingConstants.BOTTOM);
    jbAdd.setEnabled(false);
    jbAdd.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jbAdd_actionPerformed(e);
      }
    });

    jbExtract.setMaximumSize(new Dimension(47, 47));
    jbExtract.setMinimumSize(new Dimension(47, 47));
    jbExtract.setPreferredSize(new Dimension(47, 47));
    
    jbExtract.setToolTipText(mess.getString("extract"));
    jbExtract.setHorizontalTextPosition(SwingConstants.CENTER);
    jbExtract.setIcon(iExtract);
    
    jbExtract.setVerticalTextPosition(SwingConstants.BOTTOM);
    jbExtract.setEnabled(false);
    jbExtract.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jbExtract_actionPerformed(e);
      }
    });

    jbDelete.setMaximumSize(new Dimension(47, 47));
    jbDelete.setMinimumSize(new Dimension(47, 47));
    jbDelete.setPreferredSize(new Dimension(47, 47));
    
    jbDelete.setToolTipText(mess.getString("delete"));
    jbDelete.setHorizontalTextPosition(SwingConstants.CENTER);
    jbDelete.setVerticalTextPosition(SwingConstants.BOTTOM);
    jbDelete.setIcon(iDelete);
    
    jbDelete.setEnabled(false);
    jbDelete.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jbDelete_actionPerformed(e);
      }
    });

    jToolBar.add(jbNew, null);
    jToolBar.add(jbOpen, null);
    jToolBar.add(jbAdd, null);
    jToolBar.add(jbExtract, null);
    jToolBar.add(jbDelete, null);

    contentPane.add(jToolBar,   new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, -3, 0, 12), 187, -1));



    jMenuFile.setText(mess.getString("file"));
    jMenuHelp.setText(mess.getString("help"));

    jMenuNew.setText(mess.getString("new"));
    jMenuNew.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuNew_actionPerformed(e);
      }
    });

    jMenuOpen.setText(mess.getString("open"));
    jMenuOpen.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuOpen_actionPerformed(e);
      }
    });

    jMenuAdd.setText(mess.getString("add"));
    jMenuAdd.setEnabled(false);
    jMenuAdd.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuAdd_actionPerformed(e);
      }
    });

    jMenuExtract.setText(mess.getString("extract"));
    jMenuExtract.setEnabled(false);
    jMenuExtract.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuExtract_actionPerformed(e);
      }
    });

    jMenuDelete.setText(mess.getString("delete"));
    jMenuDelete.setEnabled(false);
    jMenuDelete.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuDelete_actionPerformed(e);
      }
    });

    jMenuFileExit.setText(mess.getString("exit"));
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    jMenuHelpAbout.setText(mess.getString("about"));
    jMenuHelpAbout.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e) {
        jMenuHelpAbout_actionPerformed(e);
      }
    });
    jMenuLicence.setText(mess.getString("licence"));
    jMenuLicence.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuLicence_actionPerformed(e);
      }
    });

    jMenuFile.add(jMenuNew);
    jMenuFile.add(jMenuOpen);
    jMenuFile.add(jMenuAdd);
    jMenuFile.add(jMenuExtract);
    jMenuFile.add(jMenuDelete);
    jMenuFile.add(jMenuFileExit);
    jMenuFile.addSeparator();
    jMenuFile.addSeparator();

    jMenuHelp.add(jMenuHelpAbout);
    jMenuHelp.add(jMenuLicence);

    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);

    this.setJMenuBar(jMenuBar1);

    contentPane.add(jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 4, 0, 4), 135, 93));
    contentPane.add(jTextField1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTHWEST, GridBagConstraints.BOTH, new Insets(3, 4, 3, 4), 547, 0));
 
    jScrollPane1.getViewport().add(jTable1, null);

  }

  //File | New action performed
  public void jMenuNew_actionPerformed(ActionEvent e)
  {
	jbNew_actionPerformed(e);
  }

  //File | Open action performed
  public void jMenuOpen_actionPerformed(ActionEvent e)
  {
	jbOpen_actionPerformed(e);
  }

  //File | Add action performed
  public void jMenuAdd_actionPerformed(ActionEvent e)
  {
	jbAdd_actionPerformed(e);
  }

  //File | Extract action performed
  public void jMenuExtract_actionPerformed(ActionEvent e)
  {
	jbExtract_actionPerformed(e);
  }

  //File | Delete action performed
  public void jMenuDelete_actionPerformed(ActionEvent e)
  {
	jbDelete_actionPerformed(e);
  }

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e)
  {
    System.exit(0);
  }
  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e)
  {
    GUI_AboutBox dlg = new GUI_AboutBox(this);
    
    Dimension dlgSize = dlg.getPreferredSize();
    
    Dimension frmSize = getSize();
    
    Point loc = getLocation();
    
    dlg.setTitle(mess.getString("about"));
        
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    
    dlg.setModal(true);
    
    dlg.show();
  }

  //Help | Licence action performed
  public void jMenuLicence_actionPerformed(ActionEvent e)
  {
  	
    Licence dlg = new Licence(this);
    
    dlg.setSize(550,400);    
        
    Dimension frmSize = getSize();
    
    Point loc = getLocation();
    
    dlg.setTitle(mess.getString("licence"));    
    
    dlg.setLocation((frmSize.width - 400) / 2 + loc.x, (frmSize.height - 300 ) / 2 + loc.y);
    
    dlg.show();
  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  boolean jbNew_actionPerformed(ActionEvent e)
  {
	
    JFileChooser fileChooser = new JFileChooser();

    fileChooser.addChoosableFileFilter(new MyFilter());

    fileChooser.setCurrentDirectory(new File("/"));

	fileChooser.setFileSelectionMode( JFileChooser.FILES_ONLY );

	int selection = fileChooser.showDialog( this, mess.getString("createAR") );

	if ( selection == JFileChooser.CANCEL_OPTION )
	{
		return false;
	}		

    w.newFile(fileChooser);
    
    jTable1 = new JTable(w.getObject(), colNames);
    
    jScrollPane1.getViewport().add(jTable1, null);
    
    setTitle( title + w.filename + titleEnd);

    jbAdd.setEnabled(true);
    
    jbExtract.setEnabled(false);
    
    jbDelete.setEnabled(false);
    
    jMenuAdd.setEnabled(true);
    
    jMenuExtract.setEnabled(false);
    
    jMenuDelete.setEnabled(false);

    return true;
  }

    boolean jbOpen_actionPerformed(ActionEvent e)
  {
  	
  	jTextField1.setText(work);
  	  	
	JFileChooser fileChooser = new JFileChooser();

	fileChooser.setFileSelectionMode( JFileChooser.FILES_ONLY );

    fileChooser.setCurrentDirectory(new File("/"));

    fileChooser.addChoosableFileFilter(new MyFilter());

	int selection = fileChooser.showDialog( this, mess.getString("openAR") );

	if ( selection == JFileChooser.CANCEL_OPTION )
	{
            return false;
	}	

	w.ent.clear();

    w.openFile(fileChooser.getSelectedFile());

    this.setTitle( title + w.filename + titleEnd);      
    
    jTable1 = new JTable(w.getObject(), colNames);
    
    jScrollPane1.getViewport().add(jTable1, null);
        
    jTextField1.setText(done);

	jbExtract.setEnabled(true);
	
	jbAdd.setEnabled(true);
	
	jbDelete.setEnabled(true);
	
	jMenuExtract.setEnabled(true);
	
	jMenuAdd.setEnabled(false);
	
	jMenuDelete.setEnabled(false);

	return true;
	
  }

  boolean jbAdd_actionPerformed(ActionEvent e)
  {
  	
  	jTextField1.setText(work);

	JFileChooser fileChooser = new JFileChooser();

    fileChooser.setFileSelectionMode( JFileChooser.FILES_AND_DIRECTORIES );

    fileChooser.setCurrentDirectory(new File("c:/My Documents"));

    fileChooser.setFileHidingEnabled(false);

    fileChooser.setMultiSelectionEnabled(true);

	int selection = fileChooser.showDialog( this, mess.getString("selectFI") );

	if ( selection == JFileChooser.CANCEL_OPTION )
	{
            return false;
	}

	w.addFile(fileChooser);

	jTable1 = new JTable(w.getObject(), colNames);
    
    jScrollPane1.getViewport().add(jTable1, null);
	
	jTextField1.setText(done);

    jbExtract.setEnabled(true);
    
    jbAdd.setEnabled(false);
    
    jMenuExtract.setEnabled(true);
    
    jMenuAdd.setEnabled(false);

	return true;
	
  }

  boolean jbExtract_actionPerformed(ActionEvent e)
  {	
  	int selected[];
  	
  	selected = jTable1.getSelectedRows();
  	   	
  	jTextField1.setText(work);
  	
  	if(selected.length ==0)
  	{
  		jTable1.setRowSelectionInterval(0, jTable1.getRowCount() - 1);
  	
  		selected = jTable1.getSelectedRows();
  		
  	}  
  		
	Object p[] = new Object[selected.length];
	
	for (int i=0; i < p.length; i++)
	{
		p[i] = jTable1.getValueAt(selected[i],0);
	}
	
	jTable1.setCellSelectionEnabled(false);

	JFileChooser fileChooser = new JFileChooser();

	fileChooser.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );

	fileChooser.setCurrentDirectory(new File("c:/My Documents"));

	fileChooser.setFileHidingEnabled(false);

	int selection = fileChooser.showDialog( this, mess.getString("selectDE") );

	if ( selection == JFileChooser.CANCEL_OPTION )
	{
	    return false;
	}

	w.extractFile(fileChooser, p);
	
	jTextField1.setText(done);    
    
    return true;
  }

  boolean jbDelete_actionPerformed(ActionEvent e)
  {
	return true;//stub
  }



}//end of GUI

