# UNIX C makefile for the JZIP Infocom interpreter
# JZIP 2.0.1g
#
# If you have a:    |  CC=  |  CFLAGS =      |  LIBS =     |
#    RS6000 / AIX   |  xlc  |  -c -DAIX      |  -ltermcap  |
#    SGI / Irix 4.x |  cc   |  -c -DPOSIX    |  -lcurses   |
#    SGI / Irix 5.x |  cc   |  -c -DPOSIX    |  -lcurses   |
#                   |       |  -DHAVE_GETOPT |             |
#    SPARC / SunOS  |  cc   |  -c -DPOSIX    |  -ltermcap  |
#    SPARC /Solaris |  gcc  |  -c -DPOSIX    |  -ltermcap  |
#                   |       |  -DHAVE_BCOPY  |             |
#                   |       |  -DHAVE_GETOPT |             |
#    NeXT / Mach    |  cc   |  -c -DBSD      |  -ltermcap  |    
#    Alpha / OSF/1  |  cc   |  -c -DPOSIX    |  -lcurses   |
#    HP9000 / HP-UX |  gcc  |  -c -DPOSIX    |  -ltermcap  |
#    Linux          |  gcc  |  -c -DPOSIX    |  -ltermcap  | 
#    FreeBSD        |  ??   |  -c -DBSD      |  -ltermcap  | (not tested)
#    DEC / Ultrix   |  cc   |  -c -DPOSIX    |  -lcurses   | (not tested)
#
# To try and use ANSI color escape sequences, try adding
# -DHARD_COLORS
# to the CFLAGS line.

CC = cc
CFLAGS = -c -DPOSIX 
LDFLAGS = -O
LIBS = -ltermcap

INC = ztypes.h
OBJS = jzip.o control.o extern.o fileio.o input.o interpre.o math.o memory.o \
	object.o operand.o osdepend.o property.o screen.o text.o variable.o \
	unixio.o

all  : jzip jzexe

jzexe : jzexe.h
	$(CC) -o $@ $(LDFLAGS) jzexe.c

jzip : $(OBJS)
	$(CC) -o $@ $(LDFLAGS) $(OBJS) $(LIBS)

jzip.o: $(INC) jzip.c extern.c
	$(CC) $(CFLAGS) jzip.c

control.o: $(INC) control.c extern.c
	$(CC) $(CFLAGS) control.c

extern.o: $(INC) extern.c
	$(CC) $(CFLAGS) extern.c

fileio.o: $(INC) fileio.c extern.c
	$(CC) $(CFLAGS) fileio.c

input.o: $(INC) input.c extern.c
	$(CC) $(CFLAGS) input.c

interpre.o: $(INC) interpre.c extern.c
	$(CC) $(CFLAGS) interpre.c

math.o: $(INC) math.c extern.c
	$(CC) $(CFLAGS) math.c

memory.o: $(INC) memory.c extern.c
	$(CC) $(CFLAGS) memory.c

object.o: $(INC) object.c extern.c
	$(CC) $(CFLAGS) object.c

operand.o: $(INC) operand.c extern.c
	$(CC) $(CFLAGS) operand.c

osdepend.o: $(INC) osdepend.c extern.c
	$(CC) $(CFLAGS) osdepend.c

property.o: $(INC) property.c extern.c
	$(CC) $(CFLAGS) property.c

screen.o: $(INC) screen.c extern.c
	$(CC) $(CFLAGS) screen.c

text.o: $(INC) text.c extern.c
	$(CC) $(CFLAGS) text.c

variable.o: $(INC) variable.c extern.c
	$(CC) $(CFLAGS) variable.c

unixio.o: $(INC) unixio.c extern.c
	$(CC) $(CFLAGS) unixio.c

clean :
	-rm *.o jzip jzexe
