/***************************************************************************
                             KlassModelerApp.cpp
                             -------------------
    begin                : Thu April 3, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "KlassModelerApp.h"
#include "MainFrame.h"
#include "KlassModelerDoc.h"
#include "KlassModelerView.h"
#include <wx/menu.h>
#include <wx/image.h>
#include <wx/cmdline.h>
#include <fcntl.h>
#ifdef __WXMSW__
#include <commctrl.h>
#include <io.h>
#else
#include <unistd.h>
#endif

IMPLEMENT_APP(CKlassModelerApp)

CKlassModelerApp::CKlassModelerApp()
{
	m_pDocManager = NULL;
	m_pMainFrame = NULL;
}
	
CKlassModelerApp::~CKlassModelerApp()
{
}

bool CKlassModelerApp::OnInit()
{
	wxImage::AddHandler( new wxPNGHandler );
	m_pDocManager = new wxDocManager;
	new wxDocTemplate( m_pDocManager, _T("KlassModel"), _T("*.kml"), _T(""), _T("kml"),
					   _T("KlassModelerDoc"), _T("KlassModelerView"),
					   CLASSINFO(CKlassModelerDoc), CLASSINFO(CKlassModelerView) );
	m_pMainFrame = new CMainFrame( m_pDocManager, _T("KlassModeler"), wxSize(200,600) );
	m_pPrintData = new wxPrintData();
	// set up the menus
	// file menu
	wxMenu *pFileMenu = new wxMenu;
	pFileMenu->Append( wxID_NEW, _T("&New \tCtrl-N") );
	pFileMenu->Append( wxID_OPEN, _T("&Open... \tCtrl-O") );
	pFileMenu->Append( wxID_SAVE, _T("&Save \tCtrl-S") );
	pFileMenu->Append( wxID_SAVEAS, _T("Save &As... \tCtrl-A") );
	pFileMenu->AppendSeparator();
	pFileMenu->Append( wxID_EXIT, _T("E&xit\tAlt-X") );
	m_pDocManager->FileHistoryUseMenu(pFileMenu);
	// generate menu
	wxMenu *pGenerateMenu = new wxMenu;
	pGenerateMenu->Append( KM_GENERATE_CODE, _T("&Headers\tCtrl-H") );
	pGenerateMenu->Append( KM_GENERATE_HTML, _T("HTML &Docs\tCtrl-D") );
	// help menu
	wxMenu *pHelpMenu = new wxMenu;
	pHelpMenu->Append( KLASSMODELER_CONTENTS, _T("&Contents") );
	pHelpMenu->AppendSeparator();
	pHelpMenu->Append( KLASSMODELER_ABOUT, _T("&About") );
	// main menu bar
	wxMenuBar *pMenuBar = new wxMenuBar;
	pMenuBar->Append( pFileMenu, _T("&File") );
	pMenuBar->Append( pGenerateMenu, _T("&Generate") );
	pMenuBar->Append( pHelpMenu, _T("&Help") );
	m_pMainFrame->SetMenuBar( pMenuBar );

	m_pMainFrame->Init();
	m_pMainFrame->Show( true );
	SetTopWindow( m_pMainFrame );
	if( argc == 2 ){
		CKlassModelerDoc	*pNewDoc;
		int					fd;
		fd = open( argv[1], O_RDONLY );
		if( fd != -1 ){
			close( fd );
			pNewDoc = (CKlassModelerDoc*)m_pDocManager->CreateDocument( "", wxDOC_NEW );
			pNewDoc->OnOpenDocument( argv[1] );
			pNewDoc->SetFilename( argv[1] );
		}
	}

	return true;
}

int CKlassModelerApp::OnExit()
{
	delete m_pDocManager;
	delete m_pPrintData;

	return 0;
}
