/***************************************************************************
									  KlassModelerView.cpp
                             -------------------
    begin                : Thu April 3, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "KlassModelerView.h"
#include "KlassModelerApp.h"
#include "KlassModelerDoc.h"
#include "ModelCanvas.h"
#include "MainFrame.h"
#include "ModelPrinter.h"
#include <wx/docview.h>
#include <wx/event.h>
#include <wx/printdlg.h>

IMPLEMENT_DYNAMIC_CLASS(CKlassModelerView,wxView)

BEGIN_EVENT_TABLE(CKlassModelerView,wxView)
	EVT_ACTIVATE( CKlassModelerView::OnActivate )
	EVT_MENU( KM_PRINT, CKlassModelerView::OnPrint )
	EVT_MENU( KM_VIEW_GRID, CKlassModelerView::OnViewGrid )
	EVT_MENU( KM_LGENERATE_CODE, CKlassModelerView::OnGenerateCode )
	EVT_MENU( KM_LGENERATE_HTML, CKlassModelerView::OnGenerateHTML )
END_EVENT_TABLE()

CKlassModelerView::CKlassModelerView()
	: wxView()
{
	m_pFrame = NULL;
	m_pDoc = NULL;
}

CKlassModelerView::~CKlassModelerView()
{
}

bool CKlassModelerView::OnCreate( wxDocument *pDoc, long Flags )
{
	CKlassModelerApp	&App = (CKlassModelerApp&)wxGetApp();
	
	m_pDoc = (CKlassModelerDoc*)pDoc;
	m_pFrame = new wxDocChildFrame( pDoc, (wxView*)this, (wxFrame*)App.GetMainFrame(), -1,
									_T("KlassModelerView"), wxDefaultPosition, wxSize(600,600) );
	if( m_pFrame == NULL )
		return false;
	m_pCanvas = new CModelCanvas( this, m_pFrame );
	if( m_pCanvas == NULL )
		return false;
	m_pCanvas->SetVirtualSize( CONTENTS_WIDTH, CONTENTS_HEIGHT );
	m_pCanvas->SetScrollRate( 10, 10 );
	m_pCanvas->SetBackgroundColour( *wxWHITE );
	m_pCanvas->Clear();
	m_pCanvas->ComputeSizes();
	// set up the menus
	// file menu
	wxMenu *pFileMenu = new wxMenu;
	pFileMenu->Append( wxID_SAVE, _T("&Save \tCtrl-S") );
	pFileMenu->Append( wxID_SAVEAS, _T("Save &As... \tCtrl-A") );
	pFileMenu->AppendSeparator();
	pFileMenu->Append( KM_PRINT, _T("&Print...\tCtrl-P") );
	pFileMenu->Append( wxID_PRINT_SETUP, _T("Print S&etup...\tCtrl-E") );
	pFileMenu->AppendSeparator();
	pFileMenu->Append( wxID_CLOSE, _T("&Close\tAlt-C") );
	// generate menu
	wxMenu *pGenerateMenu = new wxMenu;
	pGenerateMenu->Append( KM_LGENERATE_CODE, _T("&Headers\tCtrl-H") );
	pGenerateMenu->Append( KM_LGENERATE_HTML, _T("HTML &Docs\tCtrl-D") );
	// view menu
	wxMenu *pViewMenu = new wxMenu;
	pViewMenu->AppendCheckItem( KM_VIEW_GRID, _T("Printer Grid") );
	// help menu
	wxMenu *pHelpMenu = new wxMenu;
	pHelpMenu->Append( KLASSMODELER_CONTENTS, _T("&Contents") );
	pHelpMenu->AppendSeparator();
	pHelpMenu->Append( KLASSMODELER_ABOUT, _T("&About") );
	// main menu bar
	wxMenuBar *pMenuBar = new wxMenuBar;
	pMenuBar->Append( pFileMenu, _T("&File") );
	pMenuBar->Append( pGenerateMenu, _T("&Generate") );
	pMenuBar->Append( pViewMenu, _T("View") );
	pMenuBar->Append( pHelpMenu, _T("&Help") );
	// attatch to the frame
	m_pFrame->SetMenuBar( pMenuBar );

	m_pFrame->Show( true );
	
	return true;
}

bool CKlassModelerView::OnClose( bool bDeleteWindow )
{
	if( !GetDocument()->Close() )
		return false;
	m_pCanvas->Clear();
	m_pCanvas->Detach();
	m_pCanvas = NULL;
	SetFrame( NULL );
	Activate( false );
	if( bDeleteWindow )
		delete m_pFrame;
	wxGetApp().GetMainFrame()->DrawTree( NULL, true );

	return true;
}
	
void CKlassModelerView::OnUpdate( wxView *pSender, wxObject *pHint )
{
	if( m_pCanvas && (pSender!=this) )
		m_pCanvas->Refresh();
	wxGetApp().GetMainFrame()->DrawTree( GetDoc(), false );
}

void CKlassModelerView::OnDraw( wxDC *pDC )
{
	if( m_pCanvas ){
		int w, h;
		pDC->GetSize( &w, &h );

		m_pCanvas->OnDraw( *pDC );
	}
}

void CKlassModelerView::OnActivate( wxActivateEvent &Event )
{
	if( m_pFrame == NULL )
		return;
	if( m_pFrame->IsEnabled() && Event.GetActive() ){
		wxGetApp().GetMainFrame()->DrawTree( GetDoc(), false );
	}
}

void CKlassModelerView::OnPrint( wxCommandEvent& event )
{
	wxPrintDialogData	PrintDialogData( *(wxGetApp().GetPrintData()) );
    wxPrinter			Printer( &PrintDialogData );
    CModelPrinter		Printout( _T("KlassModeler Printout"), m_pCanvas );

    if( !Printer.Print( m_pFrame, &Printout, TRUE ) ){
        if( wxPrinter::GetLastError() == wxPRINTER_ERROR )
            wxMessageBox(_T("There was a problem printing.\nPerhaps your current printer is not set correctly?"), _T("Printing"), wxOK);
    } else {
        *(wxGetApp().GetPrintData()) = Printer.GetPrintDialogData().GetPrintData();
    }
}

void CKlassModelerView::OnViewGrid( wxCommandEvent &Event )
{
	m_pCanvas->EnableGrid( Event.IsChecked() );
}

void CKlassModelerView::OnGenerateCode( wxCommandEvent &Event )
{
	bool	bSuccess;

	m_pFrame->SetCursor( *wxHOURGLASS_CURSOR );
	bSuccess = GetDoc()->GenerateCode();
	m_pFrame->SetCursor( *wxSTANDARD_CURSOR );
	if( !bSuccess )
		wxMessageBox( _T("Error generating header"), _T("Error") );
	else {
		wxString Output;
		Output = _T("Headers enerated succesfully.  You can find them at ");
		Output += GetDoc()->GetBasePath().c_str();
		wxMessageBox( Output, _T("Success") );
	}
}

void CKlassModelerView::OnGenerateHTML( wxCommandEvent &Event )
{
	bool	bSuccess;

	m_pFrame->SetCursor( *wxHOURGLASS_CURSOR );
	bSuccess = GetDoc()->GenerateHTML( m_pCanvas );
	m_pFrame->SetCursor( *wxSTANDARD_CURSOR );
	if( !bSuccess )
		wxMessageBox( _T("Error generating HTML"), _T("Error") );
	else {
		wxString Output;
		Output = _T("HTML Generated succesfully.  You can find them at ");
		Output += GetDoc()->GetBasePath().c_str();
		wxMessageBox( Output, _T("Success") );
	}
}

