/***************************************************************************
							 Log.cpp
                             -------------------
    begin                : Thu April 17, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include "Log.h"
#include <stdio.h>
#include <stdarg.h>

// global CLog object
CLog	MasterLog( LVL_LOW );

CLog::CLog( int Level )
{
	m_pFile = fopen( "Logfile.txt", "w" );
	m_Level = Level;
}

CLog::~CLog()
{
	if( m_pFile != NULL )
		fclose( m_pFile );
}

// in cases where I'm trying to debug a crash it would
// be nice to flush the file to make sure it writes when
// I want it to.  Sort of ugly, but it's just for debugging.
void CLog::Flush()
{
	if( m_pFile != NULL )
		fclose( m_pFile );
	m_pFile = fopen( "Logfile.txt", "a+" );
}

void CLog::Log( int Level, char *Format, ... )
{
	if( (Level > m_Level) || (m_pFile==NULL) )
		return;
	char	szBuf[256];
	va_list vl;

	va_start( vl, Format );
	szBuf[255] = 0;
	vfprintf( m_pFile, Format, vl );
#ifdef _DEBUG
	Flush();
#endif
}
