/***************************************************************************
							 ObjectNotebook.cpp
                             -------------------
    begin                : Wed April 9, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "ObjectNotebook.h"
#include "CodeObjectsDlg.h"
#include "Log.h"
#include "KlassModelerDoc.h"
#include "UpArrow.xbm"
#include "DownArrow.xbm"
#include <wx/listctrl.h>
#include <wx/image.h>

#define MADD_METHOD			100
#define MDEL_METHOD			101
#define MSET_DOC			102
#define MMETHOD_LIST		103
#define MUP_ARROW			104
#define MDOWN_ARROW			105
#define VADD_METHOD			106
#define VDEL_METHOD			107
#define VSET_DOC			108
#define VVARIABLE_LIST		109
#define VUP_ARROW			110
#define VDOWN_ARROW			111
#define INHERITENCE_LIST	112
#define ADD_INHERITENCE		113
#define DEL_INHERITENCE		114
#define RELATION_LIST		115
#define ADD_HASA			116
#define ADD_USESA			117
#define DEL_RELATION		118
#define ENUM_LIST			119
#define ADD_ENUM			120
#define SET_ENUM			121
#define DEL_ENUM			122

#define IMAGE_SQUARE		7
#define RELATION_SQUARE		15

extern CLog MasterLog;

BEGIN_EVENT_TABLE(CObjectNotebook,wxNotebook)
	// method list
	EVT_LIST_ITEM_ACTIVATED(MMETHOD_LIST,CObjectNotebook::OnMethodActivated)
	EVT_LIST_ITEM_SELECTED(MMETHOD_LIST,CObjectNotebook::OnMethodSelected)
	EVT_BUTTON(MUP_ARROW,CObjectNotebook::OnMethodUpArrow)
	EVT_BUTTON(MDOWN_ARROW,CObjectNotebook::OnMethodDownArrow)
	EVT_BUTTON(MADD_METHOD,CObjectNotebook::OnAddMethod)
	EVT_BUTTON(MDEL_METHOD,CObjectNotebook::OnDelMethod)
	EVT_BUTTON(MSET_DOC,CObjectNotebook::OnSetMethodDoc)
	// variable list
	EVT_LIST_ITEM_ACTIVATED(VVARIABLE_LIST,CObjectNotebook::OnVariableActivated)
	EVT_LIST_ITEM_SELECTED(VVARIABLE_LIST,CObjectNotebook::OnVariableSelected)
	EVT_BUTTON(VUP_ARROW,CObjectNotebook::OnVariableUpArrow)
	EVT_BUTTON(VDOWN_ARROW,CObjectNotebook::OnVariableDownArrow)
	EVT_BUTTON(VADD_METHOD,CObjectNotebook::OnAddVariable)
	EVT_BUTTON(VDEL_METHOD,CObjectNotebook::OnDelVariable)
	EVT_BUTTON(VSET_DOC,CObjectNotebook::OnSetVariableDoc)
	// inheritence list
	EVT_BUTTON(ADD_INHERITENCE,CObjectNotebook::OnAddInheritence)
	EVT_BUTTON(DEL_INHERITENCE,CObjectNotebook::OnDelInheritence)
	// relations list
	EVT_BUTTON(ADD_HASA,CObjectNotebook::OnAddHasA)
	EVT_BUTTON(ADD_USESA,CObjectNotebook::OnAddUsesA)
	EVT_BUTTON(DEL_RELATION,CObjectNotebook::OnDelRelation)
	// enum list
	EVT_LIST_ITEM_SELECTED(ENUM_LIST,CObjectNotebook::OnEnumSelected)
	EVT_BUTTON(ADD_ENUM,CObjectNotebook::OnAddEnum)
	EVT_BUTTON(SET_ENUM,CObjectNotebook::OnSetEnum)
	EVT_BUTTON(DEL_ENUM,CObjectNotebook::OnDelEnum)
END_EVENT_TABLE()

CObjectNotebook::CObjectNotebook( CCodeObjectsDlg *pParent, CKlassModelerDoc *pDoc, wxWindowID ID, const wxPoint &Pos, const wxSize &Size )
	: wxNotebook( pParent, ID, Pos, Size )
{
	m_pParentDlg = pParent;
	m_pClass = NULL;
	m_pDoc = pDoc;
}

CObjectNotebook::~CObjectNotebook()
{
	DeleteAllPages();
}

void CObjectNotebook::CloseUp()
{
	if( m_Type == TClass ){
		m_pClass->SetDoc( (const char*)m_pDocText->GetValue() );
		m_pClass->SetIsQObject( m_pIsQtObjectCheck->IsChecked() );
		m_pClass->SetExcludeHeader( m_pExcludeHeader->IsChecked() );
		m_pClass->SetExcludeHTML( m_pExcludeHTML->IsChecked() );
		if( m_pHeaderFileText->GetValue().IsEmpty() )
			m_pClass->SetHeaderFile( m_pClass->GetName()+".h" );
		else
			m_pClass->SetHeaderFile( (const char*)m_pHeaderFileText->GetValue() );
		if( m_pHTMLFileText->GetValue().IsEmpty() )
			m_pClass->SetHTMLFile( m_pClass->GetName()+".html" );
		else
			m_pClass->SetHTMLFile( (const char*)m_pHTMLFileText->GetValue() );
	} else if( m_Type == TMethod ){
		m_pMethod->SetDoc( (const char*)m_pDocText->GetValue() );
		m_pMethod->SetInlineCode( (const char*)m_pMethodBodyText->GetValue() );
	} else if( m_Type == TVariable ){
		m_pVariable->SetDoc( (const char*)m_pDocText->GetValue() );
	}
}

void CObjectNotebook::BuildForClass( CClass *pClass )
{
	m_pClass = pClass;
	m_Type = TClass;
	CreateMethodListPage();
	CreateVariableListPage();
	CreateDocsPage();
	CreateRelationsPage();
	CreateClassMiscPage();
}

void CObjectNotebook::BuildForMethod( CMethod *pMethod )
{
	m_pMethod = pMethod;
	m_Type = TMethod;
	CreateVariableListPage();
	CreateDocsPage();
	CreateMethodCodePage();
}

void CObjectNotebook::BuildForVariable( CVariable *pVariable )
{
	m_pVariable = pVariable;
	m_Type = TVariable;
	CreateDocsPage();
}

void CObjectNotebook::CreateMethodListPage()
{
	wxPanel			*pPage=new wxPanel( this );
	// there's a dirty bug in gtk (or wxWindows?) that makes it so I can't put
	// a wxBitmap from a XBM into a wxBitmapButton.  It throws an exception.
	// so I get around this by loading the xbm into an wxImage, then loading
	// that into a wxBitmap, and loading that into a wxBitmapButton.
	// It's a dirty hack, but it keeps it from crashing
	wxBitmap		UpArrowHack( (const char*)UpArrow_bits, 10, 16 );
	wxImage			UpArrow( UpArrowHack );
	wxBitmap		DownArrowHack( (const char*)DownArrow_bits, 10, 16 );
	wxImage			DownArrow( DownArrowHack );
	wxImageList		*pImageList;

	// create the UI
	m_pMethodList = new wxListCtrl( pPage, MMETHOD_LIST, wxPoint(5,5), 
								  wxSize(295,205), wxLC_REPORT );
	pImageList = new wxImageList;
	CreateAccessImages( pImageList );
	m_pMethodList->AssignImageList( pImageList, wxIMAGE_LIST_SMALL );
	m_pMethodList->InsertColumn( 0, _T("") );
	m_pMethodList->InsertColumn( 1, _T("Name") );
	m_pMethodList->InsertColumn( 2, _T("Type") );
	m_pMethodList->SetColumnWidth( 0, 10 );
	m_pMethodList->SetColumnWidth( 1, 160 );
	m_pMethodList->SetColumnWidth( 2, 120 );
	m_pMethodDocText = new wxTextCtrl( pPage, -1, _T(""), wxPoint(5,220), wxSize(240, 120), wxTE_MULTILINE  );
	new wxButton( pPage, MADD_METHOD, wxT("Add Method"),
			      wxPoint(260, 225), wxSize(-1, -1) );
	new wxButton( pPage, MDEL_METHOD, wxT("Del Method"),
			      wxPoint(260, 265), wxSize(-1, -1) );
	new wxButton( pPage, MSET_DOC, wxT("Set Doc"),
			      wxPoint(260, 305), wxSize(-1, -1) );
	new wxBitmapButton( pPage, MUP_ARROW, UpArrow.ConvertToBitmap(), wxPoint(320,20) );
	new wxBitmapButton( pPage, MDOWN_ARROW, DownArrow.ConvertToBitmap(), wxPoint(320,60) );
	// the UI is setup, now put in some data
	FillMethodList( 0 );
	AddPage( pPage, _T("Methods") );
}

void CObjectNotebook::CreateVariableListPage()
{
	wxPanel			*pPage=new wxPanel( this );
	// there's a dirty bug in gtk (or wxWindows?) that makes it so I can't put
	// a wxBitmap from a XBM into a wxBitmapButton.  It throws an exception.
	// so I get around this by loading the xbm into an wxImage, then loading
	// that into a wxBitmap, and loading that into a wxBitmapButton.
	// It's a dirty hack, but it keeps it from crashing
	wxBitmap		UpArrowHack( (const char*)UpArrow_bits, 10, 16 );
	wxImage			UpArrow( UpArrowHack );
	wxBitmap		DownArrowHack( (const char*)DownArrow_bits, 10, 16 );
	wxImage			DownArrow( DownArrowHack );
	wxImageList		*pImageList;
	int				Width, Height;

	GetSize( &Width, &Height );
	// create the UI
	m_pVariableList = new wxListCtrl( pPage, VVARIABLE_LIST, wxPoint(5,5), 
									  wxSize(295,Height-165), wxLC_REPORT );
	pImageList = new wxImageList;
	CreateAccessImages( pImageList );
	m_pVariableList->AssignImageList( pImageList, wxIMAGE_LIST_SMALL );
	m_pVariableList->InsertColumn( 0, _T("") );
	m_pVariableList->InsertColumn( 1, _T("Name") );
	m_pVariableList->InsertColumn( 2, _T("Type") );
	m_pVariableList->SetColumnWidth( 0, 10 );
	m_pVariableList->SetColumnWidth( 1, 160 );
	m_pVariableList->SetColumnWidth( 2, 120 );
	m_pVariableDocText = new wxTextCtrl( pPage, -1, _T(""), wxPoint(5,Height-150), wxSize(240, 120), wxTE_MULTILINE  );
	new wxButton( pPage, VADD_METHOD, wxT("Add Variable"),
			      wxPoint(260, Height-145), wxSize(-1, -1) );
	new wxButton( pPage, VDEL_METHOD, wxT("Del Variable"),
			      wxPoint(260, Height-105), wxSize(-1, -1) );
	new wxButton( pPage, VSET_DOC, wxT("Set Doc"),
			      wxPoint(260, Height-65), wxSize(-1, -1) );
	new wxBitmapButton( pPage, VUP_ARROW, UpArrow.ConvertToBitmap(), wxPoint(320,20) );
	new wxBitmapButton( pPage, VDOWN_ARROW, DownArrow.ConvertToBitmap(), wxPoint(320,60) );
	// the UI is setup, now put in some data
	FillVariableList( 0 );
	AddPage( pPage, _T("Variables") );
}

void CObjectNotebook::CreateDocsPage()
{
	wxPanel		*pPage=new wxPanel( this );
	int			Width, Height;

	GetSize( &Width, &Height );
	m_pDocText = new wxTextCtrl( pPage, -1, _T(""), wxPoint(5,5), wxSize(345, Height-35), wxTE_MULTILINE  );
	if( m_Type == TClass )
		m_pDocText->WriteText( wxString((wxChar*)m_pClass->GetDoc().c_str()) );
	else if( m_Type == TMethod )
		m_pDocText->WriteText( wxString((wxChar*)m_pMethod->GetDoc().c_str()) );
	else if( m_Type == TVariable )
		m_pDocText->WriteText( wxString((wxChar*)m_pVariable->GetDoc().c_str()) );
	AddPage( pPage, _T("Documentation") );
}

void CObjectNotebook::CreateClassMiscPage()
{
	wxString	Choices[3] = { _T("Public"), _T("Protected"), _T("Private") };
	wxPanel		*pPage = new wxPanel( this );

	m_pIsQtObjectCheck = new wxCheckBox( pPage, -1, _T("This is a QT object"), wxPoint(5,10) );
	m_pIsQtObjectCheck->SetValue( m_pClass->IsQObject() );

	new wxStaticBox( pPage, -1, _T("File Info"), wxPoint(5,25), wxSize(340,115) );
	new wxStaticText( pPage, -1, _T("Header File:"), wxPoint(10,40) );
	m_pExcludeHeader = new wxCheckBox( pPage, -1, _T("Exclude from full model generation"), wxPoint(120, 40) );
	m_pExcludeHeader->SetValue( m_pClass->GetExcludeHeader() );
	m_pHeaderFileText = new wxTextCtrl( pPage, -1, wxString((wxChar*)m_pClass->GetHeaderFile().c_str()), wxPoint(10,55), wxSize(330, 25) );
	new wxStaticText( pPage, -1, _T("HTML File:"), wxPoint(10,90) );
	m_pExcludeHTML = new wxCheckBox( pPage, -1, _T("Exclude from full model generation"), wxPoint(120, 90) );
	m_pExcludeHTML->SetValue( m_pClass->GetExcludeHTML() );
	m_pHTMLFileText = new wxTextCtrl( pPage, -1, wxString((wxChar*)m_pClass->GetHTMLFile().c_str()), wxPoint(10,105), wxSize(330, 25) );

	new wxStaticBox( pPage, -1, _T("Enums"), wxPoint(5,140), wxSize(340,200) );
	m_pEnumList = new wxListCtrl( pPage, ENUM_LIST, wxPoint(10,155), 
								  wxSize(240,100), wxLC_REPORT );
	m_pEnumList->InsertColumn( 0, _T("Name") );
	m_pEnumList->SetColumnWidth( 0, 235 );
	new wxButton( pPage, ADD_ENUM, wxT("Add Enum"), wxPoint(260, 155), wxSize(-1, -1) );
	new wxButton( pPage, SET_ENUM, wxT("Set Enum"), wxPoint(260, 185), wxSize(-1, -1) );
	new wxButton( pPage, DEL_ENUM, wxT("Del Enum"), wxPoint(260, 215), wxSize(-1, -1) );
	m_pEnumBody = new wxTextCtrl( pPage, -1, _T(""), wxPoint(10,260), wxSize(240, 75), wxTE_MULTILINE  );
	m_pAccessType = new wxRadioBox( pPage, -1, _T("Access"), wxPoint(260,255), wxSize(80, 80), 3, Choices, 1, wxRA_SPECIFY_COLS );
	FillEnumList(0);

	AddPage( pPage, _T("Misc") );
}

void CObjectNotebook::CreateRelationsPage()
{
	wxPanel		*pPage = new wxPanel( this );
	wxImageList	*pImageList;

	new wxStaticBox( pPage, -1, _T("Inheritence Info"), wxPoint(5,5), wxSize(340,170) );
	m_pInheritenceList = new wxListCtrl( pPage, INHERITENCE_LIST, wxPoint(10,20), 
										 wxSize(240,150), wxLC_REPORT );

	m_pInheritenceList->InsertColumn( 0, _T("Parents") );
	m_pInheritenceList->SetColumnWidth( 0, 235 );
	new wxButton( pPage, ADD_INHERITENCE, _T("Add"), wxPoint(260,50) );
	new wxButton( pPage, DEL_INHERITENCE, _T("Delete"), wxPoint(260,80) );

	pImageList = new wxImageList;
	CreateRelationImages( pImageList );
	new wxStaticBox( pPage, -1, _T("Has-a/Uses-a"), wxPoint(5,180), wxSize(340,160) );
	m_pRelationList = new wxListCtrl( pPage, RELATION_LIST, wxPoint(10,195), 
									  wxSize(240,140), wxLC_REPORT );
	m_pRelationList->AssignImageList( pImageList, wxIMAGE_LIST_SMALL );
	m_pRelationList->InsertColumn( 0, _T("") );
	m_pRelationList->InsertColumn( 1, _T("Related to") );
	m_pRelationList->SetColumnWidth( 0, 20 );
	m_pRelationList->SetColumnWidth( 1, 215 );
	new wxButton( pPage, ADD_HASA, _T("Add Has-a"), wxPoint(260,220) );
	new wxButton( pPage, ADD_USESA, _T("Add Uses-a"), wxPoint(260,250) );
	new wxButton( pPage, DEL_RELATION, _T("Delete"), wxPoint(260,280) );

	FillInheritenceList( 0 );
	FillRelationList( 0 );
	AddPage( pPage, _T("Relations") );
}

void CObjectNotebook::CreateMethodCodePage()
{
	wxPanel		*pPage = new wxPanel( this );

	new wxStaticText( pPage, -1, _T("The code for the method.  This will be written into the header exactly"), wxPoint(5,5), wxSize( 345, 100 ) );
	new wxStaticText( pPage, -1, _T("as you write it, so you'll need the {} things."), wxPoint(5,20), wxSize( 345, 100 ) );
	m_pMethodBodyText = new wxTextCtrl( pPage, -1, wxString((wxChar*)m_pMethod->GetInlineCode().c_str()), wxPoint(5,50), wxSize(345, 220), wxTE_MULTILINE  );
	AddPage( pPage, _T("Method Body") );
}

void CObjectNotebook::CreateAccessImages( wxImageList *pList )
{
	wxBitmap	Public( IMAGE_SQUARE, IMAGE_SQUARE );
	wxBitmap	Protected( IMAGE_SQUARE, IMAGE_SQUARE );
	wxBitmap	Private( IMAGE_SQUARE, IMAGE_SQUARE );
	wxMemoryDC	DC;

	pList->Create( IMAGE_SQUARE, IMAGE_SQUARE, false, 4 );
	DC.SelectObject( Public );
    DC.SetBrush(*wxGREEN_BRUSH);
	DC.DrawRectangle( 0, 0, IMAGE_SQUARE, IMAGE_SQUARE );
	DC.SelectObject( Protected );
    DC.SetBrush(wxBrush(wxColour(255,255,0),wxSOLID));
	DC.DrawRectangle( 0, 0, IMAGE_SQUARE, IMAGE_SQUARE );
	DC.SelectObject( Private );
    DC.SetBrush(*wxRED_BRUSH);
	DC.DrawRectangle( 0, 0, IMAGE_SQUARE, IMAGE_SQUARE );
	DC.SelectObject( wxNullBitmap );
	pList->Add( Public );
	pList->Add( Protected );
	pList->Add( Private );
}

void CObjectNotebook::CreateRelationImages( wxImageList *pList )
{
	wxBitmap	HasA( RELATION_SQUARE, RELATION_SQUARE );
	wxBitmap	UsesA( RELATION_SQUARE, RELATION_SQUARE );
	wxMemoryDC	DC;

	pList->Create( RELATION_SQUARE, RELATION_SQUARE, false, 3 );
	DC.SelectObject( HasA );
    DC.SetBrush(*wxWHITE_BRUSH);
	DC.FloodFill( 0, 0, *wxBLACK );
    DC.SetBrush(*wxBLACK_BRUSH);
	DC.DrawCircle( 7, 7, 6 );
	DC.SelectObject( UsesA );
    DC.SetBrush(*wxWHITE_BRUSH);
	DC.FloodFill( 0, 0, *wxBLACK );
	DC.DrawCircle( 7, 7, 6 );
	DC.SelectObject( wxNullBitmap );
	pList->Add( HasA );
	pList->Add( UsesA );
}

void CObjectNotebook::FillMethodList( int Selected )
{
	MethodVector			*pMethods;
	MethodVector::iterator	itVect;

	m_pMethodList->DeleteAllItems();
	pMethods = m_pClass->GetMethods();
	for( itVect=pMethods->begin(); itVect!=pMethods->end(); ++itVect )
		AddMethodToEnd( *itVect );
	m_pMethodList->EnsureVisible( Selected );
}

void CObjectNotebook::AddMethodToEnd( CMethod *pMethod )
{
	int		i;

	i=m_pMethodList->GetItemCount();
	if( pMethod->GetAccess() == Public )
		m_pMethodList->InsertItem( i, 0 );
	else if( pMethod->GetAccess() == Protected )
		m_pMethodList->InsertItem( i, 1 );
	else 
		m_pMethodList->InsertItem( i, 2 );
	m_pMethodList->SetItem( i, 1, wxString((wxChar*)pMethod->GetName().c_str()) );
	m_pMethodList->SetItem( i, 2, wxString((wxChar*)pMethod->GetReturnType().c_str()) );
	// evil hack, but seems the way to do it
	m_pMethodList->SetItemData( i, (long)pMethod );
}

void CObjectNotebook::FillVariableList( int Selected )
{
	VariableVector				*pVariables;
	VariableVector::iterator	itVect;

	m_pVariableList->DeleteAllItems();
	if( m_Type == TClass )
		pVariables = m_pClass->GetVariables();
	else if( m_Type == TMethod )
		pVariables = m_pMethod->GetArgs();
	else	
		return;
	for( itVect=pVariables->begin(); itVect!=pVariables->end(); ++itVect )
		AddVariableToEnd( *itVect );
	m_pVariableList->EnsureVisible( Selected );
}

void CObjectNotebook::AddVariableToEnd( CVariable *pVariable )
{
	int		i;

	i=m_pVariableList->GetItemCount();
	if( pVariable->GetAccess() == Public )
		m_pVariableList->InsertItem( i, 0 );
	else if( pVariable->GetAccess() == Protected )
		m_pVariableList->InsertItem( i, 1 );
	else 
		m_pVariableList->InsertItem( i, 2 );
	m_pVariableList->SetItem( i, 1, wxString((wxChar*)pVariable->GetName().c_str()) );
	m_pVariableList->SetItem( i, 2, wxString((wxChar*)pVariable->GetType().c_str()) );
	// evil hack, but seems the way to do it
	m_pVariableList->SetItemData( i, (long)pVariable );
}

void CObjectNotebook::FillInheritenceList( int Selected )
{
   InheritenceVector                *pInheritence;
   InheritenceVector::iterator      itVect;
   int                               Index=0;

   m_pInheritenceList->DeleteAllItems();
   pInheritence = m_pClass->GetInheritence();
   for( itVect=pInheritence->begin(); itVect!=pInheritence->end(); ++itVect ){
      m_pInheritenceList->InsertItem( Index, (*itVect)->GetParentName().c_str() );
      Index++;
   }
	m_pInheritenceList->EnsureVisible( Selected );
}

void CObjectNotebook::AddRelationToEnd( CRelation *pRelation )
{
	int		i;

	i=m_pRelationList->GetItemCount();
	if( pRelation->IsHasA() )
		m_pRelationList->InsertItem( i, 0 );
	else
		m_pRelationList->InsertItem( i, 1 );
	m_pRelationList->SetItem( i, 1, wxString((wxChar*)pRelation->GetChild()->GetName().c_str()) );
}

void CObjectNotebook::FillRelationList( int Selected )
{
	RelationVector::iterator	itVect;
	RelationVector				*pVect;

	m_pRelationList->DeleteAllItems();
	pVect = m_pClass->GetRelation();
	for( itVect=pVect->begin(); itVect!=pVect->end(); ++itVect ){
		AddRelationToEnd( *itVect );
	}
	m_pRelationList->EnsureVisible( Selected );
}

void CObjectNotebook::AddEnumToEnd( CEnum *pEnum )
{
	int		i;

	i=m_pEnumList->GetItemCount();

	m_pEnumList->InsertItem( i, pEnum->GetName().c_str() );
	// evil hack, but seems the way to do it
	m_pEnumList->SetItemData( i, (long)pEnum );
}

void CObjectNotebook::FillEnumList( int Selected )
{
	EnumVector::iterator	itVect;
	EnumVector				*pVect;

	m_pEnumList->DeleteAllItems();
	pVect = m_pClass->GetEnums();
	for( itVect=pVect->begin(); itVect!=pVect->end(); ++itVect ){
		AddEnumToEnd( *itVect );
	}
	m_pEnumList->EnsureVisible( Selected );
}

// 
// Events
//
// Method List page
void CObjectNotebook::OnMethodActivated( wxListEvent &Event )
{
	if( m_pParentDlg == NULL )
		return;
	int			Index = Event.GetIndex();
	CMethod		*pMethod;

	pMethod = (CMethod*)m_pMethodList->GetItemData( Index );
	m_pParentDlg->OnMethodActivated( pMethod );
}

void CObjectNotebook::OnMethodSelected( wxListEvent &Event )
{
	int						Index = Event.GetIndex();
	MethodVector			*pVect;
	CMethod					*pMethod;

	m_pMethodDocText->Clear();
	pVect = m_pClass->GetMethods();
	if( (Index<0) || (Index>pVect->size()) )
		return;
	pMethod = (*pVect)[Index];
	m_pMethodDocText->WriteText( wxString((wxChar*)pMethod->GetDoc().c_str()) );
}

void CObjectNotebook::OnMethodUpArrow( wxCommandEvent &Event )
{
    long Index = m_pMethodList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index <= 0 )
		return;
	m_pClass->SwapMethods( Index, Index-1 );
	FillMethodList( Index );
	m_pMethodList->SetItemState( Index-1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
}

void CObjectNotebook::OnMethodDownArrow( wxCommandEvent &Event )
{
    long Index = m_pMethodList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( (Index == m_pMethodList->GetItemCount()) || (Index<0) )
		return;
	m_pClass->SwapMethods( Index, Index+1 );
	FillMethodList( Index );
	if( Index+1 == m_pMethodList->GetItemCount() )
		Index--;
	m_pMethodList->SetItemState( Index+1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
}

void CObjectNotebook::OnAddMethod( wxCommandEvent &Event )
{
	CMethod		*pMethod;

	pMethod = new CMethod( *m_pDoc );
	m_pClass->AddMethod( pMethod );
	AddMethodToEnd( pMethod );
	m_pMethodList->EnsureVisible( m_pMethodList->GetItemCount()-1 );
	m_pMethodList->SetItemState( m_pMethodList->GetItemCount()-1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
	m_pMethodDocText->Clear();
}

void CObjectNotebook::OnDelMethod( wxCommandEvent &Event )
{
	long Index = m_pMethodList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index<0 )
		return;
	m_pClass->DeleteMethod( Index );
	FillMethodList( 0 );
	m_pMethodDocText->Clear();
}

void CObjectNotebook::OnSetMethodDoc( wxCommandEvent &Event )
{
	CMethod	*pMethod;
	long	Index = m_pMethodList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index<0 )
		return;

	pMethod = m_pClass->GetMethod( Index );
	if( pMethod == NULL )
		return;
	pMethod->SetDoc( (const char*)m_pMethodDocText->GetValue() );
}

// variables list page
void CObjectNotebook::OnVariableActivated( wxListEvent &Event )
{
	if( m_pParentDlg == NULL )
		return;
	int			Index = Event.GetIndex();
	CVariable	*pVariable;

	pVariable = (CVariable*)m_pVariableList->GetItemData( Index );
	m_pParentDlg->OnVariableActivated( pVariable );
}

void CObjectNotebook::OnVariableSelected( wxListEvent &Event )
{
	int						Index = Event.GetIndex();
	VariableVector			*pVect;
	CVariable				*pVariable;

	m_pVariableDocText->Clear();
	if( m_Type == TClass )
		pVect = m_pClass->GetVariables();
	else if( m_Type == TMethod )
		pVect = m_pMethod->GetArgs();
	else
		return;
	if( (Index<0) || (Index>pVect->size()) )
		return;
	pVariable = (*pVect)[Index];
	m_pVariableDocText->WriteText( wxString((wxChar*)pVariable->GetDoc().c_str()) );
}

void CObjectNotebook::OnVariableUpArrow( wxCommandEvent &Event )
{
    long Index = m_pVariableList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index <= 0 )
		return;
	if( m_Type == TClass )
		m_pClass->SwapVariables( Index, Index-1 );
	else if( m_Type == TMethod )
		m_pMethod->SwapArgs( Index, Index-1 );
	else
		return;
	FillVariableList( Index );
	m_pVariableList->SetItemState( Index-1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
}

void CObjectNotebook::OnVariableDownArrow( wxCommandEvent &Event )
{
    long Index = m_pVariableList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( (Index == m_pVariableList->GetItemCount()) || (Index<0) )
		return;
	if( m_Type == TClass )
		m_pClass->SwapVariables( Index, Index+1 );
	else if( m_Type == TMethod )
		m_pMethod->SwapArgs( Index, Index+1 );
	else
		return;
	FillVariableList( Index );
	if( Index+1 == m_pVariableList->GetItemCount() )
		Index--;
	m_pVariableList->SetItemState( Index+1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
}

void CObjectNotebook::OnAddVariable( wxCommandEvent &Event )
{
	CVariable		*pNewVariable = new CVariable( *m_pDoc );
	
	if( m_Type == TClass )
		m_pClass->AddVariable( pNewVariable );	
	else if( m_Type == TMethod )
		m_pMethod->AddArg( pNewVariable );
	else
		return;
	AddVariableToEnd( pNewVariable );
	m_pVariableList->EnsureVisible( m_pVariableList->GetItemCount()-1 );
	m_pVariableList->SetItemState( m_pVariableList->GetItemCount()-1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
	m_pVariableDocText->Clear();
}

void CObjectNotebook::OnDelVariable( wxCommandEvent &Event )
{
	long Index = m_pVariableList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index < 0 ) 
		return;
	if( m_Type == TClass )
		m_pClass->DeleteVariable( Index );
	else if( m_Type == TMethod )
		m_pMethod->DeleteArg( Index );
	else
		return;
	FillVariableList( 0 );
	m_pVariableDocText->Clear();
}

void CObjectNotebook::OnSetVariableDoc( wxCommandEvent &Event )
{
	CVariable	*pVariable;
	long		Index = m_pVariableList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index < 0 ) 
		return;

	if( m_Type == TClass )
		pVariable = m_pClass->GetVariable( Index );
	else if( m_Type == TMethod )
		pVariable = m_pMethod->GetArg( Index );
	else
		return;
	if( pVariable == NULL )
		return;
	pVariable->SetDoc( (const char*)m_pVariableDocText->GetValue() );
}

// inheritence
void CObjectNotebook::OnAddInheritence( wxCommandEvent &Event )
{
	wxDialog		*pNameDlg;
	wxTextCtrl		*pNameText;
	string			NewParent;
	CInheritence	*pInheritence;

	pNameDlg = new wxDialog( this, -1, _T("Inheritence Info"), wxDefaultPosition, wxSize(220,120) );
	new wxStaticText( pNameDlg, -1, _T("Enter parent name:"), wxPoint(5,5) );
	pNameText = new wxTextCtrl( pNameDlg, -1, _T(""), wxPoint(5,25), wxSize(200, 25) );
	new wxButton( pNameDlg, wxID_OK, _T("OK"), wxPoint(130, 60) );
	if( pNameDlg->ShowModal() != wxID_OK )
		return;
	NewParent = (const char*)pNameText->GetValue();
	pInheritence = new CInheritence;
	pInheritence->SetParentName( NewParent );
	pInheritence->SetHorizontal( m_pClass->GetY() - 20 );
	m_pClass->AddInheritence( pInheritence );
	m_pInheritenceList->InsertItem( m_pInheritenceList->GetItemCount(), pInheritence->GetParentName().c_str() );
}

void CObjectNotebook::OnDelInheritence( wxCommandEvent &Event )
{
	long	Index = m_pInheritenceList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index < 0 ) 
		return;

	m_pClass->DeleteInheritence( Index );
	FillInheritenceList( 0 );
}

void CObjectNotebook::OnAddHasA( wxCommandEvent &Event )
{
	if( m_pDoc == NULL )
		return;
	wxDialog		*pNameDlg;
	wxTextCtrl		*pNameText;
	string			NewChild;
	CRelation		*pRelation;
	CClass			*pChild;

	pNameDlg = new wxDialog( this, -1, _T("Has A Info"), wxDefaultPosition, wxSize(220,120) );
	new wxStaticText( pNameDlg, -1, _T("Enter child name:"), wxPoint(5,5) );
	pNameText = new wxTextCtrl( pNameDlg, -1, _T(""), wxPoint(5,25), wxSize(200, 25) );
	new wxButton( pNameDlg, wxID_OK, _T("OK"), wxPoint(130, 60) );
	if( pNameDlg->ShowModal() != wxID_OK )
		return;
	NewChild = (const char*)pNameText->GetValue();
	pChild = m_pDoc->FindClassNamed( NewChild );
	if( pChild == NULL ){
		wxMessageBox( _T("Couldn't find the class specified"), _T("Error") );
		return;
	}
	pRelation = new CRelation;
	pRelation->SetChild( pChild );
	pRelation->SetHasA( true );
	m_pClass->AddRelation( pRelation );
	AddRelationToEnd( pRelation );
}

void CObjectNotebook::OnAddUsesA( wxCommandEvent &Event )
{
	if( m_pDoc == NULL )
		return;
	wxDialog		*pNameDlg;
	wxTextCtrl		*pNameText;
	string			NewChild;
	CRelation		*pRelation;
	CClass			*pChild;

	pNameDlg = new wxDialog( this, -1, _T("Uses A Info"), wxDefaultPosition, wxSize(220,120) );
	new wxStaticText( pNameDlg, -1, _T("Enter child name:"), wxPoint(5,5) );
	pNameText = new wxTextCtrl( pNameDlg, -1, _T(""), wxPoint(5,25), wxSize(200, 25) );
	new wxButton( pNameDlg, wxID_OK, _T("OK"), wxPoint(130, 60) );
	if( pNameDlg->ShowModal() != wxID_OK )
		return;
	NewChild = (const char*)pNameText->GetValue();
	pChild = m_pDoc->FindClassNamed( NewChild );
	if( pChild == NULL ){
		wxMessageBox( _T("Couldn't find the class specified"), _T("Error") );
		return;
	}
	pRelation = new CRelation;
	pRelation->SetChild( pChild );
	pRelation->SetHasA( false );
	m_pClass->AddRelation( pRelation );
	AddRelationToEnd( pRelation );
}

void CObjectNotebook::OnDelRelation( wxCommandEvent &Event )
{
	long	Index = m_pRelationList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index < 0 ) 
		return;

	m_pClass->DeleteRelation( Index );
	FillRelationList( 0 );
}

void CObjectNotebook::OnEnumSelected( wxListEvent &Event )
{
	int				Index = Event.GetIndex();
	EnumVector		*pVect;
	CEnum			*pEnum;

	m_pEnumBody->Clear();
	if( m_Type == TClass )
		pVect = m_pClass->GetEnums();
	else
		return;
	if( (Index<0) || (Index>pVect->size()) )
		return;
	pEnum = (*pVect)[Index];
	m_pEnumBody->WriteText( wxString((wxChar*)pEnum->GetText().c_str()) );
	if( pEnum->GetAccess() == Public ){
		m_pAccessType->SetSelection( 0 );
	} else if( pEnum->GetAccess() == Protected ){
		m_pAccessType->SetSelection( 1 );
	} else {
		m_pAccessType->SetSelection( 2 );
	}
}

void CObjectNotebook::OnAddEnum( wxCommandEvent &Event )
{
	wxDialog		*pNameDlg;
	wxTextCtrl		*pNameText;
	string			EnumName;
	CEnum			*pEnum;

	pNameDlg = new wxDialog( this, -1, _T("Enum Info"), wxDefaultPosition, wxSize(220,120) );
	new wxStaticText( pNameDlg, -1, _T("Enter enum name:"), wxPoint(5,5) );
	pNameText = new wxTextCtrl( pNameDlg, -1, _T(""), wxPoint(5,25), wxSize(200, 25) );
	new wxButton( pNameDlg, wxID_OK, _T("OK"), wxPoint(130, 60) );
	if( pNameDlg->ShowModal() != wxID_OK )
		return;
	EnumName = (const char*)pNameText->GetValue();
	pEnum = new CEnum( *m_pDoc );
	pEnum->SetName( EnumName );
	m_pClass->AddEnum( pEnum );
	AddEnumToEnd( pEnum );
}

void CObjectNotebook::OnSetEnum( wxCommandEvent &Event )
{
	CEnum		*pEnum;
	long		Index = m_pEnumList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index < 0 ) 
		return;

	if( m_Type == TClass )
		pEnum = m_pClass->GetEnum( Index );
	else
		return;
	if( pEnum == NULL )
		return;
	pEnum->SetText( (const char*)m_pEnumBody->GetValue() );
	if( m_pAccessType->GetSelection() == 0 )
		pEnum->SetAccessType( Public );
	else if( m_pAccessType->GetSelection() == 1 )
		pEnum->SetAccessType( Protected );
	else if( m_pAccessType->GetSelection() == 2 )
		pEnum->SetAccessType( Private );
}

void CObjectNotebook::OnDelEnum( wxCommandEvent &Event )
{
	long	Index = m_pEnumList->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if( Index < 0 ) 
		return;

	m_pClass->DeleteEnum( Index );
	FillEnumList( 0 );
}