/*
 * ##########################################################################
 * #  Dies ist der PHP Modul Code fr konto_check. Das Modul wurde nach der #
 * #  (sehr guten) Anleitung von Sara Golemon (Extension Writing) aus       #
 * #  http://devzone.zend.com/node/view/id/1021 (...1024) geschrieben.      #
 * #                                                                        #
 * #  Copyright (C) 2008 Michael Plugge <m.plugge@hs-mannheim.de>           #
 * ##########################################################################
 *
 * ##########################################################################
 * #  Dieses Programm ist freie Software; Sie drfen es unter den           #
 * #  Bedingungen der GNU Lesser General Public License, wie von der Free   #
 * #  Software Foundation verffentlicht, weiterverteilen und/oder          #
 * #  modifizieren; entweder gem Version 2.1 der Lizenz oder (nach Ihrer  #
 * #  Option) jeder spteren Version.                                       #
 * #                                                                        #
 * #  Dieses Programm wird in der Hoffnung weiterverbreitet, da es         #
 * #  ntzlich sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die    #
 * #  implizierte Garantie der MARKTREIFE oder der VERWENDBARKEIT FR       #
 * #  EINEN BESTIMMTEN ZWECK. Mehr Details finden Sie in der GNU Lesser     #
 * #  General Public License.                                               #
 * #                                                                        #
 * #  Sie sollten eine Kopie der GNU Lesser General Public License          #
 * #  zusammen mit diesem Programm erhalten haben; falls nicht,             #
 * #  schreiben Sie an die Free Software Foundation, Inc., 59 Temple        #
 * #  Place, Suite 330, Boston, MA 02111-1307, USA. Sie knnen sie auch     #
 * #  von                                                                   #
 * #                                                                        #
 * #       http://www.gnu.org/licenses/lgpl.html                            #
 * #                                                                        #
 * # im Internet herunterladen.                                             #
 * #                                                                        #
 * ##########################################################################
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef BAV_COMPATIBEL
#define BAV_COMPATIBEL 0
#endif

#include <php.h>
#include <php_ini.h>
#include "php_konto_check.h"

#ifndef SYMBOLIC_RETVALS
#define SYMBOLIC_RETVALS 1
#endif

#define INIT_DEFAULT_LUT_FILE INI_STR("konto_check.default_lut_file")
#define IMPLEMENTED_PZ_METHODEN "00 - D3"

#define ADD_ASSOC_STRING(dst,key,string,duplicate) do{if(string)add_assoc_string(dst,key,string,duplicate); else add_assoc_null(dst,key);}while(0)

   /* das folgende Makro wird vor der Rckgabe von Variablen aufgerufen, die
    * per reference bergeben wurden. Falls diese Variablen einen komplexen
    * Datentyp enthalten (String, Array, ...) mssen sie vor der Benutzung
    * gelscht werden, um den entsprechenden Speicher freizugeben (sonst gibt
    * es ein Speicherleck).
    */
#define ZVAL_DTOR(var) do switch(Z_TYPE_P(var)){ \
   case IS_NULL: \
   case IS_BOOL: \
   case IS_LONG: \
   case IS_DOUBLE: break; \
   default: zval_dtor(var); break; \
}while(0)

#define PHP_MALLOC 1
#include "../konto_check.c"

static int search_lutfile(char *name);

#ifdef ZEND_ENGINE_2
static ZEND_BEGIN_ARG_INFO(byref_0,1)
ZEND_END_ARG_INFO()

static ZEND_BEGIN_ARG_INFO(byref_1,1)
   ZEND_ARG_PASS_INFO(0)
ZEND_END_ARG_INFO()

static ZEND_BEGIN_ARG_INFO(byref_11,1)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(1)
   ZEND_ARG_PASS_INFO(0)
ZEND_END_ARG_INFO()

static ZEND_BEGIN_ARG_INFO(byref_2,1)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(0)
ZEND_END_ARG_INFO()

static ZEND_BEGIN_ARG_INFO(byref_3,1)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(0)
ZEND_END_ARG_INFO()

static ZEND_BEGIN_ARG_INFO(byref_4,1)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(0)
   ZEND_ARG_PASS_INFO(0)
ZEND_END_ARG_INFO()
#else /* ZE 1 */
static unsigned char byref_0[]={1,BYREF_FORCE_REST};
static unsigned char byref_1[]={2,BYREF_NONE,BYREF_FORCE_REST};
static unsigned char byref_11[]={2,BYREF_NONE,BYREF_FORCE,BYREF_NONE,BYREF_FORCE_REST};
static unsigned char byref_2[]={3,BYREF_NONE,BYREF_NONE,BYREF_FORCE_REST};
static unsigned char byref_3[]={4,BYREF_NONE,BYREF_NONE,BYREF_NONE,BYREF_FORCE_REST};
static unsigned char byref_4[]={5,BYREF_NONE,BYREF_NONE,BYREF_NONE,BYREF_NONE,BYREF_FORCE_REST};
#endif

static function_entry konto_check_functions[]={
   PHP_FE(kto_check,NULL)
   PHP_FE(kto_check_str,NULL)
   PHP_FE(lut_init,byref_3)
   PHP_FE(kto_check_init,byref_4)
   PHP_FE(generate_lut2,NULL)
   PHP_FE(read_lut_block,byref_2)
   PHP_FE(write_lut_block,NULL)
   PHP_FE(copy_lutfile,NULL)
   PHP_FE(kto_check_pz,NULL)
   PHP_FE(kto_check_blz,NULL)
   PHP_FE(kto_check_pz_dbg,byref_3)
   PHP_FE(kto_check_blz_dbg,byref_2)
   PHP_FE(kto_check_retval2txt,NULL)
   PHP_FE(kto_check_retval2html,NULL)
   PHP_FE(kto_check_retval2txt_short,NULL)
   PHP_FE(kto_check_retval2dos,NULL)
   PHP_FE(kto_check_retval2utf8,NULL)
   PHP_FE(get_kto_check_version,NULL)
   PHP_FE(iban_check,byref_1)
   PHP_FE(iban2bic,byref_1)
   PHP_FE(ipi_gen,byref_1)
   PHP_FE(ipi_check,byref_1)
   PHP_FE(lut_cleanup,NULL)
   PHP_FE(lut_filialen,NULL)
   PHP_FE(lut2_status,NULL)
   PHP_FE(lut_valid,NULL)
   PHP_FE(lut_multiple,byref_2)
   PHP_FE(lut_info,byref_1)
   PHP_FE(lut_name,byref_11)
   PHP_FE(lut_name_kurz,byref_11)
   PHP_FE(lut_plz,byref_11)
   PHP_FE(lut_ort,byref_11)
   PHP_FE(lut_pan,byref_11)
   PHP_FE(lut_bic,byref_11)
   PHP_FE(lut_nr,byref_11)
   PHP_FE(lut_pz,byref_11)
   PHP_FE(lut_aenderung,byref_11)
   PHP_FE(lut_loeschung,byref_11)
   PHP_FE(lut_nachfolge_blz,byref_11)
   PHP_FALIAS(lut_status,lut2_status,NULL)
   PHP_FALIAS(lut_free,lut_cleanup,NULL)
   PHP_FALIAS(kc_short,kto_check_retval2txt_short,NULL)
   PHP_FALIAS(kc_txt,kto_check_retval2txt,NULL)
   PHP_FALIAS(kc_html,kto_check_retval2html,NULL)
   PHP_FALIAS(kc_dos,kto_check_retval2dos,NULL)
   PHP_FALIAS(kc_utf8,kto_check_retval2utf8,NULL)
   {NULL, NULL, NULL}
};

zend_module_entry konto_check_module_entry={
#if ZEND_MODULE_API_NO >= 20010901
    STANDARD_MODULE_HEADER,
#endif
    PHP_KONTO_CHECK_EXTNAME,
    konto_check_functions,
    PHP_MINIT(konto_check),
    PHP_MSHUTDOWN(konto_check),
#if USE_RINIT
    PHP_RINIT(konto_check),
#else
    NULL,
#endif
#if USE_RSHUTDOWN
    PHP_RSHUTDOWN(konto_check),
#else
    NULL,
#endif
    PHP_MINFO(konto_check),
#if ZEND_MODULE_API_NO >= 20010901
    PHP_KONTO_CHECK_VERSION,
#endif
    STANDARD_MODULE_PROPERTIES
};

PHP_INI_BEGIN()
PHP_INI_ENTRY("konto_check.default_lut_file", "/etc/blz.lut", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.lut_name1", "blz.lut", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.lut_name2", "blz.lut2", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.lut_name3", "blz.lut1", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.lut_path1", "/etc", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.lut_path2", ".", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.lut_path3", "/usr/local/etc", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.request_auto_init", "0", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.request_auto_cleanup", "0", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.request_init_default_level", "0", PHP_INI_ALL, NULL)
PHP_INI_ENTRY("konto_check.init_default_level", "5", PHP_INI_ALL, NULL)
PHP_INI_END()

#if USE_RINIT
PHP_RINIT_FUNCTION(konto_check)
{
   int level;

      /* nur initialisieren, falls per INI-Wert freigegeben (das wird sonst bei
       * jedem Request gemacht, nicht nur, falls konto_check bentigt wird) 
       */
   if(INI_INT("konto_check.request_auto_init")>0){
      level=INI_INT("konto_check.request_init_default_level");
      kto_check_init_p(INIT_DEFAULT_LUT_FILE,level,0,0);
   }
   return SUCCESS;
}
#endif

#if USE_RSHUTDOWN
PHP_RSHUTDOWN_FUNCTION(konto_check)
{
   if(INI_INT("konto_check.request_auto_cleanup") && (init_status&7)==7)lut_cleanup();   /* allokierten Speicher freigeben */
   return SUCCESS;
}
#endif

PHP_MINIT_FUNCTION(konto_check)
{
   REGISTER_INI_ENTRIES();
#if SYMBOLIC_RETVALS
   REGISTER_LONG_CONSTANT("BAV_FALSE",-77,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NO_USER_BLOCK",-76,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_SET",-75,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("NO_GERMAN_BIC",-74,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("IPI_CHECK_INVALID_LENGTH",-73,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("IPI_INVALID_CHARACTER",-72,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("IPI_INVALID_LENGTH",-71,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT1_FILE_USED",-70,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("MISSING_PARAMETER",-69,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("IBAN2BIC_ONLY_GERMAN",-68,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("IBAN_OK_KTO_NOT",-67,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("KTO_OK_IBAN_NOT",-66,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("TOO_MANY_SLOTS",-65,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INIT_FATAL_ERROR",-64,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INCREMENTAL_INIT_NEEDS_INFO",-63,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INCREMENTAL_INIT_FROM_DIFFERENT_FILE",-62,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("DEBUG_ONLY_FUNCTION",-61,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_INVALID",-60,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NOT_YET_VALID",-59,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NO_LONGER_VALID",-58,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_GUELTIGKEIT_SWAPPED",-57,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_INVALID_GUELTIGKEIT",-56,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_INDEX_OUT_OF_RANGE",-55,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_INIT_IN_PROGRESS",-54,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_BLZ_NOT_INITIALIZED",-53,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_FILIALEN_NOT_INITIALIZED",-52,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NAME_NOT_INITIALIZED",-51,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PLZ_NOT_INITIALIZED",-50,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_ORT_NOT_INITIALIZED",-49,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NAME_KURZ_NOT_INITIALIZED",-48,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PAN_NOT_INITIALIZED",-47,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_BIC_NOT_INITIALIZED",-46,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PZ_NOT_INITIALIZED",-45,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NR_NOT_INITIALIZED",-44,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_AENDERUNG_NOT_INITIALIZED",-43,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_LOESCHUNG_NOT_INITIALIZED",-42,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NACHFOLGE_BLZ_NOT_INITIALIZED",-41,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NOT_INITIALIZED",-40,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_FILIALEN_MISSING",-39,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PARTIAL_OK",-38,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_Z_BUF_ERROR",-37,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_Z_MEM_ERROR",-36,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_Z_DATA_ERROR",-35,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_BLOCK_NOT_IN_FILE",-34,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_DECOMPRESS_ERROR",-33,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_COMPRESS_ERROR",-32,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_FILE_CORRUPTED",-31,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NO_SLOT_FREE",-30,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("UNDEFINED_SUBMETHOD",-29,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("EXCLUDED_AT_COMPILETIME",-28,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_LUT_VERSION",-27,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_PARAMETER_STELLE1",-26,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_PARAMETER_COUNT",-25,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_PARAMETER_PRUEFZIFFER",-24,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_PARAMETER_WICHTUNG",-23,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_PARAMETER_METHODE",-22,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LIBRARY_INIT_ERROR",-21,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT_CRC_ERROR",-20,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("FALSE_GELOESCHT",-19,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("OK_NO_CHK_GELOESCHT",-18,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("OK_GELOESCHT",-17,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("BLZ_GELOESCHT",-16,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_BLZ_FILE",-15,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LIBRARY_IS_NOT_THREAD_SAFE",-14,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("FATAL_ERROR",-13,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_KTO_LENGTH",-12,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("FILE_WRITE_ERROR",-11,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("FILE_READ_ERROR",-10,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("ERROR_MALLOC",-9,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("NO_BLZ_FILE",-8,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_LUT_FILE",-7,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("NO_LUT_FILE",-6,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_BLZ_LENGTH",-5,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_BLZ",-4,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("INVALID_KTO",-3,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("NOT_IMPLEMENTED",-2,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("NOT_DEFINED",-1,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("FALSE",0,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("OK",1,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("OK_NO_CHK",2,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("OK_TEST_BLZ_USED",3,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_VALID",4,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NO_VALID_DATE",5,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT1_SET_LOADED",6,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT1_FILE_GENERATED",7,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_BLZ",1,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_FILIALEN",2,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NAME",3,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PLZ",4,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_ORT",5,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NAME_KURZ",6,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PAN",7,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_BIC",8,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_PZ",9,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NR",10,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_AENDERUNG",11,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_LOESCHUNG",12,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NACHFOLGE_BLZ",13,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_NAME_NAME_KURZ",14,CONST_CS|CONST_PERSISTENT);
   REGISTER_LONG_CONSTANT("LUT2_INFO",15,CONST_CS|CONST_PERSISTENT);
#endif
   return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(konto_check)
{
   UNREGISTER_INI_ENTRIES();
   return SUCCESS;
}

PHP_MINFO_FUNCTION(konto_check)
{
   char *use_rinit,*use_rinit2,*use_rshutdown,*use_rshutdown2;

#if USE_RINIT
   use_rinit="enabled at compile-time";
   if(INI_INT("konto_check.request_auto_init")>0)
      use_rinit2="yes";
   else
      use_rinit2="no";
#else
   use_rinit="disabled at compile-time";
   use_rinit2="no";
#endif
#if USE_RSHUTDOWN
   use_rshutdown="enabled at compile-time";
   if(INI_INT("konto_check.request_auto_cleanup")>0)
      use_rshutdown2="yes";
   else
      use_rshutdown2="no";
#else
   use_rshutdown="disabled at compile-time";
   use_rinit2="no";
#endif
   php_info_print_table_start();
   php_info_print_table_row(2,"konto_check","enabled");
   php_info_print_table_row(2,"Version",VERSION);
   php_info_print_table_row(2,"Date",VERSION_DATE);
   php_info_print_table_row(2,"Compile Date",__DATE__ ", " __TIME__);
   php_info_print_table_row(2,"API Version","new");
   php_info_print_table_row(2,"BAV compatible version",BAV_COMPATIBEL ? "yes":"no");
#if SYMBOLIC_RETVALS
   php_info_print_table_row(2,"symbolic retvals","enabled");
#else
   php_info_print_table_row(2,"symbolic retvals","not enabled");
#endif
   php_info_print_table_row(2,"Prfziffermethoden",IMPLEMENTED_PZ_METHODEN);
   php_info_print_table_end();

   php_info_print_table_start();
   php_info_print_table_header(2,"Directive","Value");
   php_info_print_table_row(2,"default lut file",INIT_DEFAULT_LUT_FILE);
   php_info_print_table_row(2,"default lut name (1)",INI_STR("konto_check.lut_name1"));
   php_info_print_table_row(2,"default lut name (2)",INI_STR("konto_check.lut_name2"));
   php_info_print_table_row(2,"default lut name (3)",INI_STR("konto_check.lut_name3"));
   php_info_print_table_row(2,"default lut path (1)",INI_STR("konto_check.lut_path1"));
   php_info_print_table_row(2,"default lut path (2)",INI_STR("konto_check.lut_path2"));
   php_info_print_table_row(2,"default lut path (3)",INI_STR("konto_check.lut_path3"));
   php_info_print_table_row(2,"request auto-init",use_rinit);
#if USE_RINIT
   php_info_print_table_row(2,"use request auto-init",use_rinit2);
   php_info_print_table_row(2,"default request auto-init level",INI_STR("konto_check.request_init_default_level"));
#endif
   php_info_print_table_row(2,"default init level",INI_STR("konto_check.init_default_level"));
   php_info_print_table_row(2,"request auto cleanup",use_rshutdown);
   php_info_print_table_row(2,"use request auto cleanup",use_rshutdown2);
   php_info_print_table_end();
}

#ifdef COMPILE_DL_KONTO_CHECK
ZEND_GET_MODULE(konto_check)
#endif

   /* search_lutfile(): Diese Funktion sucht (physikalisch) eine LUT-Datei;
    * zunchst am angegebenen Ort, falls dort keine Datei gefunden wird, noch
    * zustzlich mit den Dateinamen lut_name1 ... lut_name3 und den Pfaden
    * lut_path1...lut_path3. Der Parameter name mu ein (schreibbares) Array
    * der Gre LUT_NAME_BUFFER sein; in diesem Array wird der gefundene
    * Dateiname zurckgeliefert.
    *
    * Es wird nicht getestet, ob die gefundene Datei wirklich eine LUT-Datei
    * ist; das wird erst spter in der C-Funktion gemacht.
    */
static int search_lutfile(char *name)
{
   char *lut_name[3],*lut_path[3];
   int retval,i,j;
   struct stat sbuf;

   if(!stat(name,&sbuf))return OK;
   lut_name[0]=INI_STR("konto_check.lut_name1");
   lut_name[1]=INI_STR("konto_check.lut_name2");
   lut_name[2]=INI_STR("konto_check.lut_name3");
   lut_path[0]=INI_STR("konto_check.lut_path1");
   lut_path[1]=INI_STR("konto_check.lut_path2");
   lut_path[2]=INI_STR("konto_check.lut_path3");
   for(i=0;i<3;i++)if(strlen(lut_path[i])){
      for(j=0;j<3;j++)if(strlen(lut_name[j])){
         snprintf(name,LUT_NAME_BUFFER,"%s/%s",lut_path[i],lut_name[j]);
         if(!stat(name,&sbuf))return OK;
      }
   }
   return NO_LUT_FILE;  /* keine Datei gefunden */
}

   /* lut_init() und kto_check_init(): die beiden Funktionen sind hnlich
    * und dienen zur Initialisierung der kto_check Bibliothek. Die Funktion
    * lut_init() testet, ob die Bibliothek bereits von der angegebenen Datei
    * initialisiert wurde und ldt bei Bedarf noch fehlende Blocks nach;
    * falls eine andere Datei (oder ein anderer Datensatz) zur Initialisierung
    * verwendet werden soll, wird eine (Neu-)Initialisierung erzwungen. Die
    * Funktion kto_check_init() des neuen Interfaces ist dagegen wesentlich
    * allgemeiner; sie enthlt die komplette Funktionalitt der C-Funktion (hat
    * aber leider auch fast die Komplexitt der C-Funktion). Im neuen Interface
    * kommt ein zustzlicher Parameter (status) dazu, in dem fr jeden
    * angeforderten Block der Status zurckgegeben wird. Da dieser Parameter
    * als letzer (!!!, anders als in der C API) steht und optional ist, ist die
    * Funktion abwrtskompatibel zur alten Version.
    *
    * Die Funktion hat die nachfolgenden Parameter. Alle Parameter sind
    * optional und knnen ber INIT-Werte gesetzt werden. Die Definition kann
    * in dieser Datei, in /etc/php.ini bzw. /etc/php.d/konto_check.ini oder in
    * einer .htaccess Datei fr das jeweilige lokale Verzeichnis (sowie
    * Unterverzeichnisse) erfolgen. Die Defaultwerte sind in Klammern
    * angegeben.
    *
    * lut_name:      Name der LUT-Datei (konto_check.default_lut_file -> /etc/blz.lut)
    *
    * required:      Blocks, die geladen werden sollen (s.u.; konto_check.init_default_level,
    *                Standard ist 5). Falls die Option konto_check.request_auto_init
    *                gesetzt ist, initialisiert die RINIT Funktion beim Start eines
    *                Skriptes automatisch die Bibliothek entsprechend dem Wert
    *                konto_check.request_init_default_level. Diese
    *                Initialisierung wird dann fr jedes PHP-Skript gemacht;
    *                daher sollte die Option nur eingeschaltet werden, wenn sie
    *                wirklich bentigt wird, z.B. fr ein bestimmtes
    *                Verzeichnis, bei dem der Test immer bentigt wird.
    *                
    * set:           Datensatz der LUT-Datei, der benutzt werden soll; 0 fr automatisch
    *                auswhlen (nach Datum), sonst 1 oder 2 (Standard ist 0)
    *
    * Liste der Blocks, die fr verschiedene Werte von required geladen werden:
    *
    *    0: BLZ, PZ
    *    1: BLZ, PZ, NAME_KURZ
    *    2: BLZ, PZ, NAME_KURZ,                 BIC
    *    3: BLZ, PZ, NAME,            PLZ, ORT
    *    4: BLZ, PZ, NAME,            PLZ, ORT, BIC
    *    5: BLZ, PZ, NAME, NAME_KURZ, PLZ, ORT, BIC
    *    6: BLZ, PZ, NAME, NAME_KURZ, PLZ, ORT, BIC, NACHFOLGE_BLZ
    *    7: BLZ, PZ, NAME, NAME_KURZ, PLZ, ORT, BIC, NACHFOLGE_BLZ, AENDERUNG
    *    8: BLZ, PZ, NAME, NAME_KURZ, PLZ, ORT, BIC, NACHFOLGE_BLZ, AENDERUNG, LOESCHUNG
    *    9: BLZ, PZ, NAME, NAME_KURZ, PLZ, ORT, BIC, NACHFOLGE_BLZ, AENDERUNG, LOESCHUNG, PAN, NR
    */

PHP_FUNCTION(lut_init)
{
   static char *lut_name,buffer[LUT_NAME_BUFFER];
   int lut_name_len,required,set,ret;
   zval *z_used_lutfile=NULL;

   lut_name=INIT_DEFAULT_LUT_FILE;
   required=INI_INT("konto_check.init_default_level");
   set=0;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"|sllz",
            &lut_name,&lut_name_len,&required,&set,&z_used_lutfile)==FAILURE)RETURN_NULL();
   if(!lut_name_len)lut_name=INIT_DEFAULT_LUT_FILE;
   snprintf(buffer,LUT_NAME_BUFFER,lut_name);
   ret=search_lutfile(buffer);
   if(z_used_lutfile){
      ZVAL_DTOR(z_used_lutfile);
      ZVAL_STRING(z_used_lutfile,buffer,1);
   }
   if(ret!=OK){RETURN_LONG(ret);}  /* keine LUT-Datei gefunden */
   ret=lut_init(buffer,required,set);
   RETURN_LONG(ret);
}

   /* generate_lut2(): diese Funktion dient zur Generierung einer LUT-Datei.
    *                Die Parameter entsprechen denen der C-Funktion. Alle
    *                Parameter auer inputname und outputname sind optional.
    *                Hier eine kurze Beschreibung:
    *
    * inputname:     Dateiname der Bundesbank-Datei
    *
    * outputname:    Dateiname der generierten LUT-Datei
    *                
    * user_info:     Info-Zeile fr die Datei (Benutzer-Info)
    *
    * gueltigkeit:   Gltigkeitszeitraum fr den Datensatz. Der Gltigkeitszeitraum
    *                ist im Format JJJJMMTT-JJJJMMTT anzugeben, also z.B.
    *                20090309-20090607 fr den Zeitraum 9.3.2009 - 6.7.2009.
    *
    * felder:        Diese Variable ist ein Skalar oder Array, in dem die in
    *                die Ausgabedatei aufzunehmenden Felder angegeben werden.
    *                Bei einem skalaren Wert sind die Felder im Anhang von
    *                00liesmich.pdf aufgezhlt; bei einem Array kann man explizit
    *                bestimmen, welche Felder in die Ausgabedatei aufgenommen
    *                werden sollen. Falls die LUT-Datei auch die Filialen enthalten
    *                soll, ist zustzlich zu den Datenblocks noch der Wert
    *                LUT2_FILIALEN in das Array einzufgen; andernfalls werden nur
    *                die Hauptstellen bercksichtigt.
    *
    *                Falls ein negativer skalarer Wert angegeben wird, werden die
    *                Werte des entsprechenden Levels mit den Filialen eingebunen.
    *
    *                Falls der Parameter nicht angegeben wird: Level 5 ohne Filialen
    *
    * slots:         Anzahl Slots im Inhaltsverzeichnis der LUT-Datei. Die Anzahl Slots
    *                kann spter nicht mehr gendert werden; wenn alle Slots einer Datei
    *                belegt sind, kann kein zustzlicher Block mehr geschrieben werden.
    *                Der Defaultwert ist 40.
    *
    *
    * lut_version:   Dateiversion der LUT-Datei, die geschrieben werden soll. 
    *                Der Parameter kann die folgenden Werte annehmen:
    *
    *                0: default (aktuelle Version, jetzt 2.0)
    *                1: Version 1.0 (obsolet)
    *                2: Version 1.1 (enthlt nur BLZ und Prfziffermethoden)
    *                3: Version 2.0 (kann alle Felder enthalten)
    *
    * set:           Datensatz, der geschrieben werden soll. Eine LUT-Datei kann zwei
    *                Datenstze mit unterschiedlichem Gltigkeitsdatum enthalten. Dieser
    *                Parameter legt fest, welcher Datensatz geschrieben werden soll
    *                (1 oder 2); Default ist Datensatz 1.
    */

PHP_FUNCTION(generate_lut2)
{
   char *inputname,*outputname,*user_info,*gueltigkeit;
   int inputname_len,outputname_len,user_info_len,gueltigkeit_len,felder_1,i,j,cnt,*rq1,ret,filialen;
   UINT4 felder_a[MAX_SLOTS+1];
   long slots,lut_version,set;
   zval *z_felder,**z_data,temp;
   HashTable *h_felder;
   HashPosition h_ptr;

   felder_1=271828182;
   slots=lut_version=set=filialen=0;
   user_info=gueltigkeit=NULL;
   z_felder=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss|sszlll",
            &inputname,&inputname_len,&outputname,&outputname_len,&user_info,&user_info_len,
            &gueltigkeit,&gueltigkeit_len,&z_felder,&slots,&lut_version,&set)==FAILURE)RETURN_NULL();

   if(z_felder){
      switch(Z_TYPE_P(z_felder)){
         case IS_STRING:
         case IS_DOUBLE:
            /* Variable kopieren, damit der Typ gendert werden kann */
            temp=*z_felder;
            zval_copy_ctor(&temp);
            convert_to_long(&temp);
            felder_1=Z_LVAL(temp);
            zval_dtor(&temp);
            break;
         case IS_LONG:
            felder_1=Z_LVAL_P(z_felder);
            break;
         case IS_ARRAY: /* das Array aufdrseln, skalare Werte zum Initialisieren benutzen */
            h_felder=Z_ARRVAL_P(z_felder);
            cnt=zend_hash_num_elements(h_felder);
            for(zend_hash_internal_pointer_reset_ex(h_felder,&h_ptr),i=0;
                  zend_hash_get_current_data_ex(h_felder,(void**)&z_data,&h_ptr)==SUCCESS && i<MAX_SLOTS;
                  zend_hash_move_forward_ex(h_felder,&h_ptr),i++){
               if(Z_TYPE_PP(z_data)==IS_LONG)felder_a[i]=Z_LVAL_PP(z_data);
               if(Z_TYPE_PP(z_data)==IS_DOUBLE || Z_TYPE_PP(z_data)==IS_STRING){

                  /* Die Array-Werte mssen nach long konvertiert werden;
                   * dazu wird vorher eine Kopie angelegt, damit der alte Typ
                   * im Array erhalten bleibt.
                   */
                  temp=**z_data;
                  zval_copy_ctor(&temp);
                  convert_to_long(&temp);
                  felder_a[i]=Z_LVAL(temp);
                  zval_dtor(&temp); /* temporre Variable wieder freigeben */
               }
            }
            felder_a[i]=0;  /* Endemarkierung einfgen */
            felder_1=271828182;
            break;
         default: /* irgendwas anderes bergeben, Default-Level benutzen */
            felder_1=INI_INT("konto_check.init_default_level");
            break;
      }
   }
   else
      felder_1=INI_INT("konto_check.init_default_level");

   if(felder_1<0){   /* auch die Filialen bercksichtigen */
      filialen=1;
      felder_1*=-1;
   }
   switch(felder_1){
      case 271828182: break;   /* es wurde ein Array bergeben; Werte sind schon eingetragen */
      case  0: rq1=lut_set_0; break;
      case  1: rq1=lut_set_1; break;
      case  2: rq1=lut_set_2; break;
      case  3: rq1=lut_set_3; break;
      case  4: rq1=lut_set_4; break;
      case  5: rq1=lut_set_5; break;
      case  6: rq1=lut_set_6; break;
      case  7: rq1=lut_set_7; break;
      case  8: rq1=lut_set_8; break;
      case  9: rq1=lut_set_9; break;
      default: rq1=lut_set_9; break;
   }
   if(felder_1>=0){
      felder_a[0]=LUT2_BLZ;
      felder_a[1]=LUT2_PZ;
      for(i=2,j=0;i<LAST_LUT_BLOCK && rq1[j];)felder_a[i++]=rq1[j++];
      if(filialen)felder_a[i++]=LUT2_FILIALEN;
      felder_a[i]=0;
   }
   ret=generate_lut2(inputname,outputname,user_info,gueltigkeit,felder_a,slots,lut_version,set);
   RETURN_LONG(ret);
}

   /* kto_check_init(): dies ist die allgemeine Funktion zur Initialisierung
    *                der kto_check Bibliothek. Die Parameter entsprechen
    *                weitgehend denen von lut_init(). Allerdings kann die
    *                Variable required ein Array sein, und es gibt noch eine
    *                Rckgabe ber den Status aller angeforderten Blocks.
    *
    * lut_name:      s.o. (bei lut_init())
    *
    * required:      s.o.; dieser Parameter kann ein Skalar oder ein Array
    *                sein; im Fall eines Arrays lassen sich beliebige Blocks
    *                spezifizieren (wie in der C-Funktion).
    *                
    * set:           s.o.
    *
    * incremental:   falls 1, wird versucht, nur Blocks nachgeladen; bei 0 wird die
    *                Bibliothek komplett neu initialisiert. Eine inkrementelle
    *                Initialisierung ist natrlich nur von derselben LUT-Datei
    *                mglich; falls eine andere LUT-Datei angegeben wird,
    *                schlgt die Initialisierung fehl.
    *
    * status:        dies ist eine Variable, die als Arrayvariable
    *                zurckgegeben wird; in ihr wird fr jeden geladenen Block
    *                der Status angegeben. Damit lt sich beim Fehler -38
    *                (Blocks teilweise geladen) feststellen, bei welchen Blocks
    *                Fehler aufgetreten sind. Diese Variable ist - anders als
    *                im C API - die letze Variable, um die Funktion kompatibel
    *                zur alten Version zu halten.
    */

PHP_FUNCTION(kto_check_init)
{
   static char *lut_name,buffer[LUT_NAME_BUFFER];
   int lut_name_len,required,set,ret,incremental;
   zval *z_required,*z_status,**z_data,*z_used_lutfile,temp;
   HashTable *h_required;
   HashPosition h_ptr;
   int i,j,cnt,required_a[LAST_LUT_BLOCK],*status,*rq1;

   set=incremental=0;
   for(i=0;i<LAST_LUT_BLOCK;i++)required_a[i]=0;
   z_status=z_required=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"|szllzz",
            &lut_name,&lut_name_len,&z_required,&set,&incremental,
            &z_status,&z_used_lutfile)==FAILURE)RETURN_NULL();
   if(!lut_name_len)lut_name=INIT_DEFAULT_LUT_FILE;
   snprintf(buffer,LUT_NAME_BUFFER,lut_name);
   ret=search_lutfile(buffer);
   if(z_used_lutfile){
      ZVAL_DTOR(z_used_lutfile);
      ZVAL_STRING(z_used_lutfile,buffer,1);
   }
   if(z_status)ZVAL_DTOR(z_status);
   if(ret!=OK){
      if(z_status)ZVAL_NULL(z_status);
      RETURN_LONG(ret);
   }
   switch(Z_TYPE_P(z_required)){
      case IS_STRING:
      case IS_DOUBLE:
            /* Variable kopieren, damit der Typ gendert werden kann */
         temp=*z_required;
         zval_copy_ctor(&temp);
         convert_to_long(&temp);
         required=Z_LVAL(temp);
         zval_dtor(&temp);
         break;
      case IS_LONG:
         required=Z_LVAL_P(z_required);
         break;
      case IS_ARRAY: /* das Array aufdrseln, skalare Werte zum Initialisieren benutzen */
         h_required=Z_ARRVAL_P(z_required);
         cnt=zend_hash_num_elements(h_required);
         for(zend_hash_internal_pointer_reset_ex(h_required,&h_ptr),i=0;
               zend_hash_get_current_data_ex(h_required,(void**)&z_data,&h_ptr)==SUCCESS && i<250;
               zend_hash_move_forward_ex(h_required,&h_ptr),i++){
            if(Z_TYPE_PP(z_data)==IS_LONG)required_a[i]=Z_LVAL_PP(z_data);
            if(Z_TYPE_PP(z_data)==IS_DOUBLE || Z_TYPE_PP(z_data)==IS_STRING){

                   /* Die Array-Werte mssen nach long konvertiert werden;
                    * dazu wird vorher eine Kopie angelegt, damit der alte Typ
                    * im Array erhalten bleibt.
                    */
               temp=**z_data;
               zval_copy_ctor(&temp);
               convert_to_long(&temp);
               required_a[i]=Z_LVAL(temp);
               zval_dtor(&temp); /* temporre Variable wieder freigeben */
            }
         }
         required_a[i]=0;  /* Endemarkierung einfgen */
         required=-1;
         break;
      default: /* irgendwas anderes bergeben, Default-Level benutzen */
         required=INI_INT("konto_check.init_default_level");
         break;
   }
   switch(required){
      case -1: break;   /* es wurde ein Array bergeben; Werte sind schon eingetragen */
      case  0: rq1=lut_set_0; break;
      case  1: rq1=lut_set_1; break;
      case  2: rq1=lut_set_2; break;
      case  3: rq1=lut_set_3; break;
      case  4: rq1=lut_set_4; break;
      case  5: rq1=lut_set_5; break;
      case  6: rq1=lut_set_6; break;
      case  7: rq1=lut_set_7; break;
      case  8: rq1=lut_set_8; break;
      case  9: rq1=lut_set_9; break;
      default: rq1=lut_set_9; break;
   }
   if(required>=0){
      required_a[0]=LUT2_BLZ;
      required_a[1]=LUT2_PZ;
      required_a[2]=LUT2_FILIALEN;
      for(i=3,j=0;i<LAST_LUT_BLOCK && rq1[j];)required_a[i++]=rq1[j++];
      required_a[i]=0;
      if(init_status<7)incremental=0; /* noch nicht initialisiert, inkrementell geht nicht */
   }
   ret=kto_check_init(buffer,required_a,&status,set,incremental);
   if(z_status){
      array_init(z_status);
      for(i=0;i<=LAST_LUT_BLOCK;i++)if(status[i])add_assoc_long(z_status,lut2_feld_namen[i],status[i]);
   }
   RETURN_LONG(ret);
}

PHP_FUNCTION(lut_valid)
{
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"")==FAILURE)RETURN_NULL();
   RETURN_LONG(lut_valid());
}

PHP_FUNCTION(lut2_status)
{
   int i;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"")==FAILURE)RETURN_NULL();
   array_init(return_value);
   for(i=0;i<=LAST_LUT_BLOCK;i++)if(lut2_block_status[i]){
      add_index_long(return_value,i,lut2_block_status[i]);
      add_assoc_long(return_value,lut2_feld_namen[i],lut2_block_status[i]);
   }
}

PHP_FUNCTION(kto_check)
{
   char *blz,*kto,*lut_name;
   int blz_len,kto_len,lut_name_len;

   lut_name=INIT_DEFAULT_LUT_FILE;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss|s",
            &blz,&blz_len,&kto,&kto_len,&lut_name,&lut_name_len)==FAILURE)RETURN_NULL();
   RETURN_LONG(kto_check(blz,kto,lut_name));
}

PHP_FUNCTION(kto_check_pz)
{
   char *kto,*pz,*blz=NULL;
   int kto_len,pz_len,blz_len,ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss|s",
            &pz,&pz_len,&kto,&kto_len,&blz,&blz_len)==FAILURE)RETURN_NULL();
   ret=kto_check_pz(pz,kto,blz);
   RETURN_LONG(ret);
}

PHP_FUNCTION(kto_check_blz)
{
   static char *blz,*kto;
   int blz_len,kto_len,ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss",
            &blz,&blz_len,&kto,&kto_len)==FAILURE)RETURN_NULL();
   ret=kto_check_blz(blz,kto);
   RETURN_LONG(ret);
}

PHP_FUNCTION(kto_check_pz_dbg)
{
   char *kto,*pz,*blz=NULL;
   int kto_len,pz_len,blz_len,ret;
   RETVAL retvals;
   zval *z_methode,*z_pz_methode,*z_pz,*z_pz_pos;

   z_methode=z_pz_methode=z_pz=z_pz_pos=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss|szzzz",&pz,&pz_len,&kto,&kto_len,
            &blz,&blz_len,&z_methode,&z_pz_methode,&z_pz,&z_pz_pos)==FAILURE)RETURN_NULL();
   ret=kto_check_pz_dbg(pz,kto,blz,&retvals);
#if DEBUG
   if(z_methode){
      ZVAL_DTOR(z_methode);
      ZVAL_STRING(z_methode,retvals.methode,1);
   }
   if(z_pz_methode){
      ZVAL_DTOR(z_pz_methode);
      ZVAL_LONG(z_pz_methode,retvals.pz_methode);
   }
   if(z_pz){
      ZVAL_DTOR(z_pz);
      ZVAL_LONG(z_pz,retvals.pz);
   }
   if(z_pz_pos){
      ZVAL_DTOR(z_pz_pos);
      ZVAL_LONG(z_pz_pos,(long)retvals.pz_pos);
   }
#else
   if(z_methode){
      ZVAL_DTOR(z_methode);
      ZVAL_NULL(z_methode);
   }
   if(z_pz_methode){
      ZVAL_DTOR(z_pz_methode);
      ZVAL_NULL(z_pz_methode);
   }
   if(z_pz){
      ZVAL_DTOR(z_pz);
      ZVAL_NULL(z_pz);
   }
   if(z_pz_pos){
      ZVAL_DTOR(z_pz_pos);
      ZVAL_NULL(z_pz_pos);
   }
#endif
   RETURN_LONG(ret);
}

PHP_FUNCTION(kto_check_blz_dbg)
{
   static char *blz,*kto;
   int blz_len,kto_len,ret;
   RETVAL retvals;
   zval *z_methode,*z_pz_methode,*z_pz,*z_pz_pos;

   z_methode=z_pz_methode=z_pz=z_pz_pos=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss|zzzz",&blz,&blz_len,
            &kto,&kto_len,&z_methode,&z_pz_methode,&z_pz,&z_pz_pos)==FAILURE)RETURN_NULL();
   ret=kto_check_blz_dbg(blz,kto,&retvals);
#if DEBUG
   if(z_methode){
      ZVAL_DTOR(z_methode);
      ZVAL_STRING(z_methode,retvals.methode,1);
   }
   if(z_pz_methode){
      ZVAL_DTOR(z_pz_methode);
      ZVAL_LONG(z_pz_methode,retvals.pz_methode);
   }
   if(z_pz){
      ZVAL_DTOR(z_pz);
      ZVAL_LONG(z_pz,retvals.pz);
   }
   if(z_pz_pos){
      ZVAL_DTOR(z_pz_pos);
      ZVAL_LONG(z_pz_pos,(long)retvals.pz_pos);
   }
#else
   if(z_methode){
      ZVAL_DTOR(z_methode);
      ZVAL_NULL(z_methode);
   }
   if(z_pz_methode){
      ZVAL_DTOR(z_pz_methode);
      ZVAL_NULL(z_pz_methode);
   }
   if(z_pz){
      ZVAL_DTOR(z_pz);
      ZVAL_NULL(z_pz);
   }
   if(z_pz_pos){
      ZVAL_DTOR(z_pz_pos);
      ZVAL_NULL(z_pz_pos);
   }
#endif
   RETURN_LONG(ret);
}

PHP_FUNCTION(lut_cleanup)
{
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"")==FAILURE)RETURN_NULL();
   RETURN_LONG(lut_cleanup());
}

PHP_FUNCTION(kto_check_str)
{
   char *blz,*kto,*lut_name;
   int blz_len,kto_len,lut_name_len,ret;
   long ret_type=0;

   lut_name=INIT_DEFAULT_LUT_FILE;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ss|ls",
            &blz,&blz_len,&kto,&kto_len,&ret_type,&lut_name,&lut_name_len)==FAILURE)RETURN_NULL();
   ret=kto_check(blz,kto,lut_name);
   switch(ret_type){
      case 1: RETURN_STRING(kto_check_retval2txt_short(ret),1); break;
      case 2: RETURN_STRING(kto_check_retval2txt(ret),1); break;
      case 3: RETURN_STRING(kto_check_retval2html(ret),1); break;
      case 4: RETURN_STRING(kto_check_retval2dos(ret),1); break;
      case 5: RETURN_STRING(kto_check_retval2utf8(ret),1); break;
      default: RETURN_STRING(kto_check_retval2html(ret),1); break;
   }
}

PHP_FUNCTION(lut_filialen)
{
   char *blz;
   int cnt,ret,blz_len;
   zval *retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|z",
            &blz,&blz_len,&retval)==FAILURE)RETURN_NULL();
   cnt=lut_filialen(blz,&ret);
   if(retval){
      ZVAL_DTOR(retval);
      ZVAL_LONG(retval,ret);
   }
   if(ret==OK){
      RETURN_LONG(cnt);
   }
   else{
      RETURN_NULL();
   }
}

PHP_FUNCTION(kto_check_retval2txt)
{
   long ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",
            &ret)==FAILURE)RETURN_NULL();
   RETURN_STRING(kto_check_retval2txt(ret),1);
}

PHP_FUNCTION(kto_check_retval2html)
{
   long ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",
            &ret)==FAILURE)RETURN_NULL();
   RETURN_STRING(kto_check_retval2html(ret),1);
}

PHP_FUNCTION(kto_check_retval2txt_short)
{
   long ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",
            &ret)==FAILURE)RETURN_NULL();
   RETURN_STRING(kto_check_retval2txt_short(ret),1);
}

PHP_FUNCTION(kto_check_retval2dos)
{
   long ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",
            &ret)==FAILURE)RETURN_NULL();
   RETURN_STRING(kto_check_retval2dos(ret),1);
}

PHP_FUNCTION(kto_check_retval2utf8)
{
   long ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",
            &ret)==FAILURE)RETURN_NULL();
   RETURN_STRING(kto_check_retval2utf8(ret),1);
}

PHP_FUNCTION(lut_name)
{
   static char *blz,*ret_lut_name;
   int ret;
   long blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_name=lut_name(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_NAME]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_STRING(ret_lut_name,1);
}

PHP_FUNCTION(lut_name_kurz)
{
   static char *blz,*ret_lut_name_kurz;
   int ret;
   long blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_name_kurz=lut_name_kurz(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_NAME_KURZ]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_STRING(ret_lut_name_kurz,1);
}

PHP_FUNCTION(lut_plz)
{
   static char *blz;
   int ret;
   long ret_lut_plz,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_plz=lut_plz(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_PLZ]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_plz);
}

PHP_FUNCTION(lut_ort)
{
   static char *blz,*ret_lut_ort;
   int ret;
   long blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_ort=lut_ort(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_ORT]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_STRING(ret_lut_ort,1);
}

PHP_FUNCTION(lut_pan)
{
   static char *blz;
   int ret;
   long ret_lut_pan,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_pan=lut_pan(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_PAN]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_pan);
}

PHP_FUNCTION(lut_bic)
{
   static char *blz,*ret_lut_bic;
   int ret;
   long blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_bic=lut_bic(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_BIC]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_STRING(ret_lut_bic,1);
}

PHP_FUNCTION(lut_nr)
{
   static char *blz;
   int ret;
   long ret_lut_nr,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_nr=lut_nr(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_NR]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_nr);
}

PHP_FUNCTION(lut_pz)
{
   static char *blz;
   int ret;
   long ret_lut_pz,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_pz=lut_pz(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_PZ]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_pz);
}

PHP_FUNCTION(lut_aenderung)
{
   static char *blz;
   int ret;
   long ret_lut_aenderung,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_aenderung=lut_aenderung(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_AENDERUNG]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_aenderung);
}

PHP_FUNCTION(lut_loeschung)
{
   static char *blz;
   int ret;
   long ret_lut_loeschung,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_loeschung=lut_loeschung(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_LOESCHUNG]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_loeschung);
}

PHP_FUNCTION(lut_nachfolge_blz)
{
   static char *blz;
   int ret;
   long ret_lut_nachfolge_blz,blz_len,zweigstelle=0;
   zval *z_retval=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zl",
            &blz,&blz_len,&z_retval,&zweigstelle)==FAILURE)RETURN_NULL();
   ret_lut_nachfolge_blz=lut_nachfolge_blz(blz,zweigstelle,&ret);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,ret);
   }
   if(ret<OK || lut2_block_status[LUT2_NACHFOLGE_BLZ]!=OK){
      RETURN_NULL();
   }
   else
      RETURN_LONG(ret_lut_nachfolge_blz);
}

PHP_FUNCTION(read_lut_block)
{
   char *lut_name;
   UINT4 block_len;
   int lut_name_len,retval;
   long typ;
   char *data;
   zval *z_retval;

   z_retval=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"sl|z",
            &lut_name,&lut_name_len,&typ,&z_retval)==FAILURE)RETURN_NULL();
   retval=read_lut_block(lut_name,(UINT4)typ,&block_len,&data);
   if(z_retval){
      ZVAL_DTOR(z_retval);
      ZVAL_LONG(z_retval,retval);
   }
   ZVAL_STRINGL(return_value,data,block_len,1);
   free(data);
}

PHP_FUNCTION(write_lut_block)
{
   char *lut_name,*data;
   int lut_name_len,data_len,retval;
   long typ;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"sls",
            &lut_name,&lut_name_len,&typ,&data,&data_len)==FAILURE)RETURN_NULL();
   retval=write_lut_block(lut_name,(UINT4)typ,(UINT4)data_len,data);
   RETURN_LONG(retval);
}

PHP_FUNCTION(copy_lutfile)
{
   char *old_name,*new_name;
   int old_name_len,new_name_len,retval;
   long slots;

   retval=slots=0;
   old_name=new_name=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ssl",
            &old_name,&old_name_len,&new_name,&new_name_len,&slots)==FAILURE)RETURN_NULL();
   if(old_name && new_name)retval=copy_lutfile(old_name,new_name,slots);
   RETURN_LONG(retval);
}

PHP_FUNCTION(lut_info)
{
   char *lut_name,*info1,*info2;
   int lut_name_len,valid1,valid2,ret;
   zval *z_info1,*z_info2,*z_valid1,*z_valid2,*z_info3,*z_slots;
   char slot_buffer[512],*ptr;
   int i,ok,retval,len1,len2,slotdir[MAX_SLOTS];
   UINT4 slot_cnt,typ,len,compressed_len,adler;
   FILE *lut;

   lut_name=NULL;
   z_info1=z_info2=z_valid1=z_valid2=z_info3=z_slots=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"|szzzzzz",
            &lut_name,&lut_name_len,&z_info1,&z_valid1,&z_info2,
            &z_valid2,&z_info3,&z_slots)==FAILURE)RETURN_NULL();
   ret=lut_info(lut_name,&info1,&info2,&valid1,&valid2);

   if(z_info1){
      ZVAL_DTOR(z_info1);
      if(info1){
         ZVAL_STRING(z_info1,info1,1);
         free(info1);
      }
      else{
         ZVAL_NULL(z_info1);
      }
   }
   if(z_info2){
      ZVAL_DTOR(z_info2);
      if(info2){
         ZVAL_STRING(z_info2,info2,1);
         free(info2);
      }
      else{
         ZVAL_NULL(z_info2);
      }
   }
   if(z_valid1){
      ZVAL_DTOR(z_valid1);
      ZVAL_LONG(z_valid1,valid1);
   }
   if(z_valid2){
      ZVAL_DTOR(z_valid2);
      ZVAL_LONG(z_valid2,valid2);
   }
   if(z_info3){
      ZVAL_DTOR(z_info3);
      ZVAL_NULL(z_info3);
   }
   if(z_slots){
      ZVAL_DTOR(z_slots);
      ZVAL_NULL(z_slots);
   }
   if(lut_name && (z_slots || z_info3)){
      if((lut=fopen(lut_name,"rb"))){
         ok=1;
         if(z_slots){
            array_init(z_slots);
            snprintf(slot_buffer,512," Slot retval   Typ     Inhalt           Lnge   kompr.  Adler32      Test");
            add_index_string(z_slots,0,slot_buffer,1);
         }
         for(len1=len2=0,i=slot_cnt=1;i<=slot_cnt;i++){
            retval=lut_dir(lut,i,&slot_cnt,&typ,&len,&compressed_len,&adler,NULL);
            if(retval==LUT2_FILE_CORRUPTED){
               if(z_slots){ZVAL_NULL(z_slots);}
               if(z_info3){ZVAL_STRING(z_info3,"Die LUT-Datei ist korrumpiert",1);}
               ok=0;
               break;
            }
            if(retval==INVALID_LUT_FILE){
               if(z_slots){ZVAL_NULL(z_slots);}
            if(z_info3){ZVAL_STRING(z_info3,"die Datei ist keine LUT-Datei",1);}
               ok=0;
               break;
            }
            if(retval==LUT1_FILE_USED){
               if(z_slots){ZVAL_NULL(z_slots);}
               if(z_info3){ZVAL_STRING(z_info3,"Die LUT-Datei ist im alten Format (1.0/1.1)",1);}
               ok=0;
               break;
            }
            if(z_slots){
               snprintf(slot_buffer,512,"%2d/%2u %3d %8d   %-15s %8u %8u  0x%08x   %s",
                     i,slot_cnt,retval,typ,typ<400?lut_block_name2[typ]:"(Userblock)",len,compressed_len,adler,retval==OK?"OK":"FEHLER");
               add_index_string(z_slots,i,slot_buffer,1);
            }
            len1+=len;
            len2+=compressed_len;
         }
         if(ok && z_info3){
            snprintf(slot_buffer,512,"Gesamtgre unkomprimiert: %d, Gesamtgre komprimiert: %d\nKompressionsrate: %1.2f%%\n",
                  len1,len2,100.*(double)len2/len1);
            for(ptr=slot_buffer,len=512;*ptr;ptr++,len--);
            retval=lut_dir(lut,0,&slot_cnt,NULL,NULL,NULL,NULL,slotdir);
            snprintf(ptr,len,"Slotdir (kurz): ");
            for(;*ptr;ptr++,len--);
            for(i=0;i<slot_cnt && len>10;i++)if(slotdir[i]){
               snprintf(ptr,len,"%d ",slotdir[i]);
               for(;*ptr;ptr++,len--);
            }
            ZVAL_STRING(z_info3,slot_buffer,1);
         }
         fclose(lut);
      }
   }
   RETURN_LONG(ret);
}

PHP_FUNCTION(lut_multiple)
{
   char *blz,*p_blz,**p_name,**p_name_kurz,**p_ort,**p_bic,*p_aenderung,*p_loeschung,short_buf[2];
   int blz_len,cnt,*p_plz,*p_pan,p_pz,*p_nr,*p_nachfolge_blz,ret;
   char ***pp_name,***pp_name_kurz,***pp_ort,***pp_bic,**pp_aenderung,**pp_loeschung;
   int **pp_plz,**pp_pan,*pp_pz,**pp_nr,**pp_nachfolge_blz;
   long zweigstelle=0;
   zval *z_cnt,*z_name,*z_name_kurz,*z_plz,*z_ort,*z_pan,*z_bic,*z_pz,*z_nr,
        *z_aenderung,*z_loeschung,*z_nachfolge_blz;

   if(init_status<7)RETURN_LONG(LUT2_NOT_INITIALIZED);
   z_cnt=z_name=z_name_kurz=z_plz=z_ort=z_pan=z_bic=z_pz=z_nr=z_aenderung
      =z_loeschung=z_nachfolge_blz=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|lzzzzzzzzzzzz",
            &blz,&blz_len,&zweigstelle,&z_cnt,&z_name,&z_name_kurz,&z_plz,&z_ort,
            &z_pan,&z_bic,&z_pz,&z_nr,&z_aenderung,&z_loeschung,&z_nachfolge_blz)==FAILURE)RETURN_NULL();

      /* es mu noch eine zustzliche Pointerschicht eingebaut werden, um nicht
       * immer den Fehler -38 (LUT2_PARTIAL_OK) zu bekommen, wie wenn man direkt
       * die Variablenpointer an lut_multiple() bergibt. Im alten Interface
       * werden immer alle Werte abgefragt; daher bekommt man in der Version
       * beim Aufruf dieser Funktion blicherweise immer -38 zurck (auer,
       * falls auch alle Blocks der BLZ-Datei geladen wurden).
       */
   if(z_name){ZVAL_DTOR(z_name); pp_name=&p_name;} else pp_name=NULL;
   if(z_name_kurz){ZVAL_DTOR(z_name_kurz); pp_name_kurz=&p_name_kurz;} else pp_name_kurz=NULL;
   if(z_plz){ZVAL_DTOR(z_plz); pp_plz=&p_plz;} else pp_plz=NULL;
   if(z_ort){ZVAL_DTOR(z_ort); pp_ort=&p_ort;} else pp_ort=NULL;
   if(z_ort){ZVAL_DTOR(z_ort); pp_ort=&p_ort;} else pp_ort=NULL;
   if(z_pan){ZVAL_DTOR(z_pan); pp_pan=&p_pan;} else pp_pan=NULL;
   if(z_bic){ZVAL_DTOR(z_bic); pp_bic=&p_bic;} else pp_bic=NULL;
   if(z_pz){ZVAL_DTOR(z_pz); pp_pz=&p_pz;} else pp_pz=NULL;
   if(z_nr){ZVAL_DTOR(z_nr); pp_nr=&p_nr;} else pp_nr=NULL;
   if(z_aenderung){ZVAL_DTOR(z_aenderung); pp_aenderung=&p_aenderung;} else pp_aenderung=NULL;
   if(z_loeschung){ZVAL_DTOR(z_loeschung); pp_loeschung=&p_loeschung;} else pp_loeschung=NULL;
   if(z_nachfolge_blz){ZVAL_DTOR(z_nachfolge_blz); pp_nachfolge_blz=&p_nachfolge_blz;} else pp_nachfolge_blz=NULL;

   ret=lut_multiple(blz,&cnt,NULL,pp_name,pp_name_kurz,pp_plz,pp_ort,pp_pan,pp_bic,
         pp_pz,pp_nr,pp_aenderung,pp_loeschung,pp_nachfolge_blz,NULL,NULL,NULL);

   if(zweigstelle>=cnt || (ret<OK && ret!=LUT2_PARTIAL_OK)){
      if(z_cnt){ZVAL_NULL(z_cnt);}
      if(z_name){ZVAL_NULL(z_name);}
      if(z_name_kurz){ZVAL_NULL(z_name_kurz);}
      if(z_plz){ZVAL_NULL(z_plz);}
      if(z_ort){ZVAL_NULL(z_ort);}
      if(z_ort){ZVAL_NULL(z_ort);}
      if(z_pan){ZVAL_NULL(z_pan);}
      if(z_bic){ZVAL_NULL(z_bic);}
      if(z_pz){ZVAL_NULL(z_pz);}
      if(z_nr){ZVAL_NULL(z_nr);}
      if(z_aenderung){ZVAL_NULL(z_aenderung);}
      if(z_loeschung){ZVAL_NULL(z_loeschung);}
      if(z_nachfolge_blz){ZVAL_NULL(z_nachfolge_blz);}
      if(zweigstelle>=cnt){
         RETURN_LONG(LUT2_INDEX_OUT_OF_RANGE);
      }
      else{
         RETURN_LONG(ret);
      }
   }
   if(z_cnt)ZVAL_LONG(z_cnt,cnt);

#define Z_RETURN_STRING(z_name,lut2_name,p_name) if(z_name){ \
      if(lut2_block_status[lut2_name]==OK){ \
         ZVAL_STRING(z_name,*(p_name+zweigstelle),1); \
      } \
      else{ \
         ZVAL_NULL(z_name); \
      } \
   }
#define Z_RETURN_LONG(z_name,lut2_name,p_name) if(z_name){ \
      if(lut2_block_status[lut2_name]==OK){ \
         ZVAL_LONG(z_name,*(p_name+zweigstelle)); \
      } \
      else{ \
         ZVAL_NULL(z_name); \
      } \
   }
   Z_RETURN_STRING(z_name,LUT2_NAME,p_name)
   Z_RETURN_STRING(z_name_kurz,LUT2_NAME_KURZ,p_name_kurz)
   Z_RETURN_LONG(z_plz,LUT2_PLZ,p_plz)
   Z_RETURN_STRING(z_ort,LUT2_ORT,p_ort)
   Z_RETURN_LONG(z_pan,LUT2_PAN,p_pan)
   Z_RETURN_STRING(z_bic,LUT2_BIC,p_bic)
   Z_RETURN_LONG(z_nr,LUT2_NR,p_nr)
   Z_RETURN_LONG(z_nachfolge_blz,LUT2_NACHFOLGE_BLZ,p_nachfolge_blz)
   if(z_pz){
      if(lut2_block_status[LUT2_PZ]==OK){
         ZVAL_LONG(z_pz,p_pz);
      }
      else{
         ZVAL_NULL(z_pz);
      }
   }
   if(z_aenderung){
      if(lut2_block_status[LUT2_AENDERUNG]==OK){
         *short_buf=*(p_aenderung+zweigstelle);
         ZVAL_STRING(z_aenderung,short_buf,1);
      }
      else{
         ZVAL_NULL(z_aenderung);
      }
   }
   if(z_loeschung){
      if(lut2_block_status[LUT2_LOESCHUNG]==OK){
         *short_buf=*(p_loeschung+zweigstelle);
         ZVAL_STRING(z_loeschung,short_buf,1);
      }
      else{
         ZVAL_NULL(z_loeschung);
      }
   }
   RETURN_LONG(ret);
}

PHP_FUNCTION(iban_check)
{
   char *iban;
   int iban_len,ret,ret_kto;
   zval *z_ret_kto=NULL;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|z",
            &iban,&iban_len,&z_ret_kto)==FAILURE)RETURN_NULL();
   ret=iban_check(iban,&ret_kto);
   if(z_ret_kto){
      ZVAL_DTOR(z_ret_kto);
      ZVAL_LONG(z_ret_kto,ret_kto);
   }
   RETURN_LONG(ret);
}

PHP_FUNCTION(iban2bic)
{
   char *iban=NULL,*bic,bptr[16],kptr[16];
   int iban_len,ret;
   zval *z_ret=NULL,*z_blz=NULL,*z_kto=NULL;


   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zzz",
            &iban,&iban_len,&z_ret,&z_blz,&z_kto)==FAILURE)RETURN_NULL();
   if(!iban)RETURN_NULL();
   bic=iban2bic(iban,&ret,bptr,kptr);
   if(z_ret){
      ZVAL_DTOR(z_ret);
      ZVAL_LONG(z_ret,ret);
   }
   if(ret==IBAN2BIC_ONLY_GERMAN){
      if(z_blz){
         ZVAL_DTOR(z_blz);
         ZVAL_NULL(z_blz);
      }
      if(z_kto){
         ZVAL_DTOR(z_kto);
         ZVAL_NULL(z_kto);
      }
      RETURN_NULL();
   }
   else{
      if(z_blz){
         ZVAL_DTOR(z_blz);
         ZVAL_STRING(z_blz,bptr,1);
      }
      if(z_kto){
         ZVAL_DTOR(z_kto);
         ZVAL_STRING(z_kto,kptr,1);
      }
      RETURN_STRING(bic,1);
   }
}

PHP_FUNCTION(ipi_gen)
{
   char *zweck,dst[24],papier[32];
   int zweck_len,ret;
   zval *z_ret,*z_papier;

   z_ret=z_papier=NULL;
   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s|zz",
            &zweck,&zweck_len,&z_ret,&z_papier)==FAILURE)RETURN_NULL();
   ret=ipi_gen(zweck,dst,papier);
   if(z_ret){
      ZVAL_DTOR(z_ret);
      ZVAL_LONG(z_ret,ret);
   }
   if(z_papier)ZVAL_DTOR(z_papier);
   if(ret==OK){
      if(z_papier)ZVAL_STRING(z_papier,papier,1);
      RETURN_STRING(dst,1);
   }
   else{
      if(z_papier)ZVAL_NULL(z_papier);
      RETURN_NULL();
   }
}

PHP_FUNCTION(ipi_check)
{
   char *zweck;
   int zweck_len,ret;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"s",
            &zweck,&zweck_len)==FAILURE)RETURN_NULL();
   ret=ipi_check(zweck);
   RETURN_LONG(ret);
}

PHP_FUNCTION(get_kto_check_version)
{
   long type=0;

   if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"|l",&type)==FAILURE)RETURN_NULL();
   switch(type){
      case 0:
      default: RETURN_STRING(get_kto_check_version(),1);
      case 1:  RETURN_STRING(VERSION,1);
      case 2:  RETURN_STRING(VERSION_DATE,1);
      case 3:  RETURN_STRING(__DATE__ ", " __TIME__,1);
   }
}
