/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "layoutpixmap.h"

layoutPixmap::layoutPixmap(int x, int y)
 : layoutImage(x,y)
{
  imageCopy=new QImage(x+2,y+2,QImage::Format_RGB32);
  pixmap=new QPixmap(x+2,y+2);

}


layoutPixmap::~layoutPixmap()
{
//printf("del layoutPixmap\n");
 delete imageCopy;
 delete pixmap;

}


void layoutPixmap::resize( int x, int y){
  //paintMutex.lock() ;
//printf("resize %d,%d\n",x,y);
  layoutImage::resize(x,y);

  delete imageCopy;
  delete pixmap;

  imageCopy=new QImage(x+2,y+2,QImage::Format_RGB32);

  pixmap=new QPixmap(x+2,y+2);
//printf("resize end\n");
}

QPixmap layoutPixmap::getPixmap(){
  if (imageChanged)
     {
     //  QTime t;
     //  t.start();
	for (int h=0; h<image->height();h++){
		uint *p1 = reinterpret_cast<uint *>(image->scanLine(h));
		uint *p0 = reinterpret_cast<uint *>(imageCopy->scanLine(h));
		for (int w=0; w<image->width();w++){
		 	*p0=*p1;
			++p0;
			++p1;
		}
	}
	//printf(".\n");
	//*imageCopy=*image;
	imageChanged=false;
	//	  printf("paint 1: %d ms\n", t.elapsed());
	*pixmap=QPixmap::fromImage(*imageCopy,Qt::AvoidDither|Qt::ThresholdDither|Qt::ThresholdAlphaDither|Qt::NoOpaqueDetection);//|Qt::OrderedDither);
	//	  printf("paint 2: %d ms\n", t.elapsed());
	}
  return *pixmap;
}

QImage layoutPixmap::getImage(){
	for (int h=0; h<image->height();h++){
		uint *p1 = reinterpret_cast<uint *>(image->scanLine(h));
		uint *p0 = reinterpret_cast<uint *>(imageCopy->scanLine(h));
		for (int w=0; w<image->width();w++){
		 	*p0=*p1;
			p0++;
			p1++;
		}
	}
	//QImage i= (*image);
	//i.detach();
	return *imageCopy;
}
