/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mousewidget.h"
#include <qimage.h>
//Added by qt3to4:
#include <QPixmap>
#include <QLabel>
#include "icons/mouse.xpm"
#include "icons/mouseleft.xpm"
#include "icons/mousemid.xpm"
#include "icons/mouseright.xpm"
#include "icons/mouseleftshift.xpm"
#include "icons/mouseleftctl.xpm"
#include "icons/mouseleftalt.xpm"
#include "icons/mouseleftshiftctl.xpm"
#include "icons/mouseleftmove.xpm"
#include "icons/mouseleftwait.xpm"
#include "icons/mousescroll.xpm"
#include "icons/mouserightshift.xpm"
#include "icons/mouserightctl.xpm"
#include "icons/mouserightmove.xpm"
#include "icons/mouseshiftleftmove.xpm"
#include "icons/mousectlleftmove.xpm"
#include "icons/mouseleftshiftctlmove.xpm"
#include <QMenu>
#include "dialog/helpwindow.h"
#include "widgets/mainwindow.h"

mouseWidget *mouseWidget::mouseInfo=NULL;
QPixmap *mouseWidget::pixmaps[18];
QString mouseWidget::functionText[8];
int mouseWidget::iconNum[8];
QMutex mouseWidget::locked;

mouseWidget::mouseWidget(mainWindow *m,QWidget *parent, const char *)
 : QWidget(parent)
{
  main=m;
  setMinimumSize(125,8*32);
  setMaximumSize(225,8*32);
  //setFixedSize(125,8*32);
  setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Fixed);
  if (mouseWidget::mouseInfo==NULL) {
	mouseWidget::mouseInfo=this;
	pixmaps[0]=new QPixmap(mouse);
	pixmaps[1]=new QPixmap(mouseleft);
	pixmaps[2]=new QPixmap(mousemid);
	pixmaps[3]=new QPixmap(mouseright);
	pixmaps[4]=new QPixmap(mouseleftshift);
	pixmaps[5]=new QPixmap(mouseleftctl);
	pixmaps[6]=new QPixmap(mouseleftshiftctl);
	pixmaps[7]=new QPixmap(mouseleftmove);
	pixmaps[8]=new QPixmap(mouseleftwait);
	pixmaps[9]=new QPixmap(mousescroll);
	pixmaps[10]=new QPixmap(mouserightshift);
	pixmaps[11]=new QPixmap(mouserightctl);
	pixmaps[12]=new QPixmap(mouserightmove);
	pixmaps[13]=new QPixmap(mouseshiftleftmove);
	pixmaps[14]=new QPixmap(mouseleftalt);
	pixmaps[15]=new QPixmap(mouseleftshiftctlmove);
	pixmaps[16]=new QPixmap(mousectlleftmove);
	}
  else {
  	QFont f;
	f.setPixelSize(11);
     for (int i=0; i<8;i++){
     	icons[i]=new QLabel(this);
	icons[i]->setPixmap(*pixmaps[i]);
	icons[i]->setGeometry(0,i*32,32,32);
	icons[i]->hide();
	textLabel[i]=new QLabel(this);
	textLabel[i]->setText("test");
	textLabel[i]->setGeometry(33,i*32,89,32);
	textLabel[i]->setFont(f);
	textLabel[i]->setAlignment(Qt::AlignLeft|Qt::AlignVCenter);
	textLabel[i]->hide();
  	}

  }
}

mouseWidget::~mouseWidget()
{
}

void mouseWidget::update(){
if (!locked.tryLock()) return;
 for (int i=0; i<8;i++){
	if (iconNum[i]<0){
		icons[i]->hide();
		textLabel[i]->hide();}
	else {
		icons[i]->setPixmap(*pixmaps[iconNum[i]]);
		icons[i]->show();
		textLabel[i]->setText(functionText[i]);
		textLabel[i]->show();
	}
 }
locked.unlock();
 //repaint();
}

void mouseWidget::set(int mode, int modestep){
if (mouseWidget::mouseInfo==NULL) return;
if (!locked.tryLock()) return;
  for (int i=0; i<8;i++){iconNum[i]=-1;functionText[i]="";}
  int rest=0;
  switch (mode){
  case 0: //default
  	if (modestep<2){
		iconNum[0]=1; functionText[0]=tr("select element");
		iconNum[1]=7; functionText[1]=tr("select elements\nin window");
		iconNum[2]=4; functionText[2]=tr("add element\nto selection");
		iconNum[3]=13; functionText[3]=tr("add window\nto selection");
		rest=4;
		}
	else if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("source point");
		rest=1;
		}
	else if (modestep==3){
		iconNum[0]=1; functionText[0]=tr("dest. point");
		rest=1;
		}
	break;
  case 1: //Point mode
  	iconNum[0]=1; functionText[0]=tr("%1.point").arg(modestep+1);
	rest=1;
  	if (modestep>=1){
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;
		}
	break;
  case 10: //fselect
  	iconNum[0]=1; functionText[0]=tr("select single\nform");
	iconNum[1]=5; functionText[1]=tr("replace select\nsingle form");
	iconNum[2]=7; functionText[2]=tr("select forms\none in window");
	iconNum[3]=13; functionText[3]=tr("select forms\nall in window");
	iconNum[4]=16; functionText[4]=tr("replace selection\none in window");
	iconNum[5]=15; functionText[5]=tr("replace selection\nall in window");
	rest=6;
  	break;
  case 15: //fdeselect
  	iconNum[0]=1; functionText[0]=tr("deselect single\nform");
	iconNum[1]=7; functionText[1]=tr("deselect forms\none in window");
	iconNum[2]=13; functionText[2]=tr("deselect forms\nall in window");
	iconNum[3]=5; functionText[3]=tr("select all except\nsingle form");
	iconNum[4]=16; functionText[4]=tr("select all except\none in window");
	iconNum[5]=15; functionText[5]=tr("select all except\nall in window");
	rest=6;
	break;
  case 20: //pselect	
  	iconNum[0]=1; functionText[0]=tr("select point");
	iconNum[1]=7; functionText[1]=tr("select points\nin window");
	iconNum[2]=5; functionText[2]=tr("replace selection\nsingle point");
	iconNum[3]=16; functionText[3]=tr("replace selection\npoints in window");
	rest=4;
	break;
  case 25: //pdeselect	
  	iconNum[0]=1; functionText[0]=tr("deselect point");
	iconNum[1]=7; functionText[1]=tr("deselect points\nin window");
	iconNum[2]=5; functionText[2]=tr("select all except\nsingle point");
	iconNum[3]=16; functionText[3]=tr("select all except\nin window");
	rest=4;
	break;
  case 30: //cselect	
  	iconNum[0]=1; functionText[0]=tr("select single\ncell");
	iconNum[1]=7; functionText[1]=tr("select cells\nin window");
	iconNum[2]=4; functionText[2]=tr("next\ncell");
	iconNum[3]=5; functionText[3]=tr("replace selection\nsingle cell");
	iconNum[4]=16; functionText[4]=tr("replace selection\ncell in window");
	rest=5;
	break;
  case 35: //cdeselect	
  	iconNum[0]=1; functionText[0]=tr("deselect single\ncell");
	iconNum[1]=7; functionText[1]=tr("deselect cells\nin window");
	iconNum[2]=4; functionText[2]=tr("next\ncell");
	iconNum[3]=5; functionText[3]=tr("select all except\nsingle cell");
	iconNum[4]=16; functionText[4]=tr("select all except\nin window");
	rest=5;
	break;
  case 100: //box
	if (modestep==0) 
		{iconNum[0]=1; functionText[0]=tr("Box: 1.corner");
		iconNum[1]=5; functionText[1]=tr("Box: center");
		rest=2;
		}
	else {
		iconNum[0]=1; functionText[0]=tr("Box: 2.corner");
		iconNum[1]=4; functionText[1]=tr("square");
		iconNum[2]=5; functionText[2]=tr("centered\nbox");
		iconNum[3]=6; functionText[3]=tr("centered\nsquare");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;
		}
	break;
  case 110: //Polygon
  	iconNum[0]=1; functionText[0]=tr("Polygon:\n%1.point").arg(modestep+1);
	rest=1;
	if (modestep==0) {
		iconNum[1]=4; functionText[1]=tr("insert point\nmode");
		iconNum[2]=5; functionText[2]=tr("move single\npoint mode");
		rest=3;
		}
  	else if ((modestep==1)|| (modestep==2)){
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;
		}
	else if (modestep>1) {
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("close polygon");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("close polygon");
		rest=5;
		}
	break;
  case 120: //cellref
  	iconNum[0]=1; functionText[0]=tr("Cellref:\norigin");
	iconNum[1]=4; functionText[1]=tr("rotate\nccw");
	iconNum[2]=5; functionText[2]=tr("rotate\ncw");
	iconNum[3]=6; functionText[3]=tr("mirror");
	rest=4;
	break;
  case 130: //Cellrefarray
    iconNum[1]=4; functionText[1]=tr("rotate\nccw");
	iconNum[2]=5; functionText[2]=tr("rotate\ncw");
	iconNum[3]=6; functionText[3]=tr("mirror");
  	if (modestep==0) { iconNum[0]=1; functionText[0]=tr("CellrefArray:\norigin");rest=4;}
	else {  iconNum[0]=1; functionText[0]=tr("CellrefArray:\nspacing");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;
		}
	break;
  case 140: //Text
  	iconNum[0]=1; functionText[0]=tr("Text: origin");
	iconNum[1]=5; functionText[1]=tr("move single\npoint mode");
	rest=2;
	break;
  case 150: //path
  	iconNum[0]=1; functionText[0]=tr("Path:\n%1.point").arg(modestep+1);
	rest=1;
	if (modestep==0) {
		iconNum[1]=4; functionText[1]=tr("insert point\nmode");
		iconNum[2]=5; functionText[2]=tr("move single\npoint mode");
		rest=3;
		}
  	else if (modestep==1){
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;
		}
	else if (modestep>1) {
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("next path");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("next path");
		rest=5;
		}
	break;
  case 170: //node mode
  	iconNum[0]=1; functionText[0]=tr("show node");
	rest=1;
	break;
  case 180: //ruler
  	iconNum[0]=1; functionText[0]=tr("Ruler: origin");
	rest=1;
	if (modestep==1){
		iconNum[1]=4; functionText[1]=tr("perpendicular\nmeasurement");
		iconNum[2]=5; functionText[2]=tr("make ruler\npermanent");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 181: //length measurement
  	iconNum[0]=1; functionText[0]=tr("Length:\n%1.point").arg(modestep+1);
	rest=1;
  	if (modestep==1){
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;
		}
	else if (modestep>1) {
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("next length");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("next length");
		rest=5;
		}
	break;
  case 182: //length element
	rest=0;
	break;
  case 183: // element size
	iconNum[0]=1; functionText[0]=tr("measure distance\nto element");
	rest=1;
	break;
  case 185: //angle
  	if (modestep==0){ 
		iconNum[0]=1; functionText[0]=tr("Angle: center");
		rest=1; }
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("Angle: set\nfirst angle");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=4; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("Angle: center");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;
		}
	break;
  case 188: //circle fit
  	iconNum[0]=1; functionText[0]=tr("Circle fit:\n%1.point").arg(modestep+1);
	rest=1;
 	 if (modestep>1) {
		iconNum[1]=4; functionText[1]=tr("fit to circle");
		iconNum[2]=5; functionText[2]=tr("fit to circle");
		iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		iconNum[4]=2; functionText[4]=tr("fit to circle");
		rest=5;
		}
	break;
  case 189: //circle box
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Circle: 1st corner");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("2nd corner");
		iconNum[1]=4; functionText[1]=tr("Circle in square");
		iconNum[2]=6; functionText[2]=tr("Ellipse");
		iconNum[3]=5; functionText[3]=tr("abort");
		iconNum[4]=2; functionText[4]=tr("abort");
		rest=5;}
	break;
  case 190: //spiral
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Spiral: center");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set start radius");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set end radius");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 191: //circle
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Circle: center");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set radius");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 192: //sector
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Sector: center");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set radius");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set arc");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 193: //arc
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Arc: center");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set radius");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set arc");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 194: //polygon arc
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Polygon Arc:\ncenter");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set start");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set arc");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 195: //bezier2
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Bezier2:\nstart");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set end");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set bezier\npoint");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 196: //bezier3
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Bezier3:\nstart");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set end");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set bezier\nstart point");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==3){
		iconNum[0]=1; functionText[0]=tr("set bezier\nend point");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 200: //zoom
  	iconNum[0]=7; functionText[0]=tr("-> zoom in\n<- zoom out");
	rest=1;
  	break;
  case 300: //mirror
  	iconNum[0]=1; functionText[0]=tr("Mirror:\n%1.point").arg(modestep+1);
	rest=1;
	if (modestep==1){
		iconNum[1]=4; functionText[1]=tr("axis mirror");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}

	break;
  case 308: //move x
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Move X: source\npoint");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set destination\npoint");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=3; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 309: //move y
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Move Y: source\npoint");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set destination\npoint");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 310: //move
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Move: source\npoint");
		iconNum[1]=4; functionText[1]=tr("move by");
		iconNum[2]=5; functionText[2]=tr("move single\npoint mode");
		rest=3;
		}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set destination\npoint");
		iconNum[1]=4; functionText[1]=tr("perpendicular\nmove");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 312: //move single point
  	if (modestep==0){
		iconNum[0]=1; functionText[0]=tr("move point:\nthis element");
		iconNum[1]=4; functionText[1]=tr("open point\ndialog");
		iconNum[2]=5; functionText[2]=tr("next element");
		iconNum[3]=2; functionText[3]=tr("next element");
		rest=4;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("move to");
		iconNum[1]=4; functionText[1]=tr("perpendicular\nmove");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 313: //insert point
  	if (modestep==0){
		iconNum[0]=1; functionText[0]=tr("insert point\nvia mouse");
		iconNum[1]=4; functionText[1]=tr("insert point\nvia dialog");
		rest=2;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("insert point");
		iconNum[1]=4; functionText[1]=tr("perpendicular\npoint");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 315: //set cell origin
  	iconNum[0]=1; functionText[0]=tr("set cell\norigin");
	rest=1;
	break;
  case 320: //rotate
	if (modestep==0){
  		iconNum[0]=1; functionText[0]=tr("Rotate:\ncenter");
		iconNum[1]=4; functionText[1]=tr("Rotate graphical\ncenter");
		rest=2;}
	if (modestep==1){
  		iconNum[0]=1; functionText[0]=tr("Rotate\nwith x-axis");
		iconNum[1]=4; functionText[1]=tr("Rotate graphical\n1. angle");
		rest=2;}
	if (modestep==2){
  		iconNum[0]=1; functionText[0]=tr("Rotate");
		iconNum[1]=4; functionText[1]=tr("Rotate\nperpendicular");
		rest=1;}
	break;
  case 330: //copy
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Copy: source\npoint");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set destination\npoint");
		iconNum[1]=4; functionText[1]=tr("perpendicular\ncopy");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 340: //cut
  	iconNum[0]=1; functionText[0]=tr("Cut:\n%1.point").arg(modestep+1);
	rest=1;
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("cut");
		iconNum[1]=4; functionText[1]=tr("perpendicular\ncut");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 350: //scale
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("Scale: set orgin");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set source\npoint");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	if (modestep==2){
		iconNum[0]=1; functionText[0]=tr("set destination\npoint");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
  	break;
  case 400: //properties
  	iconNum[0]=1; functionText[0]=tr("Properties:\nopen dialog");
	iconNum[1]=4; functionText[1]=tr("insert point\nmode");
	iconNum[2]=5; functionText[2]=tr("next\nelement");
	iconNum[3]=6; functionText[3]=tr("Properties:\nbasic editing");
	rest=4;
	break;
  case 500: //align center xy
  case 501: //align center x
  case 502: //align center y
	if (modestep==0) 
		{iconNum[0]=1; functionText[0]=tr("Align:\n1st point");
		rest=1;
		}
	else {
		iconNum[0]=1; functionText[0]=tr("Align:\n2nd point");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;
		}
	break;
  case 503: //center xy
  case 504: //center x
  case 505: //center y
	iconNum[0]=1; functionText[0]=tr("center\npoint");
	rest=1;
	break;
  case 510: //alignleft
	iconNum[0]=1; functionText[0]=tr("align left");
	rest=1;
	break;
  case 512: //alignright
	iconNum[0]=1; functionText[0]=tr("align right");
	rest=1;
	break;
  case 514: //aligntop
	iconNum[0]=1; functionText[0]=tr("align top");
	rest=1;
	break;
  case 516: //alignbottom
	iconNum[0]=1; functionText[0]=tr("align bottom");
	rest=1;
	break;
  case 520: //align Value
  	if (modestep==0){iconNum[0]=1; functionText[0]=tr("align value\nfix point");
		rest=1;}
	if (modestep==1){
		iconNum[0]=1; functionText[0]=tr("set move point");
		iconNum[1]=4; functionText[1]=tr("abort");
		iconNum[2]=5; functionText[2]=tr("abort");
		iconNum[3]=2; functionText[3]=tr("abort");
		rest=4;}
	break;
  case 590: //adjust background
  	iconNum[0]=1; functionText[0]=tr("move\nimage");
	iconNum[1]=4; functionText[1]=tr("rotate\nimage");
	iconNum[2]=5; functionText[2]=tr("scale\nimage");
	iconNum[3]=6; functionText[3]=tr("shear\nimage");
	rest=4;
	break;
  case 591: //select color background
	iconNum[0]=1; functionText[0]=tr("select\ncolor");
	rest=1;
  case 600: //select cell mode
	iconNum[0]=1; functionText[0]=tr("select cell\nto view");
	rest=1;
	break;
  case 700: //barcode
	if (modestep==0) 
		{iconNum[0]=1; functionText[0]=tr("Barcode:\n 1.corner");
		rest=1;
		}
	else {
		iconNum[0]=1; functionText[0]=tr("Barcode:\n 2.corner");
		iconNum[1]=2; functionText[1]=tr("read\nbarcode");
		rest=2;
		}
	break;
  case 701: //netlist link
  	iconNum[0]=1; functionText[0]=tr("netlist\nlink");
	rest=1;
	break;
  case 702: //121: //netlist place
  	iconNum[0]=1; functionText[0]=tr("place:\norigin");
	iconNum[1]=4; functionText[1]=tr("rotate\nccw");
	iconNum[2]=5; functionText[2]=tr("rotate\ncw");
	iconNum[3]=6; functionText[3]=tr("mirror");
	rest=4;
	break;
  case 703://160: //netlist route
	  if (modestep==0){
		  iconNum[0]=1; functionText[0]=tr("start route");
		  iconNum[1]=4; functionText[1]=tr("level up");
		  iconNum[2]=5; functionText[2]=tr("level down");
		  iconNum[3]=6; functionText[3]=tr("label node");
		  iconNum[4]=7; functionText[4]=tr("box");
		  iconNum[5]=13; functionText[5]=tr("vias up");
		  iconNum[6]=16; functionText[6]=tr("vias down");
		  iconNum[7]=9; functionText[7]=tr("zoom");
		  rest=-1;
	  }
	  else {
		  iconNum[0]=1; functionText[0]=tr("add new\npoint");
		  iconNum[1]=4; functionText[1]=tr("level up");
		  iconNum[2]=5; functionText[2]=tr("level down");
		  iconNum[3]=6; functionText[3]=tr("clear last\npoint");
		  iconNum[4]=2; functionText[4]=tr("end route");
		  iconNum[5]=14; functionText[5]=tr("end route");
		  iconNum[6]=13; functionText[6]=tr("vias up");
		  iconNum[7]=16; functionText[7]=tr("vias down");
		  rest=-1;
	  }
    break;
//schematic modes
  case 5000: //place component
	iconNum[0]=1; functionText[0]=tr("place component");
	iconNum[1]=4; functionText[1]=tr("rotate\nccw");
	iconNum[2]=5; functionText[2]=tr("rotate\ncw");
	iconNum[3]=6; functionText[3]=tr("mirror");
	rest=4;
	break;
  case 5001://wire
	iconNum[0]=1; functionText[0]=tr("start wire");
	rest=1;
	if (modestep>0) {
		iconNum[1]=4; functionText[1]=tr("exit wire");
		iconNum[2]=2; functionText[2]=tr("exit wire");
		iconNum[3]=5; functionText[3]=tr("change way");
		rest=4;
	}
	break;
  case 5002://bus
	iconNum[0]=1; functionText[0]=tr("start bus");
	rest=1;
	if (modestep>0) {
		iconNum[1]=4; functionText[1]=tr("exit bus");
		iconNum[2]=2; functionText[2]=tr("exit bus");
		iconNum[3]=5; functionText[3]=tr("change way");
		rest=4;
	}
	break;
  case 5003://label node
	iconNum[0]=1; functionText[0]=tr("label node");
	rest=1;
	break;
  case 5004://port
	iconNum[0]=1; functionText[0]=tr("place port");
	rest=1;
	break;
  case 5005://bus port
	iconNum[0]=1; functionText[0]=tr("place bus port");
	rest=1;
	break;
  case 5006://line
	iconNum[0]=1; functionText[0]=tr("line\nenter point");
	rest=1;
	if (modestep>0){
		iconNum[1]=4; functionText[1]=tr("line\nexit");
		iconNum[2]=2; functionText[2]=tr("line\nexit");
		rest=3;
	}
	break;
  case 5007://rect
	if (modestep==0) {iconNum[0]=1; functionText[0]=tr("rectabgle:\n1.point");}
	else  {iconNum[0]=1; functionText[0]=tr("rectangle:\n2.point");}
	rest=1;
	break;
  case 5008://circle
	if (modestep==0) {iconNum[0]=1; functionText[0]=tr("circle:\n1.point");}
	else  {iconNum[0]=1; functionText[0]=tr("circle:\n2.point");}
	rest=1;
	break;
  case 5009://arc
	if (modestep==0) {iconNum[0]=1; functionText[0]=tr("arc: center");}
	else if (modestep==1) {iconNum[0]=1; functionText[0]=tr("arc: 1.point");}
	else  {iconNum[0]=1; functionText[0]=tr("arc: 2.point");}
	rest=1;
	break;
  case 5010://text
	iconNum[0]=1; functionText[0]=tr("place text");
	rest=1;
	break;
  case 5011://polygon
	iconNum[0]=1; functionText[0]=tr("polygon\nenter point");
	rest=1;
	if (modestep>0){
		iconNum[1]=4; functionText[1]=tr("polygon\nclose");
		iconNum[2]=2; functionText[2]=tr("polygon\nclose");
		rest=3;
	}
	break;
  case 5012://ground
	iconNum[0]=1; functionText[0]=tr("place ground");
	rest=1;
	break;
  case 5013://edit
	if ((modestep==0)||(modestep==1)){
	iconNum[0]=1; functionText[0]=tr("do layout\ncomponent/node");
	iconNum[1]=4; functionText[1]=tr("edit component");
	rest=2;}
	else if (modestep==3){
		iconNum[0]=1; functionText[0]=tr("set\ndestination");
		rest=1;
		}
	else if (modestep==10){
	iconNum[0]=1; functionText[0]=tr("set new\nlabel orgin");
	rest=1;
	}
	else if (modestep==20){
	iconNum[0]=1; functionText[0]=tr("set new\norgin");
	rest=1;
	}
	break;
   }
  if (rest>=0){
	if (rest<8) {iconNum[rest]=9; functionText[rest]=tr("zoom");}
	if (rest<7) {iconNum[rest+1]=12; functionText[rest+1]=tr("scroll");}
	if (rest<6) {
		if ((mode==0)&&(modestep<2)) {
			iconNum[rest+2]=3; functionText[rest+2]=tr("context menu");
			}
		else if (mode==5013){
			iconNum[rest+2]=3; functionText[rest+2]=tr("context menu");
			}
		else if ((mode==10)||(mode==15)||(mode==20)||(mode==25)||(mode==30)||(mode==35)){
			iconNum[rest+2]=3; functionText[rest+2]=tr("context menu");
			}
		else {iconNum[rest+2]=3; functionText[rest+2]=tr("main-menu");}
		}
  }
 locked.unlock();
  emit mouseWidget::mouseInfo->changed();
}

void mouseWidget::set(helpText h){
if (mouseWidget::mouseInfo==NULL) return;
if (!locked.tryLock()) return;
  for (int i=0; i<8;i++){iconNum[i]=-1;functionText[i]="";}
  switch (h) {
  case clear: break;
  case layerButtonHelp:
	iconNum[0]=1; functionText[0]=tr("make active");
	iconNum[1]=2; functionText[1]=tr("toggle visibility");
	iconNum[2]=4; functionText[2]=tr("toggle visibility");
	iconNum[3]=5; functionText[3]=tr("hide all other\nlayers");
	iconNum[4]=10;functionText[4]=tr("show all layers");
	iconNum[5]=11;functionText[5]=tr("all layer\nbounding box");
	iconNum[6]=6; functionText[6]=tr("edit properties");
	iconNum[7]=8; functionText[7]=tr("show menu");
	break;
  case setBoxModeHelp: iconNum[0]=1; functionText[0]=tr("set box mode"); break;
  case setPathModeHelp: iconNum[0]=1; functionText[0]=tr("set path mode"); break;
  case setPolygonModeHelp: iconNum[0]=1; functionText[0]=tr("set polygon\nmode"); break;
  case setCellrefModeHelp: iconNum[0]=1; functionText[0]=tr("set cellref\nmode"); break;
  case setCellrefArrayModeHelp: iconNum[0]=1; functionText[0]=tr("set cellrefarray\nmode"); break;
  case setTextModeHelp: iconNum[0]=1; functionText[0]=tr("set text mode"); break;
  case setSubfunctionHelp: iconNum[0]=1; functionText[0]=functionText[1]=functionText[2]=tr("set subfunction"); 
  	 iconNum[0]=1;  iconNum[1]=4;  iconNum[2]=2;  break;
  case setCopyModeHelp: iconNum[0]=1; functionText[0]=tr("set copy mode"); break;
  case setMoveModeHelp: iconNum[0]=1; functionText[0]=tr("set move mode"); break;
  case setMovePointModeHelp: iconNum[0]=1; functionText[0]=tr("set move single\npoint mode"); break;
  case moveByHelp: iconNum[0]=1; functionText[0]=tr("move by"); break;
  case setRotateModeHelp: iconNum[0]=1; functionText[0]=tr("set rotate mode"); break;
  case setMirrorModeHelp: iconNum[0]=1; functionText[0]=tr("set mirror mode"); break;
  case copyToLayerHelp: iconNum[0]=1; functionText[0]=tr("copy to layer"); break;
  case moveToLayerHelp: iconNum[0]=1; functionText[0]=tr("move to layer"); break;
  case mergeHelp: iconNum[0]=1; functionText[0]=tr("merge"); break;
  case setCutModeHelp: iconNum[0]=1; functionText[0]=tr("set cut mode"); break;
  case deleteHelp: iconNum[0]=1; functionText[0]=tr("delete"); break;
  case setPropertiesModeHelp: iconNum[0]=1; functionText[0]=tr("set properties\nmode"); break;
  case newDrawingHelp: iconNum[0]=1; functionText[0]=tr("new drawing"); break;
  case openFileHelp: iconNum[0]=1; functionText[0]=tr("open file"); break;
  case attachFileHelp: iconNum[0]=1; functionText[0]=tr("attach file"); break;
  case saveFileHelp: iconNum[0]=1; functionText[0]=tr("save file"); break;
  case saveAsFileHelp: iconNum[0]=1; functionText[0]=tr("save file as"); break;
  case screenshotHelp: iconNum[0]=1; functionText[0]=tr("screenshot"); break;
  case printHelp: iconNum[0]=1; functionText[0]=tr("print"); break;
  case whatThisHelp: iconNum[0]=1; functionText[0]=tr("what this"); break;
  case pointSelectHelp: iconNum[0]=1; functionText[0]=tr("point select"); break;
  case formSelectHelp: iconNum[0]=1; functionText[0]=tr("form select"); break;
  case cellSelectHelp: iconNum[0]=1; functionText[0]=tr("cell select"); break;
  case pointDeselectHelp: iconNum[0]=1; functionText[0]=tr("point deselect"); break;
  case formDeselectHelp: iconNum[0]=1; functionText[0]=tr("form deselect"); break;
  case cellDeselectHelp: iconNum[0]=1; functionText[0]=tr("cell deselect"); break;
  case selectAllHelp: iconNum[0]=1; functionText[0]=tr("select all"); break;
  case selectVisibleHelp: iconNum[0]=1; functionText[0]=tr("select visible"); break;
  case deselectAllHelp: iconNum[0]=1; functionText[0]=tr("deselect all"); break;
  case scrollUpHelp: iconNum[0]=1; functionText[0]=tr("scroll up"); break;
  case scrollDownHelp: iconNum[0]=1; functionText[0]=tr("scroll down"); break;
  case scrollLeftHelp: iconNum[0]=1; functionText[0]=tr("scroll left"); break;
  case scrollRightHelp: iconNum[0]=1; functionText[0]=tr("scroll right"); break;
  case zoomPlusHelp: iconNum[0]=1; functionText[0]=tr("zoom in"); break;
  case zoomMinusHelp: iconNum[0]=1; functionText[0]=tr("zoom out"); break;
  case zoomFullHelp: iconNum[0]=1; functionText[0]=tr("zoom fit all"); break;
  case zoomOneHelp: iconNum[0]=1; functionText[0]=tr("zoom to 1:1"); break;
  case setZoomModeHelp: iconNum[0]=1; functionText[0]=tr("set zoom mode"); break;
  case setCellnameHelp: iconNum[0]=1; functionText[0]=tr("set cell name"); break;
  case newCellHelp: iconNum[0]=1; functionText[0]=tr("new cell"); break;
  case deleteCellHelp: iconNum[0]=1; functionText[0]=tr("delete cell"); break;
  case flat1Help: iconNum[0]=1; functionText[0]=tr("upgroup 1x"); break;
  case flatAllHelp: iconNum[0]=1; functionText[0]=tr("upgroup all"); break;
  case ungroupHelp: iconNum[0]=1; functionText[0]=tr("upgroup"); break;//obsolete
  case groupHelp: iconNum[0]=1; functionText[0]=tr("group"); break;
  case undoHelp: iconNum[0]=1; functionText[0]=tr("undo"); break;
  case redoHelp: iconNum[0]=1; functionText[0]=tr("redo"); break;
  case reduceGridHelp: iconNum[0]=1; functionText[0]=tr("reduce grid"); break;
  case increaseGridHelp: iconNum[0]=1; functionText[0]=tr("increase grid"); break;
  case autoGridHelp: iconNum[0]=1; functionText[0]=tr("auto grid on"); break;
  case showGridHelp: iconNum[0]=1; functionText[0]=tr("show/hide grid"); break;
  case setCircleModeHelp: iconNum[0]=1; functionText[0]=tr("set circle mode"); break;
  case setSectorModeHelp: iconNum[0]=1; functionText[0]=tr("set sector mode"); break;
  case setArcModeHelp: iconNum[0]=1; functionText[0]=tr("set arc mode"); break;
  case setSpiralModeHelp: iconNum[0]=1; functionText[0]=tr("set spiral mode"); break;
  case removeSmallHelp: iconNum[0]=1; functionText[0]=tr("remove small\nedges"); break;
  case roundHelp: iconNum[0]=1; functionText[0]=tr("round elements"); break;
  case setscaleModeHelp: iconNum[0]=1; functionText[0]=tr("set scale mode"); break;
  case sizeAdjustHelp: iconNum[0]=1; functionText[0]=tr("size adjust"); break;
  case areaHelp: iconNum[0]=1; functionText[0]=tr("calculate area"); break;
  case setRulerModeHelp: iconNum[0]=1; functionText[0]=tr("set ruler mode"); break;
  case setAHelp: iconNum[0]=1; functionText[0]=tr("Boolean: set\n select to A"); break;
  case setBHelp: iconNum[0]=1; functionText[0]=tr("Boolean: set\n select to B"); break;
  case APlusBHelp: iconNum[0]=1; functionText[0]=tr("A+B"); break;
  case AMultiBHelp: iconNum[0]=1; functionText[0]=tr("A*B"); break;
  case AMinusBHelp: iconNum[0]=1; functionText[0]=tr("A-B"); break;
  case BMinusAHelp: iconNum[0]=1; functionText[0]=tr("B-A"); break;
  case AEorBHelp: iconNum[0]=1; functionText[0]=tr("A eor B"); break;
  case snapGridHelp: iconNum[0]=1; functionText[0]=tr("snap to grid"); break;
  case snapPointHelp: iconNum[0]=1; functionText[0]=tr("snap to points"); break;
  case snapLineHelp: iconNum[0]=1; functionText[0]=tr("snap to line"); break;
  case snapMiddleHelp: iconNum[0]=1; functionText[0]=tr("snap to middle\nof line"); break;
  case snapCenterHelp: iconNum[0]=1; functionText[0]=tr("snap to center"); break;
  case snapInterHelp: iconNum[0]=1; functionText[0]=tr("snap to\nintersections"); break;
  case setupHelp: iconNum[0]=1; functionText[0]=tr("open setup\ndialog"); break;
  case setBezier2ModeHelp: iconNum[0]=1; functionText[0]=tr("set bezier\n2nd order mode"); break;
  case setBezier3ModeHelp: iconNum[0]=1; functionText[0]=tr("set bezier\n3rd order mode"); break;
  case setArc2ModeHelp: iconNum[0]=1; functionText[0]=tr("set polygon\narc mode"); break;
  case updateFileHelp: iconNum[0]=1; functionText[0]=tr("update cells\nwith file"); break;
  case pathSelectHelp: iconNum[0]=1; functionText[0]=tr("select visible\npath elements"); break;
  case pathDeselectHelp: iconNum[0]=1; functionText[0]=tr("deselect all\npath elements"); break;
  case polygonSelectHelp: iconNum[0]=1; functionText[0]=tr("select visible\npolygons"); break;
  case polygonDeselectHelp: iconNum[0]=1; functionText[0]=tr("deselect all\npolygons"); break;
  case boxSelectHelp: iconNum[0]=1; functionText[0]=tr("select visible\nbox elements"); break;
  case boxDeselectHelp: iconNum[0]=1; functionText[0]=tr("deselect all\nbox elements"); break;
  case textSelectHelp: iconNum[0]=1; functionText[0]=tr("select visible\ntext elements"); break;
  case textDeselectHelp: iconNum[0]=1; functionText[0]=tr("deselect all\ntext elements"); break;
  case toPolygonHelp: iconNum[0]=1; functionText[0]=tr("convert\nto polygon"); break;
  case toBoxHelp: iconNum[0]=1; functionText[0]=tr("convert\nto box"); break;
  case deselectLayerHelp: iconNum[0]=1; functionText[0]=tr("deselect\nactive layer"); break;
  case selectLayerHelp: iconNum[0]=1; functionText[0]=tr("select\nactive layer"); break;
  case drcSetLayerHelp: iconNum[0]=1; functionText[0]=tr("drc: set\nerror layer"); break;
  case drcShowReportHelp: iconNum[0]=1; functionText[0]=tr("drc: show\nreport"); break;
  case drcMinDistanceHelp: iconNum[0]=1; functionText[0]=tr("drc: min\ndistance"); break;
  case drcInsideHelp: iconNum[0]=1; functionText[0]=tr("drc: inside"); break;
  case drcNoElementHelp: iconNum[0]=1; functionText[0]=tr("drc: no\nelement"); break;
  case drcNoPathHelp: iconNum[0]=1; functionText[0]=tr("drc: no path"); break;
  case drcNoBoxHelp: iconNum[0]=1; functionText[0]=tr("drc: no box"); break;
  case drcNoTextHelp: iconNum[0]=1; functionText[0]=tr("drc: no\npolygon"); break;
  case drcNoPolygonHelp: iconNum[0]=1; functionText[0]=tr("drc: no text"); break;
  case drcMinSizeHelp: iconNum[0]=1; functionText[0]=tr("drc: min size"); break;
  case drcMinOverHelp: iconNum[0]=1; functionText[0]=tr("drc: min\noverlap"); break;
  case drcOverlapingElementsHelp: iconNum[0]=1; functionText[0]=tr("drc: overlap\nelemets"); break;
  case drcMinDistanceOrOverlapHelp: iconNum[0]=1; functionText[0]=tr("drc:min dis.\nwith overlap"); break;
  case setAngleModeHelp: iconNum[0]=1; functionText[0]=tr("set angle mode"); break;
  case macroReloadHelp: iconNum[0]=1; functionText[0]=tr("reloads macros"); break;
  case macroStartHelp: iconNum[0]=1; functionText[0]=tr("start macro\nrecording"); break;
  case macroStopHelp: iconNum[0]=1; functionText[0]=tr("stop macro\nrecording"); break;
  case copyCellHelp: iconNum[0]=1; functionText[0]=tr("copy current\ncell"); break;
  case extractCellHelp: iconNum[0]=1; functionText[0]=tr("extract\ncell"); break;
  case extractLayerHelp: iconNum[0]=1; functionText[0]=tr("extract\nlayer"); break;
  case invertSelectHelp: iconNum[0]=1; functionText[0]=tr("invert\nselection"); break;
  case toCircleHelp: iconNum[0]=1; functionText[0]=tr("convert\nto circle"); break;
  case zoomSelectHelp: iconNum[0]=1; functionText[0]=tr("zoom fit\nselection"); break;
  case setMoveXModeHelp: iconNum[0]=1; functionText[0]=tr("set X move\nmode"); break;
  case setMoveYModeHelp: iconNum[0]=1; functionText[0]=tr("set Y move\nmode"); break;
  case setCircleBoxModeHelp: iconNum[0]=1; functionText[0]=tr("set circle\nfrom box mode"); break;
  case setCircleFitModeHelp: iconNum[0]=1; functionText[0]=tr("set fit circle\nmode"); break;
  case centerXHelp: iconNum[0]=1; functionText[0]=tr("set center x\nmode"); break;
  case centerHelp: iconNum[0]=1; functionText[0]=tr("set center\nmode"); break;
  case centerYHelp: iconNum[0]=1; functionText[0]=tr("set center y\nmode"); break;
  case alignXHelp: iconNum[0]=1; functionText[0]=tr("set align\ncenter x mode"); break;
  case alignHelp: iconNum[0]=1; functionText[0]=tr("set align\ncenter mode"); break;
  case alignYHelp: iconNum[0]=1; functionText[0]=tr("set align\ncenter y mode"); break;
  case alignValueHelp: iconNum[0]=1; functionText[0]=tr("set align\n value mode"); break;
  case alignLeftHelp: iconNum[0]=1; functionText[0]=tr("set align\n left mode"); break;
  case alignRightHelp: iconNum[0]=1; functionText[0]=tr("set align\n right mode"); break;
  case alignTopHelp: iconNum[0]=1; functionText[0]=tr("set align\n top mode"); break;
  case alignBottomHelp: iconNum[0]=1; functionText[0]=tr("set align\n bottom mode"); break;
  case stripUnneededHelp: iconNum[0]=1; functionText[0]=tr("strip unneeded"); break;
  case clipboardCopyHelp: iconNum[0]=1; functionText[0]=tr("copy to\nclipboard"); break;
  case clipboardPasteHelp: iconNum[0]=1; functionText[0]=tr("past from\nclipboard"); break;
  case drcMinElementDisHelp: iconNum[0]=1; functionText[0]=tr("drc: minimum\nelement distance"); break;
  case view3dallHelp: iconNum[0]=1; functionText[0]=tr("all elements\nin 3D"); break;
  case view3dselectHelp: iconNum[0]=1; functionText[0]=tr("selected\nelements in 3D"); break;
  case view3dautoHelp: iconNum[0]=1; functionText[0]=tr("automatic all\nelements in 3D"); break;
  case view3doffHelp: iconNum[0]=1; functionText[0]=tr("3d view off"); break;
  case view3dscreenshotHelp: iconNum[0]=1; functionText[0]=tr("export\n3D view"); break;
  case macroExecuteHelp: iconNum[0]=1; functionText[0]=tr("execute a\nmacro"); break;
  case view3dsetupHelp: iconNum[0]=1; functionText[0]=tr("setup\n3D view"); break;
  case view3dHelp: iconNum[0]=7; functionText[0]=tr("rotate 3D view");
			iconNum[1]=9; functionText[1]=tr("zoom 3D view");
			iconNum[2]=12; functionText[2]=tr("scroll 3D view");
			iconNum[3]=3; functionText[3]=tr("3D menu"); break;
  case lengthHelp: iconNum[0]=1; functionText[0]=tr("set length mode"); break;
  case lengthelementHelp: iconNum[0]=1; functionText[0]=tr("set length element\nmode"); break;
  case selectCellHelp: iconNum[0]=1; functionText[0]=tr("select a cell\n to show"); break;
  case setGridHelp:iconNum[0]=1; functionText[0]=tr("enter grid"); break;
  case commandHelp:iconNum[0]=1; functionText[0]=tr("enter command"); break;
  case view3dRotXHelp: iconNum[0]=7; functionText[0]=tr("rotate\nX axis"); break;
  case view3dRotYHelp: iconNum[0]=7; functionText[0]=tr("rotate\nY axis"); break;
  case view3dRotZHelp: iconNum[0]=7; functionText[0]=tr("rotate\nZ axis"); break;
  case drcOnlyCircleHelp: iconNum[0]=1; functionText[0]=tr("drc: no circle"); break;
  case drcNoCircleHelp: iconNum[0]=1; functionText[0]=tr("drc: only\ncircle"); break;
  case setSelectCellModeHelp: iconNum[0]=1; functionText[0]=tr("select cell\nto view"); break;
  case setActiveLayerHelp: iconNum[0]=1; functionText[0]=tr("set active\nlayer by key"); break;
  case setVisibilityLayerHelp: iconNum[0]=1; functionText[0]=tr("toggle layer\nby shortkey"); break;
  case setHideOtherLayerHelp: iconNum[0]=1; functionText[0]=tr("hide layer\nby shortkey"); break;
  case setAllLayerHelp: iconNum[0]=1; functionText[0]=tr("all layer\nvisible"); break;
  case generateTechMacroHelp: iconNum[0]=1; functionText[0]=tr("technologie\nmacro"); break;
  case nextLayoutHelp: iconNum[0]=1; functionText[0]=tr("next layout"); break;
  case groupSimpleHelp: iconNum[0]=1; functionText[0]=tr("simple group"); break;
  case groupGlobalHelp: iconNum[0]=1; functionText[0]=tr("global group"); break;
  case groupStructureHelp: iconNum[0]=1; functionText[0]=tr("structure\ngroup"); break;
  case cellUpHelp: iconNum[0]=1; functionText[0]=tr("cell up"); break;
  case stripIdenticalElementsHelp: iconNum[0]=1; functionText[0]=tr("strip identical\nelements"); break;
  case netlistLoadHelp: iconNum[0]=1; functionText[0]=tr("load netlist"); break;
  case netlistSaveHelp: iconNum[0]=1; functionText[0]=tr("save netlist"); break;
  case netlistAddLibraryHelp: iconNum[0]=1; functionText[0]=tr("add library"); break;
  case netlistRemoveLibraryHelp: iconNum[0]=1; functionText[0]=tr("remove library"); break;
  case netlistRebuildHelp: iconNum[0]=1; functionText[0]=tr("rebuild\nlibrary/netlist"); break;
  case technologyLayerRemoveHelp: iconNum[0]=1; functionText[0]=tr("remove select\ntechnology layer"); break;
  case technologyLayerNewHelp: iconNum[0]=1; functionText[0]=tr("add new\ntechnology layer"); break;
  case technologyLayerDownHelp: iconNum[0]=1; functionText[0]=tr("technology\nlayer up"); break;
  case technologyLayerUpHelp: iconNum[0]=1; functionText[0]=tr("technology\nlayer down"); break;
  case placeShowConnectionsHelp: iconNum[0]=1; functionText[0]=tr("show\nconnections"); break;
  case setPlaceModeHelp: iconNum[0]=1; functionText[0]=tr("set place\nmode"); break;
  case setRouteModeHelp: iconNum[0]=1; functionText[0]=tr("set route\nmode"); break;
  case routeFineHelp: iconNum[0]=1; functionText[0]=tr("route fine"); break;
  case routeadjustHelp: iconNum[0]=1; functionText[0]=tr("route\nadjust"); break;
  case route45Help: iconNum[0]=1; functionText[0]=tr("route 45"); break;
  case route90Help: iconNum[0]=1; functionText[0]=tr("route 90"); break;
  case setNodeModeHelp: iconNum[0]=1; functionText[0]=tr("set node\nmode"); break;
  case buildConnectHelp: iconNum[0]=1; functionText[0]=tr("build\nconnections"); break;
  case saveGenNetHelp: iconNum[0]=1; functionText[0]=tr("save gen.\nnetlist"); break;
  case lvsHelp: iconNum[0]=1; functionText[0]=tr("lvs"); break;
  case registerLicenseHelp: iconNum[0]=1; functionText[0]=tr("register\nlicense"); break;
  case layerManagerHelp: iconNum[0]=1; functionText[0]=tr("layer\nmanager"); break;
  case compareCellHelp: iconNum[0]=1; functionText[0]=tr("compare\ncell"); break;
  case toMeshHelp: iconNum[0]=1; functionText[0]=tr("convert\nto mesh"); break;
  case generateViewMacroHelp: iconNum[0]=1; functionText[0]=tr("generate\nview macro"); break;
  case cropSharpAnglesHelp: iconNum[0]=1; functionText[0]=tr("crop sharp\nangles"); break;
  case setBarcodeCode39ModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ncode39"); break;
  case setBarcodeCode39Mod43ModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ncode39mod43"); break;
  case setBarcodeCode128ModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ncode128"); break;
  case setBarcodeCode128AModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ncode128A"); break;
  case setBarcodeCode128BModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ncode128B"); break;
  case setBarcodeCode128CModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ncode128C"); break;
  case setDatamatrixModeHelp: iconNum[0]=1; functionText[0]=tr("barcode\ndatamatrix"); break;
  case cropWithSelectionHelp: iconNum[0]=1; functionText[0]=tr("crop with\nselection"); break;
  case modifyCornersHelp: iconNum[0]=1; functionText[0]=tr("modify\ncorners"); break;
  case setCellOriginHelp: iconNum[0]=1; functionText[0]=tr("set cell\norigin mode"); break;
  case closedPathToPolygonHelp: iconNum[0]=1; functionText[0]=tr("closed path\nto polygon"); break;
  case insertPointHelp: iconNum[0]=1; functionText[0]=tr("set insert\npoint mode"); break;
  case hideUnusedLayersHelp: iconNum[0]=1; functionText[0]=tr("hide unused\nlayers design"); break;
  case hideCurUnusedLayersHelp: iconNum[0]=1; functionText[0]=tr("hide unused\nlayers cell"); break;
  case enableAllLayersHelp: iconNum[0]=1; functionText[0]=tr("enable all\nlayers"); break;
  case disableUnusedLayersHelp: iconNum[0]=1; functionText[0]=tr("disable\nunused layers"); break;
  case mergeToHelp: iconNum[0]=1; functionText[0]=tr("merge select\nto active layer"); break;
  case drcLayerCombinationHelp: iconNum[0]=1; functionText[0]=tr("drc: check\nof layer comb."); break;
  case setElementSizeModeHelp: iconNum[0]=1; functionText[0]=tr("set element\nsize mode"); break;
  case drcEnclosureHelp: iconNum[0]=1; functionText[0]=tr("drc: enclosure"); break;
  case drcOverlapDistanceHelp: iconNum[0]=1; functionText[0]=tr("drc: overlap\ndistance"); break;
  case drcOnGridHelp: iconNum[0]=1; functionText[0]=tr("drc: on grid"); break;
  case generate3dSetupMacroHelp: iconNum[0]=1; functionText[0]=tr("save 3D\nview setup"); break;
  case setLayerAHelp: iconNum[0]=1; functionText[0]=tr("Boolean: set active\nlayer to A"); break;
  case setLayerBHelp: iconNum[0]=1; functionText[0]=tr("Boolean: set active\nlayer to B"); break;
  case schematicHelp: iconNum[0]=1; functionText[0]=tr("open\nschematic"); break;
  case openLayoutHelp: iconNum[0]=1; functionText[0]=tr("open\nlayout"); break;
  case detailsLevel3Help: iconNum[0]=1; functionText[0]=tr("paint details\nlevel 3"); break;
  case detailsLevel2Help: iconNum[0]=1; functionText[0]=tr("paint details\nlevel 2"); break;
  case detailsLevel1Help: iconNum[0]=1; functionText[0]=tr("paint details\nlevel 1"); break;
  case detailsAllHelp: iconNum[0]=1; functionText[0]=tr("paint details\nall"); break;
  case detailsAutoHelp: iconNum[0]=1; functionText[0]=tr("paint details\nauto"); break;
  case gotoxyHelp: iconNum[0]=1; functionText[0]=tr("set view\ngoto XY"); break;
  case copyByHelp: iconNum[0]=1; functionText[0]=tr("copy\nmove by xy"); break;
  case drcNoHolesHelp: iconNum[0]=1; functionText[0]=tr("drc: no holes"); break;
  case drcNotchesHelp: iconNum[0]=1; functionText[0]=tr("drc: notches"); break;
  case drcAnglesHelp: iconNum[0]=1; functionText[0]=tr("drc: angles"); break;
  case drcDimensionHelp: iconNum[0]=1; functionText[0]=tr("drc: dimension"); break;
  case drcAreaHelp: iconNum[0]=1; functionText[0]=tr("drc: area"); break;
  case drcPerimeterHelp: iconNum[0]=1; functionText[0]=tr("drc: perimeter"); break;
  case setSelectEditHelp: iconNum[0]=1; functionText[0]=tr("set select\nedit mode"); break;
  case pointSelectDeselectHelp: iconNum[0]=1; functionText[0]=tr("point select"); 
 		 iconNum[1]=4; functionText[1]=tr("point deselect"); break;
  case formSelectDeselectHelp: iconNum[0]=1; functionText[0]=tr("form select"); 
 		 iconNum[1]=4; functionText[1]=tr("form deselect"); break;
  case cellSelectDeselectHelp: iconNum[0]=1; functionText[0]=tr("cell select"); 
 		 iconNum[1]=4; functionText[1]=tr("cell deselect"); break;
  case zoomPlusMinusHelp: iconNum[0]=1; functionText[0]=tr("zoom full"); 
		iconNum[1]=4; functionText[1]=tr("zoom in"); 
 		 iconNum[2]=5; functionText[2]=tr("zoom out"); break;
  case saveAsSaveFileHelp: iconNum[0]=1; functionText[0]=tr("save file"); 
 		 iconNum[1]=4; functionText[1]=tr("save file as"); break;
  case openImportFileHelp: iconNum[0]=1; functionText[0]=tr("open file"); 
 		 iconNum[1]=4; functionText[1]=tr("attach file"); break;
  case deSelectAllHelp: iconNum[0]=1; functionText[0]=tr("select all"); 
		iconNum[1]=4; functionText[1]=tr("select visible"); 
 		 iconNum[2]=5; functionText[2]=tr("deselect all"); break;
  case openImportUpdateFileHelp: iconNum[0]=1; functionText[0]=tr("open file"); 
 		 iconNum[1]=4; functionText[1]=tr("attach file"); 
		 iconNum[2]=5; functionText[2]=tr("update file"); break;
  case gridAutoPlusMinusHelp: iconNum[0]=1; functionText[0]=tr("auto grid on"); 
 		 iconNum[1]=4; functionText[1]=tr("increase grid"); 
		 iconNum[2]=5; functionText[2]=tr("reduce grid"); break;
  case setSelectCellModecellUpHelp: iconNum[0]=1; functionText[0]=tr("select cell\nto view"); 
 		 iconNum[1]=4; functionText[1]=tr("cell up"); 
		 iconNum[2]=5; functionText[2]=tr("previous cell"); 
		 break;
  case stripEmptyCellsHelp: iconNum[0]=1; functionText[0]=tr("strip emtpy\ncells"); break;
  case removeCellArrayHelp: iconNum[0]=1; functionText[0]=tr("remove\ncell arrays"); break;
  case removeNotOrthogonalRefHelp: iconNum[0]=1; functionText[0]=tr("remove not\northogonal cell"); break;
  case oaLibCreateHelp: iconNum[0]=1; functionText[0]=tr("create/register\nOpenAccess lib"); break;
  case oaSetLibHelp: iconNum[0]=1; functionText[0]=tr("set working\nlibrary"); break;
  case oaReadLayerHelp: iconNum[0]=1; functionText[0]=tr("read\nlayer.map"); break;
  case oaLoadNetHelp: iconNum[0]=1; functionText[0]=tr("load oa\nnetlist"); break;
  case oaVersionHelp: iconNum[0]=1; functionText[0]=tr("about\nopen access"); break;
  case oaOpenHelp: iconNum[0]=1; functionText[0]=tr("OpenAccess\nview open"); break;
  case removeScaledRefHelp: iconNum[0]=1; functionText[0]=tr("removed scaled\ncellrefs"); break;
  case oaCellInfoHelp: iconNum[0]=1; functionText[0]=tr("OpenAccess\ncell info"); break;
  case oaAddLibHelp: iconNum[0]=1; functionText[0]=tr("add oa library"); break;
  case macroeditHelp: iconNum[0]=1; functionText[0]=tr("edit macro"); break;
  case backgroundsetHelp: iconNum[0]=1; functionText[0]=tr("set\nbackground"); break;
  case backgroundallclearHelp: iconNum[0]=1; functionText[0]=tr("clear all\nbackgrounds"); break;
  case backgroundclearHelp: iconNum[0]=1; functionText[0]=tr("clear cur.\nbackground"); break;
  case closeDesignHelp: iconNum[0]=1; functionText[0]=tr("close\ndesign"); break;
  case selectCellNameHelp: iconNum[0]=1; functionText[0]=tr("select cell\nby name"); break;
  case placeBackgroundHelp: iconNum[0]=1; functionText[0]=tr("place\nbackground"); break;
  case centerBackgroundHelp: iconNum[0]=1; functionText[0]=tr("center\nbackground"); break;
  case backgroundSetColorHelp: iconNum[0]=1; functionText[0]=tr("set\ncolor"); break;
  case backgroundChooseColorHelp: iconNum[0]=1; functionText[0]=tr("choose\ncolor"); break;
  case backgroundPreviewColorHelp: iconNum[0]=1; functionText[0]=tr("preview\ncolor"); break;
  case layer123Help: iconNum[0]=1; functionText[0]=tr("sort layer\nby number"); break;
  case layerABCHelp: iconNum[0]=1; functionText[0]=tr("sort layer\nby name"); break;
  case layerBlockHelp: iconNum[0]=1; functionText[0]=tr("display layer\nas block"); break;
  case layerListHelp: iconNum[0]=1; functionText[0]=tr("display layer\nas list"); break;
  case setPreviousCellHelp: iconNum[0]=1; functionText[0]=tr("previous cell");  break;
  case setUserunitsHelp: iconNum[0]=1; functionText[0]=tr("set\nuserunits"); break;
  case snapShapesHelp: iconNum[0]=1; functionText[0]=tr("shap\nshapes"); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
// schematic help
  case schematicWireHelp: iconNum[0]=1; functionText[0]=tr("set wire\nmode"); break;
  case schematicBusHelp: iconNum[0]=1; functionText[0]=tr("set bus\nmode"); break;
  case lableNodeHelp: iconNum[0]=1; functionText[0]=tr("set lable\nmode"); break;
  case portHelp: iconNum[0]=1; functionText[0]=tr("set port\nmode"); break;
  case busportHelp: iconNum[0]=1; functionText[0]=tr("set busport\nmode"); break;
  case schematicLineHelp: iconNum[0]=1; functionText[0]=tr("set line\nmode"); break;
  case schematicRectHelp: iconNum[0]=1; functionText[0]=tr("set rect\nmode"); break;
  case schematicCircleHelp: iconNum[0]=1; functionText[0]=tr("set circle\nmode"); break;
  case schematicArcHelp: iconNum[0]=1; functionText[0]=tr("set arc\nmode"); break;
  case schematicTextHelp: iconNum[0]=1; functionText[0]=tr("set text\nmode"); break;
  case schematicNewHelp: iconNum[0]=1; functionText[0]=tr("new sheet\nmode"); break;
  case schematicNameHelp: iconNum[0]=1; functionText[0]=tr("set sheet\nname"); break;
  case schematicDeleteHelp: iconNum[0]=1; functionText[0]=tr("del sheet"); break;
  case schematicPolygonHelp: iconNum[0]=1; functionText[0]=tr("set polygon\nmode"); break;
  case addSchematicLibHelp: iconNum[0]=1; functionText[0]=tr("add library"); break;
  case removeSchematicLibHelp: iconNum[0]=1; functionText[0]=tr("remove\nlibrary"); break;
  case newComponentHelp: iconNum[0]=1; functionText[0]=tr("new component"); break;
  case editComponentHelp: iconNum[0]=1; functionText[0]=tr("edit\ncomponent"); break;
  case schematicLibSelectHelp: iconNum[0]=1; functionText[0]=tr("select\nlibrary"); break;
  case schematicGroundHelp: iconNum[0]=1; functionText[0]=tr("set ground\nmode"); break;
  case schematicColorHelp: iconNum[0]=1; functionText[0]=tr("set default\ncolor"); break;
  case schematicEditHelp: iconNum[0]=1; functionText[0]=tr("edit\nitem"); break;
  case toLayoutHelp: iconNum[0]=1; functionText[0]=tr("copy to\nlayout"); break;
  case toComponenttHelp: iconNum[0]=1; functionText[0]=tr("use as\ncomponent"); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
//  case : iconNum[0]=1; functionText[0]=tr(""); break;
  case execHelp: iconNum[0]=1; functionText[0]=tr("execute"); break;
  case helpHelp:
  case aboutHelp:
  case exitHelp:
	break;

  }
 locked.unlock();
  emit mouseWidget::mouseInfo->changed();
}


void mouseWidget::setMultifunction(helpText h){
  set(h);
  if (mouseWidget::mouseInfo==NULL) return;
if (!locked.tryLock()) return;
  if (iconNum[0]<0){iconNum[0]=0; functionText[0]="";}
  iconNum[1]=2; functionText[1]=tr("set subfunction");
  iconNum[2]=4; functionText[2]=tr("set subfunction");
  iconNum[3]=8; functionText[3]=tr("show menu");
 locked.unlock();
   emit mouseWidget::mouseInfo->changed();
}

void mouseWidget::resizeEvent(QResizeEvent *){
  if (mouseWidget::mouseInfo==NULL) return;
    int right=width()-33-1;
    for (int i=0; i<8;i++){
     	//icons[i]=new QLabel(this);
	//icons[i]->setPixmap(*pixmaps[i]);
	//icons[i]->setGeometry(0,i*32,32,32);
	//icons[i]->hide();
	textLabel[i]->setGeometry(33,i*32,right,32);
  	}
}

void mouseWidget::contextMenuEvent ( QContextMenuEvent * event) {
//  printf("content menu requested\n");
if (main==NULL) return;
QMenu menu;
menu.addAction(helpWindow::getIcon(helpHelp),helpWindow::getMenuname(helpHelp),main->helpwindow,SLOT(showHelp()));
menu.addAction(helpWindow::getIcon(aboutHelp),helpWindow::getMenuname(aboutHelp),main,SLOT(about()));
//menu.addAction(helpWindow::getIcon(groupHelp),tr("Group"),this,SLOT(contextGroup()));
menu.exec(QCursor::pos());
}
