/***************************************************************************
 *   Copyright (C) 2006 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "newcombobox.h"
#include "layout.h"

#include <QWhatsThis>

newComboBox::newComboBox(QWidget *parent)
 : QComboBox(parent)
{
help=setSubfunctionHelp;
setWhatsThis("No Documentation!");
}


newComboBox::~newComboBox()
{
}



QSize newComboBox::sizeHint() const {
   QSize s = QComboBox::sizeHint();
   QSize size(minimumSize().width(), s.height());
   return size;
}
void newComboBox::enterEvent ( QEvent * e ){
  mouseWidget::set(help);
  QComboBox::enterEvent(e);
}


bool newComboBox::event(QEvent * event){
  if (event->type() == QEvent::WhatsThis) {
	//QWhatsThis::hideText ();
	  layout::helpwindow->showHelp(help);
	  QWhatsThis::leaveWhatsThisMode ();
	  return true;
	}
  return QComboBox::event( event);
}
