/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "selectwidget.h"

#include <qimage.h>
#include <qstatusbar.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
#include "icons/pointtoolicon.xpm"
#include "icons/cellarrayicon.xpm"
#include "icons/boxicon.xpm"
#include "icons/polygonicon.xpm"
#include "icons/cellicon.xpm"
#include "icons/text.xpm"
#include "icons/lineicon.xpm"
#include "dialog/helpwindow.h"
#include <QMenu>

selectwidget::selectwidget(QWidget *la,QWidget *parent, const char *)
 : QWidget(parent)
{
l=la;
QString s=tr("This bar indicates all selected element in the actual cell.");
pointIcon=new QLabel(this);
pointIcon->setWhatsThis(s);
pointNumber=new QLabel(this);
pointNumber->setWhatsThis(s);
pathIcon=new QLabel(this);
pathIcon->setWhatsThis(s);
pathNumber=new QLabel(this);
pathNumber->setWhatsThis(s);
boxIcon=new QLabel(this);
boxIcon->setWhatsThis(s);
boxNumber=new QLabel(this);
boxNumber->setWhatsThis(s);
polygonIcon=new QLabel(this);
polygonIcon->setWhatsThis(s);
polygonNumber=new QLabel(this);
polygonNumber->setWhatsThis(s);
cellrefIcon=new QLabel(this);
cellrefIcon->setWhatsThis(s);
cellrefNumber=new QLabel(this);
cellrefNumber->setWhatsThis(s);
cellrefarrayIcon=new QLabel(this);
cellrefarrayIcon->setWhatsThis(s);
cellrefarrayNumber=new QLabel(this);
cellrefarrayNumber->setWhatsThis(s);
textIcon=new QLabel(this);
textIcon->setWhatsThis(s);
textNumber=new QLabel(this);
textNumber->setWhatsThis(s);;
QPixmap ppointsIcon, ppathIcon, pboxIcon, ppolygonIcon, pcellrefIcon, pcellrefarrayIcon, ptextIcon  ;
ppointsIcon = QPixmap(pointtoolicon);
pointIcon->setPixmap(ppointsIcon);
ppathIcon = QPixmap(lineicon);
pathIcon->setPixmap(ppathIcon);
pboxIcon = QPixmap(boxicon);
boxIcon->setPixmap(pboxIcon);
ppolygonIcon = QPixmap(polygonicon);
polygonIcon->setPixmap(ppolygonIcon);
pcellrefIcon = QPixmap(cellicon);
cellrefIcon->setPixmap(pcellrefIcon);
pcellrefarrayIcon = QPixmap(cellarrayicon);
cellrefarrayIcon->setPixmap(pcellrefarrayIcon);
ptextIcon = QPixmap(text);
textIcon->setPixmap(ptextIcon);
setNormal();
reset();
}
void selectwidget::setOff(){
setFixedSize(0,17);
}
void selectwidget::setSmall(){
setFixedSize(245,17);
pointIcon->setGeometry(0,0,17,17);
pointNumber->setGeometry(17,0,19,17);
pathIcon->setGeometry(35,0,17,17);
pathNumber->setGeometry(52,0,19,17);
boxIcon->setGeometry(70,0,17,17);
boxNumber->setGeometry(87,0,19,17);
polygonIcon->setGeometry(105,0,17,17);
polygonNumber->setGeometry(122,0,19,17);
cellrefIcon->setGeometry(140,0,17,17);
cellrefNumber->setGeometry(157,0,19,17);
cellrefarrayIcon->setGeometry(175,0,17,17);
cellrefarrayNumber->setGeometry(192,0,19,17);
textIcon->setGeometry(210,0,17,17);
textNumber->setGeometry(227,0,19,17);
}
void selectwidget::setNormal(){
setFixedSize(280,17);
pointIcon->setGeometry(0,0,17,17);
pointNumber->setGeometry(17,0,50,17);
pathIcon->setGeometry(40,0,17,17);
pathNumber->setGeometry(57,0,50,17);
boxIcon->setGeometry(80,0,17,17);
boxNumber->setGeometry(97,0,50,17);
polygonIcon->setGeometry(120,0,17,17);
polygonNumber->setGeometry(137,0,50,17);
cellrefIcon->setGeometry(160,0,17,17);
cellrefNumber->setGeometry(177,0,50,17);
cellrefarrayIcon->setGeometry(200,0,17,17);
cellrefarrayNumber->setGeometry(217,0,50,17);
textIcon->setGeometry(240,0,17,17);
textNumber->setGeometry(257,0,50,17);
}
void selectwidget::setWide(){
setFixedSize(350,17);
pointIcon->setGeometry(0,0,17,17);
pointNumber->setGeometry(17,0,50,17);
pathIcon->setGeometry(50,0,17,17);
pathNumber->setGeometry(67,0,50,17);
boxIcon->setGeometry(100,0,17,17);
boxNumber->setGeometry(117,0,50,17);
polygonIcon->setGeometry(150,0,17,17);
polygonNumber->setGeometry(167,0,50,17);
cellrefIcon->setGeometry(200,0,17,17);
cellrefNumber->setGeometry(217,0,50,17);
cellrefarrayIcon->setGeometry(250,0,17,17);
cellrefarrayNumber->setGeometry(267,0,50,17);
textIcon->setGeometry(300,0,17,17);
textNumber->setGeometry(317,0,50,17);
}
void selectwidget::setExtraWide(){
setFixedSize(570,17);
pointIcon->setGeometry(0,0,17,17);
pointNumber->setGeometry(17,0,70,17);
pathIcon->setGeometry(80,0,17,17);
pathNumber->setGeometry(97,0,70,17);
boxIcon->setGeometry(160,0,17,17);
boxNumber->setGeometry(177,0,70,17);
polygonIcon->setGeometry(240,0,17,17);
polygonNumber->setGeometry(257,0,70,17);
cellrefIcon->setGeometry(320,0,17,17);
cellrefNumber->setGeometry(337,0,70,17);
cellrefarrayIcon->setGeometry(400,0,17,17);
cellrefarrayNumber->setGeometry(417,0,70,17);
textIcon->setGeometry(480,0,17,17);
textNumber->setGeometry(497,0,70,17);
}
selectwidget::~selectwidget()
{
}


void selectwidget::setSelect( elementCount count){
QString s;
s.setNum(count.points);
pointNumber->setText(s);
if (count.points==0) pointIcon->setEnabled(false);
else pointIcon->setEnabled(true);
s.setNum(count.path);
pathNumber->setText(s);
if (count.path==0) pathIcon->setEnabled(false);
else pathIcon->setEnabled(true);
s.setNum(count.box);
boxNumber->setText(s);
if (count.box==0) boxIcon->setEnabled(false);
else boxIcon->setEnabled(true);
s.setNum(count.polygon);
polygonNumber->setText(s);
if (count.polygon==0) polygonIcon->setEnabled(false);
else polygonIcon->setEnabled(true);
s.setNum(count.cellref);
cellrefNumber->setText(s);
if (count.cellref==0) cellrefIcon->setEnabled(false);
else cellrefIcon->setEnabled(true);
s.setNum(count.cellrefarray);
cellrefarrayNumber->setText(s);
if (count.cellrefarray==0) cellrefarrayIcon->setEnabled(false);
else cellrefarrayIcon->setEnabled(true);
s.setNum(count.text);
textNumber->setText(s);
if (count.text==0) textIcon->setEnabled(false);
else textIcon->setEnabled(true);
}

void selectwidget::reset( ){
pointNumber->setText("0");
pointIcon->setEnabled(false);
pathNumber->setText("0");
pathIcon->setEnabled(false);
boxNumber->setText("0");
boxIcon->setEnabled(false);
polygonNumber->setText("0");
polygonIcon->setEnabled(false);
cellrefNumber->setText("0");
cellrefIcon->setEnabled(false);
cellrefarrayNumber->setText("0");
cellrefarrayIcon->setEnabled(false);
textNumber->setText("0");
textIcon->setEnabled(false);
}

int selectwidget::getSelectedAreaShapes(){
int b=boxNumber->text().toInt();
int p=polygonNumber->text().toInt();
return b+p;
}
void selectwidget::contextMenuEvent ( QContextMenuEvent * event) {
  if (QApplication::keyboardModifiers ()!=Qt::NoModifier) {event->ignore();return;}
  //printf("content menu requested\n");
#ifdef FULL_VERSION
QMenu menu;

menu.addAction(helpWindow::getIcon(pathSelectHelp),helpWindow::getMenuname(pathSelectHelp),l,SLOT(pathSelect()));
menu.addAction(helpWindow::getIcon(pathDeselectHelp),helpWindow::getMenuname(pathDeselectHelp),l,SLOT(pathDeselect()));

menu.addAction(helpWindow::getIcon(boxSelectHelp),helpWindow::getMenuname(boxSelectHelp),l,SLOT(boxSelect()));
menu.addAction(helpWindow::getIcon(boxDeselectHelp),helpWindow::getMenuname(boxDeselectHelp),l,SLOT(boxDeselect()));

menu.addAction(helpWindow::getIcon(polygonSelectHelp),helpWindow::getMenuname(polygonSelectHelp),l,SLOT(polygonSelect()));
menu.addAction(helpWindow::getIcon(polygonDeselectHelp),helpWindow::getMenuname(polygonDeselectHelp),l,SLOT(polygonDeselect()));

menu.addAction(helpWindow::getIcon(textSelectHelp),helpWindow::getMenuname(textSelectHelp),l,SLOT(textSelect()));
menu.addAction(helpWindow::getIcon(textDeselectHelp),helpWindow::getMenuname(textDeselectHelp),l,SLOT(textDeselect()));

menu.addAction(helpWindow::getIcon(selectCellNameHelp),helpWindow::getMenuname(selectCellNameHelp),l,SLOT(selectCellref()));

menu.addSeparator();
menu.addAction(helpWindow::getIcon(selectAllHelp),helpWindow::getMenuname(selectAllHelp),l,SLOT(selectAll()));
menu.addAction(helpWindow::getIcon(selectVisibleHelp),helpWindow::getMenuname(selectVisibleHelp),l,SLOT(selectVisible()));
menu.addAction(helpWindow::getIcon(deselectAllHelp),helpWindow::getMenuname(deselectAllHelp),l,SLOT(deselectAll()));


//menu.addSeparator();
// menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// reset layer
// restore layer
// store layer as
// menu.addSeparator();
//menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// layer setup ???
menu.exec(QCursor::pos());
#endif
}
