/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BOX_H
#define BOX_H

#include <qbitarray.h>
//Added by qt3to4:
#include <QTextStream>
#include "element.h"
#include "general/drawpixmap.h"
#include "shortselect.h"
/**
@author Juergen Thies
*/
class polygon;
class csv;
class elementList;
class box : public element
{
public:
QRect rect;
shortSelect p_select;
    box();
    box(QRect r,shortSelect Array);
    box(QRect r,int layer);
    box(int x, int y, int b, int h,int layer);
    box(box *b){rect=b->rect;p_select=b->p_select;layerNum=b->layerNum;select=b->select;
		property=b->property;
		datatype=b->datatype;};
    ~box();
virtual void paint(layoutImagePainter *e);
virtual void paintSelect(layoutImagePainter *e);
virtual void paintSelected(layoutImagePainter *e);
virtual void paintNode(int node, layoutImagePainter *e);
virtual void paintHighlighted(QPainter *,strans  ) ;
virtual void paintHighlighted(QPainter *,strans ,QPoint ) ;
virtual void paintSize(QPainter *,strans ,double uunits  );
virtual void paintDistance(QPainter *,strans  , double ,element *);
virtual void paintInfo(QPoint *,QPoint *,uint *)const;
virtual void fSelect(QRect select);
virtual void pSelect(QRect select);
virtual void fDeselect(QRect select);
virtual void pDeselect(QRect select);
virtual void fAllSelect(QRect select);
virtual void fAllDeselect(QRect select);
virtual void minimum(QPoint *pos);
virtual void maximum(QPoint *pos);
virtual void minimumSelect(QPoint *pos);
virtual void maximumSelect(QPoint *pos);
//virtual int minSize() { int a=rect.right()-rect.left(); int b=rect.top()-rect.bottom(); if (a>b) return b; else return a;}
virtual bool drcMinSize(int ,drc *,bool sharpAngles=true);
virtual bool drcMinDistance(int ,drc *,element *);
virtual bool drcEnclosure(int ,drc *,element *);
virtual bool drcOnGrid(int grid,int layer);
virtual bool drcAngle(double,drc *);
virtual void saveGDS(gds *);
virtual void saveDXF(dxf *);
#ifdef USE_3d
virtual void saveDXF3d(dxf3d*);
#endif
virtual void saveOASIS( oasis *);
virtual void saveCIF( cif *);
virtual void saveCSV( csv *);
virtual void saveGerber( gerber *);
virtual void saveSVG(svg *);
virtual void saveSelect(QDataStream *);
virtual void save(QDataStream *);
virtual void saveODB( odb *);
virtual void saveEPS(eps *);
virtual int saveEPSCount();
virtual void saveSOURCE( source *);
virtual void moveSelect(QPoint pos);
virtual void move(QPoint pos);
virtual void resize(double size);
virtual void resize(double ,int, bool *);
virtual bool correct();
virtual void sizeadjustSelect(int value);
virtual void sizeadjustSelect(int value1, int value2);
virtual elementList* convertToMesh(int width , int spaceing);
virtual void clean();
virtual void roundSelect(int i);
virtual bool isBox()const{return true;}
virtual box* getBox(){return this;};
virtual polygon* convertToPolygon()const;
virtual double areaSelect(){if (select) {return areaSelected();} else return 0;}
virtual double areaSelected();
virtual double circumferenceSelect(){if (select) {return circumferenceSelected();} else return 0;}
virtual double circumferenceSelected();
virtual double nearestDistance(QPoint p);
virtual double nearestDistance(const QPoint,QPoint *)const;
virtual double nearestLine(QPoint,QPoint *,int) ;
virtual double nearestMiddle(QPoint,QPoint *,int) ;
virtual double nearestCenter(QPoint,QPoint *,int);
virtual bool pointInsideElement(QPoint);
virtual bool showProperties(elementList *, drawingField *,bool basicEditing);
virtual void countSelect(elementCount *c){if (select) {c->box++;} 
					else {
						for (int i=0;i<4;i++){
							if (p_select.testBit(i))c->points++;}}}
virtual bool useLayer(int layer){if (layerNum==layer) return true; else return false;}
virtual void useLayer(QBitArray *b){b->setBit(layerNum);};
private:
 void clearAllPSelect();
 void setAllPSelect();
public:
virtual void invertSelect();
virtual void selectAll(){select=true;clearAllPSelect();}
virtual void selectVisible(){if (layers::num[layerNum].visible){select=true;clearAllPSelect();}}
virtual void deselectAll(){select=false;clearAllPSelect();}
virtual void selectLayer(int layer){if (layerNum==layer) selectAll();}
virtual void deselectLayer(int layer){if (layerNum==layer) deselectAll();}
virtual pointArray getPoints(){pointArray p; p.resize(2); p.setPoint(0,rect.left(),rect.top()); p.setPoint(1,rect.right(),rect.bottom()); return p;}
virtual bool identical(element *);
virtual bool identicalStructure(element *);
virtual double length();
virtual void findEdge(QPoint p1, QPoint p2,int layer,char dir,int *result);
virtual void lineDistanceLayer(QPoint p1,QPoint p2, int *left,int *right,int layer, QPoint min, QPoint max);
virtual bool pointOnLayer(QPoint p,int layer);
friend bool operator== (const box &r1,const box &r2);
friend bool operator% (const box &r1,const box &r2);
virtual void snapSelectGet(QHash<int,QPoint> *);
virtual void snapSelectSnap(QHash<int,QPoint> *,int radius);
};

#endif
