/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GUIWORKTHREAD_H
#define GUIWORKTHREAD_H

#include <QtGlobal>
#include <QThread>
#include <QTime>
#include <QMutex>
#include <QWaitCondition>
#include "errorreport.h"
#ifdef TEXTEDIT
 class	textEdit;
#endif

/**
@author Juergen Thies
*/

class layout;

class guiWorkThread : public QThread 
{
Q_OBJECT
public:
    guiWorkThread(layout *la);

    ~guiWorkThread();


 protected:
    void run();
signals:
    void showReport(QString s, int rang);
    void showMessage(QString s);
    void showMessage(QString s,QString s2);
    void askSaveModifications();
    void askOpenFilename();
    void askSaveFilename();
    void askPrint();
    void askText(QString,QString,QString);
    void askDouble(QString,QString,double, int);
    void askInteger(QString,QString,int);
    void askBool(QString,QString);
    void askShowMessage(QString,QString);
    void askTextEditor();
    void askScreenshot();
    void askCellName();
    void askCell();
    void setWindowTitle(QString s);
    void recountSelect();
    void cellsUpdate();
    void updateGrid();
    void updateSetupLayerbutton();
    void updateGui();
    void operationIcon(QString);
    void operationTime(int);
#ifdef USE_3d
    void trigger3dProcessRequest();
#endif
 public:
    void startOperation(QString function,QString parameter="",QString parameter2="",int parameterInt1=0,int parameterInt2=0,int parameterInt3=0,int parameterInt4=0,int parameterInt5=0,bool parameterBool=false);
public slots:
    void abortOperation();

private:
	QMutex mutex;
	QString function;
	QString parameter;
	QString parameter2;
	int parameterInt1;
	int parameterInt2;
	int parameterInt3;
	int parameterInt4;
	int parameterInt5;
	bool parameterBool;
	layout *l;
	QTime timer;
public:
protected:
	QWaitCondition waitOnGui;
	QMutex dataMutex;
	QString filename;
	bool cancel,save,open,print;
	QString text;
	int integer;
	double d;
#ifdef TEXTEDIT
	textEdit* textEditor;
#endif
// access to signals for class layout
   friend class layout;	
   //friend class macroMenuEntry;
   friend class macro;
   //friend class booleanHandler;
};

#endif
