/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#ifndef PROJECT_H
#define PROJECT_H

#include "layout.h"

/**
@author Juergen Thies
*/

class layout;

#ifdef SCHEMATIC
class schematic;
#endif

//! project
/*!
  The static project class creates new layout and schematic windows. It can also link both types of windows for a schematic driven layout.
@nomacro  
*/
class project: public QObject
{
Q_OBJECT
public:
    project();

    ~project();
public:
layout *l;
#ifdef SCHEMATIC
schematic *s;
#endif
static project projects[128];
static layout* newLayout(viewModeType viewonly);
//! new layout
/*!
  creates a new layout window
*/
static layout* newLayout(){return newLayout(fullmode);};
//! close layout
/*!
  closes the given layout window
*/
static void closeLayout(layout *l);
static layout* getNextLayout(layout *lay);

#ifdef SCHEMATIC
//! get schematic
/*!
  return a schematic window linked with the given layout window. If a linked schematic window does not exist, it will be created.
*/
static schematic* getSchematic(layout *lay);
//! get layout
/*!
  return a layout window linked with the given scheamtic window. If a linked layout window does not exist, it will be created.
*/
static layout* getLayout(schematic *s);
//! new schematic
/*!
  creates a new schematic window
*/
static schematic* newSchematic();
//! close layout
/*!
  closes the given schematic window
*/
static void closeSchematic(schematic *s);
static void link(layout *lay,schematic *s);
#endif
};

#endif
