/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYERBUTTON_H
#define LAYERBUTTON_H

#include <QToolButton>
#include <QMouseEvent>
#include <QEvent>
#include <QMenu>
#include <qwidget.h>
#include <qpixmap.h>
#include <QTimer>
#include <QIcon>
#include "mousewidget.h"
#include "general/layers.h"
#include <QAction>

/**
@author Juergen Thies
*/
class layerbutton : public QToolButton
{
Q_OBJECT
public:
  int layer_nr;
  QIcon iconVisible, iconActive, iconHide;
  QMenu popup;
  QAction *actionMakeActive, *actionShowLayer, *actionHideLayer, *actionHideOtherLayer, *actionShowAllLayer, *actionPropertiesDialog;
  bool active,shortkey;
private:
  QTimer time;
  void makeMenu();
  void updateMenu();
  void setIcon();
  QColor color;
  char brush;
public:
  layerbutton();
  layerbutton(int nr,QWidget *parent);
  ~layerbutton();
protected:
  virtual void paintEvent ( QPaintEvent * e );
  virtual void mousePressEvent(QMouseEvent *e);
  virtual void mouseMoveEvent(QMouseEvent *){}
  virtual void mouseReleaseEvent(QMouseEvent *e);
  virtual void nextCheckState (){}
  virtual void checkStateSet () {}
  void enterEvent ( QEvent * e ){mouseWidget::set(layerButtonHelp);QToolButton::enterEvent(e);}
public:
  void aktiveOff();
  void changeSetup();
  void visibleOn();
  void updateButton();
  QIcon getIcon();
public slots:
  void showLayer();
  void hideLayer();
  void showAllLayer();
  void hideOtherLayer();
  void makeLayerAktive();
  void propertiesDialog();
private slots:
  void showMenu();  
signals:
  void aktiveLayer(int layer);
  void visibleChange();
  void updateAllLayerbutton();
  //void changed(int layer);
  void updateSetup();
  void macroAdd(QString s);
};

#endif
