/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mousehelp.h"
#include <QBoxLayout>
#include <QSizePolicy>
#include "widgets/mainwindow.h"

mouseHelp::mouseHelp(mainWindow *parent, const QString & title)
 : QDockWidget(title,parent)
{
  if (mouseWidget::mouseInfo==NULL)  mouseWidget *mouse=new mouseWidget(NULL);
  setObjectName(title);
//  setCaption(tr("Mouse Help"));
  setWindowTitle(tr("Mouse Help"));
//setWindowTitle(tr("Share It"));
  mouseWidgets=new mouseWidget(parent,this);
  setWidget(mouseWidgets);
  setMinimumWidth(130);
  setMaximumHeight(8*32+40);
  setMaximumWidth(250);


  setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
  

}


mouseHelp::~mouseHelp()
{
}


