/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SELECTWIDGET_H
#define SELECTWIDGET_H

#include <qwidget.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <QContextMenuEvent>

/**
@author Juergen Thies
*/
struct elementCount {
    int points,path,box,polygon, cellref,cellrefarray, text;
    };

class selectwidget : public QWidget
{
Q_OBJECT
public:
    selectwidget(QWidget *la,QWidget *parent = 0, const char *name = 0);

    ~selectwidget();
    int getSelectedAreaShapes();
    QWidget *l;
public slots:
    void setSelect( elementCount count);
    void reset();
    void setSmall();
    void setNormal();
    void setWide();
    void setExtraWide();
    void setOff();
    
private:
    QLabel *pointIcon,*pointNumber,*pathIcon,*pathNumber, *boxIcon, *boxNumber, *polygonIcon, *polygonNumber, *cellrefIcon,*cellrefNumber, *cellrefarrayIcon, *cellrefarrayNumber, *textIcon, *textNumber;
protected:
  void contextMenuEvent ( QContextMenuEvent * event );
};

#endif
