# Leo colorizer control file for povray mode.
# This file is in the public domain.

# Properties for povray mode.
properties = {
	"commentEnd": "*/",
	"commentStart": "/*",
	"indentCloseBrackets": "}",
	"indentOpenBrackets": "{",
	"lineComment": "//",
	"lineUpClosingBracket": "true",
}

# Attributes dict for povray_main ruleset.
povray_main_attributes_dict = {
	"default": "null",
	"digit_re": "",
	"escape": "\\",
	"highlight_digits": "true",
	"ignore_case": "false",
	"no_word_sep": "",
}

# Dictionary of attributes dictionaries for povray mode.
attributesDictDict = {
	"povray_main": povray_main_attributes_dict,
}

# Keywords dict for povray_main ruleset.
povray_main_keywords_dict = {
	"#break": "keyword1",
	"#case": "keyword1",
	"#debug": "keyword1",
	"#declare": "keyword1",
	"#default": "keyword1",
	"#else": "keyword1",
	"#end": "keyword1",
	"#error": "keyword1",
	"#fclose": "keyword1",
	"#fopen": "keyword1",
	"#if": "keyword1",
	"#ifdef": "keyword1",
	"#ifndef": "keyword1",
	"#include": "keyword1",
	"#local": "keyword1",
	"#macro": "keyword1",
	"#range": "keyword1",
	"#read": "keyword1",
	"#render": "keyword1",
	"#statistics": "keyword1",
	"#switch": "keyword1",
	"#undef": "keyword1",
	"#version": "keyword1",
	"#warning": "keyword1",
	"#while": "keyword1",
	"#write": "keyword1",
	"aa_level": "keyword2",
	"aa_threshold": "keyword2",
	"abs": "function",
	"absorption": "keyword2",
	"accuracy": "keyword2",
	"acos": "function",
	"acosh": "function",
	"adaptive": "keyword2",
	"adc_bailout": "keyword2",
	"agate": "keyword2",
	"agate_turb": "keyword2",
	"all": "keyword2",
	"all_intersections": "keyword2",
	"alpha": "keyword2",
	"altitude": "keyword2",
	"always_sample": "keyword2",
	"ambient": "keyword2",
	"ambient_light": "keyword2",
	"angle": "keyword2",
	"aperture": "keyword2",
	"append": "keyword2",
	"arc_angle": "keyword2",
	"area_light": "keyword2",
	"array": "keyword2",
	"asc": "function",
	"ascii": "keyword2",
	"asin": "function",
	"asinh": "function",
	"assumed_gamma": "keyword2",
	"atan": "function",
	"atan2": "function",
	"atanh": "function",
	"autostop": "keyword2",
	"average": "keyword2",
	"b_spline": "keyword2",
	"background": "keyword1",
	"bezier_spline": "keyword2",
	"bicubic_patch": "keyword1",
	"black_hole": "keyword2",
	"blob": "keyword1",
	"blue": "literal1",
	"blur_samples": "keyword2",
	"bounded_by": "keyword1",
	"box": "keyword1",
	"boxed": "keyword2",
	"bozo": "keyword2",
	"brick": "keyword2",
	"brick_size": "keyword2",
	"brightness": "keyword2",
	"brilliance": "keyword2",
	"bump_map": "keyword1",
	"bump_size": "keyword2",
	"bumps": "keyword2",
	"camera": "keyword1",
	"caustics": "keyword2",
	"ceil": "function",
	"cells": "keyword2",
	"charset": "keyword2",
	"checker": "keyword2",
	"chr": "function",
	"circular": "keyword2",
	"clipped_by": "keyword1",
	"clock": "literal1",
	"clock_delta": "literal1",
	"clock_on": "literal1",
	"collect": "keyword2",
	"color": "keyword2",
	"color_map": "keyword2",
	"colour": "keyword2",
	"colour_map": "keyword2",
	"component": "keyword2",
	"composite": "keyword2",
	"concat": "function",
	"cone": "keyword1",
	"confidence": "keyword2",
	"conic_sweep": "keyword2",
	"conserve_energy": "keyword2",
	"contained_by": "keyword1",
	"control0": "keyword2",
	"control1": "keyword2",
	"coords": "keyword2",
	"cos": "function",
	"cosh": "function",
	"count": "keyword2",
	"crackle": "keyword2",
	"crand": "keyword2",
	"cube": "keyword1",
	"cubic": "keyword1",
	"cubic_spline": "keyword2",
	"cubic_wave": "keyword2",
	"cutaway_textures": "keyword2",
	"cylinder": "keyword1",
	"cylindrical": "keyword2",
	"defined": "function",
	"degrees": "function",
	"density": "keyword2",
	"density_file": "keyword2",
	"density_map": "keyword1",
	"dents": "keyword2",
	"df3": "keyword2",
	"difference": "keyword1",
	"diffuse": "keyword2",
	"dimension_size": "function",
	"dimensions": "function",
	"direction": "keyword2",
	"disc": "keyword1",
	"dispersion": "keyword2",
	"dispersion_samples": "keyword2",
	"dist_exp": "keyword2",
	"distance": "keyword2",
	"div": "function",
	"double_illuminate": "keyword2",
	"eccentricity": "keyword2",
	"emission": "keyword2",
	"error_bound": "keyword2",
	"evaluate": "keyword2",
	"exp": "function",
	"expand_thresholds": "keyword2",
	"exponent": "keyword2",
	"exterior": "keyword2",
	"extinction": "keyword2",
	"face_indices": "keyword1",
	"facets": "keyword2",
	"fade_color": "keyword2",
	"fade_colour": "keyword2",
	"fade_distance": "keyword2",
	"fade_power": "keyword2",
	"falloff": "keyword2",
	"falloff_angle": "keyword2",
	"false": "literal1",
	"file_exists": "function",
	"filter": "keyword2",
	"final_clock": "literal1",
	"final_frame": "literal1",
	"finish": "keyword1",
	"fisheye": "keyword2",
	"flatness": "keyword2",
	"flip": "keyword2",
	"floor": "function",
	"focal_point": "keyword2",
	"fog": "keyword1",
	"fog_alt": "keyword2",
	"fog_offset": "keyword2",
	"fog_type": "keyword2",
	"form": "keyword2",
	"frame_number": "literal1",
	"frequency": "keyword2",
	"fresnel": "keyword2",
	"function": "keyword1",
	"gather": "keyword2",
	"gif": "keyword2",
	"global_lights": "keyword2",
	"global_settings": "keyword1",
	"gradient": "keyword2",
	"granite": "keyword2",
	"gray": "literal1",
	"gray_threshold": "keyword2",
	"green": "literal1",
	"h_angle": "keyword2",
	"height_field": "keyword1",
	"hexagon": "keyword2",
	"hf_gray_16": "keyword2",
	"hierarchy": "keyword2",
	"hollow": "keyword2",
	"hypercomplex": "keyword2",
	"iff": "keyword2",
	"image_height": "literal1",
	"image_map": "keyword1",
	"image_pattern": "keyword2",
	"image_width": "literal1",
	"initial_clock": "literal1",
	"initial_frame": "literal1",
	"inside": "function",
	"int": "function",
	"interior": "keyword1",
	"interior_texture": "keyword1",
	"internal": "function",
	"interpolate": "keyword2",
	"intersection": "keyword1",
	"intervals": "keyword2",
	"inverse": "keyword2",
	"ior": "keyword1",
	"irid": "keyword1",
	"irid_wavelength": "keyword2",
	"isosurface": "keyword1",
	"jitter": "keyword2",
	"jpeg": "keyword2",
	"julia": "keyword2",
	"julia_fractal": "keyword1",
	"lambda": "keyword2",
	"lathe": "keyword1",
	"leopard": "keyword2",
	"light_group": "keyword1",
	"light_source": "keyword1",
	"linear_spline": "keyword2",
	"linear_sweep": "keyword2",
	"ln": "function",
	"load_file": "keyword2",
	"location": "keyword2",
	"log": "function",
	"look_at": "keyword2",
	"looks_like": "keyword1",
	"low_error_factor": "keyword2",
	"magnet": "keyword2",
	"major_radius": "keyword2",
	"mandel": "keyword2",
	"map_type": "keyword2",
	"marble": "keyword2",
	"material": "keyword1",
	"material_map": "keyword1",
	"matrix": "keyword2",
	"max": "function",
	"max_extent": "keyword2",
	"max_gradient": "keyword2",
	"max_intersections": "keyword2",
	"max_iteration": "keyword2",
	"max_sample": "keyword2",
	"max_trace": "keyword2",
	"max_trace_level": "keyword2",
	"media": "keyword1",
	"media_attenuation": "keyword2",
	"media_interaction": "keyword2",
	"merge": "keyword1",
	"mesh": "keyword1",
	"mesh2": "keyword1",
	"metallic": "keyword2",
	"method": "keyword2",
	"metric": "keyword2",
	"min": "function",
	"min_extent": "keyword2",
	"minimum_reuse": "keyword2",
	"mod": "function",
	"mortar": "keyword2",
	"natural_spline": "keyword2",
	"nearest_count": "keyword2",
	"no": "literal1",
	"no_bump_scale": "keyword2",
	"no_image": "keyword2",
	"no_reflection": "keyword2",
	"no_shadow": "keyword2",
	"noise_generator": "keyword2",
	"normal": "keyword1",
	"normal_indices": "keyword1",
	"normal_map": "keyword1",
	"normal_vectors": "keyword1",
	"number_of_waves": "keyword2",
	"object": "keyword1",
	"octaves": "keyword2",
	"off": "literal1",
	"offset": "keyword2",
	"omega": "keyword2",
	"omnimax": "keyword2",
	"on": "literal1",
	"once": "keyword2",
	"onion": "keyword2",
	"open": "keyword2",
	"orient": "keyword2",
	"orientation": "keyword2",
	"orthographic": "keyword2",
	"panoramic": "keyword2",
	"parallel": "keyword2",
	"parametric": "keyword2",
	"pass_through": "keyword2",
	"pattern": "keyword1",
	"perspective": "keyword2",
	"pgm": "keyword2",
	"phase": "keyword2",
	"phong": "keyword2",
	"phong_size": "keyword2",
	"photons": "keyword1",
	"pi": "literal1",
	"pigment": "keyword1",
	"pigment_map": "keyword1",
	"pigment_pattern": "keyword1",
	"planar": "keyword2",
	"plane": "keyword1",
	"png": "keyword1",
	"point_at": "keyword2",
	"poly": "keyword1",
	"poly_wave": "keyword2",
	"polygon": "keyword1",
	"pot": "keyword2",
	"pow": "function",
	"ppm": "keyword2",
	"precision": "keyword2",
	"precompute": "keyword2",
	"pretrace_end": "keyword2",
	"pretrace_start": "keyword2",
	"prism": "keyword1",
	"projected_through": "keyword2",
	"pwr": "keyword2",
	"quadratic_spline": "keyword2",
	"quadric": "keyword2",
	"quartic": "keyword2",
	"quaternion": "keyword2",
	"quick_color": "keyword2",
	"quick_colour": "keyword2",
	"quilted": "keyword2",
	"radial": "keyword2",
	"radians": "function",
	"radiosity": "keyword1",
	"radius": "keyword2",
	"rainbow": "keyword1",
	"ramp_wave": "keyword2",
	"rand": "function",
	"range_divider": "keyword2",
	"ratio": "keyword2",
	"reciprocal": "keyword2",
	"recursion_limit": "keyword2",
	"red": "literal1",
	"reflection": "keyword1",
	"reflection_exponent": "keyword2",
	"refraction": "keyword2",
	"repeat": "keyword2",
	"rgb": "keyword2",
	"rgbf": "keyword2",
	"rgbft": "keyword2",
	"rgbt": "keyword2",
	"right": "keyword2",
	"ripples": "keyword2",
	"rotate": "keyword2",
	"roughness": "keyword2",
	"samples": "keyword2",
	"save_file": "keyword2",
	"scale": "keyword2",
	"scallop_wave": "keyword2",
	"scattering": "keyword2",
	"seed": "function",
	"select": "keyword2",
	"shadowless": "keyword2",
	"sin": "function",
	"sine_wave": "keyword2",
	"sinh": "function",
	"size": "keyword2",
	"sky": "keyword2",
	"sky_sphere": "keyword1",
	"slice": "keyword2",
	"slope": "keyword1",
	"slope_map": "keyword1",
	"smooth": "keyword2",
	"smooth_triangle": "keyword1",
	"solid": "keyword1",
	"sor": "keyword1",
	"spacing": "keyword2",
	"specular": "keyword2",
	"sphere": "keyword1",
	"sphere_sweep": "keyword1",
	"spherical": "keyword2",
	"spiral1": "keyword2",
	"spiral2": "keyword2",
	"spline": "keyword1",
	"split_union": "keyword2",
	"spotlight": "keyword2",
	"spotted": "keyword2",
	"sqr": "keyword2",
	"sqrt": "function",
	"str": "function",
	"strcmp": "function",
	"strength": "keyword2",
	"strlen": "function",
	"strlwr": "function",
	"strupr": "function",
	"sturm": "keyword2",
	"substr": "function",
	"superellipsoid": "keyword1",
	"sys": "keyword2",
	"t": "literal1",
	"tan": "function",
	"tanh": "function",
	"target": "keyword2",
	"text": "keyword1",
	"texture": "keyword1",
	"texture_list": "keyword1",
	"texture_map": "keyword1",
	"tga": "keyword2",
	"thickness": "keyword2",
	"threshold": "keyword2",
	"tiff": "keyword2",
	"tightness": "keyword2",
	"tile2": "keyword2",
	"tiles": "keyword2",
	"tolerance": "keyword2",
	"toroidal": "keyword2",
	"torus": "keyword1",
	"trace": "function",
	"transform": "keyword2",
	"translate": "keyword2",
	"transmit": "keyword2",
	"triangle": "keyword1",
	"triangle_wave": "keyword2",
	"true": "literal1",
	"ttf": "keyword2",
	"turb_depth": "keyword2",
	"turbulence": "keyword2",
	"type": "keyword2",
	"u": "literal1",
	"u_steps": "keyword2",
	"ultra_wide_angle": "keyword2",
	"union": "keyword1",
	"up": "keyword2",
	"use_alpha": "keyword2",
	"use_color": "keyword2",
	"use_colour": "keyword2",
	"use_index": "keyword2",
	"utf8": "keyword2",
	"uv_indices": "keyword1",
	"uv_mapping": "keyword1",
	"uv_vectors": "keyword1",
	"v": "literal1",
	"v_angle": "keyword2",
	"v_steps": "keyword2",
	"val": "function",
	"variance": "keyword2",
	"vaxis_rotate": "function",
	"vcross": "function",
	"vdot": "function",
	"vertex_vectors": "keyword1",
	"vlength": "function",
	"vnormalize": "function",
	"vrotate": "function",
	"vstr": "function",
	"vturbulence": "function",
	"warp": "keyword1",
	"water_level": "keyword2",
	"waves": "keyword2",
	"width": "keyword2",
	"wood": "keyword2",
	"wrinkles": "keyword2",
	"x": "literal1",
	"y": "literal1",
	"yes": "literal1",
	"z": "literal1",
}

# Dictionary of keywords dictionaries for povray mode.
keywordsDictDict = {
	"povray_main": povray_main_keywords_dict,
}

# Rules for povray_main ruleset.

def povray_rule0(colorer, s, i):
    return colorer.match_span(s, i, kind="comment1", begin="/*", end="*/",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="",exclude_match=False,
        no_escape=False, no_line_break=False, no_word_break=False)

def povray_rule1(colorer, s, i):
    return colorer.match_span(s, i, kind="literal1", begin="\"", end="\"",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="",exclude_match=False,
        no_escape=False, no_line_break=True, no_word_break=False)

def povray_rule2(colorer, s, i):
    return colorer.match_span(s, i, kind="literal1", begin="'", end="'",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="",exclude_match=False,
        no_escape=False, no_line_break=True, no_word_break=False)

def povray_rule3(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment2", seq="//",
        at_line_start=False, at_whitespace_end=False, at_word_start=False,
        delegate="", exclude_match=False)

def povray_rule4(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="=",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule5(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="!",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule6(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq=">=",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule7(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="<=",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule8(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="+",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule9(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="-",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule10(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="/",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule11(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="*",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule12(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq=">",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule13(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="<",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule14(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="%",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule15(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="&",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule16(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="|",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule17(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="^",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule18(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="~",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule19(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="}",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule20(colorer, s, i):
    return colorer.match_seq(s, i, kind="operator", seq="{",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, delegate="")

def povray_rule21(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="label", pattern=":",
        at_line_start=True, at_whitespace_end=False, at_word_start=False, exclude_match=True)

def povray_rule22(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="function", pattern="(",
        at_line_start=False, at_whitespace_end=False, at_word_start=False, exclude_match=True)

def povray_rule23(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for povray_main ruleset.
rulesDict1 = {
	"!": [povray_rule5,],
	"\"": [povray_rule1,],
	"#": [povray_rule23,],
	"%": [povray_rule14,],
	"&": [povray_rule15,],
	"'": [povray_rule2,],
	"(": [povray_rule22,],
	"*": [povray_rule11,],
	"+": [povray_rule8,],
	"-": [povray_rule9,],
	"/": [povray_rule0,povray_rule3,povray_rule10,],
	"0": [povray_rule23,],
	"1": [povray_rule23,],
	"2": [povray_rule23,],
	"3": [povray_rule23,],
	"4": [povray_rule23,],
	"5": [povray_rule23,],
	"6": [povray_rule23,],
	"7": [povray_rule23,],
	"8": [povray_rule23,],
	"9": [povray_rule23,],
	":": [povray_rule21,],
	"<": [povray_rule7,povray_rule13,],
	"=": [povray_rule4,],
	">": [povray_rule6,povray_rule12,],
	"@": [povray_rule23,],
	"A": [povray_rule23,],
	"B": [povray_rule23,],
	"C": [povray_rule23,],
	"D": [povray_rule23,],
	"E": [povray_rule23,],
	"F": [povray_rule23,],
	"G": [povray_rule23,],
	"H": [povray_rule23,],
	"I": [povray_rule23,],
	"J": [povray_rule23,],
	"K": [povray_rule23,],
	"L": [povray_rule23,],
	"M": [povray_rule23,],
	"N": [povray_rule23,],
	"O": [povray_rule23,],
	"P": [povray_rule23,],
	"Q": [povray_rule23,],
	"R": [povray_rule23,],
	"S": [povray_rule23,],
	"T": [povray_rule23,],
	"U": [povray_rule23,],
	"V": [povray_rule23,],
	"W": [povray_rule23,],
	"X": [povray_rule23,],
	"Y": [povray_rule23,],
	"Z": [povray_rule23,],
	"^": [povray_rule17,],
	"_": [povray_rule23,],
	"a": [povray_rule23,],
	"b": [povray_rule23,],
	"c": [povray_rule23,],
	"d": [povray_rule23,],
	"e": [povray_rule23,],
	"f": [povray_rule23,],
	"g": [povray_rule23,],
	"h": [povray_rule23,],
	"i": [povray_rule23,],
	"j": [povray_rule23,],
	"k": [povray_rule23,],
	"l": [povray_rule23,],
	"m": [povray_rule23,],
	"n": [povray_rule23,],
	"o": [povray_rule23,],
	"p": [povray_rule23,],
	"q": [povray_rule23,],
	"r": [povray_rule23,],
	"s": [povray_rule23,],
	"t": [povray_rule23,],
	"u": [povray_rule23,],
	"v": [povray_rule23,],
	"w": [povray_rule23,],
	"x": [povray_rule23,],
	"y": [povray_rule23,],
	"z": [povray_rule23,],
	"{": [povray_rule20,],
	"|": [povray_rule16,],
	"}": [povray_rule19,],
	"~": [povray_rule18,],
}

# x.rulesDictDict for povray mode.
rulesDictDict = {
	"povray_main": rulesDict1,
}

# Import dict for povray mode.
importDict = {}

