import sys
import re
import fontforge
import psMat

# copy new characters and kerning corrections of Magyar Linux Libertine
# to the new version of Linux Libertine
# Usage: copychar.py source target new_file

if len(sys.argv) < 4:
	print "cpglyph - copy glyphs"
	print "Usage: copyglyph source_font target_font new_file glyph(s)"
	sys.exit(1)


font=fontforge.open(sys.argv[1])
font2=fontforge.open(sys.argv[2])
font.em = font2.em

# Add heavy asterisk (U+2731)

font2.selection.select("asterisk")
font2.copy()
font2.selection.select("uni2731")
font2.paste()
g = font2["uni2731"]
g.transform(psMat.scale(1/0.58))
g.transform(psMat.translate(font2.em*(font2.italicangle/100),-font2.em*0.6))

for i in sys.argv[4:]:
	font.selection.select(i)
	font.copy()
	font2.selection.select(i)
	font2.paste()

font2.selection.all()
font2.unlinkReferences()
font2.removeOverlap()
font2.em = 2048
font2.autoInstr()

fn = re.sub("^[^/]*/", "", sys.argv[2])
fn2 = sys.argv[3] + "/" + fn.replace("RO.sfd", ".ttf")
font2.generate(fn2, "old-kern")
