/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's RateRule construct.
 * <p>
 * The rule type {@link RateRule} is derived from the parent class {@link Rule}.  It is
 * used to express equations that determine the rates of change of
 * variables.  The left-hand side (the 'variable' attribute) can refer to
 * the identifier of a species, compartment, or parameter (but not a
 * reaction).  The entity identified must have its 'constant' attribute set
 * to <code>false</code>.  The effects of a {@link RateRule} are in general terms the same,
 * but differ in the precise details depending on which variable is being
 * set:
 * <ul>
 * <li> <em>In the case of a species</em>, a {@link RateRule} sets the rate of
 * change of the species' quantity (<em>concentration</em> or <em>amount of
 * substance</em>) to the value determined by the formula in the 'math'
 * subelement of the {@link RateRule} object.  The overall units of the formula in
 * 'math' should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be <em>species quantity</em>/<em>time</em>, where the
 * <em>time</em> units are the SBML predefined units of time and the
 * <em>species quantity</em> units are the <em>units of the species</em>.
 * <em>Restrictions</em>: There must not be both a {@link RateRule} 'variable'
 * attribute and a {@link SpeciesReference} 'species' attribute having the same
 * value, unless that species has its 'boundaryCondition' attribute is set
 * to <code>true</code>.  This means a rate rule cannot be defined for a species that
 * is created or destroyed in a reaction, unless that species is defined as
 * a boundary condition in the model.
 * <p>
 * <li> <em>In the case of a compartment</em>, a {@link RateRule} sets the rate of
 * change of the compartment's size to the value determined by the formula
 * in the 'math' subelement of the {@link RateRule} object.  The overall units of
 * the formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be <em>size</em>/<em>time</em>, where the <em>time</em>
 * units are the SBML predefined units of time and the <em>size</em> units
 * are the units of size on the compartment.
 * <p>
 * <li> <em>In the case of a parameter</em>, a {@link RateRule} sets the rate of
 * change of the parameter's value to that determined by the formula in the
 * 'math' subelement of the {@link RateRule} object.  The overall units of the
 * formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be <em>x</em>/<em>time</em>, where <em>x</em> are the units
 * of the parameter.
 * </ul>
 * <p>
 * In the context of a simulation, rate rules are in effect for simulation
 * time <em>t</em> &lt; <em>0</em>.  The SBML Level&nbsp;2 Version&nbsp;4
 * specification provides additional information about the semantics of
 * assignments, rules, and entity values for simulation time <em>t</em>
 * &#8804; <em>0</em>.
 * <p>
 * As mentioned in the description of {@link AssignmentRule}, a model must not
 * contain more than one {@link RateRule} or {@link AssignmentRule} object having the same
 * value of 'variable'; in other words, in the set of all assignment rules
 * and rate rules in an SBML model, each variable appearing in the
 * left-hand sides can only appear once.  This simply follows from the fact
 * that an indeterminate system would result if a model contained more than
 * one assignment rule for the same variable or both an assignment rule and
 * a rate rule for the same variable.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class RateRule extends Rule {
   private long swigCPtr;

   protected RateRule(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGRateRuleUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(RateRule obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (RateRule obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_RateRule(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link RateRule} and optionally sets its variable and formula.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param formula the mathematical formula placed in the assignment rule,
   * written as a text string.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public RateRule(String variable, String formula) {
    this(libsbmlJNI.new_RateRule__SWIG_0(variable, formula), true);
  }

  
  /**
   * Creates a new {@link RateRule} and optionally sets its variable and formula.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param formula the mathematical formula placed in the assignment rule,
   * written as a text string.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public RateRule(String variable) {
    this(libsbmlJNI.new_RateRule__SWIG_1(variable), true);
  }

  
  /**
   * Creates a new {@link RateRule} and optionally sets its variable and formula.
   * <p>
   * There exists another form of this method that allows you to use an
   * {@link ASTNode} as the the formula instead of the text string used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object) that is being assigned
   * <p>
   * @param formula the mathematical formula placed in the assignment rule,
   * written as a text string.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public RateRule() {
    this(libsbmlJNI.new_RateRule__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link RateRule} with a given <code>variable</code> and mathematical
   * expression.
   * <p>
   * There exists another form of this method that allows you to use a text
   * string to express the formula instead of the {@link ASTNode} used by this
   * variant.
   * <p>
   * @param variable the identifier of the variable (a {@link Compartment}, {@link Species}
   * or {@link Parameter} elsewhere in this {@link Model} object)
   * <p>
   * @param math an {@link ASTNode} containing the mathematical formula
   * expressing the right-hand side of the rate equation
   */
 public RateRule(String variable, ASTNode math) {
    this(libsbmlJNI.new_RateRule__SWIG_3(variable, ASTNode.getCPtr(math), math), true);
  }

  
  /**
   * Creates a new {@link RateRule} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link RateRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link RateRule}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link RateRule}
   * <p>
   * @note Once a {@link RateRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link RateRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public RateRule(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_RateRule__SWIG_4(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link RateRule} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link RateRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link RateRule}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link RateRule}
   * <p>
   * @note Once a {@link RateRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link RateRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public RateRule(long level, long version) {
    this(libsbmlJNI.new_RateRule__SWIG_5(level, version), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Rule}.
   * <p>
   * @return a (deep) copy of this {@link Rule}.
   */
 public RateRule cloneObject() {
    long cPtr = libsbmlJNI.RateRule_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new RateRule(cPtr, true);
  }

}
