/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's SpeciesType construct.
 * <p>
 * The term <em>species</em> <em>type</em> refers to reacting entities independent of
 * location.  These include simple ions (e.g., protons, calcium), simple
 * molecules (e.g., glucose, ATP), large molecules (e.g., RNA,
 * polysaccharides, and proteins), and others.
 * <p>
 * {@link SpeciesType} structures are included in SBML to enable {@link Species} of the
 * same type to be related together.  It is a conceptual construct; the
 * existence of {@link SpeciesType} objects in a model has no effect on the
 * model's numerical interpretation.  Except for the requirement for
 * uniqueness of species/species type combinations located in compartments,
 * simulators and other numerical analysis software may ignore {@link SpeciesType}
 * definitions and references to them in a model.
 * <p>
 * There is no mechanism in SBML for representing hierarchies of species
 * types.  One {@link SpeciesType} object cannot be the subtype of another
 * {@link SpeciesType} object; SBML provides no means of defining such
 * relationships.
 * <p>
 * As with other major structures in SBML, {@link SpeciesType} has a mandatory
 * attribute, 'id', used to give the species type an identifier.  The
 * identifier must be a text string conforming to the identifer syntax
 * permitted in SBML.  {@link SpeciesType} also has an optional 'name' attribute,
 * of type <code>string</code>.  The 'id' and 'name' must be used according to the
 * guidelines described in the SBML specification (e.g., Section 3.3 in
 * the Level 2 Version 4 specification).
 * <p>
 * {@link SpeciesType} was introduced in SBML Level 2 Version 2.  It is not
 * available in earlier versions of Level 2 nor in any version of Level 1.
 * <p>
 * <!---------------------------------------------------------------------- -->
 * <p>
 */

public class SpeciesType extends SBase {
   private long swigCPtr;

   protected SpeciesType(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGSpeciesTypeUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SpeciesType obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SpeciesType obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_SpeciesType(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link SpeciesType}, optionally with the given <code>id</code> and 
   * <code>name</code> attribute values.
   * <p>
   * In SBML, identifiers are required for {@link SpeciesType} objects;
   * however, the identifier does not have to be set at the time of
   * creation of the object, and instead can be set using the setId()
   * method on the {@link SBase} parent class.
   * <p>
   * @param id a string, the identifier of this {@link SpeciesType} instance
   * @param name a string, the optional name of this {@link SpeciesType} instance
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public SpeciesType(String id, String name) {
    this(libsbmlJNI.new_SpeciesType__SWIG_0(id, name), true);
  }

  
  /**
   * Creates a new {@link SpeciesType}, optionally with the given <code>id</code> and 
   * <code>name</code> attribute values.
   * <p>
   * In SBML, identifiers are required for {@link SpeciesType} objects;
   * however, the identifier does not have to be set at the time of
   * creation of the object, and instead can be set using the setId()
   * method on the {@link SBase} parent class.
   * <p>
   * @param id a string, the identifier of this {@link SpeciesType} instance
   * @param name a string, the optional name of this {@link SpeciesType} instance
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public SpeciesType(String id) {
    this(libsbmlJNI.new_SpeciesType__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link SpeciesType}, optionally with the given <code>id</code> and 
   * <code>name</code> attribute values.
   * <p>
   * In SBML, identifiers are required for {@link SpeciesType} objects;
   * however, the identifier does not have to be set at the time of
   * creation of the object, and instead can be set using the setId()
   * method on the {@link SBase} parent class.
   * <p>
   * @param id a string, the identifier of this {@link SpeciesType} instance
   * @param name a string, the optional name of this {@link SpeciesType} instance
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public SpeciesType() {
    this(libsbmlJNI.new_SpeciesType__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link SpeciesType} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link SpeciesType} object is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link SpeciesType}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link SpeciesType}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link SpeciesType}
   * <p>
   * @note Once a {@link SpeciesType} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link SpeciesType}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public SpeciesType(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_SpeciesType__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link SpeciesType} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link SpeciesType} object is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link SpeciesType}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link SpeciesType}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link SpeciesType}
   * <p>
   * @note Once a {@link SpeciesType} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link SpeciesType}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public SpeciesType(long level, long version) {
    this(libsbmlJNI.new_SpeciesType__SWIG_4(level, version), true);
  }

  
  /**
  * Copy constructor; creates a copy of this {@link SpeciesType}.
  */
 public SpeciesType(SpeciesType orig) {
    this(libsbmlJNI.new_SpeciesType__SWIG_5(SpeciesType.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link SpeciesType}.
   * <p>
   * @return a (deep) copy of this {@link SpeciesType}.
   */
 public SpeciesType cloneObject() {
    long cPtr = libsbmlJNI.SpeciesType_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, true);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.SpeciesType_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for
   * {@link SpeciesType}, is always <code>'compartmentType'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'compartmentType'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.SpeciesType_getElementName(swigCPtr, this);
  }

}
