/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Unit construct.
 * <p>
 * The SBML unit definition facility uses two classes of objects,
 * {@link UnitDefinition} and {@link Unit}.  The approach to defining units in SBML is
 * compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
 * constructed by combining a {@link Unit} object representing <em>meter</em> with
 * another {@link Unit} object representing <em>second<sup> &ndash;2</sup></em>.
 * The combination is wrapped inside a {@link UnitDefinition}, which provides for
 * assigning an identifier and optional name to the combination.  The
 * identifier can then be referenced from elsewhere in a model.  Thus, the
 * {@link UnitDefinition} class is the container, and {@link Unit} instances are placed
 * inside {@link UnitDefinition} instances.
 * <p>
 * A {@link Unit} structure has four attributes named 'kind', 'exponent', 'scale'
 * and 'multiplier'.  It represents a (possibly transformed) reference to a
 * base unit.  The attribute 'kind' on {@link Unit} indicates the chosen base unit.
 * Its value in SBML Level&nbsp;2 Version&nbsp;4 must be one of the following
 * predefined strings:
 * <p>
 * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

 * <p>
 * (See also the definition of the <code>UNIT_KIND_</code> constants in <a
 * class='el' href='#UnitKind_t'>the section below</a>.)  For SBML
 * Level&nbsp;2 Version&nbsp;1 models, the string <code>Celsius</code> is also
 * permitted.  Note also that the table above contains two names not
 * strictly defined in SBML Level&nbsp;2: <code>liter</code> and <code>meter</code>.  For
 * convenience, libSBML defines the American English spellings of these
 * units, although the SBML specification limits the valid unit names to
 * those defined by SI.
 * <p>
 * The optional attribute named 'exponent' on {@link Unit} represents an exponent
 * on the unit.  Its default value is <code>1</code> (one).  A {@link Unit} structure also
 * has an optional attribute called 'scale'; its value must be an integer
 * exponent for a power-of-ten multiplier used to set the scale of the
 * unit.  For example, a unit having a 'kind' value of <code>gram</code> and a
 * 'scale' value of <code>-3</code> signifies 10<sup>&nbsp;&ndash;3</sup>
 * &#215; gram, or milligrams.  The default value of 'scale' is <code>0</code>
 * (zero), because 10<sup> 0</sup> = 1.  Lastly, the optional attribute
 * named 'multiplier' can be used to multiply the kind unit by a
 * real-numbered factor; this enables the definition of units that are not
 * power-of-ten multiples of SI units.  For instance, a multiplier of
 * 0.3048 could be used to define <code>foot</code> as a measure of length in terms
 * of a <code>metre</code>.  The 'multiplier' attribute has a default value of <code>1</code>
 * (one).
 * <p>
 * <h3><a class='anchor' name='UnitKind_t'>UnitKind_t</a></h3>
 * <p>
 * SBML defines a set of base units which serves as the starting point for
 * new unit definitions.  This set of base units consists of the SI units
 * and a small number of additional convenience units.
 * <p>
 * In SBML Level&nbsp;2 Versions before
 * Version&nbsp;3, there existed an enumeration of units called 
 * <code>UnitKind</code>.  In Version&nbsp;3, this enumeration was removed and the
 * identifier class <code>UnitSId</code> redefined to include the previous 
 * <code>UnitKind</code> values as reserved symbols.  This change has no net effect on
 * permissible models, their representation or their syntax.  The purpose
 * of the change in the SBML specification was simply to clean up an
 * inconsistency about the contexts in which these values were usable.
 * However, LibSBML maintains UnitKind in the form of of a set of static
 * integer constants whose names begin with the characters
 * <code>UNIT_KIND_</code>.  These constants are defined in the class
 * <code><a href='libsbmlConstants.java'>libsbmlConstants</a></code> This
 * enumeration in libSBML has a small number of differences compared to the
 * SBML specifications: 
 * <p>
 * <ul>
 * <li> The alternate spelling <code>'meter'</code> is included in addition to the
 * official SI spelling <code>'metre'</code>.
 * <p>
 * <li> The alternate spelling <code>'liter'</code> is included in addition to the
 * official SI spelling <code>'litre'</code>.
 * <p>
 * <li> The unit <code>'Celsius'</code> is included because of its presence in
 * specifications of SBML prior to SBML Level&nbsp;2 Version&nbsp;3.
 * </ul>
 * <p>
 * The table below lists the unit
 * constants defined in libSBML, and their meanings. 
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left' width='200'>Enumerator</th>
     <th align='left'>Meaning</th>
 </tr>
<tr><td><code>UNIT_KIND_AMPERE</code></td><td>The ampere unit</td></tr>
<tr><td><code>UNIT_KIND_BECQUEREL</code></td><td>The becquerel unit.</td></tr>
<tr><td><code>UNIT_KIND_CANDELA</code></td><td>The candela unit.</td></tr>
<tr><td><code>UNIT_KIND_CELSIUS</code></td><td>The Celsius unit.</td></tr>
<tr><td><code>UNIT_KIND_COULOMB</code></td><td>The coulomb unit.</td></tr>
<tr><td><code>UNIT_KIND_DIMENSIONLESS</code></td><td>A pseudo-unit
indicating a dimensionless quantity.  (This is in fact defined in the
SBML specification.)</td></tr>
<tr><td><code>UNIT_KIND_FARAD</code></td><td>The farad unit.</td></tr>
<tr><td><code>UNIT_KIND_GRAM</code></td><td>The gram unit.</td></tr>
<tr><td><code>UNIT_KIND_GRAY</code></td><td>The gray unit.</td></tr>
<tr><td><code>UNIT_KIND_HENRY</code></td><td>The henry unit.</td></tr>
<tr><td><code>UNIT_KIND_HERTZ</code></td><td>The hertz unit.</td></tr>
<tr><td><code>UNIT_KIND_ITEM</code></td><td>A pseudo-unit representing a
single 'thing'. (This is in fact defined in the
SBML specification.)</td></tr>
<tr><td><code>UNIT_KIND_JOULE</code></td><td>The joule unit.</td></tr>
<tr><td><code>UNIT_KIND_KATAL</code></td><td>The katal unit.</td></tr>
<tr><td><code>UNIT_KIND_KELVIN</code></td><td>The kelvin unit.</td></tr>
<tr><td><code>UNIT_KIND_KILOGRAM</code></td><td>The kilogram unit.</td></tr>
<tr><td><code>UNIT_KIND_LITER</code></td><td>Alternate spelling of litre.</td></tr>
<tr><td><code>UNIT_KIND_LITRE</code></td><td>The litre unit.</td></tr>
<tr><td><code>UNIT_KIND_LUMEN</code></td><td>The lumen unit.</td></tr>
<tr><td><code>UNIT_KIND_LUX</code></td><td>The lux unit.</td></tr>
<tr><td><code>UNIT_KIND_METER</code></td><td>Alternate spelling of metre.</td></tr>
<tr><td><code>UNIT_KIND_METRE</code></td><td>The metre unit.</td></tr>
<tr><td><code>UNIT_KIND_MOLE</code></td><td>The mole unit.</td></tr>
<tr><td><code>UNIT_KIND_NEWTON</code></td><td>The newton unit.</td></tr>
<tr><td><code>UNIT_KIND_OHM</code></td><td>The ohm unit.</td></tr>
<tr><td><code>UNIT_KIND_PASCAL</code></td><td>The pascal unit.</td></tr>
<tr><td><code>UNIT_KIND_RADIAN</code></td><td>The radian unit.</td></tr>
<tr><td><code>UNIT_KIND_SECOND</code></td><td>The second unit.</td></tr>
<tr><td><code>UNIT_KIND_SIEMENS</code></td><td>The siemens unit.</td></tr>
<tr><td><code>UNIT_KIND_SIEVERT</code></td><td>The sievert unit.</td></tr>
<tr><td><code>UNIT_KIND_STERADIAN</code></td><td>The steradian unit.</td></tr>
<tr><td><code>UNIT_KIND_TESLA</code></td><td>The tesla unit.</td></tr>
<tr><td><code>UNIT_KIND_VOLT</code></td><td>The volt unit.</td></tr>
<tr><td><code>UNIT_KIND_WATT</code></td><td>The watt unit.</td></tr>
<tr><td><code>UNIT_KIND_WEBER</code></td><td>The weber unit.</td></tr>
<tr><td><code>UNIT_KIND_INVALID</code></td><td>Marker used by libSBML
to indicate an invalid or unset unit.</td></tr>
</table>
</center>

 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Unit extends SBase {
   private long swigCPtr;

   protected Unit(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGUnitUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Unit obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Unit obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_Unit(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link Unit}, optionally with specific values of <code>kind</code>, 
   * <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * If no
   * arguments are passed to this constructor, the value of <code>kind</code>
   * defaults to <code>UNIT_KIND_INVALID</code>.  Callers must reset the value to
   * something appropriate using the method {@link Unit#setKind(int kind)}. 
   * The use of arguments to this constructor is functionally
   * equivalent to the following: 
   * <div class='fragment'><pre>
   *   {@link Unit} u = new {@link Unit}();
   *   u.setKind(kind);
   *   u.setExponent(exponent);
   *   u.setScale(scale);
   *   u.setMultiplier(multipler);</pre></div>
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a value from the
   * set of static integer constants having names beginning with the
   * characters <code>UNIT_KIND_</code> in <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code> 
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(int kind, int exponent, int scale, double multiplier) {
    this(libsbmlJNI.new_Unit__SWIG_0(kind, exponent, scale, multiplier), true);
  }

  
  /**
   * Creates a new {@link Unit}, optionally with specific values of <code>kind</code>, 
   * <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * If no
   * arguments are passed to this constructor, the value of <code>kind</code>
   * defaults to <code>UNIT_KIND_INVALID</code>.  Callers must reset the value to
   * something appropriate using the method {@link Unit#setKind(int kind)}. 
   * The use of arguments to this constructor is functionally
   * equivalent to the following: 
   * <div class='fragment'><pre>
   *   {@link Unit} u = new {@link Unit}();
   *   u.setKind(kind);
   *   u.setExponent(exponent);
   *   u.setScale(scale);
   *   u.setMultiplier(multipler);</pre></div>
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a value from the
   * set of static integer constants having names beginning with the
   * characters <code>UNIT_KIND_</code> in <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code> 
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(int kind, int exponent, int scale) {
    this(libsbmlJNI.new_Unit__SWIG_1(kind, exponent, scale), true);
  }

  
  /**
   * Creates a new {@link Unit}, optionally with specific values of <code>kind</code>, 
   * <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * If no
   * arguments are passed to this constructor, the value of <code>kind</code>
   * defaults to <code>UNIT_KIND_INVALID</code>.  Callers must reset the value to
   * something appropriate using the method {@link Unit#setKind(int kind)}. 
   * The use of arguments to this constructor is functionally
   * equivalent to the following: 
   * <div class='fragment'><pre>
   *   {@link Unit} u = new {@link Unit}();
   *   u.setKind(kind);
   *   u.setExponent(exponent);
   *   u.setScale(scale);
   *   u.setMultiplier(multipler);</pre></div>
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a value from the
   * set of static integer constants having names beginning with the
   * characters <code>UNIT_KIND_</code> in <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code> 
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(int kind, int exponent) {
    this(libsbmlJNI.new_Unit__SWIG_2(kind, exponent), true);
  }

  
  /**
   * Creates a new {@link Unit}, optionally with specific values of <code>kind</code>, 
   * <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * If no
   * arguments are passed to this constructor, the value of <code>kind</code>
   * defaults to <code>UNIT_KIND_INVALID</code>.  Callers must reset the value to
   * something appropriate using the method {@link Unit#setKind(int kind)}. 
   * The use of arguments to this constructor is functionally
   * equivalent to the following: 
   * <div class='fragment'><pre>
   *   {@link Unit} u = new {@link Unit}();
   *   u.setKind(kind);
   *   u.setExponent(exponent);
   *   u.setScale(scale);
   *   u.setMultiplier(multipler);</pre></div>
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a value from the
   * set of static integer constants having names beginning with the
   * characters <code>UNIT_KIND_</code> in <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code> 
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(int kind) {
    this(libsbmlJNI.new_Unit__SWIG_3(kind), true);
  }

  
  /**
   * Creates a new {@link Unit}, optionally with specific values of <code>kind</code>, 
   * <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * If no
   * arguments are passed to this constructor, the value of <code>kind</code>
   * defaults to <code>UNIT_KIND_INVALID</code>.  Callers must reset the value to
   * something appropriate using the method {@link Unit#setKind(int kind)}. 
   * The use of arguments to this constructor is functionally
   * equivalent to the following: 
   * <div class='fragment'><pre>
   *   {@link Unit} u = new {@link Unit}();
   *   u.setKind(kind);
   *   u.setExponent(exponent);
   *   u.setScale(scale);
   *   u.setMultiplier(multipler);</pre></div>
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a value from the
   * set of static integer constants having names beginning with the
   * characters <code>UNIT_KIND_</code> in <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code> 
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit() {
    this(libsbmlJNI.new_Unit__SWIG_4(), true);
  }

  
  /**
   * Creates a new {@link Unit} of a specific <code>kind</code> (given as a string), and
   * optionally with <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * This
   * method accepts a unit kind name as a string, and internally converts
   * it to the appropriate <code>UNIT_KIND_</code> constants from <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code>.  If the
   * string passed as the value of <code>kind</code> is not recognized as a valid
   * unit name, this method sets the value to <code>UNIT_KIND_INVALID</code>.  The
   * following table lists the valid unit kind names: 
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition to the strings above, the string <code>Celsius</code> is
   * accepted for models in SBML Level&nbsp;2 Version&nbsp;1 format.
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a string whose value is a valid unit name
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(String kind, int exponent, int scale, double multiplier) {
    this(libsbmlJNI.new_Unit__SWIG_5(kind, exponent, scale, multiplier), true);
  }

  
  /**
   * Creates a new {@link Unit} of a specific <code>kind</code> (given as a string), and
   * optionally with <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * This
   * method accepts a unit kind name as a string, and internally converts
   * it to the appropriate <code>UNIT_KIND_</code> constants from <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code>.  If the
   * string passed as the value of <code>kind</code> is not recognized as a valid
   * unit name, this method sets the value to <code>UNIT_KIND_INVALID</code>.  The
   * following table lists the valid unit kind names: 
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition to the strings above, the string <code>Celsius</code> is
   * accepted for models in SBML Level&nbsp;2 Version&nbsp;1 format.
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a string whose value is a valid unit name
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(String kind, int exponent, int scale) {
    this(libsbmlJNI.new_Unit__SWIG_6(kind, exponent, scale), true);
  }

  
  /**
   * Creates a new {@link Unit} of a specific <code>kind</code> (given as a string), and
   * optionally with <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * This
   * method accepts a unit kind name as a string, and internally converts
   * it to the appropriate <code>UNIT_KIND_</code> constants from <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code>.  If the
   * string passed as the value of <code>kind</code> is not recognized as a valid
   * unit name, this method sets the value to <code>UNIT_KIND_INVALID</code>.  The
   * following table lists the valid unit kind names: 
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition to the strings above, the string <code>Celsius</code> is
   * accepted for models in SBML Level&nbsp;2 Version&nbsp;1 format.
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a string whose value is a valid unit name
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(String kind, int exponent) {
    this(libsbmlJNI.new_Unit__SWIG_7(kind, exponent), true);
  }

  
  /**
   * Creates a new {@link Unit} of a specific <code>kind</code> (given as a string), and
   * optionally with <code>exponent</code>, <code>scale</code> and <code>multipler</code>.
   * <p>
   * This
   * method accepts a unit kind name as a string, and internally converts
   * it to the appropriate <code>UNIT_KIND_</code> constants from <code><a
   * href='libsbmlConstants.java'>libsbmlConstants</a></code>.  If the
   * string passed as the value of <code>kind</code> is not recognized as a valid
   * unit name, this method sets the value to <code>UNIT_KIND_INVALID</code>.  The
   * following table lists the valid unit kind names: 
   * <p>
   * <table align='center' style='font-family: Courier, fixed; font-weight: bold; font-size: 12px;' cellspacing='7' border='0'>
<tr><td>ampere</td><td>gram</td><td>katal</td><td>lux</td><td>pascal</td><td>tesla</td></tr>
<tr><td>becquerel</td><td>gray</td><td>kelvin</td><td>meter</td><td>radian</td><td>volt</td></tr>
<tr><td>candela</td><td>henry</td><td>kilogram</td><td>metre</td><td>second</td><td>watt</td></tr>
<tr><td>coulomb</td><td>hertz</td><td>liter</td><td>mole</td><td>siemens</td><td>weber</td></tr>
<tr><td>dimensionless</td><td>item</td><td>litre</td><td>newton</td><td>sievert</td></tr>
<tr><td>farad</td><td>joule</td><td>lumen</td><td>ohm</td><td>steradian</td></tr>
</table>

   * <p>
   * In addition to the strings above, the string <code>Celsius</code> is
   * accepted for models in SBML Level&nbsp;2 Version&nbsp;1 format.
   * <p>
   * Readers are urged to read the description of the {@link Unit} class (both the
   * beginning of this page, and in the SBML specification documents) for
   * more information about the meaning of the arguments to this
   * constructor.
   * <p>
   * @param kind a string whose value is a valid unit name
   * <p>
   * @param exponent an integer, the 'exponent' attribute of the unit
   * definition 
   * <p>
   * @param scale an integer, the 'scale' attribute of the unit definition
   * <p>
   * @param multiplier a double, the 'multiplier' attribute of the unit
   * definition 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Unit(String kind) {
    this(libsbmlJNI.new_Unit__SWIG_8(kind), true);
  }

  
  /**
   * Creates a new {@link Unit} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Unit}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Unit}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Unit}
   * <p>
   * @note Once a {@link Unit} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Unit}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Unit(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_Unit__SWIG_9(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link Unit} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Unit}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Unit}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Unit}
   * <p>
   * @note Once a {@link Unit} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Unit}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Unit(long level, long version) {
    this(libsbmlJNI.new_Unit__SWIG_10(level, version), true);
  }

  
  /**
  * Copy constructor; creates a copy of this {@link Unit}.
  */
 public Unit(Unit orig) {
    this(libsbmlJNI.new_Unit__SWIG_11(Unit.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Unit}.
   * <p>
   * @return a (deep) copy of this {@link Unit}.
   */
 public Unit cloneObject() {
    long cPtr = libsbmlJNI.Unit_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Unit(cPtr, true);
  }

  
  /**
   * Initializes the attributes of this {@link Unit} (except for 'kind') to their
   * defaults values.
   * <p>
   * The default values are as follows:
   * <p>
   * <li> exponent   = 1
   * <li> scale      = 0
   * <li> multiplier = 1.0
   * <p>
   * The 'kind' attribute is left unchanged.
   */
 public void initDefaults() {
    libsbmlJNI.Unit_initDefaults(swigCPtr, this);
  }

  
  /**
   * Returns the 'kind' of {@link Unit} this is.
   * <p>
   * @return the value of the 'kind' attribute of this {@link Unit} as a value from
   * the <a class='el' href='#UnitKind_t'>UnitKind_t</a> enumeration
   */
 public int getKind() {
    return libsbmlJNI.Unit_getKind(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'exponent' attribute of this unit.
   * <p>
   * @return the 'exponent' value of this {@link Unit}, as an integer
   */
 public int getExponent() {
    return libsbmlJNI.Unit_getExponent(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'scale' attribute of this unit.
   * <p>
   * @return the 'scale' value of this {@link Unit}, as an integer.
   */
 public int getScale() {
    return libsbmlJNI.Unit_getScale(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'multiplier' attribute of this {@link Unit}.
   * <p>
   * @return the 'multiplier' value of this {@link Unit}, as a double
   */
 public double getMultiplier() {
    return libsbmlJNI.Unit_getMultiplier(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'offset' attribute of this {@link Unit}.
   * <p>
   * @warning The 'offset' attribute is only available in SBML Level&nbsp;2
   * Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
   * Version&nbsp;2 or above.  When producing SBML models using these later
   * specifications, modelers and software tools need to account for units
   * with offsets explicitly.  The SBML specification document offers a
   * number of suggestions for how to achieve this.  LibSBML methods such
   * as this one related to 'offset' are retained for compatibility with
   * earlier versions of SBML Level&nbsp;2, but their use is strongly
   * discouraged.
   * <p>
   * @return the 'offset' value of this {@link Unit}, as a double
   */
 public double getOffset() {
    return libsbmlJNI.Unit_getOffset(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>ampere</code>.
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>ampere</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isAmpere() {
    return libsbmlJNI.Unit_isAmpere(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>becquerel</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>becquerel</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isBecquerel() {
    return libsbmlJNI.Unit_isBecquerel(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>candela</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>candela</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isCandela() {
    return libsbmlJNI.Unit_isCandela(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>Celsius</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>Celsius</code>, <code>false</code>
   * otherwise. 
   * <p>
   * @warning The predefined unit <code>Celsius</code> was removed from the list of
   * predefined units in SBML Level&nbsp;2 Version&nbsp;2 at the same time
   * that the 'offset' attribute was removed from {@link Unit} definitions.
   * LibSBML methods such as this one related to <code>Celsius</code> are retained in
   * order to support SBML Level&nbsp;2 Version&nbsp;1, but their use is
   * strongly discouraged.
   */
 public boolean isCelsius() {
    return libsbmlJNI.Unit_isCelsius(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>coulomb</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>coulomb</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isCoulomb() {
    return libsbmlJNI.Unit_isCoulomb(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind 
   * <code>dimensionless</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>dimensionless</code>, <code>false</code>
   * <p>
   * otherwise.
   */
 public boolean isDimensionless() {
    return libsbmlJNI.Unit_isDimensionless(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>farad</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>farad</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isFarad() {
    return libsbmlJNI.Unit_isFarad(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>gram</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>gram</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isGram() {
    return libsbmlJNI.Unit_isGram(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>gray</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>gray</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isGray() {
    return libsbmlJNI.Unit_isGray(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>henry</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>henry</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isHenry() {
    return libsbmlJNI.Unit_isHenry(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>hertz</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>hertz</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isHertz() {
    return libsbmlJNI.Unit_isHertz(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>item</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>item</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isItem() {
    return libsbmlJNI.Unit_isItem(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>joule</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>joule</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isJoule() {
    return libsbmlJNI.Unit_isJoule(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>katal</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>katal</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isKatal() {
    return libsbmlJNI.Unit_isKatal(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>kelvin</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>kelvin</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isKelvin() {
    return libsbmlJNI.Unit_isKelvin(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>kilogram</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>kilogram</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isKilogram() {
    return libsbmlJNI.Unit_isKilogram(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>litre</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>litre</code> or 'liter', 
   * <code>false</code> 
   * otherwise.
   */
 public boolean isLitre() {
    return libsbmlJNI.Unit_isLitre(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>lumen</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>lumen</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isLumen() {
    return libsbmlJNI.Unit_isLumen(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>lux</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>lux</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isLux() {
    return libsbmlJNI.Unit_isLux(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>metre</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>metre</code> or 'meter', 
   * <code>false</code> 
   * otherwise.
   */
 public boolean isMetre() {
    return libsbmlJNI.Unit_isMetre(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>mole</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>mole</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isMole() {
    return libsbmlJNI.Unit_isMole(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>newton</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>newton</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isNewton() {
    return libsbmlJNI.Unit_isNewton(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>ohm</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>ohm</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isOhm() {
    return libsbmlJNI.Unit_isOhm(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>pascal</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>pascal</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isPascal() {
    return libsbmlJNI.Unit_isPascal(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>radian</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>radian</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isRadian() {
    return libsbmlJNI.Unit_isRadian(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>second</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>second</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSecond() {
    return libsbmlJNI.Unit_isSecond(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>siemens</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>siemens</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSiemens() {
    return libsbmlJNI.Unit_isSiemens(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>sievert</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>sievert</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSievert() {
    return libsbmlJNI.Unit_isSievert(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>steradian</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>steradian</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSteradian() {
    return libsbmlJNI.Unit_isSteradian(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>tesla</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>tesla</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isTesla() {
    return libsbmlJNI.Unit_isTesla(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>volt</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>volt</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isVolt() {
    return libsbmlJNI.Unit_isVolt(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>watt</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>watt</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isWatt() {
    return libsbmlJNI.Unit_isWatt(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>weber</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>weber</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isWeber() {
    return libsbmlJNI.Unit_isWeber(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether the 'kind' attribute of this {@link Unit} has been set.
   * <p>
   * @return <code>true</code> if the 'kind' attribute of this {@link Unit} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetKind() {
    return libsbmlJNI.Unit_isSetKind(swigCPtr, this);
  }

  
  /**
   * Sets the 'kind' attribute value of this {@link Unit}.
   * <p>
   * @param kind a value from the <a class='el'
   * href='#UnitKind_t'>UnitKind_t</a> enumeration
   */
 public void setKind(int kind) {
    libsbmlJNI.Unit_setKind(swigCPtr, this, kind);
  }

  
  /**
   * Sets the 'exponent' attribute value of this {@link Unit}.
   * <p>
   * @param value the integer to which the attribute 'exponent' should be set
   */
 public void setExponent(int value) {
    libsbmlJNI.Unit_setExponent(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'scale' attribute value of this {@link Unit}.
   * <p>
   * @param value the integer to which the attribute 'scale' should be set
   */
 public void setScale(int value) {
    libsbmlJNI.Unit_setScale(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'multipler' attribute value of this {@link Unit}.
   * <p>
   * @param value the floating-point value to which the attribute
   * 'multiplier' should be set
   */
 public void setMultiplier(double value) {
    libsbmlJNI.Unit_setMultiplier(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'offset' attribute value of this {@link Unit}.
   * <p>
   * @param value the float-point value to which the attribute 'offset'
   * should set
   * <p>
   * @warning The 'offset' attribute is only available in SBML Level&nbsp;2
   * Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
   * Version&nbsp;2 or above.  When producing SBML models using these later
   * specifications, modelers and software tools need to account for units
   * with offsets explicitly.  The SBML specification document offers a
   * number of suggestions for how to achieve this.  LibSBML methods such
   * as this one related to 'offset' are retained for compatibility with
   * earlier versions of SBML Level&nbsp;2, but their use is strongly
   * discouraged.
   */
 public void setOffset(double value) {
    libsbmlJNI.Unit_setOffset(swigCPtr, this, value);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Unit_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Unit}, is
   * always <code>'unit'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'unit'</code>. 
   */
 public String getElementName() {
    return libsbmlJNI.Unit_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether a given string is the name of a
   * predefined SBML unit.
   * <p>
   * @param name a string to be tested against the predefined unit names
   * <p>
   * @param level the Level of SBML for which the determination should be
   * made.  This is necessary because there are a few small differences
   * in allowed units between SBML Level&nbsp;1 and Level&nbsp;2.
   * <p>
   * @return <code>true</code> if <code>name</code> is one of the five SBML predefined unit
   * identifiers (<code>'substance'</code>, <code>'volume'</code>, <code>'area'</code>, <code>'length'</code> or 
   * <code>'time'</code>), <code>false</code> otherwise.
   * <p>
   * @note The predefined unit identifiers <code>'length'</code> and <code>'area'</code> were
   * added in Level&nbsp;2 Version&nbsp;1
   */
 public static boolean isBuiltIn(String name, long level) {
    return libsbmlJNI.Unit_isBuiltIn(name, level);
  }

  
  /**
   * Predicate to test whether a given string is the name of a valid
   * base unit in SBML (such as <code>'gram'</code> or <code>'mole'</code>).
   * <p>
   * This method exists because prior to SBML Level&nbsp;2 Version&nbsp;3,
   * an enumeration called <code>UnitKind</code> was defined by SBML.  This enumeration
   * was removed in SBML Level&nbsp;2 Version&nbsp;3 and its values were
   * folded into the space of values of a type called <code>UnitSId</code>.  This method
   * therefore has less significance in SBML Level&nbsp;2 Version&nbsp;3
   * and Level&nbsp;2 Version&nbsp;4, but remains for backward
   * compatibility and support for reading models in older Versions of
   * Level&nbsp;2.
   * <p>
   * @param name a string to be tested
   * <p>
   * @param level a long integer representing the SBML specification
   * Level 
   * <p>
   * @param version a long integer representing the SBML specification
   * Version
   * <p>
   * @return <code>true</code> if name is a valid UnitKind, <code>false</code> otherwise
   * <p>
   * @note The allowed unit names differ between SBML Levels&nbsp;1
   * and&nbsp;2 and again slightly between Level&nbsp;2 Versions&nbsp;1
   * and&nbsp;2.
   */
 public static boolean isUnitKind(String name, long level, long version) {
    return libsbmlJNI.Unit_isUnitKind(name, level, version);
  }

  
  /** 
  * Predicate returning <code>true</code> or <code>false</code> depending on whether two
  * {@link Unit} objects are identical.
  * <p>
  * Two {@link Unit} objects are considered to be <em>identical</em> if they match in
  * all attributes.  (Contrast this to the method areEquivalent(), which
  * compares {@link Unit} objects only with respect to certain attributes.)
  * <p>
  * @param unit1 the first {@link Unit} object to compare
  * @param unit2 the second {@link Unit} object to compare
  * <p>
  * @return <code>true</code> if all the attributes of unit1 are identical
  * to the attributes of unit2, <code>false</code> otherwise.
  * <p>
  * @see #areEquivalent()
  */
 public static boolean areIdentical(Unit unit1, Unit unit2) {
    return libsbmlJNI.Unit_areIdentical(Unit.getCPtr(unit1), unit1, Unit.getCPtr(unit2), unit2);
  }

  
  /** 
  * Predicate returning <code>true</code> or <code>false</code> depending on whether 
  * {@link Unit} objects are equivalent.
  * <p>
  * Two {@link Unit} objects are considered to be <em>equivalent</em> if their 'kind'
  * and 'exponent' attributes are equal.  (Contrast this to the method
  * {@link Unit#areIdentical()}, which compares {@link Unit} objects with respect to all
  * attributes, not just the kind and exponent.)
  * <p>
  * @param unit1 the first {@link Unit} object to compare
  * @param unit2 the second {@link Unit} object to compare
  * <p>
  * @return <code>true</code> if the 'kind' and 'exponent' attributes of unit1 are
  * identical to the kind and exponent attributes of unit2, <code>false</code>
  * otherwise.
  * <p>
  * @see #areIdentical()
  */
 public static boolean areEquivalent(Unit unit1, Unit unit2) {
    return libsbmlJNI.Unit_areEquivalent(Unit.getCPtr(unit1), unit1, Unit.getCPtr(unit2), unit2);
  }

  
  /** 
  * Manipulates the attributes of the {@link Unit} to express the unit with the 
  * value of the scale attribute reduced to zero.
  * <p>
  * For example, 1 millimetre can be expressed as a {@link Unit} with kind=
  * <code>'metre'</code> multiplier=<code>'1'</code> scale=<code>'-3'</code> exponent=<code>'1'</code>. It can also be
  * expressed as a {@link Unit} with kind=<code>'metre'</code>
  * multiplier=<code>'0.001'</code> scale=<code>'0'</code> exponent=<code>'1'</code>.
  * <p>
  * @param unit the {@link Unit} object to manipulate.
  */
 public static void removeScale(Unit unit) {
    libsbmlJNI.Unit_removeScale(Unit.getCPtr(unit), unit);
  }

  
  /** 
  * Merges two {@link Unit} objects with the same 'kind' attribute value into a
  * single {@link Unit}.
  * <p>
  * For example, the following,
  * <div class='fragment'><pre>
  * &lt;unit kind='metre' exponent='2'/&gt;
  * &lt;unit kind='metre' exponent='1'/&gt;</pre></div>
  * would be merged to become
  * <div class='fragment'><pre>
  * &lt;unit kind='metre' exponent='3'/&gt;</pre></div>
  * <p>
  * @param unit1 the first {@link Unit} object; the result of the operation is
  * left as a new version of this unit, modified in-place.
  * <p>
  * @param unit2 the second {@link Unit} object to merge with the first
  */
 public static void merge(Unit unit1, Unit unit2) {
    libsbmlJNI.Unit_merge(Unit.getCPtr(unit1), unit1, Unit.getCPtr(unit2), unit2);
  }

  
  /**
  * Returns a {@link UnitDefinition} object which contains the argument {@link Unit}
  * converted to the appropriate SI unit.
  * <p>
  * @param unit the {@link Unit} object to convert to SI
  * <p>
  * @return a {@link UnitDefinition} object containing the SI unit.
  */
 public static UnitDefinition convertToSI(Unit unit) {
    long cPtr = libsbmlJNI.Unit_convertToSI(Unit.getCPtr(unit), unit);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

}
