/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of errors, warnings and other diagnostics
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * LibSBML can be configured to use any of a number of XML parsers; at the
 * time of this writing, libSBML supports Xerces versions 2.4 through 3.0,
 * Expat version 1.95.x and higher, and libxml2 version 2.6.16 and higher.
 * These parsers each report different status codes for the various
 * exceptions that can occur during XML processing.  The XMLError object
 * class abstracts away from the particular diagnostics reported by the
 * different parsers and presents a single uniform interface and set of
 * status codes, along with operations for manipulating the error objects.
 * <p>
 * When the libSBML XML parser layer encounters an error in the XML content
 * being processed, or when there is something else wrong (such as an
 * out-of-memory condition), the problems are reported as XMLError objects.
 * Each XMLError object instance has an identification number that
 * identifies the nature of the problem.
 * This
 * error identifier is one of the constants listed in the next section below.
 * Applications can use the error identifiers as a means of recognizing the
 * error encountered and changing their behavior if desired.  
 * <p>
 * Integer error codes are useful for software, but not so much for telling
 * humans what happened.  For this reason, XMLError also provides two text
 * messages describing the nature of the error.  These messages are
 * accessible by means of the methods {@link XMLError#getShortMessage()} and
 * {@link XMLError#getMessage()}.  The method {@link XMLError#getShortMessage()} returns
 * a very brief synopsis of the warning or error condition, whereas
 * {@link XMLError#getMessage()} returns a longer explanation.  These text strings
 * are suitable for displaying to human users.
 * <p>
 * Each XMLError object also contains a category code; its value may be
 * retrieved using the method {@link XMLError#getCategory()}.  Category values
 * are drawn from a set of constants whose
 * names begin with the characters <code>LIBSBML_CAT_</code>.  The list of possible
 * codes is described in a separate section below. Categories are used by
 * libSBML to provide more information to calling programs about the nature
 * of a given error.  
 * <p>
 * In addition to category codes, each XMLError object also has a severity
 * code; its value may be retrieved using the method
 * {@link XMLError#getSeverity()}.  Severity code values are 
 * drawn from a
 * set of constants whose names begin with the characters <code>LIBSBML_SEV_</code>.
 * The list of possible severity codes is described in a separate section
 * below.  Severity levels range from informational (<code>LIBSBML_SEV_INFO</code>)
 * to fatal errors (<code>LIBSBML_SEV_FATAL</code>). 
 * <p>
 * Finally, XMLError objects record the line and column near where the
 * problem occurred in the XML content.  The values can be retrieved using
 * the methods {@link XMLError#getLine()} and {@link XMLError#getColumn()}.  We say 'near
 * where the problem occurred', because many factors affect how accurate
 * the line/column information ultimately is.  For example, different XML
 * parsers have different conventions for which line and column number they
 * report for a particular problem (which in turn makes a difference when a
 * problem involves an opening XML tag on one line and a closing tag on
 * another line).  In some situations, some parsers report invalid line
 * and/or column numbers altogether.  If this occurs, libSBML sets the line
 * and/or column number in the XMLError object to the the value of the
 * maximum unsigned long integer representable on the platform where
 * libSBML is running.  (This is equal to the constant named
 * <code>ULONG_MAX</code> in C and C++.)  The probability that a true line
 * or column number in an SBML model would equal this value is vanishingly
 * small; thus, if an application encounters these values in an XMLError
 * object, it can assume no valid line/column number could be provided by
 * libSBML in that situation.
 * <p>
 * <p>
 * <h3><a class='anchor' 
 * name='XMLErrorCode_t'>Error codes associated with XMLError objects</a></h3>
 * <p>
 * The error and warning codes returned by the XML layer in libSBML are
 * listed in the table below.  In the libSBML Java language interface,
 * these error identifiers are currently (in libSBML 3.3.x) implemented as
 * static integer constants defined in the interface class <code><a
 * href='libsbmlConstants.html'>libsbmlConstants</a></code>.  This is admittedly
 * not an ideal approach from the standpoint of modern Java programming,
 * but it was necessary to work around the lack of enumerations in Java
 * prior to JDK 1.5.  Future versions of libSBML may use a proper Java
 * enumeration type to define the error identifiers. 
 * <p>
 * <center>
 * <table cellspacing='1' cellpadding='1' border='0' class='text-table width80 normal-font alt-row-colors'>
 * <caption>Possible XMLError error codes.  Depending on the programming
 * language in use, the <em>Enumerator</em> values will be defined either
 * as a value from the enumeration XMLErrorCode_t or as integer constants.
 * To make this table more compact, we have shortened the identifiers for
 * the category and severity codes to their essential parts.  To get the
 * actual names of the constants, prepend <code>LIBSBML_CAT_</code> to the
 * category names and <code>LIBSBML_SEV_</code> to the severity names
 * shown in the two right-hand columns below.
 * </caption>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</th>
 *      <th>Meaning</th>
 *      <th width='90'>Category</th>
 *      <th width='90'>Severity</th>
 *  </tr>
 * <tr><td><code>XMLUnknownError</code></td><td>Unrecognized error encountered internally</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td><code>XMLOutOfMemory</code></td> <td>Out of memory</td><td>SYSTEM</td><td>FATAL</td></tr>
 * <tr><td><code>XMLFileUnreadable</code></td> <td>File unreadable</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td><code>XMLFileUnwritable</code></td> <td>File unwritable</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td><code>XMLFileOperationError</code></td><td>Error encountered while attempting file operation</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td><code>XMLNetworkAccessError</code></td><td>Network access error</td><td>SYSTEM</td><td>ERROR</td></tr>
 * <tr><td><code>InternalXMLParserError</code></td><td>Internal XML parser state error</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td><code>UnrecognizedXMLParserCode</code></td><td>XML parser returned an unrecognized error code</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td><code>XMLTranscoderError</code></td><td>Character transcoder error</td><td>INTERNAL</td><td>FATAL</td></tr>
 * <tr><td><code>MissingXMLDecl</code></td><td>Missing XML declaration at beginning of XML input</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>MissingXMLEncoding</code></td><td>Missing encoding attribute in XML declaration</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLDecl</code></td><td>Invalid or unrecognized XML declaration or XML encoding</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLDOCTYPE</code></td><td>Invalid, malformed or unrecognized XML DOCTYPE declaration</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>InvalidCharInXML</code></td><td>Invalid character in XML content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadlyFormedXML</code></td><td>XML content is not well-formed</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>UnclosedXMLToken</code></td><td>Unclosed XML token</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>InvalidXMLConstruct</code></td><td>XML construct is invalid or not permitted</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLTagMismatch</code></td><td>Element tag mismatch or missing tag</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>DuplicateXMLAttribute</code></td><td>Duplicate XML attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>UndefinedXMLEntity</code></td><td>Undefined XML entity</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadProcessingInstruction</code></td><td>Invalid, malformed or unrecognized XML processing instruction</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLPrefix</code></td><td>Invalid or undefined XML namespace prefix</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLPrefixValue</code></td><td>Invalid XML namespace prefix value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>MissingXMLRequiredAttribute</code></td><td>Missing a required XML attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLAttributeTypeMismatch</code></td><td>Data type mismatch for the value of an attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLBadUTF8Content</code></td><td>Invalid UTF8 content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>MissingXMLAttributeValue</code></td><td>Missing or improperly formed attribute value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLAttributeValue</code></td><td>Invalid or unrecognizable attribute value</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLAttribute</code></td><td>Invalid, unrecognized or malformed attribute</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>UnrecognizedXMLElement</code></td><td>Element either not recognized or not permitted</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLComment</code></td><td>Badly formed XML comment</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLDeclLocation</code></td><td>XML declaration not permitted in this location</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLUnexpectedEOF</code></td><td>Reached end of input unexpectedly</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLIDValue</code></td><td>Value is invalid for XML ID, or has already been used</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLIDRef</code></td><td>XML ID value was never declared</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>UninterpretableXMLContent</code></td><td>Unable to interpret content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>BadXMLDocumentStructure</code></td><td>Bad XML document structure</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>InvalidAfterXMLContent</code></td><td>Encountered invalid content after expected content</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLExpectedQuotedString</code></td><td>Expected to find a quoted string</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLEmptyValueNotPermitted</code></td><td>An empty value is not permitted in this context</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLBadNumber</code></td><td>Invalid or unrecognized number</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLBadColon</code></td><td>Colon characters are invalid in this context</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>MissingXMLElements</code></td><td>One or more expected elements are missing</td><td>XML</td><td>ERROR</td></tr>
 * <tr><td><code>XMLContentEmpty</code></td><td>Main XML content is empty</td><td>XML</td><td>ERROR</td></tr>
 * </table>
 * </center>
 * <p>
 * <p>
 * <h3><a class='anchor'
 * name='XMLErrorCategory_t'>Category codes associated with XMLError objects</a></h3>
 * <p>
 * As discussed above, each XMLError object contains a value for a category
 * identifier, describing the type of issue that the XMLError object represents.
 * The category can be retrieved from an XMLError object using the method
 * {@link XMLError#getCategory()}. The following table lists each possible value
 * and a brief description of its meaning.
 * <p>
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * <code>libsbmlConstants</code> in the file '<a
 * href='libsbmlConstants.html'>libsbmlConstants.java</a>'.
 * <p>
 * <p>
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='1' border='0' class='text-table width80 normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</th>
 *      <th>Meaning</th>
 *  </tr>
 * <tr><td><em>LIBSBML_CAT_INTERNAL</em></td><td>A problem involving the libSBML
 * software itself or the underlying XML parser.  This almost certainly
 * indicates a software defect (i.e., bug) in libSBML.  Please report
 * instances of this to the libSBML developers.</td></tr>
 * <tr><td><em>LIBSBML_CAT_SYSTEM</em></td><td>A problem reported by the operating
 * system, such as an inability to read or write a file.  This indicates
 * something that is not a program error but is outside of the control of
 * libSBML.</td></tr>
 * <tr><td><em>LIBSBML_CAT_XML</em></td><td>A problem in the XML content itself.  This
 * usually arises from malformed XML or the use of
 * constructs not permitted in SBML.</td></tr>
 * </table>
 * </center>
 * <p>
 * <p>
 * <h3><a class='anchor'
 * name='XMLErrorSeverity_t'>Severity codes associated with XMLError objects</a></h3>
 * <p>
 * As described above, each XMLError object contains a value for a severity
 * code, describing how severe is the issue that the XMLError object
 * represents.  The severity be retrieved from an XMLError object using the
 * method {@link XMLError#getSeverity()}. The following table lists each possible
 * value and a brief description of its meaning.
 * <p>
 * As is the case with the category codes, in the libSBML Java language
 * interface, these severity codes are currently (in libSBML 3.3.x)
 * implemented as static integer constants defined in the interface class
 * <code>libsbmlConstants</code> in the file 'libsbmlConstants.java'.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the severity codes. 
 * <p>
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='1' border='0' class='text-table width80 normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</th>
 *      <th>Meaning</th>
 *  </tr>
 * <tr><td><em>LIBSBML_SEV_INFO</em></td><td>The error is actually informational and
 * not necessarily a serious problem.</td></tr>
 * <tr><td><em>LIBSBML_SEV_WARNING</em></td><td>The error object represents a problem
 * that is not serious enough to necessarily stop the problem, but
 * applications should take note of the problem and evaluate what its
 * implications may be.</td></tr>
 * <tr><td><em>LIBSBML_SEV_ERROR</em></td><td>The error object represents a serious
 * error.  The application may continue running but it is unlikely to be
 * able to continue processing the same XML file or data stream.</td></tr>
 * <tr><td><em>LIBSBML_SEV_FATAL</em></td><td>A serious error occurred, such as an
 * out-of-memory condition, and the software should terminate
 * immediately.</td></tr>
 * </table>
 * </center>
 */

public class XMLError {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLError(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLError obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLError obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_XMLError(swigCPtr);
    }
    swigCPtr = 0;
  }

  /**
   * Equality comparison method for XMLError.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((XMLError)(sb));
  }

  /**
   * Returns a hashcode for this XMLError object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError(int errorId, String details, long line, long column, long severity, long category) {
    this(libsbmlJNI.new_XMLError__SWIG_0(errorId, details, line, column, severity, category), true);
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError(int errorId, String details, long line, long column, long severity) {
    this(libsbmlJNI.new_XMLError__SWIG_1(errorId, details, line, column, severity), true);
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError(int errorId, String details, long line, long column) {
    this(libsbmlJNI.new_XMLError__SWIG_2(errorId, details, line, column), true);
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError(int errorId, String details, long line) {
    this(libsbmlJNI.new_XMLError__SWIG_3(errorId, details, line), true);
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError(int errorId, String details) {
    this(libsbmlJNI.new_XMLError__SWIG_4(errorId, details), true);
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError(int errorId) {
    this(libsbmlJNI.new_XMLError__SWIG_5(errorId), true);
  }

  
  /**
   * Creates a new XMLError to report that something occurred during XML
   * processing.
   * <p>
   * XMLError objects have identification numbers to indicate the nature of
   * the exception.  These numbers are defined as unsigned 
   * integer constants in the file
   * 'libsbmlConstants.java'.  See the <a class='el'
   * href='#XMLErrorCode_t'>top of this documentation</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it is
   * one of the predefined error identifiers, the XMLError class assumes
   * the error is a low-level system or XML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in as
   * well. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 9999, this
   * constructor assumes that the error was generated from another part of
   * the software, and does not do additional filling in of values beyond
   * the defaults in the constructor itself.  This allows XMLError to serve
   * as a base class for other errors (and is used in this way elsewhere in
   * libSBML).  Callers should fill in all the parameters with suitable
   * values if generating errors with codes greater than 9999 to make
   * maximum use of the XMLError facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#XMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#XMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * XML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by XMLError,
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLError() {
    this(libsbmlJNI.new_XMLError__SWIG_6(), true);
  }

  
  /**
   * Copy constructor; creates a copy of this XMLError.
   */
 public XMLError(XMLError orig) {
    this(libsbmlJNI.new_XMLError__SWIG_7(XMLError.getCPtr(orig), orig), true);
  }

  
  /**
   * Returns the identifier of this error.
   * <p>
   * @return the id of this XMLError.
   * <p>
   * @see #getMessage()
   * @see #getShortMessage()
   * @see #getCategory()
   * @see #getSeverity()
   */
 public long getErrorId() {
    return libsbmlJNI.XMLError_getErrorId(swigCPtr, this);
  }

  
  /**
   * Returns the message text of this error.
   * <p>
   * The message associated with an error object describes the nature of
   * the problem.  The message returned by this method is generally longer
   * and clearer than the message returned by {@link XMLError#getShortMessage()},
   * but not in all cases.
   * <p>
   * Callers may use {@link XMLError#getCategory()} and {@link XMLError#getSeverity()} to
   * obtain additional information about the nature and severity of the
   * problem.
   * <p>
   * @return the message text
   * <p>
   * @see #getErrorId()
   * @see #getShortMessage()
   * @see #getCategory()
   * @see #getSeverity()
   */
 public String getMessage() {
    return libsbmlJNI.XMLError_getMessage(swigCPtr, this);
  }

  
  /**
   * Returns a brief message for this error.
   * <p>
   * This is an alternative error message that, in general, is as short as
   * the authors could make it.  However, brevity is often inversely
   * proportional to clarity, so this short message may not be sufficiently
   * informative to understand the nature of the error.  Calling
   * applications may wish to check {@link XMLError#getMessage()} in addition or
   * instead.
   * <p>
   * @return the short error message text
   * <p>
   * @see #getErrorId()
   * @see #getMessage()
   * @see #getCategory()
   * @see #getSeverity()
   */
 public String getShortMessage() {
    return libsbmlJNI.XMLError_getShortMessage(swigCPtr, this);
  }

  
  /**
   * Returns the line number in the XML input near where the error, warning
   * or other diagnostic occurred.
   * <p>
   * We say 'near where the problem occurred', because many factors affect
   * how accurate the line/column information ultimately is.  For example,
   * different XML parsers have different conventions for which line and
   * column number they report for a particular problem (which in turn
   * makes a difference when a problem involves an opening XML tag on one
   * line and a closing tag on another line).  In some situations, some
   * parsers report invalid line and/or column numbers altogether.  If this
   * occurs, the line and/or column number in the XMLError object will be
   * set to the the value of the maximum unsigned long integer
   * representable on the platform where libSBML is running.  (This is
   * equal to the constant named <code>ULONG_MAX</code> in C and C++.)  The
   * probability that a true line or column number in an SBML model would
   * equal this value is vanishingly small; thus, if an application
   * encounters these values in an XMLError object, it can assume no valid
   * line/column number could be provided by libSBML in that situation.
   * <p>
   * @return the line number
   * <p>
   * @see #getColumn()
   */
 public long getLine() {
    return libsbmlJNI.XMLError_getLine(swigCPtr, this);
  }

  
  /**
   * Returns the column number in the XML input near where the error,
   * warning or other diagnostic occurred.
   * <p>
   * We say 'near where the problem occurred', because many factors affect
   * how accurate the line/column information ultimately is.  For example,
   * different XML parsers have different conventions for which line and
   * column number they report for a particular problem (which in turn
   * makes a difference when a problem involves an opening XML tag on one
   * line and a closing tag on another line).  In some situations, some
   * parsers report invalid line and/or column numbers altogether.  If this
   * occurs, the line and/or column number in the XMLError object will be
   * set to the the value of the maximum unsigned long integer
   * representable on the platform where libSBML is running.  (This is
   * equal to the constant named <code>ULONG_MAX</code> in C and C++.)  The
   * probability that a true line or column number in an SBML model would
   * equal this value is vanishingly small; thus, if an application
   * encounters these values in an XMLError object, it can assume no valid
   * line/column number could be provided by libSBML in that situation.
   * <p>
   * @return the column number
   * <p>
   * @see #getLine()
   */
 public long getColumn() {
    return libsbmlJNI.XMLError_getColumn(swigCPtr, this);
  }

  
  /**
   * Returns the severity of this error.
   * <p>
   * XMLError defines an enumeration of severity codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own severity codes with numbers higher than those in the predefined
   * set of severity codes.
   * <p>
   * @return the severity of this XMLError.
   * <p>
   * @see #getSeverityAsString()
   * @see #getCategory()
   */
 public long getSeverity() {
    return libsbmlJNI.XMLError_getSeverity(swigCPtr, this);
  }

  
  /**
   * Returns a string describing the severity level of this error.
   * <p>
   * XMLError defines an enumeration of severity codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own severity codes with numbers higher than those in the predefined
   * set of severity codes.
   * <p>
   * @return string representing the severity of this XMLError.
   * <p>
   * @see #getSeverity()
   * @see #getCategoryAsString()
   */
 public String getSeverityAsString() {
    return libsbmlJNI.XMLError_getSeverityAsString(swigCPtr, this);
  }

  
  /**
   * Returns the category of this error.
   * <p>
   * XMLError defines an enumeration of category codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own categories with numbers higher than those in the predefined
   * set of category codes.
   * <p>
   * Categories can be used to partition errors into distinct groups.
   * Among other things, this can be used to prevent id conflicts by
   * uniquely identifying an XMLError by both id and category.
   * <p>
   * @return the category of this XMLError.
   * <p>
   * @see #getSeverity()
   * @see #getCategoryAsString()
   */
 public long getCategory() {
    return libsbmlJNI.XMLError_getCategory(swigCPtr, this);
  }

  
  /**
   * Returns a string describing the category of this error.
   * <p>
   * XMLError defines an enumeration of category codes for the XML layer.
   * Applications that build on XMLError by subclassing it may add their
   * own categories with numbers higher than those in the predefined
   * set of category codes.
   * <p>
   * Categories can be used to partition errors into distinct groups.
   * Among other things, this can be used to prevent id conflicts by
   * uniquely identifying an XMLError by both id and category.
   * <p>
   * @return string representing the category of this XMLError.
   * <p>
   * @see #getCategory()
   * @see #getSeverityAsString()
   */
 public String getCategoryAsString() {
    return libsbmlJNI.XMLError_getCategoryAsString(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error object is for information purposes only.
   * <p>
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value <code>LIBSBML_SEV_INFO</code> from the
   * set of predefined
   * severity codes.
   * <p>
   * @return <code>true</code> if this XMLError is for informational purposes only,
   * <code>false</code> otherwise.
   * <p>
   * @see #isWarning()
   * @see #isError()
   * @see #isFatal()
   */
 public boolean isInfo() {
    return libsbmlJNI.XMLError_isInfo(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this error object is a warning.
   * <p>
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value <code>LIBSBML_SEV_WARNING</code> from the
   * set of predefined
   * severity codes.
   * <p>
   * @return <code>true</code> if this error is a warning, <code>false</code> otherwise.
   * <p>
   * @see #isInfo()
   * @see #isError()
   * @see #isFatal()
   */
 public boolean isWarning() {
    return libsbmlJNI.XMLError_isWarning(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error is a significant error.
   * <p>
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value <code>LIBSBML_SEV_ERROR</code> from the
   * set of predefined
   * severity codes.
   * <p>
   * @return <code>true</code> if this error is an error, <code>false</code> otherwise.
   * <p>
   * @see #isInfo()
   * @see #isWarning()
   * @see #isFatal()
   */
 public boolean isError() {
    return libsbmlJNI.XMLError_isError(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error is a fatal run-time error.
   * <p>
   * This is equivalent to obtaining the severity code from an XMLError
   * object (via {@link XMLError#getSeverity()}) and then comparing it to the
   * value <code>LIBSBML_SEV_FATAL</code> from the
   * set of predefined
   * severity codes.
   * <p>
   * @return <code>true</code> if this error is a fatal error, <code>false</code> otherwise.
   * <p>
   * @see #isInfo()
   * @see #isWarning()
   * @see #isError()
   */
 public boolean isFatal() {
    return libsbmlJNI.XMLError_isFatal(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error resulted from an internal program error.
   * <p>
   * This is equivalent to obtaining the category identifier from an
   * XMLError object (via {@link XMLError#getCategory()}) and then comparing it to
   * the value <code>LIBSBML_CAT_INTERNAL</code> from the
   * set of
   * predefined category codes.
   * <p>
   * @return <code>true</code> or <code>false</code>
   * <p>
   * @see #isSystem()
   * @see #isXML()
   */
 public boolean isInternal() {
    return libsbmlJNI.XMLError_isInternal(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error was generated by the operating system.
   * <p>
   * This is equivalent to obtaining the category identifier from an
   * XMLError object (via {@link XMLError#getCategory()}) and then comparing it to
   * the value <code>LIBSBML_CAT_SYSTEM</code> from the
   * set of
   * predefined category codes.
   * <p>
   * @return <code>true</code> or <code>false</code>
   * <p>
   * @see #isInternal()
   * @see #isXML()
   */
 public boolean isSystem() {
    return libsbmlJNI.XMLError_isSystem(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * error resulted from a problem in the XML input (e.g., an XML syntax
   * error).
   * <p>
   * This is equivalent to obtaining the category identifier from an
   * XMLError object (via {@link XMLError#getCategory()}) and then comparing it to
   * the value <code>LIBSBML_CAT_XML</code> from the
   * set of
   * predefined category codes.
   * <p>
   * @return <code>true</code> or <code>false</code>
   * <p>
   * @see #isInternal()
   * @see #isSystem()
   */
 public boolean isXML() {
    return libsbmlJNI.XMLError_isXML(swigCPtr, this);
  }

  
  /**
   * Sets the line number where this error occurred.
   * <p>
   * @param line a long integer, the line number to set.
   * <p>
   * @see #setColunn()
   */
 public void setLine(long line) {
    libsbmlJNI.XMLError_setLine(swigCPtr, this, line);
  }

  
  /**
   * Sets the column number where this error occurred.
   * <p>
   * @param column a long integer, the column number to set.
   * <p>
   * @see #setLine()
   */
 public void setColumn(long column) {
    libsbmlJNI.XMLError_setColumn(swigCPtr, this, column);
  }

  
  /**
   * Returns a copy of the message string associated with the given
   * predefined XMLError code.
   * <p>
   * @param code the error code whose message is sought; it must be a
   * predefined value from <a class='el'
   * href='#XMLErrorCode_t'>the set of predefined error identifiers.
   */
 public static String getStandardMessage(int code) {
    return libsbmlJNI.XMLError_getStandardMessage(code);
  }

}
