/// 
///  @file    TestXMLErrorLog.cs
///  @brief   XMLErrorLog unit tests
///  @author  Frank Bergmann (Csharp conversion)
///  @author  Akiya Jouraku (Csharp conversion)
///  @author  Sarah Keating 
/// 
///  $Id: TestXMLErrorLog.cs 8704 2009-01-04 02:26:05Z mhucka $
///  $HeadURL: https://sbml.svn.sourceforge.net/svnroot/sbml/trunk/libsbml/src/bindings/csharp/test/xml/TestXMLErrorLog.cs $
/// 
///  This test file was converted from src/sbml/test/TestXMLErrorLog.c
///  with the help of conversion sciprt (ctest_converter.pl).
/// 
/// <!---------------------------------------------------------------------------
///  This file is part of libSBML.  Please visit http://sbml.org for more
///  information about SBML, and the latest version of libSBML.
/// 
///  Copyright 2005-2009 California Institute of Technology.
///  Copyright 2002-2005 California Institute of Technology and
///                      Japan Science and Technology Corporation.
///  
///  This library is free software; you can redistribute it and/or modify it
///  under the terms of the GNU Lesser General Public License as published by
///  the Free Software Foundation.  A copy of the license agreement is provided
///  in the file named "LICENSE.txt" included with this software distribution
///  and also available online as http://sbml.org/software/libsbml/license.html
/// --------------------------------------------------------------------------->*/


namespace LibSBMLCSTest {

  using libsbml;

  using  System.IO;

  public class TestXMLErrorLog {
    public class AssertionError : System.Exception 
    {
      public AssertionError() : base()
      {
        
      }
    }


    static void assertTrue(bool condition)
    {
      if (condition == true)
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        return;
      }
      else if (a.Equals(b))
      {
        return;
      }
  
      throw new AssertionError();
    }

    static void assertNotEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        throw new AssertionError();
      }
      else if (a.Equals(b))
      {
        throw new AssertionError();
      }
    }

    static void assertEquals(bool a, bool b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(bool a, bool b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(int a, int b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(int a, int b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }


    public void test_XMLErrorLog_add()
    {
      XMLErrorLog log = new  XMLErrorLog();
      XMLError error = new  XMLError();
      log.add(error);
      assertTrue( log != null );
      assertTrue( log.getNumErrors() == 1 );
      assertTrue( log.getError(0) != null );
      assertTrue( log.getError(2) == null );
      log = null;
    }

    public void test_XMLErrorLog_clear()
    {
      XMLErrorLog log = new  XMLErrorLog();
      XMLError error = new  XMLError();
      log.add(error);
      log.clearLog();
      assertTrue( log != null );
      assertTrue( log.getNumErrors() == 0 );
      log = null;
    }

    public void test_XMLErrorLog_create()
    {
      XMLErrorLog log = new  XMLErrorLog();
      assertTrue( log != null );
      assertTrue( log.getNumErrors() == 0 );
      log = null;
    }

  }
}
