/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's CompartmentType construct.
 * <p>
 * A <em>compartment type</em> in SBML is a grouping construct used to
 * establish a relationship between multiple {@link Compartment} objects.
 * In SBML Level 2 Versions 2, 3 and 4, a compartment type only has an
 * identity, and this identity can only be used to indicate that particular
 * compartments belong to this type.  This may be useful for conveying a
 * modeling intention, such as when a model contains many similar
 * compartments, either by their biological function or the reactions they
 * carry.  Without a compartment type construct, it would be impossible in
 * the language of SBML to indicate that all of the compartments share an
 * underlying conceptual relationship because each SBML compartment must be
 * given a unique and separate identity.  {@link Compartment} types have no
 * mathematical meaning in SBML Level 2&mdash;they have no effect on a
 * model's mathematical interpretation.  Simulators and other numerical
 * analysis software may ignore {@link CompartmentType} definitions and references
 * to them in a model.
 * <p>
 * There is no mechanism in SBML for representing hierarchies of
 * compartment types.  One {@link CompartmentType} instance cannot be the subtype
 * of another {@link CompartmentType} instance; SBML provides no means of defining
 * such relationships.
 * <p>
 * As with other major structures in SBML, {@link CompartmentType} has a mandatory
 * attribute, 'id', used to give the compartment type an identifier.  The
 * identifier must be a text string conforming to the identifer syntax
 * permitted in SBML.  {@link CompartmentType} also has an optional 'name'
 * attribute, of type <code>string</code>.  The 'id' and 'name' must be used
 * according to the guidelines described in the SBML specification (e.g.,
 * Section 3.3 in the Level 2 Version 4 specification).
 * <p>
 * {@link CompartmentType} was introduced in SBML Level 2 Version 2.  It is not
 * available in earlier versions of Level 2 nor in any version of Level 1.
 * <p>
 * @see Compartment
 * @see ListOfCompartmentTypes
 * @see SpeciesType
 * @see ListOfSpeciesTypes
 * <p>
 * <p>
 */

public class CompartmentType extends SBase {
   private long swigCPtr;

   protected CompartmentType(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGCompartmentTypeUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(CompartmentType obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (CompartmentType obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_CompartmentType(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link CompartmentType}, optionally with the given <code>id</code> and 
   * <code>name</code> attribute values.
   * <p>
   * In SBML, identifiers are required for {@link CompartmentType} objects;
   * however, the identifier does not have to be set at the time of
   * creation of the object, and instead can be set using the setId()
   * method on the {@link SBase} parent class.
   * <p>
   * @param id a string, the identifier of this {@link CompartmentType} instance
   * @param name a string, the optional name of this {@link CompartmentType} instance
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public CompartmentType(String id, String name) {
    this(libsbmlJNI.new_CompartmentType__SWIG_0(id, name), true);
  }

  
  /**
   * Creates a new {@link CompartmentType}, optionally with the given <code>id</code> and 
   * <code>name</code> attribute values.
   * <p>
   * In SBML, identifiers are required for {@link CompartmentType} objects;
   * however, the identifier does not have to be set at the time of
   * creation of the object, and instead can be set using the setId()
   * method on the {@link SBase} parent class.
   * <p>
   * @param id a string, the identifier of this {@link CompartmentType} instance
   * @param name a string, the optional name of this {@link CompartmentType} instance
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public CompartmentType(String id) {
    this(libsbmlJNI.new_CompartmentType__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link CompartmentType}, optionally with the given <code>id</code> and 
   * <code>name</code> attribute values.
   * <p>
   * In SBML, identifiers are required for {@link CompartmentType} objects;
   * however, the identifier does not have to be set at the time of
   * creation of the object, and instead can be set using the setId()
   * method on the {@link SBase} parent class.
   * <p>
   * @param id a string, the identifier of this {@link CompartmentType} instance
   * @param name a string, the optional name of this {@link CompartmentType} instance
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public CompartmentType() {
    this(libsbmlJNI.new_CompartmentType__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link CompartmentType} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link CompartmentType} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link CompartmentType}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link CompartmentType}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link CompartmentType}
   * <p>
   * @note Once a {@link CompartmentType} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link CompartmentType}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public CompartmentType(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_CompartmentType__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link CompartmentType} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link CompartmentType} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link CompartmentType}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link CompartmentType}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link CompartmentType}
   * <p>
   * @note Once a {@link CompartmentType} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link CompartmentType}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public CompartmentType(long level, long version) {
    this(libsbmlJNI.new_CompartmentType__SWIG_4(level, version), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link CompartmentType}.
   */
 public CompartmentType(CompartmentType orig) {
    this(libsbmlJNI.new_CompartmentType__SWIG_5(CompartmentType.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link CompartmentType}.
   * <p>
   * @return a (deep) copy of this {@link CompartmentType}.
   */
 public CompartmentType cloneObject() {
    long cPtr = libsbmlJNI.CompartmentType_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, true);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.CompartmentType_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for
   * {@link CompartmentType}, is always <code>'compartmentType'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'compartmentType'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.CompartmentType_getElementName(swigCPtr, this);
  }

}
