/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * @deprecated libSBML internal 
 */

public class XMLInputStream {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLInputStream(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLInputStream obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLInputStream obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_XMLInputStream(swigCPtr);
    }
    swigCPtr = 0;
  }

  /**
   * Equality comparison method for XMLInputStream.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((XMLInputStream)(sb));
  }

  /**
   * Returns a hashcode for this XMLInputStream object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLInputStream(String content, boolean isFile, String library, XMLErrorLog errorLog) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_0(content, isFile, library, XMLErrorLog.getCPtr(errorLog), errorLog), true);
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLInputStream(String content, boolean isFile, String library) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_1(content, isFile, library), true);
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLInputStream(String content, boolean isFile) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_2(content, isFile), true);
  }

  
  /**
   * Creates a new XMLInputStream.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLInputStream(String content) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_3(content), true);
  }

  
  /**
   * @return the encoding of the XML stream.
   */
 public String getEncoding() {
    return libsbmlJNI.XMLInputStream_getEncoding(swigCPtr, this);
  }

  
  /**
   * @return the version of the XML stream.
   */
 public String getVersion() {
    return libsbmlJNI.XMLInputStream_getVersion(swigCPtr, this);
  }

  
  /**
   * @return an XMLErrorLog which can be used to log XML parse errors and
   * other validation errors (and messages).
   */
 public XMLErrorLog getErrorLog() {
    long cPtr = libsbmlJNI.XMLInputStream_getErrorLog(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLErrorLog(cPtr, false);
  }

  
  /**
   * @return true if end of file (stream) has been reached, false
   * otherwise.
   */
 public boolean isEOF() {
    return libsbmlJNI.XMLInputStream_isEOF(swigCPtr, this);
  }

  
  /**
   * @return true if a fatal error occurred while reading from this stream.
   */
 public boolean isError() {
    return libsbmlJNI.XMLInputStream_isError(swigCPtr, this);
  }

  
  /**
   * @return true if the stream is in a good state (i.e. isEOF() and
   * isError() are both false), false otherwise.
   */
 public boolean isGood() {
    return libsbmlJNI.XMLInputStream_isGood(swigCPtr, this);
  }

  
  /**
   * Consumes the next XMLToken and return it.
   * <p>
   * @return the next XMLToken or EOF (XMLToken.isEOF() == true).
   */
 public XMLToken next() {
    return new XMLToken(libsbmlJNI.XMLInputStream_next(swigCPtr, this), true);
  }

  
  /**
   * Returns the next XMLToken without consuming it.  A subsequent call to
   * either peek() or next() will return the same token.
   * <p>
   * @return the next XMLToken or EOF (XMLToken.isEOF() == true).
   */
 public XMLToken peek() {
    return new XMLToken(libsbmlJNI.XMLInputStream_peek(swigCPtr, this), false);
  }

  
  /**
   * Consume zero or more XMLTokens up to and including the corresponding
   * end XML element or EOF.
   */
 public void skipPastEnd(XMLToken element) {
    libsbmlJNI.XMLInputStream_skipPastEnd(swigCPtr, this, XMLToken.getCPtr(element), element);
  }

  
  /**
   * Consume zero or more XMLTokens up to but not including the next XML
   * element or EOF.
   */
 public void skipText() {
    libsbmlJNI.XMLInputStream_skipText(swigCPtr, this);
  }

  
  /**
   * Sets the XMLErrorLog this stream will use to log errors.
   */
 public void setErrorLog(XMLErrorLog log) {
    libsbmlJNI.XMLInputStream_setErrorLog(swigCPtr, this, XMLErrorLog.getCPtr(log), log);
  }

  
  /**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   */
 public String toString() {
    return libsbmlJNI.XMLInputStream_toString(swigCPtr, this);
  }

}
