/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Compartment construct.
 * <p>
 * A compartment in SBML represents a bounded space in which species are
 * located.  Compartments do not necessarily have to correspond to actual
 * structures inside or outside of a biological cell.
 * <p>
 * It is important to note that although compartments are optional in the
 * overall definition of {@link Model}, every species in an SBML model must be
 * located in a compartment.  This in turn means that if a model defines
 * any species, the model must also define at least one compartment.  The
 * reason is simply that species represent physical things, and therefore
 * must exist <em>somewhere</em>.  Compartments represent the <em>somewhere</em>.
 * <p>
 * {@link Compartment} has one required attribute, 'id', to give the compartment a
 * unique identifier by which other parts of an SBML model definition can
 * refer to it.  A compartment can also have an optional 'name' attribute
 * of type <code>string</code>.  Identifiers and names must be used according to the
 * guidelines described in the SBML specification (e.g., Section 3.3 in
 * the Level 2 Version 4 specification).
 * <p>
 * Each compartment in a model may optionally be designated as belonging to
 * a particular compartment type.  The optional attribute 'compartmentType'
 * is used identify the compartment type represented by the {@link Compartment}
 * structure.  The 'compartmentType' attribute's value must be the
 * identifier of a {@link CompartmentType} instance defined in the model.  If the
 * 'compartmentType' attribute is not present on a particular compartment
 * definition, a unique virtual compartment type is assumed for that
 * compartment, and no other compartment can belong to that compartment
 * type.  The values of 'compartmentType' attributes on compartments have
 * no effect on the numerical interpretation of a model.  Simulators and
 * other numerical analysis software may ignore 'compartmentType'
 * attributes.
 * <p>
 * {@link Compartment} also has an optional attribute 'spatialDimensions', whose
 * value must be a positive integer indicating the number of spatial
 * dimensions possessed by the compartment.  The maximum value is <code>3</code>,
 * meaning a three-dimensional structure (a volume).  Other permissible
 * values are <code>2</code> (for a two-dimensional area), <code>1</code> (for a
 * one-dimensional curve), and <code>0</code> (for a point).  The default value of
 * 'spatialDimensions' is <code>3</code>.
 * <p>
 * {@link Compartment} has another optional attribute named 'size', representing
 * the initial total size of the compartment.  The 'size' attribute must be
 * a floating-point value and may represent a volume (if the compartment is
 * a three-dimensional one), or an area (if the compartment is
 * two-dimensional), or a length (if the compartment is one-dimensional).
 * There is no default value of compartment size in SBML Level 2.  In
 * particular, a missing 'size' value <em>does not imply that the
 * compartment size is 1</em>.  (This is unlike the definition of
 * compartment 'volume' in SBML Level 1.)  When the compartment's
 * 'spatialDimensions' attribute does not have a value of <code>0</code>, a missing
 * value of 'size' for a given compartment signifies that the value either
 * is unknown, or to be obtained from an external source, or determined by
 * an {@link InitialAssignment}, {@link AssignmentRule}, {@link AlgebraicRule} or {@link RateRule}
 * elsewhere in the model.  The 'size' attribute must not be present if the
 * 'spatialDimensions' attribute has a value of <code>0</code>; otherwise, a logical
 * inconsistency would exist because a zero-dimensional object cannot have
 * a physical size.
 * <p>
 * The units associated with a compartment's 'size' attribute value may be
 * set using the optional {@link Compartment} attribute 'units'.  The default
 * units, and the kinds of units allowed as values of the attribute
 * 'units', interact with the number of spatial dimensions of the
 * compartment.  The value of the 'units' attribute of a {@link Compartment} object
 * must be one of the base units (see {@link Unit}), or the predefined unit
 * identifiers <code>volume</code>, <code>area</code>, <code>length</code> or <code>dimensionless</code>, or a new
 * unit defined by a {@link UnitDefinition} object in the enclosing {@link Model}, subject
 * to the restrictions detailed in the following table:
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
<caption class='top-caption'>Restrictions on values permitted for
compartment <code>size</code> and <code>units</code> attributes.</caption>
 <tr>
     <th align='left' valign='bottom'>
       Value of<br><code>spatialDimensions</code>
     </th>
     <th align='left' valign='bottom'>
       <code>size</code><br>allowed?
     </th>
     <th align='left' valign='bottom'>
       <code>units</code><br>allowed?
     </th>
     <th align='left' valign='bottom'>
	  Allowable kinds of units
     </th>
     <th align='left' valign='bottom'>
	  Default value of attribute <code>units</code>
     </th>
 </tr>
 <tr>
     <td>'<code>3</code>'</td>
     <td>yes</td>
     <td>yes</td>
     <td>units of volume, or <code>dimensionless</code></td>
     <td>'<code>volume</code>'</td>
 </tr>
 <tr>
     <td>'<code>2</code>'</td>
     <td>yes</td>
     <td>yes</td>
     <td>units of area, or <code>dimensionless</code></td>
     <td>'<code>area</code>'</td>
 </tr>
 <tr>
     <td>'<code>1</code>'</td>
     <td>yes</td>
     <td>yes</td>
     <td>units of length, or <code>dimensionless</code></td>
     <td>'<code>length</code>'</td>
 </tr>
 <tr>
     <td>'<code>0</code>'</td>
     <td>no</td>
     <td>no</td>
     <td>(no units allowed)</td>
     <td></td>
 </tr>
 </tr>
</table>
</center>

 * <p>
 * In SBML Level 2, the units of the compartment size, as defined by the
 * 'units' attribute or (if 'units' is not set) the default value listed in
 * the table above, are used in the following ways when the compartment has
 * a 'spatialDimensions' value greater than <code>0</code>:
 * <ul>
 * <li> The value of the 'units' attribute is used as the units of the
 * compartment identifier when the identifier appears as a numerical
 * quantity in a mathematical formula expressed in MathML.
 * <p>
 * <li> The <code>math</code> element of an {@link AssignmentRule} or {@link InitialAssignment}
 * referring to this compartment must have identical units.
 * <p>
 * <li> In {@link RateRule} objects that set the rate of change of the compartment's
 * size, the units of the rule's <code>math</code> element must be identical to the
 * compartment's 'units' attribute divided by the default <em>time</em> units.
 * (In other words, the units for the rate of change of compartment size
 * are <em>compartment size</em>/<em>time</em> units.
 * <p>
 * <li> When a {@link Species} is to be treated in terms of concentrations or
 * density, the units of the spatial size portion of the concentration
 * value (i.e., the denominator in the units formula <em>substance</em>/
 * <em>size</em>) are those indicated by the value of the 'units' attribute on the
 * compartment in which the species is located.
 * </ul>
 * <p>
 * Compartments with 'spatialDimensions'=<code>0</code> require special treatment in
 * this framework.  If a compartment has no size or dimensional units, how
 * should such a compartment's identifier be interpreted when it appears in
 * mathematical formulas?  The answer is that such a compartment's
 * identifier should not appear in mathematical formulas in the first
 * place&mdash;it has no value, and its value cannot change.  Note also
 * that a zero-dimensional compartment is a point, and species located at
 * points can only be described in terms of amounts, not
 * spatially-dependent measures such as concentration.  Since SBML
 * {@link KineticLaw} formulas are already in terms of <em>substance</em>/<em>time</em> and
 * not (say) <em>concentration</em>/<em>time</em>, volume or other factors in
 * principle are not needed for species located in zero-dimensional
 * compartments.
 * <p>
 * {@link Compartment} has another optional attribute named 'constant'.  This takes
 * a boolean value indicating whether the compartment's size stays constant
 * or can vary during a simulation.  A value of <code>false</code> indicates the
 * compartment's 'size' can be changed by other constructs in SBML.  A
 * value of <code>true</code> indicates the compartment's 'size' cannot be changed by
 * any other construct except {@link InitialAssignment}.  In the special case of
 * 'spatialDimensions'=<code>0</code>, the value cannot be changed by
 * {@link InitialAssignment} either.  The default value for the 'constant'
 * attribute is <code>true</code> because in the most common modeling scenarios at
 * the time of this writing, compartment sizes remain constant.  The
 * 'constant' attribute must default to or be set to <code>true</code> if the value
 * of the 'spatialDimensions' attribute is <code>0</code>, because a zero-dimensional
 * compartment cannot ever have a size.
 * <p>
 * Finally, {@link Compartment} has an optional attribute named 'outside', whose
 * value can be the identifier of another {@link Compartment} object defined in the
 * enclosing {@link Model} object.  Doing so means that the other compartment
 * contains it or is outside of it.  This enables the representation of
 * simple topological relationships between compartments, for those
 * simulation systems that can make use of the information (e.g., for
 * drawing simple diagrams of compartments).  There are two restrictions on
 * the containment relationships in SBML.  First, because a compartment
 * with 'spatialDimensions' of <code>0</code> has no size, such a compartment cannot
 * act as the container of any other compartment <em>except</em> compartments
 * that <em>also</em> have 'spatialDimensions' values of <code>0</code>.  Second, the
 * directed graph formed by representing {@link Compartment} structures as vertexes
 * and the 'outside' attribute values as edges must be acyclic.  The latter
 * condition is imposed to prevent a compartment from being contained
 * inside itself.  In the absence of a value for 'outside', compartment
 * definitions in SBML Level 2 do not have any implied spatial
 * relationships between each other.
 * <p>
 * It is worth noting that in SBML, there is no relationship between
 * compartment sizes when compartment positioning is expressed using the
 * 'outside' attribute.  The size of a given compartment does not in any
 * sense include the sizes of other compartments having it as the value of
 * their 'outside' attributes.  In other words, if a compartment <em>B</em> has
 * the identifier of compartment <em>A</em> as its 'outside' attribute value,
 * the size of <em>A</em> does not include the size of <em>B</em>.  The compartment
 * sizes are separate.
 * <p>
 * @note the 'size' attribute on a compartment must be defined as optional;
 * however, <em>it is extremely good practice to specify values for
 * compartment sizes</em> when such values are available.  There are three
 * major technical reasons for this.  First, if the model contains any
 * species whose initial amounts are given in terms of concentrations, and
 * there is at least one reaction in the model referencing such a species,
 * then the model is numerically incomplete if it lacks a value for the
 * size of the compartment in which the species is located.  The reason is
 * simply that SBML {@link Reaction} objects defined in units of
 * <em>substance</em>/<em>time</em>, not concentration per time, and
 * thus the compartment size must at some point be used to convert from
 * species concentration to substance units.  Second, models ideally should
 * be instantiable in a variety of simulation frameworks.  A commonly-used
 * one is the discrete stochastic framework in which species are
 * represented as item counts (e.g., molecule counts).  If species' initial
 * quantities are given in terms of concentrations or densities, it is
 * impossible to convert the values to item counts without knowing
 * compartment sizes.  Third, if a model contains multiple compartments
 * whose sizes are not all identical to each other, it is impossible to
 * quantify the reaction rate expressions without knowing the compartment
 * volumes.  The reason for the latter is again that reaction rates in SBML
 * are defined in terms of <em>substance</em>/<em>time</em>, and when
 * species quantities are given in terms of concentrations or densities,
 * the compartment sizes become factors in the reaction rate expressions.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Compartment extends SBase {
   private long swigCPtr;

   protected Compartment(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGCompartmentUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Compartment obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Compartment obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Compartment(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Compartment} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Compartment}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Compartment}
   * <p>
   * @note Once a {@link Compartment} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> for the document <em>override</em> those used
   * to create the {@link Compartment}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public Compartment(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Compartment} using the given {@link SBMLNamespaces} object 
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp; Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a {@link Compartment} is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method {@link SBase#setId(String id)} .
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Once a {@link Compartment} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Compartment}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public Compartment(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of a {@link Compartment}.
   * <p>
   * @param orig the {@link Compartment} instance to copy.
   */
 public Compartment(Compartment orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Compartment__SWIG_2(Compartment.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Compartment}.
   * <p>
   * @return a (deep) copy of this {@link Compartment}.
   */
 public Compartment cloneObject() {
    long cPtr = libsbmlJNI.Compartment_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Compartment(cPtr, true);
  }

  
  /**
   * Initializes the fields of this {@link Compartment} to the defaults defined in
   * the specification of the relevant Level/Version of SBML.
   * <ul>
   * <li> (SBML Level 1 only) sets attribute 'volume' to <code>1</code>.0
   * <li> (SBML Level 2 only) sets attribute 'spatialDimensions' to <code>3</code>
   * <li> (SBML Level 2 only) sets attribute 'constant' to <code>1</code> (true)
   * </ul>
   */
 public void initDefaults() {
    libsbmlJNI.Compartment_initDefaults(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'id' attribute of this {@link Compartment}.
   * <p>
   * @return the id of this {@link Compartment}.
   */
 public String getId() {
    return libsbmlJNI.Compartment_getId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'name' attribute of this {@link Compartment}.
   * <p>
   * @return the name of this {@link Compartment}.
   */
 public String getName() {
    return libsbmlJNI.Compartment_getName(swigCPtr, this);
  }

  
  /**
   * Get the compartment type of this {@link Compartment}, as indicated by the
   * {@link Compartment} object's 'compartmentType' attribute value.
   * <p>
   * @return the value of the 'compartmentType' attribute of this
   * {@link Compartment} as a string.
   */
 public String getCompartmentType() {
    return libsbmlJNI.Compartment_getCompartmentType(swigCPtr, this);
  }

  
  /**
   * Get the number of spatial dimensions of this {@link Compartment} object.
   * <p>
   * @return the value of the 'spatialDimensions' attribute of this
   * {@link Compartment} as a long integereger
   */
 public long getSpatialDimensions() {
    return libsbmlJNI.Compartment_getSpatialDimensions(swigCPtr, this);
  }

  
  /**
   * Get the size of this {@link Compartment}
   * <p>
   * This method is identical to getVolume().  In SBML Level 1,
   * compartments are always three-dimensional constructs and only have
   * volumes, whereas in SBML Level 2, compartments may be other than
   * three-dimensional and therefore the 'volume' attribute is named 'size'
   * in Level 2.  LibSBML provides both getSize() and getVolume() for
   * easier compatibility between SBML Levels.
   * <p>
   * @return the value of the 'size' attribute ('volume' in Level 1) of
   * this {@link Compartment} as a float-point number.
   * <p>
   * @see #isSetSize()
   */
 public double getSize() {
    return libsbmlJNI.Compartment_getSize(swigCPtr, this);
  }

  
  /**
   * (For SBML Level 1) Get the volume of this {@link Compartment}
   * <p>
   * This method is identical to getSize().  In SBML Level 1, compartments
   * are always three-dimensional constructs and only have volumes, whereas
   * in SBML Level 2, compartments may be other than three-dimensional and
   * therefore the 'volume' attribute is named 'size' in Level 2.  LibSBML
   * provides both getSize() and getVolume() for easier compatibility
   * between SBML Levels.
   * <p>
   * @return the value of the 'volume' attribute ('size' in Level 2) of
   * this {@link Compartment}, as a floating-point number.
   * <p>
   * @see #isSetVolume()
   */
 public double getVolume() {
    return libsbmlJNI.Compartment_getVolume(swigCPtr, this);
  }

  
  /**
   * Get the units of this compartment's size or volume.
   * <p>
   * @return the value of the 'units' attribute of this {@link Compartment}.
   */
 public String getUnits() {
    return libsbmlJNI.Compartment_getUnits(swigCPtr, this);
  }

  
  /**
   * Get the identifier, if any, of the compartment that is designated
   * as being outside of this one.
   * <p>
   * @return the value of the 'outside' attribute of this {@link Compartment}.
   */
 public String getOutside() {
    return libsbmlJNI.Compartment_getOutside(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'constant' attribute of this {@link Compartment}.
   * <p>
   * @return <code>true</code> if this {@link Compartment}'s size is flagged as being
   * constant, <code>false</code> otherwise.
   */
 public boolean getConstant() {
    return libsbmlJNI.Compartment_getConstant(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Compartment}'s 'id' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'id' attribute of this {@link Compartment} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetId() {
    return libsbmlJNI.Compartment_isSetId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Compartment}'s 'name' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'name' attribute of this {@link Compartment} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetName() {
    return libsbmlJNI.Compartment_isSetName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Compartment}'s 'compartmentType' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'compartmentType' attribute of this {@link Compartment}
   * has been set, <code>false</code> otherwise.
   */
 public boolean isSetCompartmentType() {
    return libsbmlJNI.Compartment_isSetCompartmentType(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Compartment}'s 'size' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This method is similar but not identical to isSetVolume().  The latter
   * should be used in the context of SBML Level 1 models instead of
   * isSetSize() because isSetVolume() performs extra processing to take
   * into account the difference in default values between SBML Levels 1
   * and 2.
   * <p>
   * @return <code>true</code> if the 'size' attribute ('volume' in Level) of this
   * {@link Compartment} has been set, <code>false</code> otherwise.
   * <p>
   * @see #isSetVolume()
   * @see #setSize(double value)
   */
 public boolean isSetSize() {
    return libsbmlJNI.Compartment_isSetSize(swigCPtr, this);
  }

  
  /**
   * (For SBML Level 1) Predicate returning <code>true</code> or <code>false</code> depending
   * on whether this {@link Compartment}'s 'volume' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This method is similar but not identical to isSetSize().  The latter
   * should not be used in the context of SBML Level 1 models because this
   * method (isSetVolume()) performs extra processing to take into account
   * the difference in default values between SBML Levels 1 and 2.
   * <p>
   * @return <code>true</code> if the 'volume' attribute ('size' in L2) of this
   * {@link Compartment} has been set, <code>false</code> otherwise.
   * <p>
   * @see #isSetSize()
   * @see #setVolume(double value)
   * <p>
   * @note In SBML Level 1, a compartment's volume has a default value (
   * <code>1</code>.0) and therefore this method will always return <code>true</code>.  In Level
   * 2, a compartment's size (the equivalent of SBML Level 1's 'volume') is
   * optional and has no default value, and therefore may or may not be
   * set.
   */
 public boolean isSetVolume() {
    return libsbmlJNI.Compartment_isSetVolume(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Compartment}'s 'units' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'units' attribute of this {@link Compartment} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetUnits() {
    return libsbmlJNI.Compartment_isSetUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Compartment}'s 'outside' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'outside' attribute of this {@link Compartment} has
   * been set, <code>false</code> otherwise.
   */
 public boolean isSetOutside() {
    return libsbmlJNI.Compartment_isSetOutside(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'id' attribute of this {@link Compartment}.
   * <p>
   * The string <code>sid</code> is copied.  Note that SBML has strict requirements
   * for the syntax of identifiers.  The following is summary of the
   * definition of the SBML identifier type <code>SId</code> (here expressed in an
   * extended form of BNF notation):
   * <div class='fragment'><pre>
   *   letter .= 'a'..'z','A'..'Z'
   *   digit  .= '0'..'9'
   *   idChar .= letter | digit | '_'
   *   SId    .= ( letter | '_' ) idChar</pre></div>
   * The equality of SBML identifiers is determined by an exact character
   * sequence match; i.e., comparisons must be performed in a
   * case-sensitive manner.  In addition, there are a few conditions for
   * the uniqueness of identifiers in an SBML model.  Please consult the
   * SBML specifications for the exact formulations.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the string to use as the identifier of this {@link Compartment}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
 public int setId(String sid) {
    return libsbmlJNI.Compartment_setId(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'name' attribute of this {@link Compartment}.
   * <p>
   * The string in <code>name</code> is copied.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param name the new name for the {@link Compartment}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
 public int setName(String name) {
    return libsbmlJNI.Compartment_setName(swigCPtr, this, name);
  }

  
  /**
   * Sets the 'compartmentType' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of a {@link CompartmentType} object defined
   * elsewhere in this {@link Model}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   */
 public int setCompartmentType(String sid) {
    return libsbmlJNI.Compartment_setCompartmentType(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'spatialDimensions' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * If <code>value</code> is not one of <code>0</code>, <code>1</code>, <code>2</code>, or <code>3</code>, this method will
   * have no effect (i.e., the 'spatialDimensions' attribute will not be
   * set).
   * <p>
   * @param value a long integereger indicating the number of dimensions
   * of this compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   */
 public int setSpatialDimensions(long value) {
    return libsbmlJNI.Compartment_setSpatialDimensions(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'size' attribute (or 'volume' in SBML Level 1) of this
   * {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This method is identical to setVolume() and is provided for
   * compatibility between SBML Level 1 and Level 2.
   * <p>
   * @param value a <code>double</code> representing the size of this compartment
   * instance in whatever units are in effect for the compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int setSize(double value) {
    return libsbmlJNI.Compartment_setSize(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'volume' attribute (or 'size' in SBML Level 2) of this
   * {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This method is identical to setVolume() and is provided for
   * compatibility between SBML Level 1 and Level 2.
   * <p>
   * @param value a <code>double</code> representing the volume of this compartment
   * instance in whatever units are in effect for the compartment.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int setVolume(double value) {
    return libsbmlJNI.Compartment_setVolume(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'units' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of the defined units to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
 public int setUnits(String sid) {
    return libsbmlJNI.Compartment_setUnits(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'outside' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of a compartment that encloses this one.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
 public int setOutside(String sid) {
    return libsbmlJNI.Compartment_setOutside(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'constant' attribute of this {@link Compartment}.
   * <p>
   * @param value a boolean indicating whether the size/volume of this
   * compartment should be considered constant (<code>true</code>) or variable (
   * <code>false</code>)
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   */
 public int setConstant(boolean value) {
    return libsbmlJNI.Compartment_setConstant(swigCPtr, this, value);
  }

  
  /**
   * Unsets the value of the 'name' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetName() {
    return libsbmlJNI.Compartment_unsetName(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'compartmentType' attribute of this
   * {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @see #setCompartmentType(String sid)
   * @see #isSetCompartmentType()
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetCompartmentType() {
    return libsbmlJNI.Compartment_unsetCompartmentType(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'size' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int unsetSize() {
    return libsbmlJNI.Compartment_unsetSize(swigCPtr, this);
  }

  
  /**
   * (For SBML Level 1) Unsets the value of the 'volume' attribute of this
   * {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * In SBML Level 1, a {@link Compartment} volume has a default value (1.0) and
   * therefore <em>should always be set</em>.  In Level 2, 'size' is
   * optional with no default value and as such may or may not be set.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int unsetVolume() {
    return libsbmlJNI.Compartment_unsetVolume(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'units' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetUnits() {
    return libsbmlJNI.Compartment_unsetUnits(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'outside' attribute of this {@link Compartment}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetOutside() {
    return libsbmlJNI.Compartment_unsetOutside(swigCPtr, this);
  }

  
  /**
   * Constructs and returns a {@link UnitDefinition} that corresponds to the units
   * of this {@link Compartment}'s designated size.
   * <p>
   * Compartments in SBML have an attribute ('units') for declaring the
   * units of measurement intended for the value of the compartment's size.
   * In the absence of a value given for this attribute, the units are
   * taken from the model's definition of <code>'volume'</code>, <code>'area'</code>, 
   * <code>'length'</code> units, depending on the value given to this {@link Compartment}'s
   * 'size' attribute, or (if the {@link Model} does not redefine them) the
   * corresponding SBML default units for those quantities.  Following that
   * procedure, the method getDerivedUnitDefinition() returns a
   * {@link UnitDefinition} based on the interpreted units of this compartment's
   * size.
   * <p>
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return NULL.
   * <p>
   * Note also that unit declarations for {@link Compartment} are in terms of the
   * <em>identifier</em> of a unit, but this method returns a {@link UnitDefinition}
   * object, not a unit identifier.  It does this by constructing an
   * appropriate {@link UnitDefinition}.  Callers may find this particularly useful
   * when used in conjunction with the helper methods on {@link UnitDefinition} for
   * comparing different {@link UnitDefinition} objects.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of this 
   * {@link Compartment}.
   * <p>
   * @see #getUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.Compartment_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Compartment_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Compartment}, is
   * always <code>'compartment'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'compartment'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.Compartment_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * all the required attributes for this {@link Compartment} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link Compartment} object are:
   * id (name in L1)
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.Compartment_hasRequiredAttributes(swigCPtr, this);
  }

}
