/*
 *
 * @file    TestXMLError.java
 * @brief   XMLError unit tests, C++ version
 *
 * @author  Akiya Jouraku (Java conversion)
 * @author  Michael Hucka 
 *
 * $Id: TestXMLError.java 9655 2009-06-23 09:01:29Z ajouraku $
 * $HeadURL: https://sbml.svn.sourceforge.net/svnroot/sbml/branches/libsbml-4/src/bindings/java/test/org/sbml/libsbml/test/xml/TestXMLError.java $
 *
 * This test file was converted from src/sbml/test/TestXMLError.cpp
 * with the help of conversion sciprt (ctest_converter.pl).
 *
 *<!---------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright 2005-2009 California Institute of Technology.
 * Copyright 2002-2005 California Institute of Technology and
 *                     Japan Science and Technology Corporation.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 *--------------------------------------------------------------------------->*/


package org.sbml.libsbml.test.xml;

import org.sbml.libsbml.*;

import java.io.File;
import java.lang.AssertionError;

public class TestXMLError {

  static void assertTrue(boolean condition) throws AssertionError
  {
    if (condition == true)
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      return;
    }
    else if (a.equals(b))
    {
      return;
    }

    throw new AssertionError();
  }

  static void assertNotEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      throw new AssertionError();
    }
    else if (a.equals(b))
    {
      throw new AssertionError();
    }
  }

  static void assertEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(int a, int b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(int a, int b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  public void test_XMLError_create()
  {
    XMLError error = new XMLError();
    assertTrue( error != null );
    error = null;
    error = new XMLError(libsbml.DuplicateXMLAttribute);
    assertTrue( error.getErrorId() == libsbml.DuplicateXMLAttribute );
    assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_ERROR );
    assertTrue( error.getSeverityAsString().equals( "Error" ) );
    assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_XML );
    assertTrue( error.getCategoryAsString().equals( "XML content") );
    assertTrue( error.getMessage().equals( "Duplicate XML attribute." ) );
    assertTrue( error.getShortMessage().equals( "Duplicate attribute" ) );
    error = null;
    error = new XMLError(12345, "My message");
    assertTrue( error.getErrorId() == 12345 );
    assertTrue( error.getMessage().equals( "My message" ) );
    assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_FATAL );
    assertTrue( error.getSeverityAsString().equals( "Fatal" ) );
    assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_INTERNAL );
    assertTrue( error.getCategoryAsString().equals( "Internal") );
    error = null;
    error = new XMLError(12345, "My message",0,0,libsbml.LIBSBML_SEV_INFO,libsbml.LIBSBML_CAT_SYSTEM);
    assertTrue( error.getErrorId() == 12345 );
    assertTrue( error.getMessage().equals( "My message" ) );
    assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_INFO );
    assertTrue( error.getSeverityAsString().equals( "Informational" ) );
    assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_SYSTEM );
    assertTrue( error.getCategoryAsString().equals( "Operating system") );
    assertEquals( true, error.isInfo() );
    assertEquals( true, error.isSystem() );
    error = null;
    error = new XMLError(10000, "Another message",0,0,libsbml.LIBSBML_SEV_FATAL,libsbml.LIBSBML_CAT_XML);
    assertTrue( error.getErrorId() == 10000 );
    assertTrue( error.getMessage().equals( "Another message" ) );
    assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_FATAL );
    assertTrue( error.getSeverityAsString().equals( "Fatal" ) );
    assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_XML );
    assertTrue( error.getCategoryAsString().equals( "XML content") );
    assertEquals( true, error.isFatal() );
    assertEquals( true, error.isXML() );
    error = null;
  }

  public void test_XMLError_setters()
  {
    XMLError error = new XMLError();
    assertTrue( error != null );
    long i = error.setLine(23);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
    assertTrue( error.getLine() == 23 );
    i = error.setColumn(45);
    assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS );
    assertTrue( error.getColumn() == 45 );
    error = null;
  }

  /**
   * Loads the SWIG-generated libSBML Java module when this class is
   * loaded, or reports a sensible diagnostic message about why it failed.
   */
  static
  {
    String varname;
    String shlibname;

    if (System.getProperty("mrj.version") != null)
    {
      varname = "DYLD_LIBRARY_PATH";    // We're on a Mac.
      shlibname = "libsbmlj.jnilib and/or libsbml.dylib";
    }
    else
    {
      varname = "LD_LIBRARY_PATH";      // We're not on a Mac.
      shlibname = "libsbmlj.so and/or libsbml.so";
    }

    try
    {
      System.loadLibrary("sbmlj");
      // For extra safety, check that the jar file is in the classpath.
      Class.forName("org.sbml.libsbml.libsbml");
    }
    catch (SecurityException e)
    {
      e.printStackTrace();
      System.err.println("Could not load the libSBML library files due to a"+
                         " security exception.\n");
      System.exit(1);
    }
    catch (UnsatisfiedLinkError e)
    {
      e.printStackTrace();
      System.err.println("Error: could not link with the libSBML library files."+
                         " It is likely\nyour " + varname +
                         " environment variable does not include the directories\n"+
                         "containing the " + shlibname + " library files.\n");
      System.exit(1);
    }
    catch (ClassNotFoundException e)
    {
      e.printStackTrace();
      System.err.println("Error: unable to load the file libsbmlj.jar."+
                         " It is likely\nyour -classpath option and CLASSPATH" +
                         " environment variable\n"+
                         "do not include the path to libsbmlj.jar.\n");
      System.exit(1);
    }
  }
}
