/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of MIRIAM-compliant model history data.
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * The SBML specification beginning with Level 2 Version 2 defines a
 * standard approach to recording model history and model creator
 * information in a form that complies with MIRIAM ('Minimum Information
 * Requested in the Annotation of biochemical Models', <i>Nature
 * Biotechnology</i>, vol. 23, no. 12, Dec. 2005).  LibSBML provides the
 * {@link ModelHistory} class as a convenience high-level interface for working
 * with model history data.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class ModelHistory {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected ModelHistory(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(ModelHistory obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ModelHistory obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ModelHistory(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for ModelHistory.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((ModelHistory)(sb));
  }

  /**
   * Returns a hashcode for this ModelHistory object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new {@link ModelHistory}.
   */
 public ModelHistory() {
    this(libsbmlJNI.new_ModelHistory__SWIG_0(), true);
  }

  
  /**
  * Copy constructor; creates a copy of the {@link ModelHistory}.
  */
 public ModelHistory(ModelHistory orig) {
    this(libsbmlJNI.new_ModelHistory__SWIG_1(ModelHistory.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a copy of this {@link ModelHistory}.
   * <p>
   * @return a (deep) copy of this {@link ModelHistory}.
   */
 public ModelHistory cloneObject() {
    long cPtr = libsbmlJNI.ModelHistory_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelHistory(cPtr, true);
  }

  
  /**
   * Returns the createdDate from the {@link ModelHistory}.
   * <p>
   * @return {@link Date} object representing the createdDate
   * from the {@link ModelHistory}.
   */
 public Date getCreatedDate() {
    long cPtr = libsbmlJNI.ModelHistory_getCreatedDate(swigCPtr, this);
    return (cPtr == 0) ? null : new Date(cPtr, false);
  }

  
  /**
   * Returns the modifiedDate from the {@link ModelHistory}.
   * <p>
   * @return {@link Date} object representing the modifiedDate
   * from the {@link ModelHistory}.
   */
 public Date getModifiedDate() {
    long cPtr = libsbmlJNI.ModelHistory_getModifiedDate__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Date(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelHistory}'s createdDate has been set.
   * <p>
   * @return <code>true</code> if the createdDate of this {@link ModelHistory} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetCreatedDate() {
    return libsbmlJNI.ModelHistory_isSetCreatedDate(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelHistory}'s modifiedDate has been set.
   * <p>
   * @return <code>true</code> if the modifiedDate of this {@link ModelHistory} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetModifiedDate() {
    return libsbmlJNI.ModelHistory_isSetModifiedDate(swigCPtr, this);
  }

  
  /**
   * Sets the createdDate.
   * <p>
   * @param date a {@link Date} object representing the date
   * the {@link ModelHistory} was created. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   */
 public int setCreatedDate(Date date) {
    return libsbmlJNI.ModelHistory_setCreatedDate(swigCPtr, this, Date.getCPtr(date), date);
  }

  
  /**
   * Sets the modifiedDate.
   * <p>
   * @param date a {@link Date} object representing the date
   * the {@link ModelHistory} was modified. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   */
 public int setModifiedDate(Date date) {
    return libsbmlJNI.ModelHistory_setModifiedDate(swigCPtr, this, Date.getCPtr(date), date);
  }

  
  /**
   * Adds a modifiedDate.
   * <p>
   * @param date a {@link Date} object representing the date
   * the {@link ModelHistory} was modified. 
   */
 public int addModifiedDate(Date date) {
    return libsbmlJNI.ModelHistory_addModifiedDate(swigCPtr, this, Date.getCPtr(date), date);
  }

  
  /**
   * Get the list of ModifiedDate objects in this 
   * {@link ModelHistory}.
   * <p>
   * @return the list of ModifiedDates for this {@link ModelHistory}.
   */
 public  DateList  getListModifiedDates() { 
  long cPtr = libsbmlJNI.ModelHistory_getListModifiedDates(swigCPtr, this);
  return (cPtr == 0) ? null : new  DateList(cPtr, true);
}

  
  /**
   * Get the nth {@link Date} object in the list of ModifiedDates
   * in this {@link ModelHistory}.
   * <p>
   * @return the nth {@link Date} in the list of ModifiedDates of 
   * this {@link ModelHistory}.
   */
 public Date getModifiedDate(long n) {
    long cPtr = libsbmlJNI.ModelHistory_getModifiedDate__SWIG_1(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Date(cPtr, false);
  }

  
  /**
   * Get the number of ModifiedDate objects in this 
   * {@link ModelHistory}.
   * <p>
   * @return the number of ModifiedDates in this 
   * {@link ModelHistory}.
   */
 public long getNumModifiedDates() {
    return libsbmlJNI.ModelHistory_getNumModifiedDates(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link ModelCreator} object to 
   * this {@link ModelHistory}.
   * <p>
   * @param mc the {@link ModelCreator} to add
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int addCreator(ModelCreator mc) {
    return libsbmlJNI.ModelHistory_addCreator(swigCPtr, this, ModelCreator.getCPtr(mc), mc);
  }

  
  /**
   * Get the list of {@link ModelCreator} objects in this 
   * {@link ModelHistory}.
   * <p>
   * @return the list of ModelCreators for this {@link ModelHistory}.
   */
 public  ModelCreatorList  getListCreators() { 
  long cPtr = libsbmlJNI.ModelHistory_getListCreators(swigCPtr, this);
  return (cPtr == 0) ? null : new  ModelCreatorList(cPtr, true);
}

  
  /**
   * Get the nth {@link ModelCreator} object in this {@link ModelHistory}.
   * <p>
   * @return the nth {@link ModelCreator} of this {@link ModelHistory}.
   */
 public ModelCreator getCreator(long n) {
    long cPtr = libsbmlJNI.ModelHistory_getCreator(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ModelCreator(cPtr, false);
  }

  
  /**
   * Get the number of {@link ModelCreator} objects in this 
   * {@link ModelHistory}.
   * <p>
   * @return the number of ModelCreators in this 
   * {@link ModelHistory}.
   */
 public long getNumCreators() {
    return libsbmlJNI.ModelHistory_getNumCreators(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link ModelCreator} objects in this 
   * {@link ModelHistory}.
   * <p>
   * @return the number of ModelCreators in this 
   * {@link ModelHistory}.
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.ModelHistory_hasRequiredAttributes(swigCPtr, this);
  }

}
