/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Trigger construct for Event.
 * <p>
 * An {@link Event} object defines when the event can occur, the variables that
 * are affected by the event, and how the variables are affected.  The
 * {@link Trigger} construct in SBML is used to define a mathematical expression
 * that determines when an {@link Event} <em>fires</em>.
 * <p>
 * A {@link Trigger} contains one subelement named 'math' containing a MathML
 * expression.  The expression must evaluate to a value of type <code>boolean</code>.
 * The exact moment at which the expression evaluates to <code>true</code> is the
 * time point when the {@link Event} is <em>fired</em>.
 * <p>
 * An event only fires when its {@link Trigger} expression makes the transition in
 * value from <code>false</code> to <code>true</code>.  The event will also fire at any future
 * time points when the trigger expression makes this transition; in other
 * words, an event can fire multiple times during a simulation if its
 * trigger condition makes the transition from <code>false</code> to <code>true</code> more
 * than once.
 * <p>
 * An important question is whether an event can fire prior to, or at,
 * initial simulation time, that is <em>t &lt; 0</em>.  The answer is no:
 * an event can only be triggered immediately after initial simulation time
 * i.e., <em>t &gt; 0</em>.
 * <p>
 * @see Event
 * @see Delay
 * @see EventAssignment
 */

public class Trigger extends SBase {
   private long swigCPtr;

   protected Trigger(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGTriggerUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Trigger obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Trigger obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Trigger(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Trigger} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Trigger}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Trigger}
   * <p>
   * @note Upon the addition of a {@link Trigger} object to an {@link SBMLDocument} (e.g.,
   * using Model.addTrigger()), the SBML Level, SBML Version and
   * XML namespace of the document <em>override</em> the values used when
   * creating the {@link Trigger} object via this constructor.  This is necessary
   * to ensure that an SBML document is a consistent structure.
   * Nevertheless, the ability to supply the values at the time of creation
   * of a {@link Trigger} is an important aid to producing valid SBML.  Knowledge
   * of the intented SBML Level and Version determine whether it is valid
   * to assign a particular value to an attribute, or whether it is valid
   * to add an object to an existing {@link SBMLDocument}.
   */
 public Trigger(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Trigger__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Trigger} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of a {@link Trigger} object to an {@link SBMLDocument} (e.g.,
   * using Model.addTrigger()), the SBML XML namespace of the document 
   * <em>overrides</em> the value used when creating the {@link Trigger} object via this
   * constructor.  This is necessary to ensure that an SBML document is a
   * consistent structure.  Nevertheless, the ability to supply the values
   * at the time of creation of a {@link Trigger} is an important aid to producing
   * valid SBML.  Knowledge of the intented SBML Level and Version
   * determine whether it is valid to assign a particular value to an
   * attribute, or whether it is valid to add an object to an existing
   * {@link SBMLDocument}.
   */
 public Trigger(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Trigger__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link Trigger}.
   */
 public Trigger(Trigger orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Trigger__SWIG_2(Trigger.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Trigger}.
   * <p>
   * @return a (deep) copy of this {@link Trigger}.
   */
 public Trigger cloneObject() {
    long cPtr = libsbmlJNI.Trigger_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, true);
  }

  
  /**
   * Get the mathematical formula for the trigger and return it
   * as an AST.
   * <p>
   * @return the math of this {@link Trigger}.
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.Trigger_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Predicate to test whether the math for this trigger has been set.
   * <p>
   * @return <code>true</code> if the formula (meaning the 'math' subelement) of
   * this {@link Trigger} has been set, <code>false</code> otherwise.
   */
 public boolean isSetMath() {
    return libsbmlJNI.Trigger_isSetMath(swigCPtr, this);
  }

  
  /**
   * Sets the trigger expression of this {@link Trigger} instance to a copy of the given
   * {@link ASTNode}.
   * <p>
   * @param math an {@link ASTNode} representing a formula tree.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }!
   */
 public int setMath(ASTNode math) {
    return libsbmlJNI.Trigger_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Trigger_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Trigger}, is
   * always <code>'trigger'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'trigger'</code>. 
   */
 public String getElementName() {
    return libsbmlJNI.Trigger_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required elements for this {@link Trigger} object
   * have been set.
   * <p>
   * @note The required elements for a {@link Trigger} object are:
   * math
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.Trigger_hasRequiredElements(swigCPtr, this);
  }

}
