/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.0
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of MIRIAM-compliant controlled vocabulary annotation.
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * {@link CVTerm} is a libSBML construct used as part of the libSBML support for
 * annotations conforming to the guidelines specified by MIRIAM ('Minimum
 * Information Requested in the Annotation of biochemical Models').  The
 * general scheme is as follows.  A set of RDF-based annotations attached
 * to a given SBML <code>&lt;annotation&gt;</code> element are read by
 * {@link RDFAnnotationParser} and converted into a list of {@link CVTerm} objects.  Each
 * {@link CVTerm} object instance stores the following components of an annotation:
 * <p>
 * <ul>
 * <li>The qualifier, which can be a MIRIAM 'biological qualifier', a
 * 'model qualifier', or an unknown qualifier (as far as the {@link CVTerm} class
 * is concerned).  Qualifiers are used in MIRIAM to indicate the nature of
 * the relationship between the object being annotated and the resource.
 * In {@link CVTerm}, the qualifiers can be manipulated using the methods
 * {@link CVTerm#getQualifierType()},
 * {@link CVTerm#setQualifierType(int type)},
 * and related methods.
 * <p>
 * <li>The resource, represent by a URI (note: not a URL).  In {@link CVTerm}, the
 * resource component can be manipulated using the methods
 * {@link CVTerm#addResource(String resource)}
 * and {@link CVTerm#removeResource(String resource)}.
 * </ul>
 */

public class CVTerm {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected CVTerm(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(CVTerm obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (CVTerm obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_CVTerm(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for CVTerm.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((CVTerm)(sb));
  }

  /**
   * Returns a hashcode for this CVTerm object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new {@link CVTerm}, optionally with the given qualifier type code value
   * <code>type</code>.
   * <p>
   * The possible qualifier types are {@link  libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER} 
   * and {@link  libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER}.  If an explicit
   * value for <code>type</code> is not given, this method defaults to using
   * {@link  libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}.  The
   * qualifier type code type
   * value can be set later using the {@link CVTerm#setQualifierType(int type)}
   * method.
   * <p>
   * @param type a qualifier type code value
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.

   */
 public CVTerm(int type) {
    this(libsbmlJNI.new_CVTerm__SWIG_0(type), true);
  }

  
  /**
   * Creates a new {@link CVTerm}, optionally with the given qualifier type code value
   * <code>type</code>.
   * <p>
   * The possible qualifier types are {@link  libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER} 
   * and {@link  libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER}.  If an explicit
   * value for <code>type</code> is not given, this method defaults to using
   * {@link  libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}.  The
   * qualifier type code type
   * value can be set later using the {@link CVTerm#setQualifierType(int type)}
   * method.
   * <p>
   * @param type a qualifier type code value
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.

   */
 public CVTerm() {
    this(libsbmlJNI.new_CVTerm__SWIG_1(), true);
  }

  
  /**
   * Create a new {@link CVTerm} from the given {@link XMLNode}.
   * <p>
   * In libSBML, RDF annotations on a model component are stored as a list
   * of {@link CVTerm} ('controlled vocabulary term') objects.  This allows the
   * user to interact with the {@link CVTerm} objects directly.  When LibSBML reads
   * in a model containing RDFAnnotation, it parses them into a list of
   * {@link CVTerm} objects, and when writing a model, it parses the {@link CVTerm} objects
   * into the appropriate SBML <code>&lt;annotation&gt;</code> structure.
   * <p>
   * This method creates a {@link CVTerm} from the {@link XMLNode} object supplied.
   * <p>
   * @param node an XMLNode representing a {@link CVTerm}.
   * <p>
   * @note This method assumes that the given {@link XMLNode} object <code>node</code> is of
   * the correct structural form.
   */
 public CVTerm(XMLNode node) {
    this(libsbmlJNI.new_CVTerm__SWIG_2(XMLNode.getCPtr(node), node), true);
  }

  
  /**
   * Copy constructor; creates a copy of a {@link CVTerm}.
   * <p>
   * @param orig the {@link CVTerm} instance to copy.
   */
 public CVTerm(CVTerm orig) {
    this(libsbmlJNI.new_CVTerm__SWIG_3(CVTerm.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link CVTerm} object.
   * <p>
   * @return a (deep) copy of this {@link CVTerm}.
   */
 public CVTerm cloneObject() {
    long cPtr = libsbmlJNI.CVTerm_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new CVTerm(cPtr, true);
  }

  
  /**
   * Returns the qualifier type code for this {@link CVTerm} object.
   * <p>
   * @return the qualifier type code value of this object or
   * {@link  libsbmlConstants#UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER}
   * (the default).
   */
 public int getQualifierType() {
    return libsbmlJNI.CVTerm_getQualifierType(swigCPtr, this);
  }

  
  /**
   * Returns the model qualifier type code for this {@link CVTerm} object.
   * <p>
   * @return the model qualifier type code value of this object or
   * {@link  libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN}
   * (the default).
   */
 public int getModelQualifierType() {
    return libsbmlJNI.CVTerm_getModelQualifierType(swigCPtr, this);
  }

  
  /**
   * Returns the biological qualifier type code for this {@link CVTerm} object.
   * <p>
   * @return the biology qualifier type code value of this object or
   * {@link  libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN}
   * (the default).
   */
 public int getBiologicalQualifierType() {
    return libsbmlJNI.CVTerm_getBiologicalQualifierType(swigCPtr, this);
  }

  
  /**
   * Returns the resources for this {@link CVTerm} object.
   * <p>
   * @return the {@link XMLAttributes} that store the resources of this {@link CVTerm}.
   */
 public XMLAttributes getResources() {
    long cPtr = libsbmlJNI.CVTerm_getResources__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLAttributes(cPtr, false);
  }

  
  /**
   * Returns the number of resources for this {@link CVTerm} object.
   * <p>
   * @return the number of resources in the set of {@link XMLAttributes}
   * of this {@link CVTerm}.
   */
 public long getNumResources() {
    return libsbmlJNI.CVTerm_getNumResources(swigCPtr, this);
  }

  
  /**
   * Returns the value of the nth resource for this {@link CVTerm} object.
   * <p>
   * @param n the index of the resource to query
   * <p>
   * @return string representing the value of the nth resource
   * in the set of {@link XMLAttributes} of this {@link CVTerm}.
   * <p>
   * @note Since the values of the resource attributes in a {@link CVTerm} are
   * URIs, this is a convenience method to facilitate interaction with the
   * {@link CVTerm} class.
   */
 public String getResourceURI(long n) {
    return libsbmlJNI.CVTerm_getResourceURI(swigCPtr, this, n);
  }

  
  /**
   * Sets the qualifier type code value of this {@link CVTerm} object.
   * <p>
   * @param type the qualifier type code type value 
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   */
 public int setQualifierType(int type) {
    return libsbmlJNI.CVTerm_setQualifierType(swigCPtr, this, type);
  }

  
  /**
   * Sets the model qualifier type code value of this {@link CVTerm} object.
   * <p>
   * @param type the model qualifier type code value
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <p>
   * @note If the Qualifier Type of this object is not
   * {@link  libsbmlConstants#MODEL_QUALIFIER MODEL_QUALIFIER}, 
   * then the ModelQualifierType_t value will default to
   * {@link  libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN}.
   */
 public int setModelQualifierType(int type) {
    return libsbmlJNI.CVTerm_setModelQualifierType(swigCPtr, this, type);
  }

  
  /**
   * Sets the biology qualifier type code of this {@link CVTerm} object.
   * <p>
   * @param type the biology qualifier type code value
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <p>
   * @note If the Qualifier Type of this object is not
   * {@link  libsbmlConstants#BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER},
   * then the biology qualifier type code value will default
   * to {@link  libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN}.
   */
 public int setBiologicalQualifierType(int type) {
    return libsbmlJNI.CVTerm_setBiologicalQualifierType(swigCPtr, this, type);
  }

  
  /**
   * Adds a resource to the {@link CVTerm}.
   * <p>
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   * <p>
   * @note This method adds the name <code>'rdf:resource'</code> to the
   * attribute prior to adding it to the resources in this {@link CVTerm} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   */
 public int addResource(String resource) {
    return libsbmlJNI.CVTerm_addResource(swigCPtr, this, resource);
  }

  
  /**
   * Removes a resource from the {@link CVTerm}.
   * <p>
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   */
 public int removeResource(String resource) {
    return libsbmlJNI.CVTerm_removeResource(swigCPtr, this, resource);
  }

  
  /**
   * Predicate returning <code>true</code> if all the
   * required elements for this {@link Rule} object have been set.
   * <p>
   * @note The required attributes for a {@link CVTerm} are:
   * <li> qualifierType and appropriate biologicalQualifierType or 
   * <li> modelQualifierType and at least one resource.
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.CVTerm_hasRequiredAttributes(swigCPtr, this);
  }

}
