/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.0
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBase, the base class of most SBML objects.
 * <p>
 * Most components in SBML are derived from a single abstract base type,
 * {@link SBase}.  In addition to serving as the parent class for most other
 * classes of objects in SBML, this base type is designed to allow a
 * modeler or a software package to attach arbitrary information to each
 * major element or list in an SBML model.
 * <p>
 * {@link SBase} has an optional subelement called 'notes'.  It is intended to
 * serve as a place for storing optional information intended to be seen by
 * humans.  An example use of the 'notes' element would be to contain
 * formatted user comments about the model element in which the 'notes'
 * element is enclosed.  There are certain conditions on the XHTML content
 * permitted inside the 'notes' element; please consult the <a
 * target='_blank' href='http://sbml.org/Documents/Specifications'>SBML
 * specification document</a> corresponding to the SBML Level and Version
 * of your model for more information about the requirements for 'notes'
 * content.
 * <p>
 * {@link SBase} has another optional subelement called 'annotation'.  Whereas the
 * 'notes' element described above is a container for content to be shown
 * directly to humans, the 'annotation' element is a container for optional
 * software-generated content <em>not</em> meant to be shown to humans.  The
 * element's content type is <a target='_blank'
 * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
 * 'any'</a>, allowing essentially arbitrary data content.  SBML places
 * only a few restrictions on the organization of the content; these are
 * intended to help software tools read and write the data as well as help
 * reduce conflicts between annotations added by different tools.  As is
 * the case with 'notes', it is important to refer to the <a
 * target='_blank' href='http://sbml.org/Documents/Specifications'>SBML
 * specification document</a> corresponding to the SBML Level and Version
 * of your model for more information about the requirements for
 * 'annotation' content.
 * <p>
 * It is worth pointing out that the 'annotation' element in the definition
 * of {@link SBase} exists in order that software developers may attach optional
 * application-specific data to the elements in an SBML model.  However, it
 * is important that this facility not be misused.  In particular, it is
 * <em>critical</em> that data essential to a model definition or that can
 * be encoded in existing SBML elements is <em>not</em> stored in
 * 'annotation'. {@link Parameter} values, functional dependencies between model
 * elements, etc., should not be recorded as annotations.  It is crucial to
 * keep in mind the fact that data placed in annotations can be freely
 * ignored by software applications.  If such data affects the
 * interpretation of a model, then software interoperability is greatly
 * impeded.
 * <p>
 * SBML Level 2 introduced an optional {@link SBase} attribute named 'metaid' for
 * supporting metadata annotations using RDF (<a target='_blank'
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>). The
 * attribute value has the data type <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML identifier
 * type, which means each 'metaid' value must be globally unique within an
 * SBML file.  (Importantly, this uniqueness criterion applies across any
 * attribute with type <a href='http://www.w3.org/TR/REC-xml/#id'>XML
 * ID</a>, not just the 'metaid' attribute used by SBML&mdash;something to
 * be aware of if your application-specific XML content inside the
 * 'annotation' subelement happens to use <a
 * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)  The 'metaid' value
 * serves to identify a model component for purposes such as referencing
 * that component from metadata placed within 'annotation' subelements.
 * <p>
 * Beginning with SBML Level 2 Version 3, {@link SBase} also has an optional
 * attribute named 'sboTerm' for supporting the use of the Systems Biology
 * Ontology.  In SBML proper, the data type of the attribute is a string of
 * the form 'SBO:NNNNNNN', where 'NNNNNNN' is a seven digit integer number;
 * libSBML simplifies the representation by only storing the 'NNNNNNN'
 * integer portion.  Thus, in libSBML, the 'sboTerm' attribute on {@link SBase} has
 * data type <code>int</code>, and {@link SBO} identifiers are stored simply as integers.
 * (For convenience, {@link SBase} offers methods for returning both the integer
 * form and a text-string form of the {@link SBO} identifier.)  {@link SBO} terms are a
 * type of optional annotation, and each different class of SBML object
 * derived from {@link SBase} imposes its own requirements about the values
 * permitted for 'sboTerm'.  Please consult the SBML Level&nbsp;2
 * Version&nbsp;4 specification for more information about the use of {@link SBO}
 * and the 'sboTerm' attribute.
 * <p>
 * Finally, note that, in the list of methods on {@link SBase}, there is no public
 * constructor because {@link SBase} is an abstract class.  The constructors reside
 * in the subclasses derived from {@link SBase}.
 * <p>
 * <p>
 * <h2>Standard format for annotations linking data resources</h2>
 * <p>
 * SBML Level 2 Versions 2, 3 and 4 define a proposed regular format for
 * encoding two particular categories of annotations: (a) references to
 * controlled vocabulary terms and database identifiers which define and
 * describe biological and biochemical entities in a model; and (b)
 * descriptions of the provenance of a model, including its author(s) and
 * modification history.
 */

public class SBase {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBase(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBase obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBase obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBase(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for SBase.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((SBase)(sb));
  }

  /**
   * Returns a hashcode for this SBase object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates and returns a deep copy of this {@link SBase} object.
   * <p>
   * @return a (deep) copy of this {@link SBase} object.
   */
 public SBase cloneObject() {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_cloneObject(swigCPtr, this), true);
}

  
  /**
   * Returns the value of the 'metaid' attribute of this object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * @return the metaid of this SBML object.
   * <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   */
 public String getMetaId() {
    return libsbmlJNI.SBase_getMetaId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'metaid' attribute of this object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format).  The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * @return the metaid of this SBML object, as a string.
   * <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public String getId() {
    return libsbmlJNI.SBase_getId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'metaid' attribute of this object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format).  The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model
   * component for purposes such as referencing that component from
   * metadata placed within 'annotation' subelements.
   * <p>
   * @return the metaid of this SBML object, as a string.
   * <p>
   * @see #isSetMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public String getName() {
    return libsbmlJNI.SBase_getName(swigCPtr, this);
  }

  
  /**
   * Returns the content of the 'notes' subelement of this object as
   * a tree of {@link XMLNode} objects.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * The 'notes' element content returned by this method will be in XML
   * form, but libSBML does not provide an object model specifically for
   * the content of notes.  Callers will need to traverse the XML tree
   * structure using the facilities available on {@link XMLNode} and related
   * objects.  For an alternative method of accessing the notes, see
   * getNotesString().
   * <p>
   * @return the content of the 'notes' subelement of this SBML object as a
   * tree structure composed of {@link XMLNode} objects.
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public XMLNode getNotes() {
    long cPtr = libsbmlJNI.SBase_getNotes(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
  /**
   * Returns the content of the 'notes' subelement of this object as a
   * string.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * For an alternative method of accessing the notes, see getNotes(),
   * which returns the content as an {@link XMLNode} tree structure.  Depending on
   * an application's needs, one or the other method may be more
   * convenient.
   * <p>
   * @return the content of the 'notes' subelement of this SBML object as a
   * string.
   * <p>
   * @see #getNotes()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public String getNotesString() {
    return libsbmlJNI.SBase_getNotesString(swigCPtr, this);
  }

  
  /**
   * Returns the content of the 'annotation' subelement of this object as
   * a tree of {@link XMLNode} objects.
   * <p>
   * Whereas the SBML 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * The annotations returned by this method will be in XML form.  LibSBML
   * provides an object model and related interfaces for certain specific
   * kinds of annotations, namely model history information and RDF
   * content.  See the {@link ModelHistory}, {@link CVTerm} and {@link RDFAnnotationParser} classes
   * for more information about the facilities available.
   * <p>
   * @return the annotation of this SBML object as a tree of {@link XMLNode} objects.
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public XMLNode getAnnotation() {
    long cPtr = libsbmlJNI.SBase_getAnnotation(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
  /**
   * Returns the content of the 'annotation' subelement of this object as a
   * character string.
   * <p>
   * Whereas the SBML 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * The annotations returned by this method will be in string form.
   * <p>
   * @return the annotation of this SBML object as a character string.
   * <p>
   * @see #getAnnotation()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public String getAnnotationString() {
    return libsbmlJNI.SBase_getAnnotationString(swigCPtr, this);
  }

  
  /**
   * Returns a list of the XML Namespaces declared on this SBML document.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in SBML Level&nbsp;3) packages used in addition to SBML Level&nbsp;3
   * Core.
   * <p>
   * @return the XML Namespaces associated with this SBML object
   * <p>
   * @see #getLevel()
   * @see #getVersion()
   */
 public XMLNamespaces getNamespaces() {
    long cPtr = libsbmlJNI.SBase_getNamespaces(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLNamespaces(cPtr, false);
  }

  
  /**
   * Returns the {@link SBMLDocument} object containing <em>this</em> object instance.
   * <p>
   * LibSBML uses the class {@link SBMLDocument} as a top-level container for
   * storing SBML content and data associated with it (such as warnings and
   * error messages).  An SBML model in libSBML is contained inside an
   * {@link SBMLDocument} object.  {@link SBMLDocument} corresponds roughly to the class
   * <i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
   * specifications, but it does not have a direct correspondence in SBML
   * Level&nbsp;1.  (But, it is created by libSBML no matter whether the
   * model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
   * <p>
   * This method allows the caller to obtain the {@link SBMLDocument} for the
   * current object.
   * <p>
   * @return the parent {@link SBMLDocument} object of this SBML object.
   * <p>
   * @see #getParentSBMLObject()
   * @see #getModel()
   */
 public SBMLDocument getSBMLDocument() {
    long cPtr = libsbmlJNI.SBase_getSBMLDocument__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, false);
  }

  
  /**
   * Returns the parent SBML object containing this object.
   * <p>
   * This returns the immediately-containing object.  This method is
   * convenient when holding an object nested inside other objects in an
   * SBML model.  
   * <p>
   * @return the parent SBML object of this SBML object.
   * <p>
   * @see #getSBMLDocument()
   * @see #getModel()
   */
 public SBase getParentSBMLObject() {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getParentSBMLObject(swigCPtr, this), false);
}

  
  /**
   * Returns the ancestor SBML object that corresponds to the given
   * SBML type code value.
   * <p>
   * This function allows any object to determine its exact
   * location/function within a model.  For example, in SBML Level&nbsp;2 a
   * {@link StoichiometryMath} object has ancestors (in order) of type
   * {@link SpeciesReference}, {@link ListOfSpeciesReferences}, {@link Reaction}, {@link ListOfReactions}
   * and {@link Model}, any of which can be accessed via this function.
   * <p>
   * @param type the SBML object type code of the ancestor being sought.
   * <p>
   * @return the ancestor SBML object of this SBML object that corresponds
   * to the given SBML object type code, or <code>null</code> if none exists.
   */
 public SBase getAncestorOfType(int type) {
  return libsbml.DowncastSBase(libsbmlJNI.SBase_getAncestorOfType(swigCPtr, this, type), false);
}

  
  /**
   * Returns the integer portion of the value of the 'sboTerm' attribute of
   * this object.
   * <p>
   * Beginning with SBML Level 2 Version 3, objects derived from {@link SBase} have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
   * are stored simply as integers.  (For convenience, libSBML offers
   * methods for returning both the integer form and a text-string form of
   * the {@link SBO} identifier.)
   * <p>
   * {@link SBO} terms are a type of optional annotation, and each different class
   * of SBML object derived from {@link SBase} imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * @return the value of the 'sboTerm' attribute as an integer, or <code>-1</code>
   * if the value is not set.
   */
 public int getSBOTerm() {
    return libsbmlJNI.SBase_getSBOTerm(swigCPtr, this);
  }

  
  /**
   * Returns the string representation of the 'sboTerm' attribute of
   * this object.
   * <p>
   * Beginning with SBML Level 2 Version 3, objects derived from {@link SBase} have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
   * are stored simply as integers.  This method returns the entire {@link SBO}
   * identifier as a text string in the form 'SBO:NNNNNNN'.
   * <p>
   * {@link SBO} terms are a type of optional annotation, and each different class
   * of SBML object derived from {@link SBase} imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * @return the value of the 'sboTerm' attribute as a string (its value
   * will be of the form 'SBO:NNNNNNN'), or an empty string if
   * the value is not set.
   */
 public String getSBOTermID() {
    return libsbmlJNI.SBase_getSBOTermID(swigCPtr, this);
  }

  
  /**
   * Returns the line number on which this object first appears in the XML
   * representation of the SBML document.
   * <p>
   * @return the line number of this SBML object.
   * <p>
   * @see #getColumn()
   * <p>
   * @note The line number for each construct in an SBML model is set upon
   * reading the model.  The accuracy of the line number depends on the
   * correctness of the XML representation of the model, and on the
   * particular XML parser library being used.  The former limitation
   * relates to the following problem: if the model is actually invalid
   * XML, then the parser may not be able to interpret the data correctly
   * and consequently may not be able to establish the real line number.
   * The latter limitation is simply that different parsers seem to have
   * their own accuracy limitations, and out of all the parsers supported
   * by libSBML, none have been 100% accurate in all situations. (At this
   * time, libSBML supports the use of <a target='_blank'
   * href='http://xmlsoft.org'>libxml2</a>, <a target='_blank'
   * href='http://expat.sourceforge.net/'>Expat</a> and <a target='_blank'
   * href='http://http://xerces.apache.org/xerces-c/'>Xerces</a>.)
   */
 public long getLine() {
    return libsbmlJNI.SBase_getLine(swigCPtr, this);
  }

  
  /**
   * Returns the column number on which this object first appears in the XML
   * representation of the SBML document.
   * <p>
   * @return the column number of this SBML object.
   * <p>
   * @see #getLine()
   * <p>
   * @note The column number for each construct in an SBML model is set
   * upon reading the model.  The accuracy of the column number depends on
   * the correctness of the XML representation of the model, and on the
   * particular XML parser library being used.  The former limitation
   * relates to the following problem: if the model is actually invalid
   * XML, then the parser may not be able to interpret the data correctly
   * and consequently may not be able to establish the real column number.
   * The latter limitation is simply that different parsers seem to have
   * their own accuracy limitations, and out of all the parsers supported
   * by libSBML, none have been 100% accurate in all situations. (At this
   * time, libSBML supports the use of <a target='_blank'
   * href='http://xmlsoft.org'>libxml2</a>, <a target='_blank'
   * href='http://expat.sourceforge.net/'>Expat</a> and <a target='_blank'
   * href='http://http://xerces.apache.org/xerces-c/'>Xerces</a>.)
   */
 public long getColumn() {
    return libsbmlJNI.SBase_getColumn(swigCPtr, this);
  }

  
  /**
   * Returns the {@link ModelHistory} object, if any, attached to this object.
   * <p>
   * @return the {@link ModelHistory} object attached to this object, or <code>null</code> if
   * none exist.
   * <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */
 public ModelHistory getModelHistory() {
    long cPtr = libsbmlJNI.SBase_getModelHistory__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelHistory(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's 'metaid' attribute has been set.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model component for purposes
   * such as referencing that component from metadata placed within
   * 'annotation' subelements.
   * <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   */
 public boolean isSetMetaId() {
    return libsbmlJNI.SBase_isSetMetaId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's 'metaid' attribute has been set.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model component for purposes
   * such as referencing that component from metadata placed within
   * 'annotation' subelements.
   * <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public boolean isSetId() {
    return libsbmlJNI.SBase_isSetId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's 'metaid' attribute has been set.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model component for purposes
   * such as referencing that component from metadata placed within
   * 'annotation' subelements.
   * <p>
   * @return <code>true</code> if the 'metaid' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   * <p>
   * @see #getMetaId()
   * @see #setMetaId(String metaid)
   <p>
 * @deprecated libSBML internal
 */
 public boolean isSetName() {
    return libsbmlJNI.SBase_isSetName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's 'notes' subelement exists and has content.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * @return <code>true</code> if a 'notes' subelement exists, <code>false</code> otherwise.
   * <p>
   * @see #getNotes()
   * @see #getNotesString()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public boolean isSetNotes() {
    return libsbmlJNI.SBase_isSetNotes(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's 'annotation' subelement exists and has content.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * @return <code>true</code> if a 'annotation' subelement exists, <code>false</code>
   * otherwise.
   * <p>
   * @see #getAnnotation()
   * @see #getAnnotationString()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public boolean isSetAnnotation() {
    return libsbmlJNI.SBase_isSetAnnotation(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's 'sboTerm' attribute has been set.
   * <p>
   * @return <code>true</code> if the 'sboTerm' attribute of this SBML object has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetSBOTerm() {
    return libsbmlJNI.SBase_isSetSBOTerm(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'metaid' attribute of this object.
   * <p>
   * The string <code>metaid</code> is copied.  The value of <code>metaid</code> must be an
   * identifier conforming to the syntax defined by the XML 1.0 data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>ID</a>.  Among other
   * things, this type requires that a value is unique among all the values
   * of type XML ID in an {@link SBMLDocument}.  Although SBML only uses <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a> for the 'metaid'
   * attribute, callers should be careful if they use
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>'s in XML
   * portions of a model that are not defined by SBML, such as in the
   * application-specific content of the 'annotation' subelement.
   * <p>
   * @param metaid the identifier string to use as the value of the
   * 'metaid' attribute
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <p>
   * @see #getMetaId()
   * @see #isSetMetaId()
   */
 public int setMetaId(String metaid) {
    return libsbmlJNI.SBase_setMetaId(swigCPtr, this, metaid);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object has a {@link ModelHistory} object attached to it.
   * <p>
   * @return <code>true</code> if the {@link ModelHistory} of this object has been set, 
   * <code>false</code> otherwise.
   * <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */
 public boolean isSetModelHistory() {
    return libsbmlJNI.SBase_isSetModelHistory(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object has a {@link ModelHistory} object attached to it.
   * <p>
   * @return <code>true</code> if the {@link ModelHistory} of this object has been set, 
   * <code>false</code> otherwise.
   * <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   <p>
 * @deprecated libSBML internal
 */
 public int setId(String sid) {
    return libsbmlJNI.SBase_setId(swigCPtr, this, sid);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object has a {@link ModelHistory} object attached to it.
   * <p>
   * @return <code>true</code> if the {@link ModelHistory} of this object has been set, 
   * <code>false</code> otherwise.
   * <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   <p>
 * @deprecated libSBML internal
 */
 public int setName(String name) {
    return libsbmlJNI.SBase_setName(swigCPtr, this, name);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object.
   * <p>
   * The content of <code>annotation</code> is copied, and any previous content of
   * this object's 'annotation' subelement is deleted.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the 
   * <code>annotation</code> that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use {@link SBase#appendAnnotation(XMLNode  annotation)} or
   * {@link SBase#appendAnnotation(String annotation)}.
   * <p>
   * @param annotation an XML structure that is to be used as the new content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public int setAnnotation(XMLNode annotation) {
    return libsbmlJNI.SBase_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object.
   * <p>
   * The content of <code>annotation</code> is copied, and any previous content of
   * this object's 'annotation' subelement is deleted.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Call this method will result in any existing content of the
   * 'annotation' subelement to be discarded.  Unless you have taken steps
   * to first copy and reconstitute any existing annotations into the 
   * <code>annotation</code> that is about to be assigned, it is likely that performing
   * such wholesale replacement is unfriendly towards other software
   * applications whose annotations are discarded.  An alternative may be
   * to use {@link SBase#appendAnnotation(XMLNode  annotation)} or
   * {@link SBase#appendAnnotation(String annotation)}.
   * <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public int setAnnotation(String annotation) {
    return libsbmlJNI.SBase_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Appends the given <code>annotation</code> to the 'annotation' subelement of this
   * object.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a
   * target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type 'any'</a>,
   * allowing essentially arbitrary well-formed XML data content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Unlike {@link SBase#setAnnotation(XMLNode  annotation)} or
   * {@link SBase#setAnnotation(String annotation)}, this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   * <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(String annotation)
   * @see #unsetAnnotation()
   */
 public int appendAnnotation(XMLNode annotation) {
    return libsbmlJNI.SBase_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Appends the given <code>annotation</code> to the 'annotation' subelement of this
   * object.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a
   * target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type 'any'</a>,
   * allowing essentially arbitrary well-formed XML data content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * Unlike {@link SBase#setAnnotation(XMLNode  annotation)} or
   * {@link SBase#setAnnotation(String annotation)}, this method
   * allows other annotations to be preserved when an application adds its
   * own data.
   * <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #unsetAnnotation()
   */
 public int appendAnnotation(String annotation) {
    return libsbmlJNI.SBase_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Sets the value of the 'notes' subelement of this SBML object.
   * <p>
   * The content of <code>notes</code> is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * @param notes an XML structure that is to be used as the content of the
   * 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public int setNotes(XMLNode notes) {
    return libsbmlJNI.SBase_setNotes__SWIG_0(swigCPtr, this, XMLNode.getCPtr(notes), notes);
  }

  
  /**
   * Sets the value of the 'notes' subelement of this SBML object to a copy
   * of the string <code>notes</code>.
   * <p>
   * The content of <code>notes</code> is copied, and any existing content of this
   * object's 'notes' subelement is deleted.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * @param notes an XML string that is to be used as the content of the
   * 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public int setNotes(String notes) {
    return libsbmlJNI.SBase_setNotes__SWIG_1(swigCPtr, this, notes);
  }

  
  /**
   * Appends the given <code>notes</code> to the 'notes' subelement of this object.
   * <p>
   * The content of <code>notes</code> is copied.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * @param notes an XML node structure that is to appended to the content
   * of the 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(String notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public int appendNotes(XMLNode notes) {
    return libsbmlJNI.SBase_appendNotes__SWIG_0(swigCPtr, this, XMLNode.getCPtr(notes), notes);
  }

  
  /**
   * Appends the given <code>notes</code> to the 'notes' subelement of this object.
   * <p>
   * The content of the parameter <code>notes</code> is copied.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * @param notes an XML string that is to appended to the content of
   * the 'notes' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #unsetNotes()
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public int appendNotes(String notes) {
    return libsbmlJNI.SBase_appendNotes__SWIG_1(swigCPtr, this, notes);
  }

  
  /**
   * Sets the {@link ModelHistory} of this object.
   * <p>
   * The content of <code>history</code> is copied, and this object's existing model
   * history content is deleted.
   * <p>
   * @param history {@link ModelHistory} of this object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */
 public int setModelHistory(ModelHistory history) {
    return libsbmlJNI.SBase_setModelHistory(swigCPtr, this, ModelHistory.getCPtr(history), history);
  }

  
  /**
   * Sets the value of the 'sboTerm' attribute.
   * <p>
   * Beginning with SBML Level 2 Version 3, objects derived from {@link SBase} have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
   * are stored simply as integers. 
   * <p>
   * {@link SBO} terms are a type of optional annotation, and each different class
   * of SBML object derived from {@link SBase} imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * @param value the NNNNNNN integer portion of the {@link SBO} identifier
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <p>
   * @see #setSBOTerm(String sbo_id)
   */
 public int setSBOTerm(int value) {
    return libsbmlJNI.SBase_setSBOTerm__SWIG_0(swigCPtr, this, value);
  }

  
  /**
   * Sets the value of the 'sboTerm' attribute by string.
   * <p>
   * Beginning with SBML Level 2 Version 3, objects derived from {@link SBase} have
   * an optional attribute named 'sboTerm' for supporting the use of the
   * Systems Biology Ontology.  In SBML proper, the data type of the
   * attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
   * seven digit integer number; libSBML simplifies the representation by
   * only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
   * 'sboTerm' attribute on {@link SBase} has data type <code>int</code>, and {@link SBO} identifiers
   * are stored simply as integers.  This method lets you set the value of
   * 'sboTerm' as a complete string of the form 'SBO:NNNNNNN', whereas
   * setSBOTerm(int value) allows you to set it using the integer form.
   * <p>
   * {@link SBO} terms are a type of optional annotation, and each different class
   * of SBML object derived from {@link SBase} imposes its own requirements about
   * the values permitted for 'sboTerm'.  Please consult the SBML
   * Level&nbsp;2 Version&nbsp;4 specification for more information about
   * the use of {@link SBO} and the 'sboTerm' attribute.
   * <p>
   * @param sboid the {@link SBO} identifier string of the form 'SBO:NNNNNNN'
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <p>
   * @see #setSBOTerm(int value)
   */
 public int setSBOTerm(String sboid) {
    return libsbmlJNI.SBase_setSBOTerm__SWIG_1(swigCPtr, this, sboid);
  }

  
  /**
   * Sets the namespaces relevant of this SBML object.
   * <p>
   * The content of <code>xmlns</code> is copied, and this object's existing
   * namespace content is deleted.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * <p>
   * @param xmlns the namespaces to set
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setNamespaces(XMLNamespaces xmlns) {
    return libsbmlJNI.SBase_setNamespaces(swigCPtr, this, XMLNamespaces.getCPtr(xmlns), xmlns);
  }

  
  /**
   * Unsets the value of the 'metaid' attribute of this SBML object.
   * <p>
   * The optional attribute named 'metaid', present on every major SBML
   * component type, is for supporting metadata annotations using RDF
   * (Resource Description Format). The attribute value has the data type
   * <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, the XML
   * identifier type, which means each 'metaid' value must be globally
   * unique within an SBML file.  (Importantly, this uniqueness criterion
   * applies across any attribute with type <a
   * href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>, not just the
   * 'metaid' attribute used by SBML&mdash;something to be aware of if your
   * application-specific XML content inside the 'annotation' subelement
   * happens to use <a href='http://www.w3.org/TR/REC-xml/#id'>XML ID</a>.)
   * The 'metaid' value serves to identify a model component for purposes
   * such as referencing that component from metadata placed within
   * 'annotation' subelements.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetMetaId() {
    return libsbmlJNI.SBase_unsetMetaId(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'notes' subelement of this SBML object.
   * <p>
   * The optional SBML element named 'notes', present on every major SBML
   * component type, is intended as a place for storing optional
   * information intended to be seen by humans.  An example use of the
   * 'notes' element would be to contain formatted user comments about the
   * model element in which the 'notes' element is enclosed.  Every object
   * derived directly or indirectly from type {@link SBase} can have a separate
   * value for 'notes', allowing users considerable freedom when adding
   * comments to their models.
   * <p>
   * The format of 'notes' elements must be <a target='_blank'
   * href='http://www.w3.org/TR/xhtml1/'>XHTML&nbsp;1.0</a>.  To help
   * verify the formatting of 'notes' content, libSBML provides the static
   * utility method {@link SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)}; however,
   * readers are urged to consult the appropriate <a target='_blank'
   * href='http://sbml.org/Documents/Specifications'>SBML specification
   * document</a> for the Level and Version of their model for more
   * in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
   * specifications have considerable detail about how 'notes' element
   * content must be structured.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <p>
   * @see #getNotesString()
   * @see #isSetNotes()
   * @see #setNotes(XMLNode  notes)
   * @see #setNotes(String notes)
   * @see #appendNotes(XMLNode  notes)
   * @see #appendNotes(String notes)
   * @see SyntaxChecker#hasExpectedXHTMLSyntax(XMLNode xhtml)
   */
 public int unsetNotes() {
    return libsbmlJNI.SBase_unsetNotes(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'annotation' subelement of this SBML object.
   * <p>
   * Whereas the {@link SBase} 'notes' subelement is a container for content to be
   * shown directly to humans, the 'annotation' element is a container for
   * optional software-generated content <em>not</em> meant to be shown to
   * humans.  Every object derived from {@link SBase} can have its own value for
   * 'annotation'.  The element's content type is <a target='_blank'
   * href='http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls'>XML type
   * 'any'</a>, allowing essentially arbitrary well-formed XML data
   * content.
   * <p>
   * SBML places a few restrictions on the organization of the content of
   * annotations; these are intended to help software tools read and write
   * the data as well as help reduce conflicts between annotations added by
   * different tools.  Please see the SBML specifications for more details.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <p>
   * @see #getAnnotation()
   * @see #getAnnotationString()
   * @see #isSetAnnotation()
   * @see #setAnnotation(XMLNode  annotation)
   * @see #setAnnotation(String annotation)
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   */
 public int unsetAnnotation() {
    return libsbmlJNI.SBase_unsetAnnotation(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'sboTerm' attribute of this SBML object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   */
 public int unsetSBOTerm() {
    return libsbmlJNI.SBase_unsetSBOTerm(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link CVTerm} object to this SBML object.
   * <p>
   * @param term the {@link CVTerm} to assign
   * <p>
   * @param newBag if <code>true</code>, creates a new RDF bag with the same identifier
   * as a previous bag, and if <code>false</code>, adds the term to an existing
   * RDF bag with the same type of qualifier as the term being added.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }, if
   * this object lacks a 'metaid' attribute
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <p>
   * @note Since the CV Term uses the 'metaid' attribute of the object as a
   * reference, if the object has no 'metaid' attribute value set, then the
   * {@link CVTerm} will not be added.
   * <p>
   * @warning The fact that this method <em>copies</em> the object passed to it
   * means that the caller will be left holding a physically different
   * object instance than the one contained in <em>this</em> object.  Changes
   * made to the original object instance (such as resetting attribute
   * values) will <em>not affect the instance added here</em>.  In
   * addition, the caller should make sure to free the original object if
   * it is no longer being used, or else a memory leak will result.
   */
 public int addCVTerm(CVTerm term, boolean newBag) {
    return libsbmlJNI.SBase_addCVTerm__SWIG_0(swigCPtr, this, CVTerm.getCPtr(term), term, newBag);
  }

  
  /**
   * Adds a copy of the given {@link CVTerm} object to this SBML object.
   * <p>
   * @param term the {@link CVTerm} to assign
   * <p>
   * @param newBag if <code>true</code>, creates a new RDF bag with the same identifier
   * as a previous bag, and if <code>false</code>, adds the term to an existing
   * RDF bag with the same type of qualifier as the term being added.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }, if
   * this object lacks a 'metaid' attribute
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <p>
   * @note Since the CV Term uses the 'metaid' attribute of the object as a
   * reference, if the object has no 'metaid' attribute value set, then the
   * {@link CVTerm} will not be added.
   * <p>
   * @warning The fact that this method <em>copies</em> the object passed to it
   * means that the caller will be left holding a physically different
   * object instance than the one contained in <em>this</em> object.  Changes
   * made to the original object instance (such as resetting attribute
   * values) will <em>not affect the instance added here</em>.  In
   * addition, the caller should make sure to free the original object if
   * it is no longer being used, or else a memory leak will result.
   */
 public int addCVTerm(CVTerm term) {
    return libsbmlJNI.SBase_addCVTerm__SWIG_1(swigCPtr, this, CVTerm.getCPtr(term), term);
  }

  
  /**
   * Returns a list of {@link CVTerm} objects in the annotations of this SBML
   * object.
   * <p>
   * @return the list of CVTerms for this SBML object.
   */
 public  CVTermList  getCVTerms() { 
  long cPtr = libsbmlJNI.SBase_getCVTerms__SWIG_0(swigCPtr, this);
  return (cPtr == 0) ? null : new  CVTermList(cPtr, true);
}

  
  /**
   * Returns the number of {@link CVTerm} objects in the annotations of this SBML
   * object.
   * <p>
   * @return the number of CVTerms for this SBML object.
   */
 public long getNumCVTerms() {
    return libsbmlJNI.SBase_getNumCVTerms(swigCPtr, this);
  }

  
  /**
   * Returns the nth {@link CVTerm} in the list of CVTerms of this SBML
   * object.
   * <p>
   * @param n long the index of the {@link CVTerm} to retrieve
   * <p>
   * @return the nth {@link CVTerm} in the list of CVTerms for this SBML object.
   */
 public CVTerm getCVTerm(long n) {
    long cPtr = libsbmlJNI.SBase_getCVTerm(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CVTerm(cPtr, false);
  }

  
  /**
   * Clears the list of {@link CVTerm} objects attached to this SBML object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetCVTerms() {
    return libsbmlJNI.SBase_unsetCVTerms(swigCPtr, this);
  }

  
  /**
   * Unsets the {@link ModelHistory} object attached to this object.
   * <p>
   * @return integer value indicating success/failure of the
   * function.  The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @note In SBML Level&nbsp;2, model history annotations were only
   * permitted on the {@link Model} element.  In SBML Level&nbsp;3, they are
   * permitted on all SBML components derived from {@link SBase}.
   */
 public int unsetModelHistory() {
    return libsbmlJNI.SBase_unsetModelHistory(swigCPtr, this);
  }

  
  /**
   * Returns the MIRIAM <em>biological qualifier</em> associated with the
   * given resource.
   * <p>
   * In <a target='_blank' href='http://biomodels.net/miriam'>MIRIAM</a>,
   * qualifiers are an optional means of indicating the relationship
   * between a model component and its annotations.  There are two broad
   * kinds of annotations: <em>model</em> and <em>biological</em>.  The
   * latter kind is used to qualify the relationship between a model
   * component and a biological entity which it represents.  Examples of
   * relationships include 'is' and 'has part', but many others are
   * possible.  MIRIAM defines <a target='_blank'
   * href='http://www.ebi.ac.uk/miriam/main/qualifiers/'>numerous
   * relationship qualifiers</a> to enable different software tools to
   * qualify biological annotations in the same standardized way.  In
   * libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
   * element are represented using lists of {@link CVTerm} objects, and the
   * the MIRIAM biological qualifiers are represented using
   * values whose
   * names begin with <code>BQB_</code> in the interface class
   * {@link libsbmlConstants}.
   * <p>
   * This method searches the controlled-vocabulary annotations
   * (i.e., the list of {@link CVTerm} objects) on the present object, then out of
   * those that have biological qualifiers, looks for an annotation to the
   * given <code>resource</code>.  If such an annotation is found, it returns the
   * type of biological qualifier associated with that resource as a 
   * value whose name
   * begins with <code>BQB_</code> from the interface
   * class {@link libsbmlConstants}.
   * <p>
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   * <p>
   * @return the qualifier associated with the resource,
   * or {@link  libsbmlConstants#BQB_UNKNOWN BQB_UNKNOWN} if the
   * resource does not exist.
   * <p>
   * * @note The set of MIRIAM biological qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQB_</code> constants defined in {@link libsbmlConstants}
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * <p>
   */
 public int getResourceBiologicalQualifier(String resource) {
    return libsbmlJNI.SBase_getResourceBiologicalQualifier(swigCPtr, this, resource);
  }

  
  /**
   * Returns the MIRIAM <em>model qualifier</em> associated with the
   * given resource.
   * <p>
   * In <a target='_blank' href='http://biomodels.net/miriam'>MIRIAM</a>,
   * qualifiers are an optional means of indicating the relationship
   * between a model component and its annotations.  There are two broad
   * kinds of annotations: <em>model</em> and <em>biological</em>.  The
   * former kind is used to qualify the relationship between a model
   * component and another modeling object.  An example qualifier is
   * 'isDerivedFrom', to indicate that a given component of the model is
   * derived from the modeling object represented by the referenced
   * resource.  MIRIAM defines <a target='_blank'
   * href='http://www.ebi.ac.uk/miriam/main/qualifiers/'>numerous
   * relationship qualifiers</a> to enable different software tools to
   * qualify model annotations in the same standardized way.  In libSBML,
   * the MIRIAM controlled-vocabulary annotations on an SBML model element
   * are represented using lists of {@link CVTerm} objects, and the 
   * the MIRIAM model qualifiers are represented using
   * values whose
   * names begin with <code>BQM_</code> in the interface class
   * {@link libsbmlConstants}.
   * <p>
   * This method method searches the controlled-vocabulary annotations
   * (i.e., the list of {@link CVTerm} objects) on the present object, then out of
   * those that have model qualifiers, looks for an annotation to the given
   * <code>resource</code>.  If such an annotation is found, it returns the type of
   * type of model qualifier associated with that resource as a 
   * value whose name
   * begins with <code>BQM_</code> from the interface
   * class {@link libsbmlConstants}.
   * <p>
   * @param resource string representing the resource; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   * <p>
   * @return the #ModelQualifierType_t value associated with the resource,
   * or {@link  libsbmlConstants#BQM_UNKNOWN BQM_UNKNOWN} if the
   * resource does not exist.
   * <p>
   * * @note The set of MIRIAM model qualifiers grows over
   * time, although relatively slowly.  The values are up to date with
   * MIRIAM at the time of a given libSBML release.  The set of values in
   * list of <code>BQM_</code> constants defined in {@link libsbmlConstants}
   * may be expanded in later libSBML releases, to match
   * the values defined by MIRIAM at that later time.
   * <p>
   */
 public int getResourceModelQualifier(String resource) {
    return libsbmlJNI.SBase_getResourceModelQualifier(swigCPtr, this, resource);
  }

  
  /**
   * Returns the {@link Model} object in which the current object is located.
   * <p>
   * @return the parent {@link Model} of this SBML object.
   * <p>
   * @see #getParentSBMLObject()
   * @see #getSBMLDocument()
   */
 public Model getModel() {
    long cPtr = libsbmlJNI.SBase_getModel(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
  /**
   * Returns the SBML Level of the {@link SBMLDocument} object containing this
   * object.
   * <p>
   * @return the SBML level of this SBML object.
   * <p>
   * @see #getVersion()
   * @see #getNamespaces()
   */
 public long getLevel() {
    return libsbmlJNI.SBase_getLevel(swigCPtr, this);
  }

  
  /**
   * Returns the Version within the SBML Level of the {@link SBMLDocument} object
   * containing this object.
   * <p>
   * @return the SBML version of this SBML object.
   * <p>
   * @see #getLevel()
   * @see #getNamespaces()
   */
 public long getVersion() {
    return libsbmlJNI.SBase_getVersion(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code for this object.
   * <p>
   * This method may return the type code of this SBML object, or it may
   * return {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN}.  This
   * is because subclasses of {@link SBase} are not required to implement this
   * method to return a type code.  This method is meant primarily for the
   * LibSBML C interface, in which class and subclass information is not
   * readily available.
   * <p>
   * @return the SBML object type code
   * of this SBML object or
   * {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (the default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.SBase_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * object's level/version and namespace values correspond to a valid
   * SBML specification.
   * <p>
   * The valid combinations of SBML Level, Version and Namespace as of this
   * release of libSBML are the following:
   * <ul>
   * <li> Level&nbsp;1 Version&nbsp;2: <code>'http://www.sbml.org/sbml/level1'</code>
   * <li> Level&nbsp;2 Version&nbsp;1: <code>'http://www.sbml.org/sbml/level2'</code>
   * <li> Level&nbsp;2 Version&nbsp;2: <code>'http://www.sbml.org/sbml/level2/version2'</code>
   * <li> Level&nbsp;2 Version&nbsp;3: <code>'http://www.sbml.org/sbml/level2/version3'</code>
   * <li> Level&nbsp;2 Version&nbsp;4: <code>'http://www.sbml.org/sbml/level2/version4'</code>
   * <li> Level&nbsp;3 Version&nbsp;1 Core: <code>'http://www.sbml.org/sbml/level3/version1/core'</code>
   * </ul>
   * <p>
   * @return <code>true</code> if the level, version and namespace values of this 
   * SBML object correspond to a valid set of values, <code>false</code> otherwise.
   */
 public boolean hasValidLevelVersionNamespaceCombination() {
    return libsbmlJNI.SBase_hasValidLevelVersionNamespaceCombination(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object.
   * <p>
   * This is overridden by subclasses to return a string appropriate to the
   * SBML component.  For example, {@link Model} defines it as returning 
   * <code>'model'</code>, {@link CompartmentType} defines it as returning <code>'compartmentType'</code>,
   * and so on.
   */
 public String getElementName() {
    return libsbmlJNI.SBase_getElementName(swigCPtr, this);
  }

  
  /**
   * Returns a string consisting of a partial SBML corresponding to just
   * this object.
   * <p>
   * @return the partial SBML that describes this SBML object.
   * <p>
   * @warning This is primarily provided for testing and debugging
   * purposes.  It may be removed in a future version of libSBML.
   */
 public String toSBML() {
    return libsbmlJNI.SBase_toSBML(swigCPtr, this);
  }

  
  /**
   * Subclasses should override this method to write out their contained
   * SBML objects as XML elements.  Be sure to call your parents
   * implementation of this method as well.  For example:
   * <p>
   *   {@link SBase#writeElements(stream)};
   *   mReactans.write(stream);
   *   mProducts.write(stream);
   *   ...
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.SBase_hasRequiredAttributes(swigCPtr, this);
  }

  
  /**
   * Subclasses should override this method to write out their contained
   * SBML objects as XML elements.  Be sure to call your parents
   * implementation of this method as well.  For example:
   * <p>
   *   {@link SBase#writeElements(stream)};
   *   mReactans.write(stream);
   *   mProducts.write(stream);
   *   ...
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredElements() {
    return libsbmlJNI.SBase_hasRequiredElements(swigCPtr, this);
  }

}
