# @file    TestReadFromFile5.rb
# @brief   Reads test-data/l2v1-assignment.xml into memory and tests it.
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Ben Bornstein 
#
# $Id: TestReadFromFile5.rb 11522 2010-07-22 00:32:10Z mhucka $
# $HeadURL: http://sbml.svn.sourceforge.net/svnroot/sbml/trunk/libsbml/src/bindings/ruby/test/sbml/TestReadFromFile5.rb $
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestReadFromFile5.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestReadFromFile5 < Test::Unit::TestCase

  def test_read_l2v1_assignment
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "l2v1-assignment.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    assert( d.getLevel() == 2 )
    assert( d.getVersion() == 1 )
    m = d.getModel()
    assert( m != nil )
    assert( m.getNumCompartments() == 1 )
    c = m.getCompartment(0)
    assert( c != nil )
    assert( c.getId() ==  "cell" )
    ud = c.getDerivedUnitDefinition()
    assert( ud.getNumUnits() == 1 )
    assert( ud.getUnit(0).getKind() == LibSBML::UNIT_KIND_LITRE )
    loc = m.getListOfCompartments()
    c1 = loc.get(0)
    assert( c1 == c )
    c1 = loc.get("cell")
    assert( c1 == c )
    assert( m.getNumSpecies() == 5 )
    s = m.getSpecies(0)
    assert( s != nil )
    assert( s.getId() ==  "X0"   )
    assert( s.getCompartment() ==  "cell" )
    assert( s.getInitialConcentration() == 1.0 )
    los = m.getListOfSpecies()
    s1 = los.get(0)
    assert( s1 == s )
    s1 = los.get("X0")
    assert( s1 == s )
    s = m.getSpecies(1)
    assert( s != nil )
    assert( s.getId() ==  "X1"   )
    assert( s.getCompartment() ==  "cell" )
    assert( s.getInitialConcentration() == 0.0 )
    s = m.getSpecies(2)
    assert( s != nil )
    assert( s.getId() ==  "T"    )
    assert( s.getCompartment() ==  "cell" )
    assert( s.getInitialConcentration() == 0.0 )
    s = m.getSpecies(3)
    assert( s != nil )
    assert( s.getId() ==  "S1"   )
    assert( s.getCompartment() ==  "cell" )
    assert( s.getInitialConcentration() == 0.0 )
    s = m.getSpecies(4)
    assert( s != nil )
    assert( s.getId() ==  "S2"   )
    assert( s.getCompartment() ==  "cell" )
    assert( s.getInitialConcentration() == 0.0 )
    assert( m.getNumParameters() == 1 )
    p = m.getParameter(0)
    assert( p != nil )
    assert( p.getId() ==  "Keq" )
    assert( p.getValue() == 2.5 )
    lop = m.getListOfParameters()
    p1 = lop.get(0)
    assert( p1 == p )
    p1 = lop.get("Keq")
    assert( p1 == p )
    ud = p.getDerivedUnitDefinition()
    assert( ud.getNumUnits() == 0 )
    assert( m.getNumRules() == 2 )
    ar = m.getRule(0)
    assert( ar != nil )
    assert( ar.getVariable() ==  "S1"            )
    assert( ar.getFormula() ==  "T / (1 + Keq)" )
    ud = ar.getDerivedUnitDefinition()
    assert( ud.getNumUnits() == 2 )
    assert( ud.getUnit(0).getKind() == LibSBML::UNIT_KIND_MOLE )
    assert( ud.getUnit(0).getExponent() == 1 )
    assert( ud.getUnit(1).getKind() == LibSBML::UNIT_KIND_LITRE )
    assert( ud.getUnit(1).getExponent() == -1 )
    assert( ar.containsUndeclaredUnits() == true )
    lor = m.getListOfRules()
    ar1 = lor.get(0)
    assert( ar1 == ar )
    ar1 = lor.get("S1")
    assert( ar1 == ar )
    ar = m.getRule(1)
    assert( ar != nil )
    assert( ar.getVariable() ==  "S2"       )
    assert( ar.getFormula() ==  "Keq * S1" )
    assert( m.getNumReactions() == 2 )
    r = m.getReaction(0)
    assert( r != nil )
    assert( r.getId() ==  "in" )
    assert( r.getNumReactants() == 1 )
    assert( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    assert( sr != nil )
    assert( sr.getSpecies() ==  "X0" )
    sr = r.getProduct(0)
    assert( sr != nil )
    assert( sr.getSpecies() ==  "T"  )
    kl = r.getKineticLaw()
    assert( kl != nil )
    assert( kl.getFormula() ==  "k1 * X0" )
    assert( kl.getNumParameters() == 1 )
    r1 = kl.getParentSBMLObject()
    assert( r1 != nil )
    assert( r1.getId() ==  "in" )
    assert( r1.getNumReactants() == 1 )
    assert( r1.getNumProducts() == 1 )
    p = kl.getParameter(0)
    assert( p != nil )
    assert( p.getId() ==  "k1" )
    assert( p.getValue() == 0.1 )
    kl = p.getParentSBMLObject().getParentSBMLObject()
    assert( kl != nil )
    assert( kl.getFormula() ==  "k1 * X0" )
    assert( kl.getNumParameters() == 1 )
    r = m.getReaction(1)
    assert( r != nil )
    assert( r.getId() ==  "out" )
    assert( r.getNumReactants() == 1 )
    assert( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    assert( sr != nil )
    assert( sr.getSpecies() ==  "T"  )
    sr = r.getProduct(0)
    assert( sr != nil )
    assert( sr.getSpecies() ==  "X1" )
    kl = r.getKineticLaw()
    assert( kl != nil )
    assert( kl.getFormula() ==  "k2 * T" )
    assert( kl.getNumParameters() == 1 )
    p = kl.getParameter(0)
    assert( p != nil )
    assert( p.getId() ==  "k2" )
    assert( p.getValue() == 0.15 )
    d = nil
  end

end
