<?php

	

    /**
     * \ingroup XML
     * 
     * <p>Provides information about an RSS channel, fetched from an RSS resource.</p>
     * <p>This class provides methods to get the value of some of the attributes and possible child
     * tags of the &lt;channel&lt; tag. In case we need to know about any other value that is not available
     * via one of the 'getter' functions (getTitle(), getDescription(), getLink()), we can then get
     * values from the resulting array as generated by the underlying RSS parser using the get() function.
     * The array is an associative array where the keys are the name of the attribute/tag and the values are
     * the value of the attribute/tag.</p>
     */
	class RSSChannel  {

		var $_title;
		var $_description;
		var $_link;
		var $_channel;

        /**
         * Constructor.
         *
         * @param rssChannel An associative array which is the output of the MagpieRSS library
         */
		function RSSChannel( $rssChannel )
		{
			$this->_title = $rssChannel["title"];
			$this->_description = $rssChannel["description"];
			$this->_link = $rssChannel["link"];

			$this->_channel = $rssChannel;
		}

        /**
         * Returns the title of the channel
         *
         * @return Title of the channel
         */
		function getTitle()
		{
			return $this->_title;
		}

        /**
         * Returns the description of the channel
         *
         * @return Description of the channel
         */
		function getDescription()
		{
			return $this->_description;
		}

        /**
         * Returns the link of the channel
         *
         * @return The link of the channel
         */
		function getLink()
		{
			return $this->_link;
		}

        /**
         * Gets another property of the channel. The methods shown so far give easier access
         * to some of the methods more commonly used, but the MagpieRSS will include anything else
         * in the output array, so access is given to this method. We only need to know the name
         * of the parameter.
         *
         * @param key The name of the parameter
         * @return The value assigned to that parameter
         */
		function get( $key )
		{
			return $this->_channel[$key];
		}
	}
?>
