<?php
/////////////////                                          //////////////////
///////////////// STRINGS FOR THE ADMINISTRATION INTERFACE //////////////////
/////////////////                                          //////////////////

// Initial translation by Nino NJOPKOU
// nino@akopo.com - http://nino.akopo.com
// Yaoundé - CAMEROUN (Africa)

// 8/06/2007 - Modifications by Gabriel ROUSSEAU
// grvg@free.fr - http://grvg.free.fr
// FRANCE
// – Corrections de fautes de frappes et de quelques angliscismes.
// – Changement des apostrophes informatiques ' par les apostrophes typographiques ’
// – Changement des guillemets informatiques " par les guillemets typographiques « et »
// – Respect des règles de la typographie de ponctuation francophone (espaces, etc…)
// – Harmonisation globale (ajouts de points, utilisation de la même logique partout)
// – Remise à niveau avec le dernier locale_en_UK qui est la référence pour les clef

// 22/06/2007 - added LT 1.2.4 strings by Gabriel ROUSSEAU


$messages['login'] = 'Connexion';
$messages['welcome_message'] = 'Bienvenue dans LifeType';
$messages['error_incorrect_username_or_password'] = 'Désolé, identifiant ou mot de passe incorrect.';
$messages['error_dont_belong_to_any_blog'] = 'Désolé, vous n’êtes encore membre d’aucun blog.';
$messages['logout_message'] = 'Déconnexion réussie.';
$messages['logout_message_2'] = 'Cliquer <a href="%1$s">ici</a> pour aller sur %2$s </a>.';
$messages['error_access_forbidden'] = 'Accès refusé. Vous devez d’abord vous identifier.';
$messages['username'] = 'Identifiant';
$messages['password'] = 'Mot de passe';
$messages['dashboard'] = 'Tableau de bord';
$messages['recent_articles'] = 'Les derniers articles';
$messages['recent_comments'] = 'Les derniers commentaires';
$messages['recent_trackbacks'] = 'Les derniers rétroliens';
$messages['blog_statistics'] = 'Stats';
$messages['total_posts'] = 'Nombre d’articles';
$messages['total_comments'] = 'Commentaires';
$messages['total_trackbacks'] = 'Rétroliens';
$messages['total_viewed'] = 'Articles lus';
$messages['in'] = 'dans';
$messages['newPost'] = 'Nouveau';
$messages['Manage'] = 'Gestion';
$messages['managePosts'] = 'Gérer les articles';
$messages['editPosts'] = 'Articles';
$messages['editArticleCategories'] = 'Catégories';
$messages['newArticleCategory'] = 'Nouvelle catégorie';
$messages['manageLinks'] = 'Gérer les liens';
$messages['editLinks'] = 'Liens';
$messages['newLink'] = 'Nouveau lien';
$messages['editLink'] = 'Editer les liens';
$messages['editLinkCategories'] = 'Catégories de liens';
$messages['newLinkCategory'] = 'Nouvelle catégorie de liens';
$messages['editLinkCategory'] = 'Editer la catégorie de liens';
$messages['manageCustomFields'] = 'Gérer les champs personnalisables';
$messages['blogCustomFields'] = 'Champs personnalisables';
$messages['newCustomField'] = 'Nouveau champ personnalisable';
$messages['resourceCenter'] = 'Centre des ressources';
$messages['resources'] = 'Ressources';
$messages['newResourceAlbum'] = 'Nouvel album';
$messages['newResource'] = 'Nouvelle ressource';
$messages['controlCenter'] = 'Réglages';
$messages['manageSettings'] = 'Propriétés';
$messages['blogSettings'] = 'Propriétés du blog';
$messages['userSettings'] = 'Paramètres utilisateur';
$messages['pluginCenter'] = 'Gestion des modules';
$messages['Stats'] = 'Stats';
$messages['manageBlogUsers'] = 'Gérer les membres';
$messages['newBlogUser'] = 'Nouveau membre';
$messages['showBlogUsers'] = 'Membres';
$messages['manageBlogTemplates'] = 'Gabarits';
$messages['newBlogTemplate'] = 'Nouveau gabarit';
$messages['blogTemplates'] = 'Gabarits';
$messages['adminSettings'] = 'Administration';
$messages['Users'] = 'Membres';
$messages['createUser'] = 'Créer membre';
$messages['editSiteUsers'] = 'Membres';
$messages['Blogs'] = 'Blogs';
$messages['createBlog'] = 'Créer un blog';
$messages['editSiteBlogs'] = 'Blogs';
$messages['Locales'] = 'Traductions';
$messages['newLocale'] = 'Nouvelle traduction';
$messages['siteLocales'] = 'Traductions';
$messages['Templates'] = 'Gabarits';
$messages['newTemplate'] = 'Nouveau gabarit';
$messages['siteTemplates'] = 'Gabarits du site';
$messages['GlobalSettings'] = 'Paramètres';
$messages['editSiteSettings'] = 'Index';
$messages['summarySettings'] = 'Accueil';
$messages['templateSettings'] = 'Gabarits';
$messages['urlSettings'] = 'URLs';
$messages['emailSettings'] = 'Courriel';
$messages['uploadSettings'] = 'Téléversements';
$messages['helpersSettings'] = 'Aides externes';
$messages['interfacesSettings'] = 'Interfaces';
$messages['securitySettings'] = 'Securité';
$messages['bayesianSettings'] = 'Filtre bayesien';
$messages['resourcesSettings'] = 'Ressources';
$messages['searchSettings'] = 'Recherche';
$messages['cleanUpSection'] = 'Nettoyer';
$messages['cleanUp'] = 'Nettoyer';
$messages['editResourceAlbum'] = 'Éditer l’album';
$messages['resourceInfo'] = 'Infos ressources';
$messages['editBlog'] = 'Éditer le blog';
$messages['Logout'] = 'Déconnexion';
$messages['topic'] = 'Sujet';
$messages['topic_help'] = 'Titre de l’article.';
$messages['text'] = 'Texte';
$messages['text_help'] = 'Texte de l’article. Cette partie apparaîtra dans la page d’accueil.';
$messages['extended_text'] = 'Texte étendu';
$messages['extended_text_help'] = 'Texte étendu de l’article. Cette partie peut optionellement apparaître sur la page des articles ou sur la page principale. Voir les paramètres du blog pour plus d’informations.';
$messages['trackback_urls'] = 'URLs réelles des rétroliens';
$messages['trackback_urls_help'] = 'Si l’article auquel vous voulez envoyer le rétrolien ne supporte pas le mécanisme de reconnaissance des rétroliens, merci de préciser ici l’URL réelle de rétrolien et d’utiliser le saut de ligne pour séparer des URLs différentes.';
$messages['post_slug'] = 'Titre de lien';
$messages['post_slug_help'] = 'Le titre de lien est utilisé pour générer des liens permanents agréables.';
$messages['date'] = 'Date';
$messages['post_date_help'] = 'Date à laquelle l’article a été posté.';
$messages['status'] = 'Statut';
$messages['post_status_help'] = 'Choisir un statut.';
$messages['post_status_published'] = 'Publié';
$messages['post_status_draft'] = 'Brouillon';
$messages['post_status_deleted'] = 'Supprimé';
$messages['post_categories_help'] = 'Choisir une ou plusieurs catégories.';
$messages['post_comments_enabled_help'] = 'Autoriser les commentaires.';
$messages['send_notification_help'] = 'Notification des nouveaux commentaires.';
$messages['send_trackback_pings_help'] = 'Envoyer un écho aux rétroliens.';
$messages['send_xmlrpc_pings_help'] = 'Envoyer des échos XMLRPC.';
$messages['save_draft_and_continue'] = 'Sauvegarder le brouillon';
$messages['preview'] = 'Prévisualiser';
$messages['add_post'] = 'Bloguer !';
$messages['error_saving_draft'] = 'Une erreur est survenue lors de la sauvegarde de la copie';
$messages['draft_saved_ok'] = 'Brouillon sauvegardé';
$messages['error_sending_request'] = 'Erreur en envoyant la requête';
$messages['error_no_category_selected'] = 'Choisissez au moins une catégorie';
$messages['error_missing_post_topic'] = 'Article manquant';
$messages['error_missing_post_text'] = 'Texte manquant';
$messages['error_adding_post'] = 'Erreur en ajoutant l’article';
$messages['post_added_not_published'] = 'Article ajouté, mais non publié';
$messages['post_added_ok'] = 'Article ajouté !';
$messages['send_notifications_ok'] = 'Une notification sera envoyée pour chaque nouveau commentaire ou rétrolien.';
$messages['bookmarklet'] = 'Marque-pages';
$messages['bookmarklet_help'] = 'Glisser ce lien dans votre barre d’outils ou faites un clic droit et choisissez « Ajouter aux favoris ».';
$messages['blogit_to_lifetype'] = 'Bloguer !';
$messages['original_post'] = '<br />(Article d’origine)';
$messages['error_sending_trackbacks'] = 'Erreur lors de l’ajout des rétroliens suivants';
$messages['send_trackbacks_help'] = 'Sélectionnez les liens auxquels vous voulez envoyer un rétrolien. Assurez vous que ces sites supportent les rétroliens.';
$messages['send_trackbacks'] = 'Envoyer les rétroliens';
$messages['ping_selected'] = 'Pinguer la sélection';
$messages['trackbacks_sent_ok'] = 'Rétroliens envoyés aux URLs sélectionnées';
$messages['show_by'] = 'Classer par';
$messages['category'] = 'Catégorie';
$messages['author'] = 'Auteur';
$messages['post_status_all'] = 'Tous';
$messages['author_all'] = 'Tous';
$messages['search_terms'] = 'Chercher';
$messages['show'] = 'Montrer';
$messages['delete'] = 'Effacer';
$messages['actions'] = 'Actions';
$messages['all'] = 'Tous';
$messages['category_all'] = 'Toutes';
$messages['error_incorrect_article_id'] = 'Identifiant de l’article incorrect';
$messages['error_deleting_article'] = 'Erreur lors de la suppression de l’article "%s"';
$messages['article_deleted_ok'] = 'Article "%s" supprimé';
$messages['articles_deleted_ok'] = '%s articles supprimés';
$messages['error_deleting_article2'] = 'Erreur lors de la suppression de l’article avec l’identifiant "%s"';
$messages['update'] = 'Mettre à jour';
$messages['editPost'] = 'Éditer l’article';
$messages['post_updated_ok'] = 'Article "%s" mis-à-jour .';
$messages['error_updating_post'] = 'Erreur lors de la mise-à-jour de l’article';
$messages['notification_added'] = 'Vous recevrez des notifications lors de nouveaux commentaires ou rétroliens';
$messages['notification_removed'] = 'Aucune notification ne sera envoyée lors des nouveaux commentaires ou rétroliens';
$messages['url'] = 'URL';
$messages['comment_status_all'] = 'Tous';
$messages['comment_status_spam'] = 'Indésirable';
$messages['comment_status_nonspam'] = 'Désirable';
$messages['error_fetching_comments'] = 'Erreur lors de la requête vers les commentaires des articles';
$messages['error_deleting_comments'] = 'Erreur lors de la suppression des commentaires, ou aucun commentaire sélectionné au préalable';
$messages['comment_deleted_ok'] = 'Commentaire "%s" supprimé ';
$messages['comments_deleted_ok'] = '%s commentaires supprimés ';
$messages['error_deleting_comment'] = 'Erreur lors de la suppression du commentaire "%s"';
$messages['error_deleting_comment2'] = 'Erreur lors de la suppression du commentaire avec l’identifiant %s';
$messages['editComments'] = 'Commentaires';
$messages['mark_as_spam'] = 'Marquer comme indésirable';
$messages['mark_as_no_spam'] = 'Marquer comme désirable';
$messages['error_incorrect_comment_id'] = 'Identifiant du commentaire incorrect';
$messages['error_marking_comment_as_spam'] = 'Erreur lors du marquage du commentaire comme indésirable';
$messages['comment_marked_as_spam_ok'] = 'Commentaire marqué comme indésirable ';
$messages['error_marking_comment_as_nonspam'] = 'Erreur lors du marquage du commentaire comme désirable';
$messages['comment_marked_as_nonspam_ok'] = 'Commentaire marqué comme désirable ';
$messages['blog'] = 'Blog';
$messages['excerpt'] = 'Extrait';
$messages['error_fetching_trackbacks'] = 'Erreur lors de la requête vers les rétroliens';
$messages['error_deleting_trackbacks'] = 'Erreur lors de la suppression des rétroliens, ou aucune entrée n’a été sélectionnée';
$messages['error_deleting_trackback'] = 'Erreur lors de la suppression du rétrolien "%s"';
$messages['error_deleting_trackback2'] = 'Erreur lors de la suppression du rétrolien avec l’identifiant "%s"';
$messages['trackback_deleted_ok'] = 'Rétrolien "%s" supprimé';
$messages['trackbacks_deleted_ok'] = '%s rétroliens supprimmés';
$messages['editTrackbacks'] = 'Rétroliens';
$messages['referrer'] = 'Référant';
$messages['hits'] = 'Clics';
$messages['error_no_items_selected'] = 'Aucune entrée sélectionnée pour suppression';
$messages['error_deleting_referrer'] = 'Erreur lors de la suppression du référant "%s"';
$messages['error_deleting_referrer2'] = 'Erreur lors de la suppression du référant avec identifiant "%s"';
$messages['referrer_deleted_ok'] = 'Référant "%s" supprimé';
$messages['referrers_deleted_ok'] = '%s référants supprimés';
$messages['posts'] = 'Articles';
$messages['show_in_main_page'] = 'Montrer dans la page d’accueil';
$messages['error_category_has_articles'] = 'La catégorie "%s" est utilisée par des articles. Éditez d’abord les articles, et ensuite supprimez la catégorie';
$messages['category_deleted_ok'] = 'Catégorie "%s" supprimée';
$messages['categories_deleted_ok'] = '%s catégories supprimées';
$messages['error_deleting_category'] = 'Erreur lors de la suppression de la catégorie "%s"';
$messages['error_deleting_category2'] = 'Erreur lors de la suppression de la catégorie avec l’identifiant "%s"';
$messages['yes'] = 'Oui';
$messages['no'] = 'Non';
$messages['name'] = 'Nom';
$messages['category_name_help'] = 'Nom utilisé pour afficher la catégorie.';
$messages['description'] = 'Description';
$messages['category_description_help'] = 'Description longue de cette catégorie.';
$messages['show_in_main_page_help'] = 'Sélectionnez pour afficher les articles de cette catégorie sur la page d’accueil, ou seulement quand on navigue dans cette catégorie particulière.';
$messages['error_empty_name'] = 'Fournir un nom';
$messages['error_empty_description'] = 'Fournir une description';
$messages['error_adding_article_category'] = 'Erreur lors de l’ajout d’une nouvelle catégorie. Veuillez vérifier les informations et réessayer';
$messages['category_added_ok'] = 'Catégorie "%s" ajoutée au blog';
$messages['add'] = 'Ajouter';
$messages['reset'] = 'Réinitialiser';
$messages['error_updating_article_category'] = 'Erreur lors de la mise-à-jour de la catégorie de l’article';
$messages['article_category_updated_ok'] = 'Catégorie "%s" mise-à-jour';
$messages['feed'] = 'Flux';
$messages['error_no_links_selected'] = 'Identifiant du lien incorrect, ou aucune entrée n’a été sélectionnée pour êter supprimée';
$messages['error_incorrect_link_id'] = 'Identifiant du lien incorrect';
$messages['error_removing_link'] = 'Erreur lors de la suppression du lien "%s"';
$messages['error_removing_link2'] = 'Erreur lors de la suppression du lien avec identifiant "%s"';
$messages['link_deleted_ok'] = 'Le lien "%s" a été supprimé ';
$messages['links_deleted_ok'] = 'Liens %s supprimés ';
$messages['link_name_help'] = 'Nom du lien.';
$messages['link_url_help'] = 'Adresse vers laquelle pointe ce lien. Exemple: http://www.domaine.com/ (ATTENTION: http:// doit être inclus dans le lien)';
$messages['link_description_help'] = 'Brève description du lien.';
$messages['link_feed_help'] = 'Un lien vers un flux RSS ou Atom du lien peut aussi être fourni.';
$messages['link_category_help'] = 'Choisir parmi les catégories de liens disponibles.';
$messages['error_adding_link'] = 'Erreur lors du rajout du lien. Vérifier les informations et réessayer';
$messages['error_invalid_url'] = 'Adresse incorrecte';
$messages['link_added_ok'] = 'Le lien "%s" a été ajouté ';
$messages['bookmarkit_to_lifetype'] = 'Rajouter à vos marque-pages';
$messages['error_updating_link'] = 'Erreur lors de la mise-à-jour du lien. Vérifier les informations et réessayer';
$messages['error_fetching_link'] = 'Erreur lors de la requête vers le lien';
$messages['link_updated_ok'] = 'Le lien "%s" a été mis-à-jour ';
$messages['error_invalid_link_category_id'] = 'L’identifiant de la catégorie de liens est incorrecte, ou aucune catégorie de lien n’a été sélectionnée';
$messages['error_links_in_link_category'] = 'La catégorie de liens "%s" est utilisée par des liens. Modifier d’abord ces liens et re-essayer';
$messages['error_removing_link_category'] = 'Erreur lors de la suppression de la catégorie de liens "%s"';
$messages['link_category_deleted_ok'] = 'La catégorie de liens "%s" a été supprimée';
$messages['link_categories_deleted_ok'] = 'Les catégories de liens %s ont été supprimées';
$messages['error_removing_link_category2'] = 'Erreur lors de la suppression de la catégorie de liens avec l’identifiant "%s"';
$messages['link_category_name_help'] = 'Nom donné à cette catégorie de liens.';
$messages['error_adding_link_category'] = 'Erreur lors de l’ajout de la nouvelle catégorie de liens';
$messages['link_category_added_ok'] = 'La catégorie de liens "%s" a été ajoutée ';
$messages['error_updating_link_category'] = 'Erreur lors de la mise-à-jour de la catégorie de liens. Vérifier les données et réessayer';
$messages['link_category_updated_ok'] = 'La catégorie de liens "%s" a été mise-à-jour ';
$messages['error_fetching_link_category'] = 'Erreur lors de la requête vers la catégorie de liens';
$messages['type'] = 'Type';
$messages['hidden'] = 'Caché';
$messages['fields_deleted_ok'] = 'Les champs personnalisables %s ont été supprimés ';
$messages['field_deleted_ok'] = 'Le champ personnalisable "%s" a été supprimé ';
$messages['error_deleting_field'] = 'Erreur lors de la suppression du champ personnalisable "%s" ';
$messages['error_deleting_field2'] = 'Erreur lors de la suppression du champ personnalisable avec l’identifiant "%s" ';
$messages['error_incorrect_field_id'] = 'Identifiant du champ personnalisable invalide';
$messages['field_name_help'] = 'Identifiant qui sera utilisé en référence à la valeur de ce champ dans les articles.';
$messages['field_description_help'] = 'Brève description du champ, qui sera présentée lors de l’ajout ou l’édition d’articles.';
$messages['field_type_help'] = 'Choisir l’un des types de champs disponibles.';
$messages['field_hidden_help'] = 'Si un champ est caché, il ne sera pas montré lors de l’ajout ou l’édition d’articles. Cette fonctionnalité est surtout utilisée par les modules.';
$messages['error_adding_custom_field'] = 'Erreur lors de l’ajout du champ personnalisable. Vérifier les données et réessayer';
$messages['custom_field_added_ok'] = 'Champ personnalisable "%s" ajouté ';
$messages['text_field'] = 'Texte';
$messages['text_area'] = 'Boite texte';
$messages['checkbox'] = 'Case à cocher';
$messages['date_field'] = 'Date';
$messages['error_fetching_custom_field'] = 'Erreur lors de la requête vers le champ personnalisable';
$messages['error_updating_custom_field'] = 'Erreur lors de la mise-à-jour du champ personnalisable/ Vérifier les données et réessayer';
$messages['custom_field_updated_ok'] = 'Champ personnalisable "%s" mis à jour ';
$messages['root_album'] = 'Album principal';
$messages['num_resources'] = 'Nombre de ressources';
$messages['total_size'] = 'Taille totale';
$messages['album'] = 'Album';
$messages['error_incorrect_album_id'] = 'Identifiant de l’album incorrect.';
$messages['error_base_storage_folder_missing_or_unreadable'] = 'Le système n’a pas pu créer les dossiers nécessaires où déposer les ressources. Plusieurs causes possibles : installation PHP en safe mode, droits insuffisants, ... Vous pouvez toujours procéder manuellement à  la création des dossiers: <br/><br/>%s<br/><br/> Si ces dossiers existent déjà , veuillez vérifier que l’utilisateur du serveur web a les droits de lecture/écriture sur ceux-ci.';
$messages['items_deleted_ok'] = '%s éléments supprimés';
$messages['error_album_has_children'] = 'L’album « %s » a des sous-albums. Veuillez d’abord éditer les albums fils.';
$messages['item_deleted_ok'] = 'Elément « %s » supprimé';
$messages['error_deleting_album'] = 'Erreur en supprimant l’album « %s »';
$messages['error_deleting_album2'] = 'Erreur en supprimant l’album avec l’identifiant « %s »';
$messages['error_deleting_resource'] = 'Erreur en supprimant la ressource « %s »';
$messages['error_deleting_resource2'] = 'Erreur en supprimant la ressource avec l’identifiant « %s »';
$messages['error_no_resources_selected'] = 'Aucun élément sélectionné pour être supprimé';
$messages['resource_deleted_ok'] = 'Ressource « %s » supprimée';
$messages['album_deleted_ok'] = 'Album « %s » supprimé';
$messages['add_resource'] = 'Ajouter la ressource';
$messages['add_resource_preview'] = 'Ajouter un aperçu (petit)';
$messages['add_resource_medium'] = 'Ajouter un aperçu (moyen)';
$messages['add_album'] = 'Ajouter l’album';
$messages['album_name_help'] = 'Nom court du nouvel album.';
$messages['parent'] = 'Parent';
$messages['no_parent'] = 'Pas de parent';
$messages['parent_album_help'] = 'Utilisez ceci pour imbriquer des albums les uns dans les autres afin de mieux organiser vos fichiers.';
$messages['album_description_help'] = 'Description longue du contenu de l’album.';
$messages['error_adding_album'] = 'Erreur en ajoutant le nouvel album. Vérifiez les données entrées et recommencez.';
$messages['album_added_ok'] = 'Album « %s » ajouté';
$messages['error_fetching_album'] = 'Erreur en récupérant l’album.';
$messages['error_updating_album'] = 'Erreur en mettant l’album à jour. Vérifiez les données entrées et recommencez.';
$messages['album_updated_ok'] = 'Album « %s » mis à jour';
$messages['show_album_help'] = 'Si cette case est décochée, l’album ne sera pas visible dans la liste des albums disponibles sur ce blog.';
$messages['file'] = 'Fichier';
$messages['resource_file_help'] = 'Fichier qui sera ajouté au blog. Utilisez le lien « Ajouter » pour ajouter plusieurs fichiers en même temps.';
$messages['add_field'] = 'Ajouter';
$messages['resource_description_help'] = 'Description longue du fichier.';
$messages['resource_album_help'] = 'Sélectionnez l’album auquel le fichier sera ajouté.';
$messages['error_no_resource_uploaded'] = 'Aucun fichier sélectionné pour être ajouté.';
$messages['resource_added_ok'] = 'Ressource « %s » ajoutée';
$messages['error_resource_forbidden_extension'] = 'Type de fichier interdit';
$messages['error_resource_too_big'] = 'Fichier trop volumineux';
$messages['error_uploads_disabled'] = 'Les téléversements ont été désactivés';
$messages['error_quota_exceeded'] = 'Quota dépassé !';
$messages['error_adding_resource'] = 'Erreur en ajoutant le fichier';
$messages['editResource'] = 'Éditer la ressource';
$messages['resource_information_help'] = 'Quelques informations à propos du fichier.';
$messages['information'] = 'Information';
$messages['thumbnail_format'] = 'Taille de l’aperçu';
$messages['regenerate_preview'] = 'Régénérer l’aperçu';
$messages['error_fetching_resource'] = 'Erreur en récupérant la ressource';
$messages['error_updating_resource'] = 'Erreur en mettant à jour la ressource';
$messages['resource_updated_ok'] = 'Ressource « %s » mise à jour';
$messages['blog_link'] = 'Lien vers le blog';
$messages['blog_link_help'] = 'Lien permanent vers ce blog.';
$messages['blog_name_help'] = 'Titre du blog.';
$messages['blog_description_help'] = 'Description longue du contenu de ce blog.';
$messages['language'] = 'Langue';
$messages['blog_language_help'] = 'Langue utilisée pour afficher les textes dans le blog et dans la partie administration.';
$messages['max_main_page_items'] = 'Nombre d’articles sur la page principale';
$messages['max_main_page_items_help'] = 'Nombre d’articles qui peuvent être affichés à la fois sur la page principale de ce blog.';
$messages['max_recent_items'] = 'Nombre d’articles récents';
$messages['max_recent_items_help'] = 'Nombre maximum d’articles affichés comme récents sur la page principale.';
$messages['template'] = 'Gabarit';
$messages['choose'] = 'Choisir…';
$messages['blog_template_help'] = 'Gabarit qui sera utilisé pour afficher le contenu de ce blog. Cette liste contient les gabarits généraux et ceux installés uniquement pour ce blog.';
$messages['use_read_more'] = 'Utiliser le lien « suite… » dans les articles';
$messages['use_read_more_help'] = 'Si cette case est cochée, seul le texte tapé dans « Texte » sera affiché sur la page principale. Et pour afficher le texte tapé dans « Texte étendu », un lien « suite… » sera ajouté à  chaque article.';
$messages['enable_wysiwyg'] = 'Activer l’éditeur riche pour les articles';
$messages['enable_wysiwyg_help'] = 'Active un éditeur HTML complet pour l’édition des articles. L’éditeur fonctionne seulement sur Mozilla 1.3 et ultérieurs, IE 5.5 et ultérieurs.';
$messages['enable_comments'] = 'Active les commentaires par défaut.';
$messages['enable_comments_help'] = 'Active les commentaires pour tous les articles par défaut. Les commentaires pourront être activés ou désactivés pour un article particulier à sa création ou à son édition.';
$messages['show_future_posts'] = 'Montre les articles futurs dans le calendrier.';
$messages['show_future_posts_help'] = 'Les articles dont la date de publication n’est pas passée pourront apparaître dans le calendrier et seront donc visibles par les visiteurs.';
$messages['comments_order'] = 'Ordre des commentaires';
$messages['comments_order_help'] = 'Ordre dans lequel les commentaires apparaîtront sur la page principale.';
$messages['oldest_first'] = 'Les plus anciens en premier';
$messages['newest_first'] = 'Les plus recents en premier';
$messages['categories_order'] = 'Ordre des catégories';
$messages['categories_order_help'] = 'Ordre dans lequel les catégories apparaîtront sur la page principale.';
$messages['most_recent_updated_first'] = 'Les plus récemment mis-à-jour en premier';
$messages['alphabetical_order'] = 'Ordre alphabétique';
$messages['reverse_alphabetical_order'] = 'Ordre alphabétique inverse';
$messages['most_articles_first'] = 'Les plus lus en premier';
$messages['link_categories_order'] = 'Ordre des catégories de liens';
$messages['link_categories_order_help'] = 'Ordre dans lequel les catégories de liens apparaîtront sur la page principale.';
$messages['most_links_first'] = 'Le plus de liens en premier';
$messages['most_links_last'] = 'Le plus de liens en dernier';
$messages['time_offset'] = 'Fuseau horaire';
$messages['time_offset_help'] = 'Décalage horaire qui sera ajouté dynamiquement à toutes les dates et heures dans le blog.';
$messages['close'] = 'Fermer';
$messages['select'] = 'Sélectionnez';
$messages['error_updating_settings'] = 'Erreur en mettant à jour les paramètres du blog. Vérifiez les données entrées et recommencez';
$messages['error_invalid_number'] = 'Nombre incorrect';
$messages['error_incorrect_time_offset'] = 'Fuseau horaire invalide';
$messages['blog_settings_updated_ok'] = 'Paramètres mis à jour';
$messages['hours'] = 'Heures';
$messages['username_help'] = 'Pseudonyme public. Ce pseudonyme ne pourra être changé par la suite.';
$messages['full_name'] = 'Nom complet';
$messages['full_name_help'] = 'Nom complet de l’utilisateur.';
$messages['password_help'] = 'Tapez et confirmez un nouveau mot de passe. Laissez vide pour ne pas le changer.';
$messages['confirm_password'] = 'Confirmez le mot de passe';
$messages['email'] = 'Adresse électronique';
$messages['email_help'] = 'Courriel où les notifications seront envoyées.';
$messages['bio'] = 'Présentation';
$messages['bio_help'] = 'Votre portrait. Description de vous-même.';
$messages['picture'] = 'Photo';
$messages['user_picture_help'] = 'Sélectionnez une photo comme photo personnelle (parmi celles ajoutées à ce blog).';
$messages['error_invalid_password'] = 'Mot de passe inccorect. Vérifiez qu’il n’est pas trop court.';
$messages['error_passwords_dont_match'] = 'Désolé, mot de passe incorrect';
$messages['error_updating_user_settings'] = 'Erreur en mettant à jour les paramètres du membre. Vérifiez les données entrées et recommencez.';
$messages['user_settings_updated_ok'] = 'Paramètres membre mis à jour';
$messages['resource'] = 'Ressource';
$messages['identifier'] = 'Identifiant';
$messages['error_plugins_disabled'] = 'Modules désactivés';
$messages['revoke_permissions'] = 'Révoquer toutes les permissions';
$messages['error_no_users_selected'] = 'Aucun membre sélectionné.';
$messages['user_removed_from_blog_ok'] = 'Membre « %s » bien supprimé du blog.';
$messages['users_removed_from_blog_ok'] = '%s membres supprimés';
$messages['error_removing_user_from_blog'] = 'Erreur en supprimant le membre « %s » du blog.';
$messages['error_removing_user_from_blog2'] = 'Erreur en supprimant du blog le membre avec l’identifiant « %s ».';
$messages['new_blog_username_help'] = 'Identifiant du membre qui aura accès à ce blog. Les nouveaux membres ont seulement accès aux sections « Réglages » et « Gestion des ressources ».';
$messages['send_notification'] = 'Envoyer une notification';
$messages['send_user_notification_help'] = 'Envoyer un courriel de notification à ce membre.';
$messages['notification_text'] = 'Texte de la notification';
$messages['notification_text_help'] = 'Texte qui sera inclu dans le message de notification.';
$messages['error_adding_user'] = 'Erreur en ajoutant le membre. Vérifiez les données entrées et recommencez.';
$messages['error_empty_text'] = 'Vous devez entrer un texte';
$messages['error_invalid_user'] = 'Identifiant du membre invalide ou membre inexistant.';
$messages['user_added_to_blog_ok'] = 'Le membre « %s » peut désormais accéder à ce blog.';
$messages['error_no_templates_selected'] = 'Aucun gabarit sélectionné';
$messages['error_template_is_current'] = 'Le gabarit « %s » ne peut être supprimé car c’est celui qui est utilisé.';
$messages['error_removing_template'] = 'Erreur en supprimant le gabarit « %s »';
$messages['template_removed_ok'] = 'Gabarit « %s » supprimé';
$messages['templates_removed_ok'] = '%s gabarits supprimés';
$messages['template_installed_ok'] = 'Gabarit « %s » ajouté';
$messages['error_installing_template'] = 'Erreur durant l’installation du gabarit « %s »';
$messages['error_missing_base_files'] = 'Fichier(s) du gabarit basique manquant(s)';
$messages['error_add_template_disabled'] = 'Aucun gabarit ne peut être ajouté car cette fonction a été désactivée.';
$messages['error_must_upload_file'] = 'Pas de gabarit à téléverser';
$messages['error_no_new_templates_found'] = 'Pas de nouveau gabarit trouvé';
$messages['error_template_not_inside_folder'] = 'Les fichiers du gabarit doivent être dans un répertoire du même nom que le gabarit.';
$messages['error_unpacking'] = 'Erreur en décompressant le fichier';
$messages['error_forbidden_extensions'] = 'Des fichiers d’extensions interdites sont inclus dans le gabarit';
$messages['error_creating_working_folder'] = 'Erreur durant la création du répertoire temporaire nécessaire à la décompression.';
$messages['error_checking_template'] = 'Erreur en vérifiant le gabarit : %s';
$messages['template_package'] = 'Package du gabarit';
$messages['blog_template_package_help'] = 'Utilisez ce formulaire pour téléverser un nouvau gabarit, qui ne sera utilisable que sur votre blog. Si vous ne pouvez pas téléverser un gabarit par ce formulaire, téléversez-le manuellement dans le répertoire <b>%s</b>, qui est le dossier où les gabarits de blog sont stockés et cliquez sur « <b>Scanner les gabarits</b> ». Le système scannera le dossier et ajoutera automatiquement les nouveaux gabarits.';
$messages['scan_templates'] = 'Scanner les gabarits';
$messages['user_status_active'] = 'Actif';
$messages['user_status_disabled'] = 'Inactif';
$messages['user_status_all'] = 'Tous';
$messages['user_status_unconfirmed'] = 'non confirmé';
$messages['error_invalid_user2'] = 'Le membre avec l’identifiant « %s » n’existe pas';
$messages['error_deleting_user'] = 'Erreur en supprimant le membre « %s »';
$messages['user_deleted_ok'] = 'Membre « %s » supprimé';
$messages['users_deleted_ok'] = '%s membres supprimés';
$messages['user_added_ok'] = 'Membre « %s » ajouté';
$messages['user_status_help'] = 'Statut actuel du membre.';
$messages['user_blog_help'] = 'Blog avec lequel ce membre est initialisé.';
$messages['none'] = 'Aucun';
$messages['error_updating_user'] = 'Erreur en mettant à jour les paramètres du membre. Vérifiez les données entrées et recommencez.';
$messages['blogs'] = 'Blogs';
$messages['user_blogs_help'] = 'Blogs du membre ou de ceux auxquels il a accès.';
$messages['site_admin'] = 'Administrateur';
$messages['site_admin_help'] = 'Si ce membre est administrateur, il pourra accéder à la partie « Administration » et accomplir des tâches administratives.';
$messages['user_updated_ok'] = 'Membre « %s » mis à jour';
$messages['blog_status_all'] = 'Tous';
$messages['blog_status_active'] = 'Actif';
$messages['blog_status_disabled'] = 'Inactif';
$messages['blog_status_unconfirmed'] = 'Non-validé';
$messages['owner'] = 'Propriétaire';
$messages['quota'] = 'Quota';
$messages['bytes'] = 'octets';
$messages['error_no_blogs_selected'] = 'Aucun blog sélectionné pour être désactivé';
$messages['error_blog_is_default_blog'] = 'Ce blog « %s » ne peut être supprimé car il s’agit du blog par défaut.';
$messages['blog_deleted_ok'] = 'Blog « %s » désactivé';
$messages['blogs_deleted_ok'] = '%s blogs supprimés';
$messages['error_deleting_blog'] = 'Erreur en désactivant le blog « %s »';
$messages['error_deleting_blog2'] = 'Erreur en désactivant le blog avec l’identifiant « %s »';
$messages['error_adding_blog'] = 'Erreur en ajoutant le blog. Vérifiez les données entrées et recommencez';
$messages['blog_added_ok'] = 'Blog « %s » ajouté';
$messages['blog_status_help'] = 'Statut du blog.';
$messages['blog_owner_help'] = 'Membre considéré comme propriétaire du blog, qui aura un contrôle total des paramètres du blog.';
$messages['users'] = 'Membres';
$messages['blog_quota_help'] = 'Quota de ressource en octets. Mettre à  0 pour illimité, ou laisser vide pour utiliser le quota par défaut.';
$messages['edit_blog_settings_updated_ok'] = 'Blog « %s » mis à jour';
$messages['error_updating_blog_settings'] = 'Erreur en mettant à  jour le blog « %s »';
$messages['error_incorrect_blog_owner'] = 'Membre sélectionné comme propriétaire incorrect.';
$messages['error_fetching_blog'] = 'Erreur en récupérant le blog';
$messages['error_updating_blog_settings2'] = 'Erreur en mettant à jour le blog. Vérifiez les données entrées et recommencez.';
$messages['add_or_remove'] = 'Ajouter ou supprimer des membres';
$messages['locale'] = 'Traduction';
$messages['locale_encoding'] = 'Encodage';
$messages['locale_deleted_ok'] = 'Traduction « %s » supprimée';
$messages['error_no_locales_selected'] = 'Aucune traduction sélectionnée pour être supprimée';
$messages['error_deleting_only_locale'] = 'Cette traduction ne peut être supprimée car c’est la seule présente sur le système.';
$messages['locales_deleted_ok'] = '%s traductions supprimées';
$messages['error_deleting_locale'] = 'Erreur en supprimant la traduction « %s »';
$messages['error_locale_is_default'] = 'La traduction « %s » ne peut être supprimée car il s’agit de la traduction par défaut pour les nouveaux blogs.';
$messages['error_invalid_locale_file'] = 'Fichier de traduction invalide';
$messages['error_no_new_locales_found'] = 'Pas de nouveau fichier de traduction trouvé';
$messages['locale_added_ok'] = 'Traduction « %s » ajouté';
$messages['error_saving_locale'] = 'Erreur en sauvegardant la nouvelle traduction';
$messages['scan_locales'] = 'Scanner les traductions';
$messages['add_locale_help'] = 'Utilisez ce formulaire pour téléverser une nouvelle traduction. Si vous ne pouvez pas téléverser de traduction par ce formulaire, téléversez-le manuellement dans le répertoire <b>./locales/</b>, qui est le dossier où les gabarits de blog sont stockés et cliquez sur « <b>Scanner les traductions</b> » . LifeType scannera le dossier et ajoutera automatiquement les nouvelles traductions.';
$messages['error_template_is_default'] = 'Le gabarit « %s » ne peut être supprimée car il s’agit du gabarit par défaut';
$messages['global_template_package_help'] = 'Utilisez ce formulaire pour téléverser un nouvau gabarit, qui sera utilisable sur tous les nouveaux blogs. Si vous ne pouvez pas téléverser un gabarit par ce formulaire, téléversez-le manuellement dans le répertoire <b>%s</b>, qui est le dossier où les gabarits de blog sont stockés et cliquez sur « <b>Scanner les gabarits</b> » . LifeType scannera le dossier et ajoutera automatiquement les nouveaux gabarits.';
$messages['site_config_saved_ok'] = 'Paramètres de site sauvegardés';
$messages['error_saving_site_config'] = 'Erreur en sauvegardant les paramètres de site';
$messages['help_comments_enabled'] = 'Activer ou désactiver les commentaires sur les nouveaux blogs. [Défaut : Activer]';
$messages['help_beautify_comments_text'] = 'Formater les commentaires postés en ajoutant des paragraphes et des liens automatiques pour toutes les URLs. [Défaut : Activer]';
$messages['help_temp_folder'] = 'Répertoire que LifeType peut utiliser pour écrire les données temporaires comme les gabarits compilés, etc. Utiliser un répertoire hors de cette partie du serveur pour augmenter la sécurité. [Défaut : ./tmp]';
$messages['help_base_url'] = 'URL de base où ce blog est installé.';
$messages['help_subdomains_enabled'] = 'Activer ou désactiver les sous-domaines. Veuillez lire la documentation au sujet des sous-domaines pour plus d’informations. [Défaut : Non]';
$messages['help_include_blog_id_in_url'] = 'Si les sous-domaines sont activés et que les URLs sont en mode « normal », force les URL générées à ne pas utiliser l’identifiant de blog. Ne changez ce paramètre que si vous savez exactement ce que vous faites. [Défaut : Oui]';
$messages['help_script_name'] = 'Changez ceci si vous souhaitez renommer « index.php » en autre chose. [Défaut : index.php]';
$messages['help_show_posts_max'] = 'Nombre maximum d’articles affichés sur la page principale. S’applique aux nouveaux blogs uniquement. [Défaut : 15]';
$messages['help_recent_posts_max'] = 'Nombre maximum d’articles récents affichés sur la page principale. S’applique aux nouveaux blogs uniquement. [Défaut : 10]';
$messages['help_save_drafts_via_xmlhttprequest_enabled'] = 'Active ou désactive la fonctionnalité de sauvegarde des brouillons par Ajax. [Défaut : Oui]';
$messages['help_locale_folder'] = 'Répertoire où sont stockées les traductions. [Défaut : ./locale]';
$messages['help_default_locale'] = 'Langue par défaut des nouveaux blogs. [Défaut : en_UK]';
$messages['help_default_blog_id'] = 'Blog affiché par défaut si aucun n’est spécifié. [Défaut : 1]';
$messages['help_default_time_offset'] = 'Zone horaire par défaut pour les nouveaux blogs. [Défaut : 0]';
$messages['help_html_allowed_tags_in_comments'] = 'Tags HTML autorisés dans les commentaires, séparés par des espaces. [Défaut : &lt;a&gt;&lt;i&gt;&lt;br&gt;&lt;br/&gt;&lt;b&gt;]';
$messages['help_referer_tracker_enabled'] = 'Activer ou désactiver la fonctionnalité de sauvegarde des référants en base de données. Désactivez-la pour améliorer les performances. [Défaut : Oui]';
$messages['help_show_more_enabled'] = 'Activer ou désactiver par défaut le lien « (Lire la suite de l’article) » des articles pour les nouveaux blogs. [Défaut : Oui]';
$messages['help_update_article_reads'] = 'Activer ou désactiver le compteur de lectures. Désactivez pour améliorer les performances. [Défaut : Oui]';
$messages['help_update_cached_article_reads'] = 'Activer ou désactiver le compteur de lectures des articles mis en cache. Désactivez pour améliorer les performances. [Défaut : Oui]';
$messages['help_xmlrpc_ping_enabled'] = 'Activer ou désactiver les pings XML-RPC pour les sites qui les supportent. [Défaut : Oui]';
$messages['help_send_xmlrpc_pings_enabled_by_default'] = 'Activer ou désactiver cette fonctionnalité par défaut lors de l’ajout ou de la modification d’articles. [Défaut : Oui]';
$messages['help_xmlrpc_ping_hosts'] = 'URLs des sites disposant d’une interface XML-RPC. Une URL par ligne. [Défaut : http://rpc.weblogs.com/RPC2]';
$messages['help_trackback_server_enabled'] = 'Activer ou désactiver la possibilité de recevoir des rétroliens. [Défaut : Oui]';
$messages['help_htmlarea_enabled'] = 'Activer ou désactiver l’éditeur enrichi de texte. [Défaut : Oui]';
$messages['help_plugin_manager_enabled'] = 'Activer ou désactiver les modules. [Défaut : Oui]';
$messages['help_minimum_password_length'] = 'Taille minimale des mots de passe. [Défaut : 4]';
$messages['help_xhtml_converter_enabled'] = 'Convertir tout le code HTML en code XHTML valide. [Défaut : Oui]';
$messages['help_xhtml_converter_aggressive_mode_enabled'] = 'Si cette case est cochée, le système essayera de convertir encore plus le code HTML en XHTML valide, mais il y a un risque plus élevé d’erreurs. [Défaut : Non]';
$messages['help_session_save_path'] = 'Utilisez ce champ pour spécifier où LifeType sauvegarde des données de session, via la fonction PHP session_save_path(). Veuillez vous assurer que ce dossier est en lecture/écriture pour l’utilisateur du serveur web. Laissez vide pour conserver le dossier PHP par défaut. [Défaut : <i>vide</i>]';
$messages['help_summary_page_show_max'] = 'Nombre d’articles qui seront affichés sur la page résumé. Ce paramètre contrôle toutes les listes de la page du sommaire. [Défaut : 10]';
$messages['help_summary_items_per_page'] = 'Nombre de blogs par page dans la section « Liste de blogs ». [Défaut : 25]';
$messages['help_forbidden_usernames'] = 'Liste de noms d’utilisateur non autorisés à s’inscrire. [Défaut : admin www blog ftp]';
$messages['help_force_one_blog_per_email_account'] = 'Restreindre à seulement un blog par adresse électronique. [Défaut : Non]';
$messages['help_summary_show_agreement'] = 'Afficher un message d’avertissement et demander l’acceptation aux utilisateurs qui s’inscrivent. [Défaut : Oui]';
$messages['help_need_email_confirm_registration'] = 'Obliger les utilisateurs à  confirmer leur inscription en cliquant sur un lien envoyé par courriel (recommandé). [Défaut : Oui]';
$messages['help_summary_disable_registration'] = 'Désactiver l’inscription à de nouveaux blogs sur ce site. [Défaut : Oui]';
$messages['help_template_folder'] = 'Dossier où sont stockés les gabarits. [Défaut : ./templates]';
$messages['help_default_template'] = 'Gabarit par défaut des nouveaux blogs. [Défaut : standard]';
$messages['help_users_can_add_templates'] = 'Autoriser les utilisateurs à téléverser leurs propres gabarits. [Défaut : Oui]';
$messages['help_template_compile_check'] = 'Vérifier à chaque fois si le gabarit a été modifié, et modifier les pages en conséquence. Désactivez pour améliorer les performances. [Défaut : Oui]';
$messages['help_template_cache_enabled'] = 'Activer le cache de gabarits. Les gabarits seront précompilés, et aucun accès à la base de données ne sera nécessaire (recommandé). [Défaut : Oui]';
$messages['help_template_cache_lifetime'] = 'Durée de vie du cache en secondes. Mettez -1 pour que le cache n’expire jamais. Si vous mettez 0, le cache sera désactivé, mais préférez l’option « Désactiver le cache » pour cette fonctionnalité. [Défaut : -1]';
$messages['help_template_http_cache_enabled'] = 'Activer le support des requêtes HTTP conditionnelles. Si activé, LifeType vérifiera le champ « If-Modified-Since » de l’en-tête HTTP et n’enverra une réponse que s’il y a lieu. Utilisez ceci pour sauvegarder de la bande passante. [Défaut : Non]';
$messages['help_allow_php_code_in_templates'] = 'Autoriser l’utilisation de code PHP dans les gabarits Smarty ({php}...{/php}). Pour des raisons de sécurité, fortement déconseillé. [Défaut : Non]';
$messages['help_request_format_mode'] = 'Sélectionner un des formats d’URL disponibles. Si vous utlisez les URLs personnalisées, configurez les paramètres ci-dessous. [Défaut : normal]';
$messages['plain'] = 'normal';
$messages['search_engine_friendly'] = 'moteur de recherches';
$messages['custom_url_format'] = 'URLs personnalisées';
$messages['help_permalink_format'] = 'Format des liens permanents lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/{catname}/{year}/{month}/{day}/{postname}$]';
$messages['help_category_link_format'] = 'Format des liens vers les catégories lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/{catname}$]';
$messages['help_blog_link_format'] = 'Format des liens vers les blogs lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}$]';
$messages['help_archive_link_format'] = 'Format des liens vers les archives lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/archives/{year}/?{month}/?{day}]';
$messages['help_user_posts_link_format'] = 'Format des liens vers des articles postés par certains membres lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/user/{username}$]';
$messages['help_post_trackbacks_link_format'] = 'Format vers les rétroliens page lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/post/trackbacks/{postname}$]';
$messages['help_template_link_format'] = 'Format des liens vers les pages de gabarits classiques personnalisées lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/content/{templatename}$]';
$messages['help_album_link_format'] = 'Format des liens vers les albums lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/album/{albumname}$]';
$messages['help_resource_link_format'] = 'Format des liens vers les pages de ressources avec des fichiers lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/resource/{albumname}/{resourcename}$]';
$messages['help_resource_preview_link_format'] = 'Format des liens vers les aperçus des ressources lors de l’utilisation des URLs pérsonnalisées. [Défaut : /blog/{blogname}/resource/{albumname}/preview/{resourcename}$]';
$messages['help_resource_medium_size_preview_link_format'] = 'Format des liens vers les aperçus de moyenne taille des ressources lors de l’utilisation des URLs pérsonnalisées. [Défaut : /blog/{blogname}/resource/{albumname}/preview-med/{resourcename}$]';
$messages['help_resource_download_link_format'] = 'Format des liens vers les fichiers lors de l’utilisation des URLs personnalisées. [Défaut : /blog/{blogname}/resource/{albumname}/download/{resourcename}$]';
$messages['help_check_email_address_validity'] = 'Vérifier l’adresse électronique des nouveaux membres. [Défaut : Non]';
$messages['help_email_service_enabled'] = 'Activer/Désactiver le service de courrier électronique. [Défaut : Oui]';
$messages['help_email_service_type'] = 'Méthode d’envoi des courriels. [Défaut : PHP]';
$messages['help_smtp_host'] = 'Si vous utilisez SMTP, remplir ici le serveur qui sera utilisé pour l’envoi de courriels. [Défaut : <i>vide</i>]';
$messages['help_smtp_port'] = 'Si le serveur SMTP fonctionne sur un port autre que le 25, configurer la bonne valeur. [Défaut : <i>vide</i>]';
$messages['help_smtp_use_authentication'] = 'Activer si le serveur SMTP requiert une authentification.  [Défaut : Non]';
$messages['help_smtp_username'] = 'Si le SMTP requiert une authentification, remplir l’identifiant. [Défaut : <i>vide</i>]';
$messages['help_smtp_password'] = 'Si le SMTP requiert une authentification, remplir le mot de passe. [Défaut : <i>vide</i>]';
$messages['help_path_to_tar'] = 'Chemin vers « tar », nécessaire pour décompresser les formats « .tar.bz » ou « .tar.bz2 ». [Défaut : /bin/tar]';
$messages['help_path_to_gzip'] = 'Chemin vers « gzip », nécessaire pour décompresser les formats « .tar.gz ». [Défaut : /bin/gzip]';
$messages['help_path_to_bz2'] = 'Chemin vers « bz2 », nécessaire pour décompresser les formats « .tar.gz2 ». [Défaut : /usr/bin/bzip2]';
$messages['help_path_to_unzip'] = 'Chemin vers « unzip », nécessaire pour décompresser le format « .zip ». [Défaut : /usr/bin/unzip]';
$messages['help_unzip_use_native_version'] = 'Utiliser les fonctions PHP natives pour décompresser les fichiers « .zip ». [Défaut : Non]';
$messages['help_uploads_enabled'] = 'Activer/Désactiver le téléversement de TOUS les fichiers. [Défaut : Oui]';
$messages['help_maximum_file_upload_size'] = 'Taille maximale en octets des fichiers téléversés; ne doit jamais être supérieure à la limite interne de PHP. [Défaut : 2 000 000]';
$messages['help_upload_forbidden_files'] = 'Liste des extensions de fichiers interdits, séparés par un espace. Vous pouvez utiliser « * » ou « ? ». [Défaut : *.php *.php3 *.php4 *.phtml]';
$messages['help_xmlrpc_api_enabled'] = 'Activer/Désactiver XMLRPC. [Défaut : Oui]';
$messages['help_rdf_enabled'] = 'Activer la syndication des contenus via Atom ou RSS. [Défaut : Oui]';
$messages['help_default_rss_profile'] = 'Version par défaut de RSS ou d’Atom utilisée pour syndiquer les flux sauf si quelque chose d’autre est spécifié. [Défaut : RSS 1.0]';
$messages['help_security_pipeline_enabled'] = 'Activer les fonctions de sécurité et tous les filtres associés. Ceci affecte aussi les modules qui enregistrent de nouveaux filtres. [Défaut : Oui]';
$messages['help_maximum_comment_size'] = 'Taille maximum en octets des commentaires, mettre à 0 pour désactiver cette fonctionnalité. [Défaut : 0]';
$messages['help_bayesian_filter_enabled'] = 'Activer/Désactiver le filtrage bayesien (spam) pour améliorer les messages indésirables. [Défaut : Oui]';
$messages['help_bayesian_filter_spam_probability_treshold'] = 'Valeur maximale avant qu’un commentaire soit considéré comme indésirable. [Défaut : 0.9]';
$messages['help_bayesian_filter_nonspam_probability_treshold'] = 'Valeur minimale au dessus de laquelle un commentaire est considéré comme indésirable. [Défaut : 0.2]';
$messages['help_bayesian_filter_min_length_token'] = 'Longueur minimale d’un jeton pour être considéré comme pertinent pour le filtre bayesien. [Défaut : 3]';
$messages['help_bayesian_filter_max_length_token'] = 'Longueur maximale d’un jeton pour être considéré comme pertinent pour le filtre bayesien. [Défaut : 100]';
$messages['help_bayesian_filter_number_significant_tokens'] = 'Nombre de jetons significatifs. [Défaut : 15]';
$messages['help_bayesian_filter_spam_comments_action'] = 'Que faire des commentaires marqués comme indésirables. Les supprimer quand le filtre sera suffisamment entraîné. [Défaut : Garder…]';
$messages['keep_spam_comments'] = 'Garder dans la base de données les commentaires marqués comme « indésirable »';
$messages['throw_away_spam_comments'] = 'Les supprimer directement (ne pas les sauvegarder)';
$messages['help_resources_enabled'] = 'Activer ou non les ressources. [Défaut : Oui]';
$messages['help_resources_folder'] = 'Chemin vers le répertoire où les ressources sont stockées (images, vidéos, etc…). [Défaut : ./gallery]';
$messages['help_thumbnail_method'] = 'Méthode de génération des aperçus. Avec PHP, le support GD est nécessaire. [Défaut : PHP]';
$messages['help_path_to_convert'] = 'Répertoire de l’outil « convert » du package ImageMagick. Obligatoire si la méthode de génération d’aperçu est « ImageMagick ». [Défaut : /usr/bin/convert]';
$messages['help_thumbnail_format'] = 'Format dans lequel les aperçus seront sauvegardés. [Défaut : Same as image]';
$messages['help_thumbnail_height'] = 'Hauteur par défaut des petits aperçus. [Défaut : 120]';
$messages['help_thumbnail_width'] = 'Largeur par défaut des petits aperçus. [Défaut : 120]';
$messages['help_medium_size_thumbnail_height'] = 'Hauteur par défaut des aperçus de taille moyenne. [Défaut : 480]';
$messages['help_medium_size_thumbnail_width'] = 'Largeur par défaut des aperçus de taille moyenne. [Défaut : 640]';
$messages['help_thumbnails_keep_aspect_ratio'] = 'Conserver les proportions lors de la génération des aperçus. Peut générer des aperçus plus grands que la taille spécifiée au dessus, mais de qualité meilleure. [Défaut : Oui]';
$messages['help_thumbnail_generator_force_use_gd1'] = 'Forcer LifeType à  utiliser uniquement les fontions GD1. [Défaut : Non]';
$messages['help_thumbnail_generator_user_smoothing_algorithm'] = 'Algorithme utilisé pour lisser les aperçus. Utilisé uniquement quand la méthode de génération d’aperçu est GD. [Défaut : PHP Imagecopyresampled]';
$messages['help_resources_quota'] = 'Quota de ressources pour les blogs par défaut en octets (ex. 5 242 880 octets = 5 Mo), ou laisser à 0 pour ne pas limiter le quota. [Défaut : 0]';
$messages['help_resource_server_http_cache_enabled'] = 'Activer le support des requêtes HTTP conditionnelles. À activer pour réduire l’utilisation de bande passante. [Défaut : Non]';
$messages['help_resource_server_http_cache_lifetime'] = 'Temps en secondes pendant lequel les ressources sont mises en cache. [Défaut : 86 400]';
$messages['same_as_image'] = 'Pareille que l’image originale';
$messages['help_search_engine_enabled'] = 'Activer ou non le moteur de recherche. [Défaut : Oui]';
$messages['help_search_in_custom_fields'] = 'Rechercher dans les champs personnalisés. [Défaut : Oui]';
$messages['help_search_in_comments'] = 'Rechercher dans les commentaires. [Défaut : Oui]';
$messages['purge'] = 'Nettoyer';
$messages['cleanup_spam'] = 'Nettoyer les indésirables';
$messages['cleanup_spam_help'] = 'Ceci supprimera définitivement tous les commentaires marqués comme indésirables. Ils ne sera pas possible de revenir en arrière.';
$messages['spam_comments_purged_ok'] = 'Commentaires indésirables nettoyés';
$messages['cleanup_posts'] = 'Nettoyer les articles';
$messages['cleanup_posts_help'] = 'Ceci supprimera définitivement tous les articles supprimés (marqués comme « supprimés »). Il sera impossible de les récupérer après !';
$messages['posts_purged_ok'] = 'Articles nettoyés ';
$messages['purging_error'] = 'Erreur lors du nettoyage des données';
$messages['summary'] = 'Accueil';
$messages['register'] = 'S’inscrire';
$messages['summary_welcome'] = 'Bienvenue !';
$messages['summary_most_active_blogs'] = 'Blogs les plus actifs';
$messages['summary_most_commented_articles'] = 'Articles les plus commentés';
$messages['summary_most_read_articles'] = 'Articles les plus lus';
$messages['password_forgotten'] = 'Vous avez perdu votre mot de passe ?';
$messages['summary_newest_blogs'] = 'Nouveaux blogs';
$messages['summary_latest_posts'] = 'Derniers articles';
$messages['summary_search_blogs'] = 'Recherche d’un blog';
$messages['updated'] = 'Mis à jour';
$messages['total_reads'] = 'lectures';
$messages['latest_posts'] = 'Derniers articles';
$messages['register_step0_title'] = 'Accepter les conditions d’utilisation';
$messages['agreement'] = 'Conditions d’utilisation';
$messages['decline'] = 'Refuser';
$messages['accept'] = 'Accepter';
$messages['read_service_agreement'] = 'Veuillez lire les termes de ce service et cliquer sur le bouton « Accepter » si vous êtes d’accord';
$messages['register_step1_title'] = 'Créer votre compte [1/4]';
$messages['register_step1_help'] = 'Vous devez créer un compte pour ensuite avoir un blog. Ce compte sera le compte principal de ce blog et aura accès à toutes ses fonctionnalités.';
$messages['register_next'] = 'Suivant';
$messages['register_back'] = 'Retour';
$messages['register_step2_title'] = 'Créer votre Blog [2/4]';
$messages['register_blog_name_help'] = 'Nom du nouveau blog.';
$messages['register_step3_title'] = 'Choisir un gabarit [3/4]';
$messages['step1'] = 'Étape 1';
$messages['step2'] = 'Étape 2';
$messages['step3'] = 'Étape 3';
$messages['register_step3_help'] = 'Sélectionnez un des gabarits disponibles qui sera celui par défaut de votre blog. Vous pourrez le changer ultérieurement.';
$messages['error_must_choose_template'] = 'Vous devez choisir un gabarit';
$messages['select_template'] = 'Sélectionner un gabarit';
$messages['register_step5_title'] = 'Merci ! [4/4]';
$messages['finish'] = 'Fin';
$messages['register_need_confirmation'] = 'Un courriel de confirmation vous a été envoyé, cliquez sur le lien dès que vous recevrez ce message pour démarrer l’édition du blog';
$messages['register_step5_help'] = 'Merci, votre compte et votre blog ont été créés !';
$messages['register_blog_link'] = 'Si vous voulez voir votre Blog, Vous pouvez aller ici : <a href="%2$s">%1$s</a>';
$messages['register_blog_admin_link'] = 'Si vous préférez rédiger et publier des articles sur votre blog, cliquez ici pour accéder à <a href="admin.php">l’interface d’administration</a>';
$messages['register_error'] = 'Erreur durant la procédure';
$messages['error_registration_disabled'] = 'Désolé, les inscriptions sont momentanément suspendues';
$messages['register_default_article_topic'] = 'Félicitations !';
$messages['register_default_article_text'] = 'Si vous pouvez lire cet article, cela signifie que votre enregistrement s’est déroulé correctement et que vous pouvez démarrer l’édition et la publication d’articles.';
$messages['register_default_category'] = 'Général';
$messages['register_confirmation_email_text'] = 'Bonjour,
Veuillez cliquer sur ce lien pour activer votre blog:

%s

Bonne journée.';
$messages['error_invalid_activation_code'] = 'Désolé, votre numéro de confirmation est invalide.';
$messages['blog_activated_ok'] = 'Félicitations, votre compte et votre blog ont été activés !';
$messages['reset_password'] = 'Réinitialiser votre mot de passe';
$messages['reset_password_username_help'] = 'Nom d’utilisateur (pour qui le mot de passe doit être réinitialisé).';
$messages['reset_password_email_help'] = 'Adresse électronique utilisée pour l’inscription de cet utilisateur.';
$messages['reset_password_help'] = 'Utilisez ce formulaire pour réinitialiser votre mot de passe perdu. Entrez à la fois le nom d’utilisateur et l’adresse électronique utilisée pour l’inscription.';
$messages['error_resetting_password'] = 'Il y a eu une erreur lors de la réinitialisation du mot de passe. Vérifiez les données entrées et recommencez.';
$messages['reset_password_error_incorrect_email_address'] = 'L’adresse électronique spécifiée est incorrecte, ou ne correspond pas à celle utilisée pour l’inscription.';
$messages['password_reset_message_sent_ok'] = 'Un courriel vous a été envoyé. Cliquez sur le lien qu’il contient pour réinitialiser votre mot de passe.';
$messages['error_incorrect_request'] = 'Les paramètres d’URL sont incorrects.';
$messages['change_password'] = 'Nouveau mot de passe';
$messages['change_password_help'] = 'Confirmez votre nouveau mot de passe.';
$messages['new_password'] = 'Nouveau mot de passe';
$messages['new_password_help'] = 'Entrez ici votre nouveau mot de passe.';
$messages['password_updated_ok'] = 'Votre mot de passe a bien été mis à jour';
$messages['upgrade_information'] = 'Cette page apparait brute et non stylée parce que vous utilisez un navigateur non conforme. Mettez à jour votre navigateur pour la voir dans les meilleures conditions.';
$messages['jump_to_navigation'] = 'Aller au menu';
$messages['comment_email_never_display'] = 'Retours à la ligne automatiques, adresse électronique jamais affichée.';
$messages['comment_html_allowed'] = '<acronym title="Hypertext Markup Language">HTML</acronym> allowed: &lt;<acronym title="Hyperlink">a</acronym> href=&quot;&quot; title=&quot;&quot; rel=&quot;&quot;&gt; &lt;<acronym title="Acronym Description">acronym</acronym> title=&quot;&quot;&gt; &lt;<acronym title="Quote">blockquote</acronym> cite=&quot;&quot;&gt; &lt;<acronym title="Strike">del</acronym>&gt; &lt;<acronym title="Italic">em</acronym>&gt; &lt;<acronym title="Underline">ins</acronym>&gt; &lt;<acronym title="Bold">strong</acronym>&gt;';
$messages['trackback_uri'] = 'L’<acronym title="Uniform Resource Identifier">URI</acronym> de rétrolien pour cet article est : ';
$messages['xmlrpc_ping_ok'] = 'Ping XMLRPC envoyé avec succès';
$messages['error_sending_xmlrpc_ping'] = 'Erreur lors de l’envoi du ping XMLRPC vers : ';
$messages['error_sending_xmlrpc_ping_message'] = 'Erreur lors de l’envoi du ping XMLRPC : ';
$messages['error_incorrect_trackback_id'] = 'L’identifiant du rétrolien est incorrect';
$messages['error_marking_trackback_as_spam'] = 'Erreur lors du marquage du rétrolien comme indésirable';
$messages['trackback_marked_as_spam_ok'] = 'Rétrolien marqué comme indésirable';
$messages['error_marking_trackback_as_nonspam'] = 'Erreur lors du marquage du rétrolien comme désirable';
$messages['trackback_marked_as_nonspam_ok'] = 'Rétrolien marqué comme désirable';
$messages['upload_here'] = 'Téléverser…';
$messages['cleanup_users'] = 'Purge des utilisateurs';
$messages['cleanup_users_help'] = 'Cette action purge tous les utilisateurs qui avaient été supprimés par l’administrateur (marqués comme « supprimés »). Il enlèvera également tous les blogs et leurs contenus de cet utilisateur. Si un utilisateur avait des droits pour poster dans d’autres blogs, tous ses posts seront supprimés. Il n’est pas possible de revenir en arrière après la purge.';
$messages['users_purged_ok'] = 'Purge des utilisateurs réussie';
$messages['cleanup_blogs'] = 'Purge des blogs';
$messages['cleanup_blogs_help'] = 'Cette action purge tous les blogs qui avaient été supprimés par l’administrateur (marqués comme « supprimés »). Il supprime tout le contenu de ces blogs. Il n’est pas possible de revenir en arrière après la purge.';
$messages['blogs_purged_ok'] = 'Purge des blogs réussie';
$messages['help_use_http_accept_language_detection'] = 'La plupart des navigateurs, comme Mozilla Firefox, Safari ou Internet Explorer, envoient le code de la langue que de l’utilisateur est <i>supposé</i> comprendre. Si cette fonctionnalité est activée, LifeType essaye, si possible, de servir l’utilisateur avec la langue demandée. [Défaut : Non]';
$messages['error_invalid_blog_category'] = 'Catégorie de blog invalide';
$messages['error_adding_blog_category'] = 'Erreur lors de l’ajout de la catégorie de blogs';
$messages['newBlogCategory'] = 'Nouvelle catégorie de blogs';
$messages['editBlogCategories'] = 'Catégorie de blogs';
$messages['blog_category_added_ok'] = 'Nouvelle catégorie de blogs ajoutée avec succès';
$messages['error_blog_category_has_blogs'] = 'La catégorie de blogs « %s » a des blogs qui lui sont assignés. Éditez d’abord ces blogs et reéssayer ensuite.';
$messages['error_deleting_blog_category'] = 'Une erreur s’est produite lors de la suppression de la catégorie de blogs';
$messages['blog_category_deleted_ok'] = 'La catégorie de blogs « %s » a été supprimé avec succès';
$messages['blog_categories_deleted_ok'] = 'Catégorie de blogs « %s » supprimée avec succès';
$messages['error_deleting_blog_category2'] = 'Une erreur s’est produite lors de la suppression de la catégorie de blogs dont l’identifiant est « %s »';
$messages['blog_category'] = 'Catégorie de blogs';
$messages['blog_category_help'] = 'Catégorie générale de blog assignée à ce blog.';
$messages['help_use_captcha_auth'] = 'Utiliser un mécanisme de CAPTCHA lors de processus d’inscription pour éviter automatiquement l’inscription des scripts robots. [Défaut : Non]';
$messages['help_skip_dashboard'] = 'La page de tableau de bord ne sera plus affichée à la connection des utilisateurs qui seront dirigés vers le premier blog auquel ils appartiennent. [Défaut : Non]';
$messages['manageGlobalArticleCategory'] = 'Catégories globales d’articles';
$messages['newGlobalArticleCategory'] = 'Nouvelle catégorie globale d’articles';
$messages['editGlobalArticleCategories'] = 'Éditer les catégories globales d’articles';
$messages['global_category_name_help'] = 'Nom de la nouvelle catégorie globale d’article.';
$messages['global_category_description_help'] = 'Description de la nouvelle catégorie globale d’article.';
$messages['error_incorrect_global_category_id'] = 'Catégorie globale d’article invalide';
$messages['global_category_deleted_ok'] = 'La catégorie d’article « %s » a été supprimée';
$messages['global_category_added_ok'] = 'La catégorie globale « %s » a été ajoutée';
$messages['error_deleting_global_category2'] = 'Une erreur s’est produite lors du retrait de la catégorie d’articles avec l’identifiant « %s »';
$messages['help_page_suffix_format'] = 'Suffixe qui sera rajouté aux URLs supportant la pagination. [Défaut : /page/{page}]';
$messages['help_final_size_thumbnail_width'] = 'Largeur finale des images téléversées. Laisser vide ou égal à 0 pour stocker les images en taille initiale. [Défaut : 0]';
$messages['help_final_size_thumbnail_height'] = 'Hauteur finale des images téléchargées. Laisser vide ou égal à 0 pour stocker les images en taille initiale. [Défaut : 0]';
$messages['error_comment_too_big'] = 'Ce commentaire est trop long';
$messages['error_you_have_been_blocked'] = 'Interdit: cette requête n’a pas abouti';
$messages['created'] = 'Créé';
$messages['view'] = 'Voir';
$messages['editUser'] = 'Paramètres de l’utilisateur';
$messages['help_urlize_word_separator'] = 'Caractère qui sera employé comme séparateur de mot pour les URLs des pages LifeType. Il sera aussi utilisé pour la génération des noms de blogs si le support des sous-domaines est activé. [Défaut : -]';
$messages['help_summary_template_cache_lifetime'] = 'Durée de vie en secondes du sommaire du cache des pages. Si vous parémétrez une valeur autre que 0, le sommaire des pages sera conservé aussi longtemps qu’indiqué ici, au lieu d’être mis à jour à chaque changement de données.';
$messages['register_default_album_name'] = 'Général';
$messages['register_default_album_description'] = 'Utiliser cet album pour téléverser les nouvelles images';
$messages['show_in_summary'] = 'Montrer dans le sommaire';
$messages['show_in_summary_help'] = 'Inclure ce blog dans le sommaire du site.';
$messages['saving_message'] = 'Enregistrement en cours…';
$messages['show_option_panel'] = 'Montrer les options';
$messages['hide_option_panel'] = 'Masquer les options';
$messages['quick_launches'] = 'Lancements rapides';
$messages['confirmation_message_resent_ok'] = 'Message de confirmation réenvoyé avec succès.';
$messages['goto_blog_page'] = 'Aller à  %s';
$messages['help_num_blogs_per_user'] = 'Nombre de blogs que l’utilisateur peut créer à travers cette interface d’administration.';
$messages['massive_change_option'] = 'Éditer les options en masse';
$messages['show_massive_change_option'] = 'Voir l’édition des options en masse';
$messages['hide_massive_change_option'] = 'Masquer l’édition des options en masse';
$messages['change_status'] = 'Changer de statut';
$messages['change_category'] = 'Changer de catégorie';
$messages['error_updating_comment_no_comment'] = 'Une erreur s’est produite lors de la mise à jour du commentaire. Commentaire n°%s introuvable.';
$messages['error_updating_comment_wrong_blog'] = 'Une erreur s’est produite lors de la mise à jour du commentaire. Le commentaire « %s » n’a pas été posté sur ce blog.';
$messages['error_updating_comment'] = 'Une erreur s’est produite lors de la mise à  jour de « %s »';
$messages['error_updating_comment_already_updated'] = 'Aucun changement fait à « %s »';
$messages['comment_updated_ok'] = 'Commentaire mis à jour avec succès';
$messages['comments_updated_ok'] = '%s commentaires mis à jour avec succès';
$messages['error_post_status'] = 'SVP, sélectionnez le statut du post';
$messages['error_comment_status'] = 'SVP, sélectionnez le statut du commentaire';
$messages['admin_mode'] = 'Mode administrateur';
$messages['administrate_user_blog'] = 'Administrer ce blog';
$messages['trackbacks_updated_ok'] = '%s rétroliens mis à jour avec succès';
$messages['trackback_updated_ok'] = 'Rétrolien mis à jour avec succès';
$messages['error_trackback_status'] = 'Veuillez sélectionner un statut valide';
$messages['remove_selected'] = 'Supprimer la sélection';
$messages['notification_subject'] = 'Système de notification de LifeType';
$messages['error_no_trackback_links_sent'] = 'Attention : Aucun rétrolien envoyé';
$messages['help_http_cache_lifetime'] = 'Durée de vie en secondes du cache coté client. Les navigateurs ne feront pas de requête vers le serveur pendant ce laps de temps, et les pages viendront du cache local. La navigation sera plus rapide, mais les articles et les commentaires ne seront pas immédiatemnt visibles. [Défaut : 1 800]';
$messages['trackbacks_no_trackback'] = 'L’envoi d’un rétrolien à l’URL suivante a échoué';
$messages['error_comment_spam_throw_away'] = 'Vous ne pouvez pas poster ce message. Le filtre bayesien l’a bloqué';
$messages['error_comment_spam_keep'] = 'Le filtre bayesien a mis votre commentaire dans la file de modération et il devra être approuvé par le propriétaire du blog.';
$messages['blog_categories'] = 'Catégories de blogs';
$messages['global_article_categories'] = 'Catégories d’article global';
$messages['help_force_posturl_unique'] = 'Forcer l’unicité de toutes les URLs d’articles dans un blog. Nécessaire uniquement si vous changez les URLs et supprimez les dates dans les URLs.';
$messages['default_send_notification'] = 'Notification d’envoi par défaut';
$messages['enable_pull_down_menu'] = 'Menu déroulant';
$messages['enable_pull_down_menu_help'] = 'Activer ou désactiver le menu déroulant.';
$messages['change_album'] = 'Changer d’album';
$messages['warning_autosave_message'] = '<img src="imgs/admin/icon_warning-16.png" alt="Erreur" class="InfoIcon"/><p class="ErrorText">Vous avez quitté cette page sans sauvegarder votre article. Si c’est le cas,<a href="#" onclick="restoreAutoSave();">cliquez ici pour le récupérer</a> ou <a href="#" onclick="eraseAutoSave();">supprimez le</a></p> ';
$messages['check_username'] = 'Vérifier l’identifiant';
$messages['check_username_ok'] = 'L’identifiant est disponible';
$messages['error_username_exist'] = 'Désolé, l’identifiant n’est pas disponible. Essayez-en d’autres.';
$messages['error_rule_email_dns_server_temp_fail'] = 'Echec temporaire - essayez plus tard';
$messages['error_rule_email_dns_server_unreachable'] = 'Echec de la connexion au serveur de courrier électronique';
$messages['error_rule_email_dns_not_permitted'] = 'Courriels interdits';
$messages['blog_users_help'] = 'Membres autorisés sur ce blog.';
$messages['summary_welcome_paragraph'] = 'Placez ici le message de bienvenue que verrons vos utilisateurs. Ou supprimez complètement le message actuel et réorganisez la page entière. Ou autre chose ;-) Jetez un coup d’œil dans templates/summary , c’est l’endroit où les fichiers qui constituent cette page sont stockés. Vous êtes libre de les modifier à votre guise.';
$messages['first_day_of_week'] = '0';
$messages['first_day_of_week_label'] = 'Premier jour de la semaine';
$messages['first_day_of_week_help'] = 'Premier jour de la semaine sur le calendrier.';
$messages['help_subdomains_base_url'] = 'Quand les sous-domaines sont activés, cette URL est utilisée à la place de « base_url ». Utilisez {blogname} pour obtenir le nom du blog, {username} pour obtenir le nom du propriétaire du blog et {blogdomain} pour permettre à l’utilisateur de spécifier un sous-domaine pour générer un lien vers un blog. ( Ex. http://{blogname}.votre-domaine.com )';
$messages['registration_default_subject'] = 'Confirmation d’enregistrement sur LifeType';
$messages['error_invalid_subdomain'] = 'Le nom du sous-domaine est invalide ou n’est pas unique';
$messages['register_blog_domain_help'] = 'Nom et sous-domaine que vous souhaitez utiliser pour votre nouveau blog.';
$messages['domain'] = 'Domaine';
$messages['help_subdomains_available_domains'] = 'Entrer un ensemble des domaines principaux autorisés en les séparant par des espaces. L’utilisateur verra une liste déroulante de ces valeurs et pourra ajouter le sous-domaine de son choix. Ceci est utilisé uniquement si vous activez les sous-domaines et utilisez {blogdomain} dans le « subdomain_base_url » du dessus. Utilisez un point d’interrogation « ? » si vous voulez autoriser un domaine.';
$messages['subdomains_any_domain'] = 'Multi domaine activé. Tapez le domaine complet';
$messages['error_updating_blog_subdomain'] = 'Une erreur s’est produite lors de la mise à jour du sous-domaine. Vérifiez encore les données et reéssayez';
$messages['error_updating_blog_main_domain'] = 'Une erreur s’est produite lors de la mise à jour des paramètres du site. L’adminsitrateur a probablement mal configuré un paramètre';
$messages['monthsshort'] = 'Array';
$messages['weekdaysshort'] = 'Array';
$messages['search_type'] = 'Chercher dans';
$messages['upload_in_progress'] = 'Téléversement en cours. Veuillez patienter';
$messages['error_incorrect_username'] = 'Le pseudo est incorrect. Il est déjà  utilisé ou est trop long (maximum de 15 caractères)';
$messages['Miscellaneous'] = 'Divers';
$messages['Plugins'] = 'Modules';
$messages['auth_img'] = 'Code d’authentification';
$messages['auth_img_help'] = 'SVP, tapez le code que vous voyez dans l’image ci-dessous.';
$messages['global_category'] = 'Catégorie générale';
$messages['global_article_category_help'] = 'Catégorie globale du site pour cet article.';
$messages['password_reset_subject'] = 'Demande de réinitialisation du mot de passe';
$messages['auth'] = 'Authentification';
$messages['authenticated'] = 'Authentifié';
$messages['dropdown_list_field'] = 'Menu déroulant';
$messages['values'] = 'Champ de valeurs';
$messages['field_values'] = 'Valeurs qui seront montrées en option dans ce champ. La première sera utilisée comme option par défaut.';
$messages['permission_added_ok'] = 'Permission ajoutée';
$messages['core_perm'] = 'Permission système';
$messages['admin_only'] = 'Admin seulement';
$messages['permissionsList'] = 'Permissions';
$messages['newPermission'] = 'Nouvelle Permission';
$messages['permission_name_help'] = 'Nom unique de la permission.';
$messages['permission_description_help'] = 'Description donnée à la permission.';
$messages['core_perm_help'] = 'Si cette permission fait partie du système, il sera impossible de la supprimer.';
$messages['admin_only_help'] = 'Déterminer si la permission peut seulement être assignée par les administrateurs.';
$messages['error_adding_new_permission'] = 'Erreur lors de l’ajout de la nouvelle permission, veuillez vérifier vos données.';
$messages['error_incorrect_permission_id'] = 'Identifiant de la permission incorrect';
$messages['error_permission_cannot_be_deleted'] = 'La permission « %s » ne peut être supprimée parce que soit elle est attribuée à au moins un utilisateur, soit elle fait partie du système.';
$messages['error_deleting_permission'] = 'Erreur lors de la suppression de la permission « %s »';
$messages['permission_deleted_ok'] = 'Permission « %s » supprimée';
$messages['permissions_deleted_ok'] = '%s permissions  supprimées';
$messages['error_deleting_permission2'] = 'Erreur lors de la suppression de la permission avec l’identifiant « %s »';
$messages['help_hard_show_posts_max'] = 'Limite maximale du nombre d’articles sur les pages du blog. Si un utilisateur paramètre une valeur supérieure, elle sera ignorée et cette valeur-ci sera utilisée. [Défaut : 50]';
$messages['error_permission_required'] = 'Vous n’avez pas suffisamment de permissions pour réaliser l’action demandée';
$messages['user_permissions_updated_ok'] = 'Permissions utilisateur mises à jour';
$messages['add_album_desc'] = 'Ajouter de nouveaux albums';
$messages['add_blog_template_desc'] = 'Ajouter de nouveaux gabarits au blog';
$messages['add_blog_user_desc'] = 'Ajouter de nouveaux utilisateurs du blog';
$messages['add_category_desc'] = 'Ajouter de nouvelles catégories';
$messages['add_custom_field_desc'] = 'Ajouter de nouveaux champs personnalisables';
$messages['add_link_desc'] = 'Ajouter de nouveaux liens';
$messages['add_link_category_desc'] = 'Ajouter de nouvelles catégories de liens';
$messages['add_post_desc'] = 'Ajouter de nouveaux articles';
$messages['add_resource_desc'] = 'Autoriser les nouvelles ressources';
$messages['blog_access_desc'] = 'Autoriser l’accès à ce blog';
$messages['update_album_desc'] = 'Mettre à jour les blogs existants';
$messages['update_blog_desc'] = 'Mettre à jour les propriétés du blog';
$messages['update_blog_template_desc'] = 'Mettre à jour le gabarit du jour';
$messages['update_blog_user_desc'] = 'Mettre à jour les permissions des utilisateurs';
$messages['update_category_desc'] = 'Mettre à jour les catégories existantes';
$messages['update_comment_desc'] = 'Mettre à jour les commentaires existants';
$messages['update_custom_field_desc'] = 'Mettre à jour les champs personnalisables existants';
$messages['update_link_desc'] = 'Mettre à jour les liens existants';
$messages['update_link_category_desc'] = 'Mettre à jour les catégories de liens';
$messages['update_post_desc'] = 'Mettre à jour les posts existants';
$messages['update_resource_desc'] = 'Mettre à jour les ressources existantes';
$messages['update_trackback_desc'] = 'Mettre à jour les rétroliens existants';
$messages['view_blog_templates_desc'] = 'Voir les gabarits du blog';
$messages['view_blog_users_desc'] = 'Voir les utilisateurs du blog';
$messages['view_categories_desc'] = 'Voir les catégories du blog';
$messages['view_comments_desc'] = 'Voir les commentaires du blog';
$messages['view_custom_fields_desc'] = 'Voir les champs personnalisables du blog';
$messages['view_links_desc'] = 'Voir les liens du blog';
$messages['view_link_categories_desc'] = 'Voir les catégories de liens du blog';
$messages['view_posts_desc'] = 'Voir les articles du blog';
$messages['view_resources_desc'] = 'Voir les ressources du blog';
$messages['view_trackbacks_desc'] = 'Voir les rétroliens du blog';
$messages['login_perm_desc'] = 'Le membre est autorisé à se connecter';
$messages['add_blog_category_desc'] = 'Le membre peut ajouter des catégories de blogs';
$messages['add_global_article_category_desc'] = 'Le membre peut ajouter des catégories globales d’articles';
$messages['add_locale_desc'] = 'Le membre peut ajouter des locales';
$messages['add_permission_desc'] = 'Le membre peut ajouter de nouvelles permissions';
$messages['add_site_blog_desc'] = 'Le membre peut ajouter de nouveaux blogs';
$messages['add_template_desc'] = 'Le membre peut ajouter des nouveaux gabarits';
$messages['add_user_desc'] = 'Le membre peut ajouter de nouveaux utilisateurs';
$messages['edit_blog_admin_mode_desc'] = 'Le membre peut administrer d’autres blogs (mode administrateur)';
$messages['purge_data_desc'] = 'Le membre peut nettoyer les données';
$messages['update_blog_category_desc'] = 'Le membre peut mettre à jour et supprimer les catégories de blogs';
$messages['update_global_article_category_desc'] = 'Le membre peut mettre à jour et supprimer les catégories globales d’articles';
$messages['update_global_settings_desc'] = 'Le membre peut mettre à jour les paramètres du site';
$messages['update_locale_desc'] = 'Le membre peut mettre à jour et supprimer des locales';
$messages['update_permission_desc'] = 'Le membre peut mettre à jour et supprimer des permissions';
$messages['update_plugin_settings_desc'] = 'Le membre peut mettre à jour les modules';
$messages['update_site_blog_desc'] = 'Le membre peut mettre à jour et supprimer des blogs';
$messages['update_template_desc'] = 'Le membre peut mettre à jour et supprimer des gabarits';
$messages['update_user_desc'] = 'Le membre peut mettre à jour et supprimer des utilisateurs';
$messages['view_blog_categories'] = 'Le membre peut voir les catégories de blogs';
$messages['view_global_article_categories_desc'] = 'Le membre peut voir les catégories globales d’articles';
$messages['view_global_settings_desc'] = 'Le membre peut voir la configuration du site';
$messages['view_locales_desc'] = 'Le membre peut voir les locales';
$messages['view_permissions_desc'] = 'Le membre peut voir les permissions';
$messages['view_plugins_desc'] = 'Le membre peut installer les modules';
$messages['view_site_blogs_desc'] = 'Le membre peut voir tous les blogs du site';
$messages['view_templates_desc'] = 'Le membre peut voir les gabarits';
$messages['view_users_desc'] = 'Le membre peut voir les utilisateurs';
$messages['update_blog_stats_desc'] = 'L’utilisateur peut supprimer les référants';
$messages['manage_admin_plugins_desc'] = 'Gérer les propriétés d’administration des modules';
$messages['summary_welcome_msg'] = 'Vous êtes connectés, %s !';
$messages['summary_go_to_admin'] = 'Partie administration';
$messages['error_can_only_update_own_articles'] = 'Vos habilitations vous permettent de modifier uniquement vos propres articles.';
$messages['update_all_user_articles_desc'] = 'Autoriser à modifier les articles des autres utilisateurs';
$messages['error_can_only_view_own_articles'] = 'Votre habilitation ne vous permet de voir que vos propres articles';
$messages['view_all_user_articles_desc'] = 'Autoriser à voir tous les articles des autres utilisateurs';
$messages['error_fetching_permission'] = 'Erreur lors du chargement de la permission';
$messages['editPermission'] = 'Éditer la permission';
$messages['error_updating_permission'] = 'Erreur lors de la mise à jour de la permission';
$messages['permission_updated_ok'] = 'Permission mise à jour ';
$messages['error_adding_permission'] = 'Une erreur est survenue lors de l’ajout de la permission';
$messages['error_cannot_login'] = 'Désolé, vous n’êtes pas habilité à vous connecter';
$messages['admin_user_permissions_help'] = 'Permissions globales du site ouvertes à cet utilisateur.';
$messages['permissions'] = 'Permissions';
$messages['blog_user_permissions_help'] = 'Permissions assignées à cet utilisateur sur ce blog.';
$messages['pluginSettings'] = 'Paramètres des modules';
$messages['user_can_override'] = 'Modifiable par les utilisateurs';
$messages['user_cannot_override'] = 'Non modifiable par les utilisateurs';
$messages['global_plugin_settings_saved_ok'] = 'Paramètres des modules sauvegardés ';
$messages['error_updating_global_plugin_settings'] = 'Erreur lors de la sauvegarde des paramètres des modules';
$messages['error_incorrect_value'] = 'La valeur est incorrecte';
$messages['parameter'] = 'Paramètre';
$messages['value'] = 'Valeur';
$messages['override'] = 'Modifier';
$messages['editCustomField'] = 'Éditer le champ personnalisable';
$messages['view_blog_stats_desc'] = 'Voir les stats du blog';
$messages['manage_plugins_desc'] = 'Gérer les modules';
$messages['error_global_category_has_articles'] = 'La catégorie ne peut pas être supprimée car elle contient encore des articles';
$messages['error_adding_global_article_category'] = 'Erreur lors de l’ajout d’une catégorie globale d’articles';
$messages['temp_folder_reset_ok'] = 'Le répertoire temporaire a été vidé ';
$messages['cleanup_temp_help'] = 'Ceci déclenchera la purge du répertoire temporaire, obligeant les caches à être réinitialisés pour tous les blogs.';
$messages['cleanup_temp'] = 'Vider le répertoire temporaire';
$messages['comment_only_auth_users'] = 'Seuls les authentifiés laissent des commentaires';
$messages['comment_only_auth_users_help'] = 'Seuls les utilisateurs qui ont un identifiant et un mot de passe valides, et qui ne sont loggués seront autorisés à laisser des commentaires.';
$messages['show_comments_max'] = 'Commentaires par page';
$messages['show_comments_max_help'] = 'Nombre maximum de commentaires par page. [Défaut : 20]';
$messages['hard_show_comments_max_help'] = 'Limite supérieure du nombre de commentaires par page. [Défaut : 50]';
$messages['error_resource_not_whitelisted_extension'] = 'Le type de fichier n’est pas l’un des types autorisés.';
$messages['help_upload_allowed_files'] = 'Liste des types de fichiers autorisés à être téléversés. L’utilisation de « * » et « ? » est autorisée. Si « upload_forbidden_file » et cette option sont activées, la liste des types de fichiers autorisés « upload_allowed_files » est prioritaire sur la liste des types interdits. [Défaut : Aucun]';
$messages['help_template_load_order'] = 'Définit dans quel ordre les gabarits sont recherchés et chargés. Si vous utilisez « Charger les gabarits par défaut d’abord », LifeType essaiera d’abord de trouver les fichiers dans le dossier \templates\default, ensuite dans le dossier templates de l’utilisateur. Si le même fichier de gabarit existe dans les 2 répertoires, ceux par défaut sont prioritaires.<br />

Si vous utilisez « Charger d’abord les gabarits des utilisateurs », ces gabarits seront toujours chargés en premier, et s’ils ne sont pas disponibles, les gabarits par défaut seront utilisés. Si le même fichier existe dans les 2 répertoires, ceux de l’utilisateur sont prioritaires.';
$messages['template_load_order_user_first'] = 'Charger les gabarits par défaut d’abord';
$messages['template_load_order_default_first'] = 'Charger d’abord les gabarits des utilisateurs';
$messages['editBlogUser'] = 'Éditer l’utilisateur du blog';
$messages['help_summary_service_name'] = 'Nom de votre site/service qui apparaitra à plusieurs endroits comme dans la page d’accueil et les flux RSS. [Défaut : <i>vide</i>]';
$messages['register_step2_help'] = 'Veuillez fournir les informations pour créer un blog.';
$messages['create_date'] = 'Date de création';
$messages['insert_media'] = 'Insérer un fichier média';
$messages['insert_more'] = 'Ajouter/supprimer le séparateur « lire la suite de l’article »';
$messages['purging_please_wait'] = 'Patientez pendant que les données sont purgées. Cette page se rafraîchira automatiquement quand les données seront nettoyées, n’essayez pas d’arrêter le processus';
$messages['error_cannot_delete_last_blog_category'] = 'Impossible de supprimer la dernière catégorie de blogs.';
$messages['help_logout_destination_url'] = 'URL où les utilisateurs seront redirigés quand ils se déconnecteront du service, à la place de la page de connexion de l’interface d’administration. [Défaut : <i>vide</i>]';
$messages['help_default_global_article_category_id'] = 'Identifiant de la catégorie globale d’articles par défaut. [Défaut : <i>vide</i>]';
$messages['help_blog_does_not_exist_url'] = 'URL où les utilisateurs seront renvoyés s’ils essaient d’atteindre un blog inexistant sur le site, à la place d’être renvoyé vers le blog par défaut du site. [Défaut : <i>vide</i>]';
$messages['error_invalid_blog_name'] = 'Le nom du blog est invalide';
$messages['help_forbidden_blognames'] = 'Liste des mots interdits comme noms de blogs séparés par un espace. Il est possible d’utiliser des expressions régulières. [Défaut : <i>vide</i>]';
$messages['posts_updated_ok'] = 'Les articles %s ont été mis à jour ';
$messages['error_updating_post2'] = 'Erreur lors de la mise à jour de l’article d’identifiant %s';
$messages['resources_updated_ok'] = 'Les ressources %s ont été mises à jour ';
$messages['error_updating_resource2'] = 'Erreur lors de la mise à jour de la ressource d’identifiant %s';
$messages['albums_updated_ok'] = 'Les albums %s ont été mis à jour ';
$messages['error_updating_album2'] = 'Erreur lors de la mise à jour de l’album d’identifiant %s';
$messages['links_updated_ok'] = 'Les liens %s ont été mis à jour ';
$messages['error_updating_link2'] = 'Erreur lors de la mise à jour du lien d’identifiant %s';
$messages['version'] = 'Version';
$messages['error_resources_disabled'] = 'Désolé, le téléchargement de nouveaux fichiers a été désactivé sur ce site';
$messages['help_login_admin_panel'] = 'Cliquer sur le nom du blog pour entrer dans la zone d’administration.';
$messages['help_allow_javascript_blocks_in_posts'] = 'Autoriser des blocs de code JavaScript dans les articles par les balises &lt;script&gt;. Veuillez noter que ceci cause des risques de sécurité dans vos blogs. [Défaut : Non]';
$messages['Versions'] = 'Versions';
$messages['incorrect_file_version_error'] = 'Les fichiers suivants ne correspondent pas aux contenus attendus:';
$messages['lifetype_version'] = 'LifeType';
$messages['lifetype_version_help'] = 'La version actuellement installée de LifeType est : ';
$messages['file_version_check'] = 'Vérification de la version du fichier';
$messages['file_version_check_help'] = 'Ceci déclenchera une vérification basique de la plupart des fichiers systèmes de LifeType, afin de vérifier que la version courante des fichiers correspond aux contenus attendus en accord avec la version installée. Veuillez patienter, le processus peut prendre un certain temps.';
$messages['check'] = 'Vérifier';
$messages['all_files_ok'] = 'Tous les fichiers sont corrects';
$messages['articles_order'] = 'Ordre des articles';
$messages['articles_order_help'] = 'Ordre dans lequel les articles doivent être affichés.';
$messages['help_post_notification_source_address'] = 'Adresse électronique de l’expéditeur ( From: ) lors de l’envoi de courriels depuis LifeType. [Défaut : noreply@your.host.com]';
$messages['blog_updated_ok'] = 'Le blog « %s » a correctement été mis-à-jour';
$messages['blogs_updated_ok'] = '%s blogs ont correctement été mis-à-jour';
$messages['error_updating_blog2'] = 'Il y a eu une erreur lors de la mise-à-jour du blog dont l’identifiant est « %s »';
$messages['error_updating_blog'] = 'Il y a eu une erreur lors de la mise-à-jour du blog « %s »';
$messages['users_updated_ok'] = '%s membres ont correctement été mis-à-jour';
$messages['eror_updating_user2'] = 'Il y a eu une erreur lors de la mise-à-jour du membre dont l’identifiant est « %s »';
$messages['error_select_status'] = 'Veuillez sélectionner un statut valide';
$messages['help_resources_naming_rule'] = 'Méthode de nommage de fichier pour les resources importées. « nom de fichier original » utilise le fichier original importé. « nom de fichier encodé » utilise un nom de fichier encodé, la règle de nommage est [BlogId]-[ResourceId].[Ext]. Utilisez « nom de fichier encodé » si vous installez LifeType dans un environnement Microsoft Windows multi-octet. <strong>Ne changez pas cette option une fois que des fichiers ont été importés. Ces fichiers ne seraient plus accessibles.</strong> [Défaut : nom de fichier original]';
$messages['original_file_name'] = 'nom de fichier original';
$messages['encoded_file_name'] = 'nom de fichier encodé';
$messages['quick_permission_selection'] = 'Sélection rapide de permission';
$messages['basic_blog_permission'] = 'Permettre au membre du blog d’ajouter, mettre-à-jour et supprimer les articles, les liens et les ressources';
$messages['full_blog_permission'] = 'Permettre au membre du blog d’accéder à toutes les fonctions du blog comme son propriétaire';
$messages['error_template_exist'] = 'Il y a eu une erreur en important le gabarit, le gabarit « %s » existe déjà.';
$messages['posted_by_help'] = 'Sélectionnez un rédacteur.';
$messages['insert_player'] = 'Insérer un lecteur';
$messages['enable_pull_down_menu_help'] = 'Activer ou désactiver le menu déroulant.';
$messages['help_hard_recent_posts_max_help'] = 'Limite maximale du nombre d’articles récents sur les pages du blog. Si un utilisateur paramètre une valeur supérieure, elle sera ignorée et la valeur ici spécifiée sera utilisée. [Défaut : 25]';


/// new strings for LT 1.2.4 ///
$messages['plugin_latest_version'] = 'Dernière version disponible : ';
$messages['check_versions'] = 'Vérifier les versions';
$messages['lt_version_ok'] = 'La version actuelle de LifeType est à jour.';
$messages['lt_version_error'] = 'La version la plus récente de LifeType est : ';
$messages['release_notes'] = 'Notes sur la version';

$messages['kb'] = 'Ko';
$messages['mb'] = 'Mo';
$messages['gb'] = 'Go';
$messages['edit'] = 'Éditer';

/// new strings for LT 1.2.5 ///
$messages['bookmark_this_filter'] = 'Mettre ce filtre en signet';
$messages['help_trim_whitespace_output'] = 'Supprime tous les blancs des rendus de gabarits ; cela peut alléger les page jusqu’à 40%. Il est recommandé de l’activer, à moins que vous soyez sensible sur les performances [Défaut : Oui]';
$messages['help_notify_new_blogs'] = 'Avertir l’administrateur pour chaque nouveau blog créé sur ce site';
$messages['new_blog_admin_notification_text'] = 'Ceci est le système d’avertissement automatique de LifeType.

Un nouveau blog intitulé "%1$s" (%2$s) a été créé dans votre installation LifeType.

Bonne journée.
';
?>
