import java.io.*;
import java.net.*;
import java.util.*;

public class configloader
{
 private Vector loc;

 /* global setup */
 // proxy server

 private InetAddress proxyserver;
 private int 	     proxyport;

 private boolean     proxydefined;
 private short       threads;
 private byte	     maxretry;
 private float	     retryprio;

 private localstore store;

 public static final byte MAX_RETRY=3;
 public static final float RETRY_PRIORITY=-1f;

 public static boolean case_sensitive;

 /* default */
 private location def;

 private int debuglevel=5;

 public final static String[] OPTIONS_SORTMAP={ "systemdefault","none","default","nodefaults"};
 public final static String[] ACT_SORTMAP={ "noparse","reject"};

 configloader(String cfgfile) throws IOException
 {
   location lastloc;

   loc=new Vector();
   def=new location("http://config.defaults/");
   def.urlmasks=new mask[0];
   lastloc=null;

   proxyserver=null;
   proxyport=0;
   proxydefined=false;
   threads=loader.THREADS;
   maxretry=MAX_RETRY;
   retryprio=RETRY_PRIORITY;
   store=new localstore(null);

   case_sensitive=false;

   DataInputStream dis=new DataInputStream(new BufferedInputStream(
                        new FileInputStream(cfgfile) ) );

  System.err.println("[CONFIG] Processing "+loader.PROG_NAME+" config file "+cfgfile);
  int lineno=0;
  String line,token;
  StringTokenizer st;
  while ( (line = dis.readLine()) != null)
  {
          lineno++;
          if(line.startsWith("#")) continue;
	  st=new StringTokenizer(line);
          if(st.hasMoreTokens()==false) continue;
          token=st.nextToken();
          token=token.toLowerCase();
          try
          {
	  // ************ immediate options ****************
          if(token.equals("case_sensitive_matching")) {
          				                   char c=(char)Integer.valueOf(st.nextToken()).intValue();
                                                           if(c==1) case_sensitive=true; else case_sensitive=false;
                                                           continue;
                                                      }
	  // **************  Global options *********************
          if(token.equals("localstore"))
          {
            String nt=st.nextToken();
            if(nt.equalsIgnoreCase("none"))
             {
              store=new nullstore(null);
             }
            else if(nt.equalsIgnoreCase("smartcache"))
             {
	      String arg[]=new String[1];
	      arg[0]=st.nextToken();
              store=new scachestore(arg);
             }
            else if(nt.equalsIgnoreCase("directory"))
	     {
	       String arg[]=new String[1];
	       arg[0]=st.nextToken();
	       store=new localstore(arg);
	     }
            else
             System.err.println("[CONFIG_ERROR] Unknown localstore type: "+nt);
            continue;
          }
          if(token.equals("threads")) {        int c=Integer.valueOf(st.nextToken()).intValue();
                                               threads=(short)c;
          				         continue;
                                      }

          if(token.equals("http_proxy"))
                                      {
                                        proxyserver=InetAddress.getByName(st.nextToken());
                                        proxyport=Integer.valueOf(st.nextToken()).intValue();
                                        proxydefined=true;
                                        continue;
                                      }

          if(token.equals("user_agent"))
                                      {
                                        loader.useragent="User-Agent: "+st.nextToken("\r\n").trim()+"\r\n";
                                        continue;
                                      }

          if(token.equals("retry")) {        int c=Integer.valueOf(st.nextToken()).intValue();
                                               maxretry=(byte )c;
          				         continue;
                                      }

          if(token.equals("retrypriority")) {
          				                   float c=Float.valueOf(st.nextToken()).floatValue();
                                                           retryprio=c;
                                                           continue;
                                                      }


          // ************* default server options ********************
          if(token.equals("defaultserverpriority")) {
          				                   float c=Float.valueOf(st.nextToken()).floatValue();
                                                           def.setPriority(c);
                                                           continue;
                                                      }

          if(token.equals("defaultscandepth") ||
	     token.equals("defaultdepth"))         {       // Java 1.0.X doesn't have Short class, using Integer
          				                   short c=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           def.setDepth(c);
                                                           continue;
                                                      }
          if(token.equals("defaultserveroptions")) {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options("options="+c);
                                                           // o.parse();
                                                           //System.out.println("[DEBUG] "+o);
                                                           o.prioritySort("options",OPTIONS_SORTMAP,false);
                                                           //System.out.println("[DEBUG] Sorted as "+o);
                                                           def.serveroptions(o);
                                                           continue;
                                                      }

          if(token.equals("defaultactions")) {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options(c);
                                                           def.setActions(o,null);
                                                           continue;
                                                      }
          if(token.equals("defaultmask"))
                                                     {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options(c);
                                                           o.addDefault(def.actions);
                                                           o.prioritySort("act",ACT_SORTMAP,false);
                                                           def.addMask(o);
                                                           // System.out.println(o);
                                                           continue;
                                                     }
          if(token.equals("defaultdelay")
                                    ) {
          				                   float f=util.timestring(st.nextToken());
                                                           def.setDelay(f);
                                                           continue;
                                                      }
          if(token.equals("defaultcrawltime")
                                    ) {
          				                   float f=util.timestring(st.nextToken());
                                                           def.setCrawlTime(f);
                                                           continue;
                                                      }
          // ************* per server configuration ********************
          if(token.equals("location"))
                                                     {
          				                   String c=st.nextToken();
                                                           lastloc=new location(c,def);
                                                           loc.addElement(lastloc);
                                                           //System.out.println("Location: "+c);
                                                           continue;
                                                     }

          if(token.equals("starturl"))
                                                     {
                                                           while(st.hasMoreTokens())
                                                             lastloc.addStartURL(st.nextToken());
                                                           continue;
                                                     }

          if(token.equals("referer"))
                                                     {
                                                           lastloc.referer=st.nextToken();
                                                           continue;
                                                     }

          if(token.equals("name"))
                                                     {
          				                   String c=st.nextToken();
                                                           lastloc.setName(c);
                                                           continue;
                                                     }

          if(token.equals("alias"))
                                                     {
                                                           while(st.hasMoreTokens())
                                                           {
                                                             lastloc.addAlias(st.nextToken());
                                                           }
                                                           continue;
                                                     }

          if(token.equals("priority")) {
          				                   float c=Float.valueOf(st.nextToken()).floatValue();
                                                           lastloc.setPriority(c);
                                                           continue;
                                                      }

          if(token.equals("scandepth")
             ||token.equals("depth")
                                    ) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   short c=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           lastloc.setDepth(c);
                                                           continue;
                                                      }
          if(token.equals("delay")
                                    ) {
          				                   float f=util.timestring(st.nextToken());
                                                           lastloc.setDelay(f);
                                                           continue;
                                                      }
          if(token.equals("crawltime")
                                    ) {
          				                   float f=util.timestring(st.nextToken());
                                                           lastloc.setCrawlTime(f);
                                                           continue;
                                                      }
          if(token.equals("options")) {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options("options="+c);
                                                           // o.parse();
                                                           //System.out.println("[DEBUG] "+o);
                                                           o.prioritySort("options",OPTIONS_SORTMAP,false);
                                                           //System.out.println("[DEBUG] Sorted as "+o);
                                                           lastloc.serveroptions(o);
                                                           continue;
                                                      }

          if(token.equals("actions")) {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options(c);
                                                           lastloc.setActions(o,def.actions);
                                                           continue;
                                                      }

          if(token.equals("addactions")) {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options(c);
                                                           lastloc.addActions(o,false);
                                                           continue;
                                                      }

          if(token.equals("extracturl"))  {
	                                                   String c=st.nextToken();
							   lastloc.addURLExtract(c,st.hasMoreTokens()? st.nextToken() : null);
							   continue;
	                                              }
          if(token.equals("mask")) {
          				                   String c=st.nextToken("\n");
                                                           options o;
                                                           o=new options(c);
                                                           o.addDefault(lastloc.actions);
                                                           o.prioritySort("act",ACT_SORTMAP,false);
                                                           lastloc.addMask(o);
                                                           // System.out.println(o);
                                                           continue;
                                                     }


          System.err.println("[CONFIG_ERROR] Unknown keyword: "+token+" at line "+lineno);

          }
          catch (NoSuchElementException nse)
           { System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" Missing arguent(s).");
             continue;}
   }
   dis.close();
   System.err.println("[CONFIG] Proccessing finished.\n");
 }

 /* proxy set-up */
 public final boolean isProxyDefined()
 {
  return proxydefined;
 }

 public final InetAddress getProxyServer()
 {
  return proxyserver;
 }

 public final int getProxyPort()
 {
  return proxyport;
 }

 public final location getDefaultLocation()
 {
  return def;
 }

 public final short getThreads()
 {
  return threads;
 }

 public final byte getMaxretry()
 {
  return maxretry;
 }

 public final float getRetryPriority()
 {
  return retryprio;
 }

 public final location[] getLocations()
 {
  location tmp[];
  tmp=new location[loc.size()];
  int i=0;
  Enumeration en=loc.elements();
  while(en.hasMoreElements())
  {
   tmp[i++]=(location)en.nextElement();
  }
  return tmp;
 }

 public final localstore getLocalStore()
 {
  return store;
 }

}
