/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.LoadBalancingConnectionProxy;
import com.mysql.jdbc.SQLError;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionGroup {
    private String groupName;
    private long connections = 0L;
    private long activeConnections = 0L;
    private HashMap<Long, LoadBalancingConnectionProxy> connectionProxies = new HashMap();
    private Set<String> hostList = new HashSet<String>();
    private boolean isInitialized = false;
    private long closedProxyTotalPhysicalConnections = 0L;
    private long closedProxyTotalTransactions = 0L;
    private int activeHosts = 0;
    private Set<String> closedHosts = new HashSet<String>();

    ConnectionGroup(String groupName) {
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerConnectionProxy(LoadBalancingConnectionProxy proxy2, List<String> localHostList) {
        long currentConnectionId;
        ConnectionGroup connectionGroup = this;
        synchronized (connectionGroup) {
            if (!this.isInitialized) {
                this.hostList.addAll(localHostList);
                this.isInitialized = true;
                this.activeHosts = localHostList.size();
            }
            currentConnectionId = ++this.connections;
            this.connectionProxies.put(currentConnectionId, proxy2);
        }
        ++this.activeConnections;
        return currentConnectionId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Collection<String> getInitialHosts() {
        return this.hostList;
    }

    public int getActiveHostCount() {
        return this.activeHosts;
    }

    public Collection<String> getClosedHosts() {
        return this.closedHosts;
    }

    public long getTotalLogicalConnectionCount() {
        return this.connections;
    }

    public long getActiveLogicalConnectionCount() {
        return this.activeConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActivePhysicalConnectionCount() {
        long result2 = 0L;
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i2 = proxyMap.entrySet().iterator();
        while (i2.hasNext()) {
            LoadBalancingConnectionProxy proxy2 = (LoadBalancingConnectionProxy)i2.next().getValue();
            result2 += proxy2.getActivePhysicalConnectionCount();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPhysicalConnectionCount() {
        long allConnections = this.closedProxyTotalPhysicalConnections;
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i2 = proxyMap.entrySet().iterator();
        while (i2.hasNext()) {
            LoadBalancingConnectionProxy proxy2 = (LoadBalancingConnectionProxy)i2.next().getValue();
            allConnections += proxy2.getTotalPhysicalConnectionCount();
        }
        return allConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalTransactionCount() {
        long transactions = this.closedProxyTotalTransactions;
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i2 = proxyMap.entrySet().iterator();
        while (i2.hasNext()) {
            LoadBalancingConnectionProxy proxy2 = (LoadBalancingConnectionProxy)i2.next().getValue();
            transactions += proxy2.getTransactionCount();
        }
        return transactions;
    }

    public void closeConnectionProxy(LoadBalancingConnectionProxy proxy2) {
        --this.activeConnections;
        this.connectionProxies.remove(proxy2.getConnectionGroupProxyID());
        this.closedProxyTotalPhysicalConnections += proxy2.getTotalPhysicalConnectionCount();
        this.closedProxyTotalTransactions += proxy2.getTransactionCount();
    }

    public void removeHost(String host) throws SQLException {
        this.removeHost(host, false);
    }

    public void removeHost(String host, boolean killExistingConnections) throws SQLException {
        this.removeHost(host, killExistingConnections, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHost(String host, boolean killExistingConnections, boolean waitForGracefulFailover) throws SQLException {
        if (this.activeHosts == 1) {
            throw SQLError.createSQLException("Cannot remove host, only one configured host active.", null);
        }
        if (this.hostList.remove(host)) {
            --this.activeHosts;
        } else {
            throw SQLError.createSQLException("Host is not configured: " + host, null);
        }
        if (killExistingConnections) {
            HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
            HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
            synchronized (hashMap) {
                proxyMap.putAll(this.connectionProxies);
            }
            Iterator i2 = proxyMap.entrySet().iterator();
            while (i2.hasNext()) {
                LoadBalancingConnectionProxy proxy2 = (LoadBalancingConnectionProxy)i2.next().getValue();
                if (waitForGracefulFailover) {
                    proxy2.removeHostWhenNotInUse(host);
                    continue;
                }
                proxy2.removeHost(host);
            }
        }
        this.closedHosts.add(host);
    }

    public void addHost(String host) {
        this.addHost(host, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHost(String host, boolean forExisting) {
        ConnectionGroup connectionGroup = this;
        synchronized (connectionGroup) {
            if (this.hostList.add(host)) {
                ++this.activeHosts;
            }
        }
        if (!forExisting) {
            return;
        }
        HashMap<Long, LoadBalancingConnectionProxy> proxyMap = new HashMap<Long, LoadBalancingConnectionProxy>();
        HashMap<Long, LoadBalancingConnectionProxy> hashMap = this.connectionProxies;
        synchronized (hashMap) {
            proxyMap.putAll(this.connectionProxies);
        }
        Iterator i2 = proxyMap.entrySet().iterator();
        while (i2.hasNext()) {
            LoadBalancingConnectionProxy proxy2 = (LoadBalancingConnectionProxy)i2.next().getValue();
            proxy2.addHost(host);
        }
    }
}

