/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ConnectionGroup;
import com.mysql.jdbc.jmx.LoadBalanceConnectionGroupManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionGroupManager {
    private static HashMap<String, ConnectionGroup> GROUP_MAP = new HashMap();
    private static LoadBalanceConnectionGroupManager mbean = new LoadBalanceConnectionGroupManager();
    private static boolean hasRegisteredJmx = false;

    public static synchronized ConnectionGroup getConnectionGroupInstance(String groupName) {
        if (GROUP_MAP.containsKey(groupName)) {
            return GROUP_MAP.get(groupName);
        }
        ConnectionGroup group2 = new ConnectionGroup(groupName);
        GROUP_MAP.put(groupName, group2);
        return group2;
    }

    public static void registerJmx() throws SQLException {
        if (hasRegisteredJmx) {
            return;
        }
        mbean.registerJmx();
        hasRegisteredJmx = true;
    }

    public static ConnectionGroup getConnectionGroup(String groupName) {
        return GROUP_MAP.get(groupName);
    }

    private static Collection<ConnectionGroup> getGroupsMatching(String group2) {
        if (group2 == null || group2.equals("")) {
            HashSet<ConnectionGroup> s2 = new HashSet<ConnectionGroup>();
            s2.addAll(GROUP_MAP.values());
            return s2;
        }
        HashSet<ConnectionGroup> s3 = new HashSet<ConnectionGroup>();
        ConnectionGroup o = GROUP_MAP.get(group2);
        if (o != null) {
            s3.add(o);
        }
        return s3;
    }

    public static void addHost(String group2, String host, boolean forExisting) {
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            cg.addHost(host, forExisting);
        }
    }

    public static int getActiveHostCount(String group2) {
        HashSet<String> active = new HashSet<String>();
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            active.addAll(cg.getInitialHosts());
        }
        return active.size();
    }

    public static long getActiveLogicalConnectionCount(String group2) {
        int count2 = 0;
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            count2 = (int)((long)count2 + cg.getActiveLogicalConnectionCount());
        }
        return count2;
    }

    public static long getActivePhysicalConnectionCount(String group2) {
        int count2 = 0;
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            count2 = (int)((long)count2 + cg.getActivePhysicalConnectionCount());
        }
        return count2;
    }

    public static int getTotalHostCount(String group2) {
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        HashSet<String> hosts = new HashSet<String>();
        for (ConnectionGroup cg : s2) {
            hosts.addAll(cg.getInitialHosts());
            hosts.addAll(cg.getClosedHosts());
        }
        return hosts.size();
    }

    public static long getTotalLogicalConnectionCount(String group2) {
        long count2 = 0L;
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            count2 += cg.getTotalLogicalConnectionCount();
        }
        return count2;
    }

    public static long getTotalPhysicalConnectionCount(String group2) {
        long count2 = 0L;
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            count2 += cg.getTotalPhysicalConnectionCount();
        }
        return count2;
    }

    public static long getTotalTransactionCount(String group2) {
        long count2 = 0L;
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            count2 += cg.getTotalTransactionCount();
        }
        return count2;
    }

    public static void removeHost(String group2, String host) throws SQLException {
        ConnectionGroupManager.removeHost(group2, host, false);
    }

    public static void removeHost(String group2, String host, boolean removeExisting) throws SQLException {
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        for (ConnectionGroup cg : s2) {
            cg.removeHost(host, removeExisting);
        }
    }

    public static String getActiveHostLists(String group2) {
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(group2);
        HashMap<String, Integer> hosts = new HashMap<String, Integer>();
        for (ConnectionGroup cg : s2) {
            Collection<String> l = cg.getInitialHosts();
            for (String host : l) {
                Integer o = (Integer)hosts.get(host);
                o = o == null ? Integer.valueOf(1) : Integer.valueOf(o + 1);
                hosts.put(host, o);
            }
        }
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (String host : hosts.keySet()) {
            sb.append(sep);
            sb.append(host);
            sb.append('(');
            sb.append(hosts.get(host));
            sb.append(')');
            sep = ",";
        }
        return sb.toString();
    }

    public static String getRegisteredConnectionGroups() {
        Collection<ConnectionGroup> s2 = ConnectionGroupManager.getGroupsMatching(null);
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (ConnectionGroup cg : s2) {
            String group2 = cg.getGroupName();
            sb.append(sep);
            sb.append(group2);
            sep = ",";
        }
        return sb.toString();
    }
}

