/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.log;

import com.mysql.jdbc.log.Log;
import com.mysql.jdbc.log.LogUtils;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdk14Logger
implements Log {
    private static final Level DEBUG = Level.FINE;
    private static final Level ERROR = Level.SEVERE;
    private static final Level FATAL = Level.SEVERE;
    private static final Level INFO = Level.INFO;
    private static final Level TRACE = Level.FINEST;
    private static final Level WARN = Level.WARNING;
    protected Logger jdkLogger = null;

    public Jdk14Logger(String name2) {
        this.jdkLogger = Logger.getLogger(name2);
    }

    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.jdkLogger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    public void logDebug(Object message2) {
        this.logInternal(DEBUG, message2, null);
    }

    public void logDebug(Object message2, Throwable exception2) {
        this.logInternal(DEBUG, message2, exception2);
    }

    public void logError(Object message2) {
        this.logInternal(ERROR, message2, null);
    }

    public void logError(Object message2, Throwable exception2) {
        this.logInternal(ERROR, message2, exception2);
    }

    public void logFatal(Object message2) {
        this.logInternal(FATAL, message2, null);
    }

    public void logFatal(Object message2, Throwable exception2) {
        this.logInternal(FATAL, message2, exception2);
    }

    public void logInfo(Object message2) {
        this.logInternal(INFO, message2, null);
    }

    public void logInfo(Object message2, Throwable exception2) {
        this.logInternal(INFO, message2, exception2);
    }

    public void logTrace(Object message2) {
        this.logInternal(TRACE, message2, null);
    }

    public void logTrace(Object message2, Throwable exception2) {
        this.logInternal(TRACE, message2, exception2);
    }

    public void logWarn(Object message2) {
        this.logInternal(WARN, message2, null);
    }

    public void logWarn(Object message2, Throwable exception2) {
        this.logInternal(WARN, message2, exception2);
    }

    private static final int findCallerStackDepth(StackTraceElement[] stackTrace) {
        int numFrames = stackTrace.length;
        for (int i2 = 0; i2 < numFrames; ++i2) {
            String callerClassName = stackTrace[i2].getClassName();
            if (callerClassName.startsWith("com.mysql.jdbc") && !callerClassName.startsWith("com.mysql.jdbc.compliance")) continue;
            return i2;
        }
        return 0;
    }

    private void logInternal(Level level2, Object msg, Throwable exception2) {
        if (this.jdkLogger.isLoggable(level2)) {
            String messageAsString = null;
            String callerMethodName = "N/A";
            String callerClassName = "N/A";
            if (msg instanceof ProfilerEvent) {
                messageAsString = LogUtils.expandProfilerEventIfNecessary(msg).toString();
            } else {
                Throwable locationException = new Throwable();
                StackTraceElement[] locations = locationException.getStackTrace();
                int frameIdx = Jdk14Logger.findCallerStackDepth(locations);
                if (frameIdx != 0) {
                    callerClassName = locations[frameIdx].getClassName();
                    callerMethodName = locations[frameIdx].getMethodName();
                }
                messageAsString = String.valueOf(msg);
            }
            if (exception2 == null) {
                this.jdkLogger.logp(level2, callerClassName, callerMethodName, messageAsString);
            } else {
                this.jdkLogger.logp(level2, callerClassName, callerMethodName, messageAsString, exception2);
            }
        }
    }
}

