/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.log;

import com.mysql.jdbc.Util;
import com.mysql.jdbc.log.Log;
import com.mysql.jdbc.log.LogUtils;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.util.Date;

public class StandardLogger
implements Log {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static final int DEBUG = 4;
    private static final int TRACE = 5;
    public static StringBuffer bufferedLog = null;
    private boolean logLocationInfo = true;

    public StandardLogger(String name2) {
        this(name2, false);
    }

    public StandardLogger(String name2, boolean logLocationInfo) {
        this.logLocationInfo = logLocationInfo;
    }

    public static void saveLogsToBuffer() {
        if (bufferedLog == null) {
            bufferedLog = new StringBuffer();
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void logDebug(Object message2) {
        this.logInternal(4, message2, null);
    }

    public void logDebug(Object message2, Throwable exception2) {
        this.logInternal(4, message2, exception2);
    }

    public void logError(Object message2) {
        this.logInternal(1, message2, null);
    }

    public void logError(Object message2, Throwable exception2) {
        this.logInternal(1, message2, exception2);
    }

    public void logFatal(Object message2) {
        this.logInternal(0, message2, null);
    }

    public void logFatal(Object message2, Throwable exception2) {
        this.logInternal(0, message2, exception2);
    }

    public void logInfo(Object message2) {
        this.logInternal(3, message2, null);
    }

    public void logInfo(Object message2, Throwable exception2) {
        this.logInternal(3, message2, exception2);
    }

    public void logTrace(Object message2) {
        this.logInternal(5, message2, null);
    }

    public void logTrace(Object message2, Throwable exception2) {
        this.logInternal(5, message2, exception2);
    }

    public void logWarn(Object message2) {
        this.logInternal(2, message2, null);
    }

    public void logWarn(Object message2, Throwable exception2) {
        this.logInternal(2, message2, exception2);
    }

    protected void logInternal(int level2, Object msg, Throwable exception2) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append(new Date().toString());
        msgBuf.append(" ");
        switch (level2) {
            case 0: {
                msgBuf.append("FATAL: ");
                break;
            }
            case 1: {
                msgBuf.append("ERROR: ");
                break;
            }
            case 2: {
                msgBuf.append("WARN: ");
                break;
            }
            case 3: {
                msgBuf.append("INFO: ");
                break;
            }
            case 4: {
                msgBuf.append("DEBUG: ");
                break;
            }
            case 5: {
                msgBuf.append("TRACE: ");
            }
        }
        if (msg instanceof ProfilerEvent) {
            msgBuf.append(LogUtils.expandProfilerEventIfNecessary(msg));
        } else {
            if (this.logLocationInfo && level2 != 5) {
                Throwable locationException = new Throwable();
                msgBuf.append(LogUtils.findCallingClassAndMethod(locationException));
                msgBuf.append(" ");
            }
            if (msg != null) {
                msgBuf.append(String.valueOf(msg));
            }
        }
        if (exception2 != null) {
            msgBuf.append("\n");
            msgBuf.append("\n");
            msgBuf.append("EXCEPTION STACK TRACE:");
            msgBuf.append("\n");
            msgBuf.append("\n");
            msgBuf.append(Util.stackTraceToString(exception2));
        }
        String messageAsString = msgBuf.toString();
        System.err.println(messageAsString);
        if (bufferedLog != null) {
            bufferedLog.append(messageAsString);
        }
    }
}

