/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.AbstractDistanceCalculator;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;

public class CartesianDistCalc
extends AbstractDistanceCalculator {
    private final boolean squared;

    public CartesianDistCalc() {
        this.squared = false;
    }

    public CartesianDistCalc(boolean squared) {
        this.squared = squared;
    }

    @Override
    public double distance(Point from, double toX, double toY) {
        double result2 = 0.0;
        double v = from.getX() - toX;
        result2 += v * v;
        v = from.getY() - toY;
        result2 += v * v;
        if (this.squared) {
            return result2;
        }
        return Math.sqrt(result2);
    }

    @Override
    public Point pointOnBearing(Point from, double distDEG, double bearingDEG, SpatialContext ctx, Point reuse) {
        if (distDEG == 0.0) {
            if (reuse == null) {
                return from;
            }
            reuse.reset(from.getX(), from.getY());
            return reuse;
        }
        double bearingRAD = DistanceUtils.toRadians(bearingDEG);
        double x = from.getX() + Math.sin(bearingRAD) * distDEG;
        double y = from.getY() + Math.cos(bearingRAD) * distDEG;
        if (reuse == null) {
            return ctx.makePoint(x, y);
        }
        reuse.reset(x, y);
        return reuse;
    }

    @Override
    public Rectangle calcBoxByDistFromPt(Point from, double distDEG, SpatialContext ctx, Rectangle reuse) {
        double minX = from.getX() - distDEG;
        double maxX = from.getX() + distDEG;
        double minY = from.getY() - distDEG;
        double maxY = from.getY() + distDEG;
        if (reuse == null) {
            return ctx.makeRectangle(minX, maxX, minY, maxY);
        }
        reuse.reset(minX, maxX, minY, maxY);
        return reuse;
    }

    @Override
    public double calcBoxByDistFromPt_yHorizAxisDEG(Point from, double distDEG, SpatialContext ctx) {
        return from.getY();
    }

    @Override
    public double area(Rectangle rect2) {
        return rect2.getArea(null);
    }

    @Override
    public double area(Circle circle) {
        return circle.getArea(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartesianDistCalc that = (CartesianDistCalc)o;
        return this.squared == that.squared;
    }

    public int hashCode() {
        return this.squared ? 1 : 0;
    }
}

