/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;

public class DistanceUtils {
    public static final double DEG_45_AS_RADS = 0.7853981633974483;
    public static final double SIN_45_AS_RADS = Math.sin(0.7853981633974483);
    public static final double DEG_90_AS_RADS = 1.5707963267948966;
    public static final double DEG_180_AS_RADS = Math.PI;
    public static final double DEG_225_AS_RADS = 3.9269908169872414;
    public static final double DEG_270_AS_RADS = 4.71238898038469;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double KM_TO_MILES = 0.621371192;
    public static final double MILES_TO_KM = 1.6093440006146922;
    public static final double EARTH_MEAN_RADIUS_KM = 6371.0087714;
    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.137;
    public static final double EARTH_MEAN_RADIUS_MI = 3958.7613145272735;
    public static final double EARTH_EQUATORIAL_RADIUS_MI = 3963.190590429304;

    private DistanceUtils() {
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power) {
        return DistanceUtils.vectorDistance(vec1, vec2, power, 1.0 / power);
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power, double oneOverPower) {
        double result2 = 0.0;
        if (power == 0.0) {
            for (int i2 = 0; i2 < vec1.length; ++i2) {
                result2 += vec1[i2] - vec2[i2] == 0.0 ? 0.0 : 1.0;
            }
        } else if (power == 1.0) {
            for (int i3 = 0; i3 < vec1.length; ++i3) {
                result2 += vec1[i3] - vec2[i3];
            }
        } else if (power == 2.0) {
            result2 = Math.sqrt(DistanceUtils.distSquaredCartesian(vec1, vec2));
        } else if (power == 2.147483647E9 || Double.isInfinite(power)) {
            for (int i4 = 0; i4 < vec1.length; ++i4) {
                result2 = Math.max(result2, Math.max(vec1[i4], vec2[i4]));
            }
        } else {
            for (int i5 = 0; i5 < vec1.length; ++i5) {
                result2 += Math.pow(vec1[i5] - vec2[i5], power);
            }
            result2 = Math.pow(result2, oneOverPower);
        }
        return result2;
    }

    public static double[] vectorBoxCorner(double[] center2, double[] result2, double distance, boolean upperRight) {
        if (result2 == null || result2.length != center2.length) {
            result2 = new double[center2.length];
        }
        if (!upperRight) {
            distance = -distance;
        }
        distance = SIN_45_AS_RADS * distance;
        for (int i2 = 0; i2 < center2.length; ++i2) {
            result2[i2] = center2[i2] + distance;
        }
        return result2;
    }

    public static Point pointOnBearingRAD(double startLat, double startLon, double distanceRAD, double bearingRAD, SpatialContext ctx, Point reuse) {
        double cosAngDist = Math.cos(distanceRAD);
        double cosStartLat = Math.cos(startLat);
        double sinAngDist = Math.sin(distanceRAD);
        double sinStartLat = Math.sin(startLat);
        double lat2 = Math.asin(sinStartLat * cosAngDist + cosStartLat * sinAngDist * Math.cos(bearingRAD));
        double lon2 = startLon + Math.atan2(Math.sin(bearingRAD) * sinAngDist * cosStartLat, cosAngDist - sinStartLat * Math.sin(lat2));
        if (lon2 > Math.PI) {
            lon2 = -1.0 * (Math.PI - (lon2 - Math.PI));
        } else if (lon2 < -Math.PI) {
            lon2 = lon2 + Math.PI + Math.PI;
        }
        if (lat2 > 1.5707963267948966) {
            lat2 = 1.5707963267948966 - (lat2 - 1.5707963267948966);
            lon2 = lon2 < 0.0 ? (lon2 += Math.PI) : (lon2 -= Math.PI);
        } else if (lat2 < -1.5707963267948966) {
            lat2 = -1.5707963267948966 - (lat2 + 1.5707963267948966);
            lon2 = lon2 < 0.0 ? (lon2 += Math.PI) : (lon2 -= Math.PI);
        }
        if (reuse == null) {
            return ctx.makePoint(lon2, lat2);
        }
        reuse.reset(lon2, lat2);
        return reuse;
    }

    public static double normLonDEG(double lon_deg) {
        if (lon_deg >= -180.0 && lon_deg <= 180.0) {
            return lon_deg;
        }
        double off = (lon_deg + 180.0) % 360.0;
        if (off < 0.0) {
            return 180.0 + off;
        }
        if (off == 0.0 && lon_deg > 0.0) {
            return 180.0;
        }
        return -180.0 + off;
    }

    public static double normLatDEG(double lat_deg) {
        if (lat_deg >= -90.0 && lat_deg <= 90.0) {
            return lat_deg;
        }
        double off = Math.abs((lat_deg + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    public static Rectangle calcBoxByDistFromPtDEG(double lat, double lon, double distDEG, SpatialContext ctx, Rectangle reuse) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        if (distDEG == 0.0) {
            minX = lon;
            maxX = lon;
            minY = lat;
            maxY = lat;
        } else if (distDEG >= 180.0) {
            minX = -180.0;
            maxX = 180.0;
            minY = -90.0;
            maxY = 90.0;
        } else {
            maxY = lat + distDEG;
            minY = lat - distDEG;
            if (maxY >= 90.0 || minY <= -90.0) {
                minX = -180.0;
                maxX = 180.0;
                if (maxY <= 90.0 && minY >= -90.0) {
                    minX = DistanceUtils.normLonDEG(lon - 90.0);
                    maxX = DistanceUtils.normLonDEG(lon + 90.0);
                }
                if (maxY > 90.0) {
                    maxY = 90.0;
                }
                if (minY < -90.0) {
                    minY = -90.0;
                }
            } else {
                double lon_delta_deg = DistanceUtils.calcBoxByDistFromPt_deltaLonDEG(lat, lon, distDEG);
                minX = DistanceUtils.normLonDEG(lon - lon_delta_deg);
                maxX = DistanceUtils.normLonDEG(lon + lon_delta_deg);
            }
        }
        if (reuse == null) {
            return ctx.makeRectangle(minX, maxX, minY, maxY);
        }
        reuse.reset(minX, maxX, minY, maxY);
        return reuse;
    }

    public static double calcBoxByDistFromPt_deltaLonDEG(double lat, double lon, double distDEG) {
        if (distDEG == 0.0) {
            return 0.0;
        }
        double lat_rad = DistanceUtils.toRadians(lat);
        double dist_rad = DistanceUtils.toRadians(distDEG);
        double result_rad = Math.asin(Math.sin(dist_rad) / Math.cos(lat_rad));
        if (!Double.isNaN(result_rad)) {
            return DistanceUtils.toDegrees(result_rad);
        }
        return 90.0;
    }

    public static double calcBoxByDistFromPt_latHorizAxisDEG(double lat, double lon, double distDEG) {
        if (distDEG == 0.0) {
            return lat;
        }
        double lat_rad = DistanceUtils.toRadians(lat);
        double dist_rad = DistanceUtils.toRadians(distDEG);
        double result_rad = Math.asin(Math.sin(lat_rad) / Math.cos(dist_rad));
        if (!Double.isNaN(result_rad)) {
            return DistanceUtils.toDegrees(result_rad);
        }
        if (lat > 0.0) {
            return 90.0;
        }
        if (lat < 0.0) {
            return -90.0;
        }
        return lat;
    }

    public static double distSquaredCartesian(double[] vec1, double[] vec2) {
        double result2 = 0.0;
        for (int i2 = 0; i2 < vec1.length; ++i2) {
            double v = vec1[i2] - vec2[i2];
            result2 += v * v;
        }
        return result2;
    }

    public static double distHaversineRAD(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double hsinX = Math.sin((lon1 - lon2) * 0.5);
        double hsinY = Math.sin((lat1 - lat2) * 0.5);
        double h = hsinY * hsinY + Math.cos(lat1) * Math.cos(lat2) * hsinX * hsinX;
        return 2.0 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
    }

    public static double distLawOfCosinesRAD(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double dLon = lon2 - lon1;
        double a = 1.5707963267948966 - lat1;
        double c = 1.5707963267948966 - lat2;
        double cosB = Math.cos(a) * Math.cos(c) + Math.sin(a) * Math.sin(c) * Math.cos(dLon);
        if (cosB < -1.0) {
            return Math.PI;
        }
        if (cosB >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosB);
    }

    public static double distVincentyRAD(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double cosLat1 = Math.cos(lat1);
        double cosLat2 = Math.cos(lat2);
        double sinLat1 = Math.sin(lat1);
        double sinLat2 = Math.sin(lat2);
        double dLon = lon2 - lon1;
        double cosDLon = Math.cos(dLon);
        double sinDLon = Math.sin(dLon);
        double a = cosLat2 * sinDLon;
        double b = cosLat1 * sinLat2 - sinLat1 * cosLat2 * cosDLon;
        double c = sinLat1 * sinLat2 + cosLat1 * cosLat2 * cosDLon;
        return Math.atan2(Math.sqrt(a * a + b * b), c);
    }

    public static double dist2Degrees(double dist, double radius) {
        return DistanceUtils.toDegrees(DistanceUtils.dist2Radians(dist, radius));
    }

    public static double degrees2Dist(double degrees, double radius) {
        return DistanceUtils.radians2Dist(DistanceUtils.toRadians(degrees), radius);
    }

    public static double dist2Radians(double dist, double radius) {
        return dist / radius;
    }

    public static double radians2Dist(double radians, double radius) {
        return radians * radius;
    }

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double toDegrees(double radians) {
        return radians * 57.29577951308232;
    }
}

